#version 100

precision lowp float;
precision lowp int;

attribute vec4 vertex;
attribute vec4 uv0;
#if PACK_NORMAL_POSW
#else
attribute vec3 normal;
#endif


varying vec2 TexCoord;
varying lowp vec4 Illuminance;

#if PACK_NORMAL_POSW
#else
uniform vec4 localLightPositions;
#endif

uniform mat4 worldViewProj;
uniform mat4 transformMatrix;
uniform vec4 lightDiffuseColors;   
uniform vec4 ambientSceneColor;

void main(void)
{
	TexCoord = (transformMatrix * uv0).xy;
	
#if PACK_NORMAL_POSW
	Illuminance = ambientSceneColor + lightDiffuseColors * vertex.w;
	gl_Position = worldViewProj * vec4( vertex.xyz, 1.0 );
#else
	vec3 vL = normalize( localLightPositions.xyz - ( vertex.xyz * localLightPositions.w ) );
	Illuminance = ambientSceneColor + lightDiffuseColors * max(  dot( vL.xyz, normal.xyz ) , 0.0 );
	gl_Position = worldViewProj * vertex;
#endif	
}




