#version 100

precision highp float;
precision highp int;

attribute vec4 vertex;
attribute vec4 uv0;
attribute vec3 normal;

varying vec2 TexCoord;
varying vec4 LocalPosition;
varying vec4 LocalNormal;
#if !NO_SHADOW
varying vec4 ShadowUV;
#endif

uniform mat4 world;
uniform mat4 viewProj;
uniform mat4 shadowViewProj;
uniform float lightCount;

void main(void)
{
	vec4 vWorldPos = world * vertex;

	TexCoord = uv0.xy;
	LocalNormal = vec4( normal, 1 );
	LocalPosition = vertex;
	gl_Position = viewProj * vWorldPos;
	
#if !NO_SHADOW  
	ShadowUV = shadowViewProj * vWorldPos;
#endif
}

