#version 100

precision highp float;
precision highp sampler2D;

vec4 blinnPhongShading( 	vec4 DiffuseLightColor, vec4 SpecularLightColor, 
							float SpecularShinness, vec3 N, vec3 L, vec3 V 	)
{    
	vec3 H = normalize( L + V );
	vec4 s = SpecularLightColor * pow( clamp( dot( N, H ), 0.0, 1.0 ), SpecularShinness );
	vec4 d = DiffuseLightColor *  max( dot( L, N ), 0.0 );

	return s + d; 
}

float shadowPCF(sampler2D shadowMap, vec4 shadowUV, vec2 offset)
{
	vec4 uv = vec4(shadowUV.xy, shadowUV.xy);
	vec4 o = vec4(offset, -offset.x, offset.y);
	vec4 h1 = uv + o;
	vec4 h2 = uv - o;

	float c =	(shadowUV.z <= texture2D(shadowMap, h1.xy).r) ? 1.0 : 0.0; // top left
	c +=		(shadowUV.z <= texture2D(shadowMap, h2.xy).r) ? 1.0 : 0.0; // bottom right
	c +=		(shadowUV.z <= texture2D(shadowMap, h1.zw).r) ? 1.0 : 0.0; // bottom left
	c +=		(shadowUV.z <= texture2D(shadowMap, h2.zw).r) ? 1.0 : 0.0; // top right
	return c / 4.0;
}

varying vec2 TexCoord;
varying vec4 LocalPosition;
varying vec4 LocalNormal;
#if !NO_SHADOW
varying vec4 ShadowUV;
#endif

uniform float fixedDepthBias;
uniform vec4 ambientSceneColor;
uniform vec4 localLightPositions;
uniform vec4 lightDiffuseColors;
uniform vec4 lightSpecularColors;
uniform vec4 localLightDirections;
uniform vec4 spotlightParams;
uniform vec4 lightAttenuations;
uniform vec4 localCameraPosition;
uniform float  lightCount;
uniform float  specularShinness;
	
uniform vec4 lightMultiplayer;

uniform sampler2D albedo;
uniform sampler2D specularMap;
uniform sampler2D shadowMap;

void main(void)
{
	vec4 vTotalIlluminance = ambientSceneColor;
	vec4 vLocalIlluminance;


	vec3 vLocalPos = LocalPosition.xyz;
	vec3 diff = localLightPositions.xyz - ( vLocalPos.xyz * localLightPositions.w );
	float dist = length( diff );
	vec3 vL =  diff / dist;

	bool isVisible = dot( - localLightDirections.xyz, vL ) > spotlightParams[0] || spotlightParams[0] == 1.0;
	
	if( isVisible )
	{
		float att = clamp( (1.0/(lightAttenuations.y + ( lightAttenuations.z  + lightAttenuations.w * dist ) * dist)) , 0.0, 1.0);
		vec3 vV = normalize( localCameraPosition.xyz - vLocalPos.xyz );
		vec4 specCol = lightSpecularColors * texture2D( specularMap, TexCoord );
		vLocalIlluminance = blinnPhongShading( lightDiffuseColors, specCol, specularShinness, LocalNormal.xyz, vL, vV ) * att;
		vLocalIlluminance *= ( spotlightParams[0] == 1.0 ) ? 1.0 : lightMultiplayer[0];

#if !NO_SHADOW  
		//vec4 shadowUV = ShadowUV / ShadowUV.w;
		//float depth = texture2D(shadowMap, shadowUV.xy  ).x + fixedDepthBias;
	#if PCF
		//vLocalIlluminance = vLocalIlluminance * shadowPCF( shadowMap, shadowUV, vec2( 0.0005, 0.0005 ) );
	#else
		//vLocalIlluminance = vLocalIlluminance * ( ( shadowUV.z <= texture2D(shadowMap, shadowUV.xy).r) ? 1.0 : 0.0 );
	#endif
#endif
		vTotalIlluminance += vLocalIlluminance;
	}
	
	vec4 texColor = texture2D( albedo, TexCoord );
	
	gl_FragColor = texColor;
	gl_FragColor.xyz *= vTotalIlluminance.xyz ;
}
