#version 100

#define MAX_BLEND_WEIGHTS 4

precision lowp float;
precision lowp int;

attribute vec4 vertex;
attribute vec4 uv0;
attribute vec3 normal;

attribute vec4 blendWeights;
attribute vec4 blendIndices;

varying vec2 TexCoord;
varying lowp vec4 Illuminance;

uniform vec4 worldLightPositions;
uniform vec4 lightDiffuseColors;   
uniform vec4 ambientSceneColor;

uniform vec4 world3x4Array[120];
uniform mat4 viewProj;

void main(void)
{
	vec3 vWorldPos = vec3( 0.0, 0.0, 0.0 );
	vec3 vWorldNor = vec3( 0.0, 0.0, 0.0 );
		
   	int i;
	float last = 1.0;
	
	mat4 world3x4Matrix = mat4(0.0);

	for (i = 0; i < 4; ++i)
	{
		int idx = int( blendIndices[ i ] ) * 3;
		float weight = ( i == 3 ) ? last : blendWeights[ i ];
		
		world3x4Matrix[0] += world3x4Array[ idx + 0 ]*weight;
		world3x4Matrix[1] += world3x4Array[ idx + 1 ]*weight;
		world3x4Matrix[2] += world3x4Array[ idx + 2 ]*weight;
		
		last -= blendWeights[ i ];
    }

	vWorldPos = ( vertex * world3x4Matrix ).xyz;
	vWorldNor = vec3(dot(world3x4Matrix[0].xyz,normal),
					 dot(world3x4Matrix[1].xyz,normal),
					 dot(world3x4Matrix[2].xyz,normal));
			
	TexCoord = uv0.xy;	
	
	vec3 vLight = normalize( worldLightPositions.xyz - ( vWorldPos * worldLightPositions.w ) );
	
	Illuminance = ambientSceneColor + lightDiffuseColors * max( dot( vLight.xyz, vWorldNor.xyz ), 0.1 );
	
	gl_Position = viewProj * vec4( vWorldPos, 1.0 );
}
