#version 100

precision lowp float;
precision lowp int;

attribute vec4 vertex;
attribute vec4 uv0;
#if PACK_NORMAL_POSW
#else
attribute vec3 normal;
#endif


varying vec2 TexCoord;
varying lowp vec4 Illuminance;

#if PACK_NORMAL_POSW
uniform mat4 worldViewProj;
#else
uniform mat4 worldProj;
uniform mat4 viewProj;
uniform vec4 worldLightPositions;
#endif

uniform vec4 lightDiffuseColors;   
uniform vec4 ambientSceneColor;


void main(void)
{
	TexCoord = uv0.xy;	
	
#if PACK_NORMAL_POSW
	Illuminance = ambientSceneColor + lightDiffuseColors * vertex.w;
	gl_Position = worldViewProj * vec4( vertex.xyz, 1.0 );
#else
	vec4 vWorldPos = worldProj * vertex;
	vec4 vWorldNor = worldProj * vec4( normal, 0.0 );
	vec3 vLight = normalize( worldLightPositions.xyz - ( vWorldPos.xyz * worldLightPositions.w ) );
	Illuminance = ambientSceneColor + lightDiffuseColors * max(  dot( vLight.xyz, vWorldNor.xyz ) , 0.1 );
	gl_Position = viewProj * vWorldPos;
#endif
}

