#version 100

precision lowp float;
precision lowp int;

attribute vec4 vertex;
attribute vec4 uv0;
attribute vec3 normal;
attribute vec4 colour;

varying vec2 TexCoord;
varying lowp vec4 Illuminance;

uniform float health;
uniform float strength;
uniform float timer;
uniform mat4 worldViewProj;
uniform vec4 localLightPositions;
uniform vec4 lightDiffuseColors;   
uniform vec4 ambientSceneColor;

void main(void)
{
	TexCoord = uv0.xy;	
	
	float changeR = sin(timer*3.14);
	float changeG = cos(timer*4.94);
	float changeB = sin(timer*7.73);
	
	vec3	changeRGB = vec3( changeR, changeG, changeB );
			changeRGB = ( 1.0 + changeRGB ) / 2.0;
			
	vec4 pos = vertex;

	pos.xyz += normal.xyz * colour.x * changeRGB.x * health * strength;
	pos.xyz += normal.xyz * colour.y * changeRGB.y * health * strength;
	pos.xyz += normal.xyz * colour.z * changeRGB.z * health * strength;
	
	vec3 vL = normalize( localLightPositions.xyz - ( vertex.xyz * localLightPositions.w ) );
	
	Illuminance = ambientSceneColor + lightDiffuseColors * max(  dot( vL.xyz, normal.xyz ) , 0.0 );
	
	gl_Position = worldViewProj * pos;
}

