#version 100

precision highp float;
precision highp int;

attribute vec4 vertex;

uniform float health,
uniform float strength,
uniform float timer,
uniform mat4 p_WorldViewProj;

varying lowp vec4 depth;

void main(void)
{

	float changeR = sin(timer*3.14);
	float changeG = cos(timer*4.94);
	float changeB = sin(timer*7.73);
	
	vec3	changeRGB = vec3( changeR, changeG, changeB );
			changeRGB = ( 1.0 + changeRGB ) / 2.0;
			
	vec4 pos = vertex;
	
	pos.xyz += normal.xyz * color.x * changeRGB.x * health * strength;
	pos.xyz += normal.xyz * color.y * changeRGB.y * health * strength;
	pos.xyz += normal.xyz * color.z * changeRGB.z * health * strength;
	
	gl_Position = p_WorldViewProj * pos;

	depth = gl_Position;
}