#version 100

precision lowp float;
precision lowp int;

attribute vec4 vertex;
attribute vec4 uv0;
attribute vec3 normal;

varying vec2 TexCoord;
varying lowp vec4 Illuminance;

uniform mat4 worldViewProj;
uniform vec4 ambientSceneColor;
uniform vec4 localLightPositions;
uniform vec4 lightDiffuseColors;   

void main(void)
{
	TexCoord = uv0.xy;	
	
	vec3 vL = normalize( localLightPositions.xyz - ( vertex.xyz * localLightPositions.w ) );
	
	Illuminance = lightDiffuseColors * max(  dot( vL.xyz, normal.xyz ) , 0.0 ) + ambientSceneColor;
	
	gl_Position = worldViewProj * vertex;
}

