#version 100

precision highp float;
precision highp sampler2D;

varying highp vec2 TexCoord;

uniform vec4 healthInfo;
uniform sampler2D albedo;

void main(void) 
{
	float alfaGreen = healthInfo.x;
	float alfaRed = healthInfo.y;
	
	float x = TexCoord.x - 1.0;
	float y = TexCoord.y;
	
	vec4 color = texture2D( albedo, TexCoord );	
	
	if ( alfaGreen * x + 1.0 > y )
	{
		color.xyz = vec3( 0.0, 0.0, 0.0 );
			
		if ( alfaRed * x + 1.0 < y )
		{
			color.x = 0.95;
		}
	}
	
	gl_FragColor = color;
}
