#version 100

precision highp float;
precision highp sampler2D;

varying highp vec2 TexCoord;

uniform vec4 healthInfo;
uniform sampler2D albedo;

void main(void) 
{
	vec4 color = texture2D( albedo, TexCoord );	
	
	if ( TexCoord.x < 1.0 - healthInfo.x )
	{
		if ( TexCoord.x > 1.0 - healthInfo.y ) 
		{
			color.xyz = vec3( 0.8, 0.0, 0.0 );
		}
		else
		{
			color.xyz = vec3( 0.0, 0.0, 0.0 );
		}	
	}
	
	gl_FragColor = color;
}
