/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.frozenbubble;

import com.nokia.frozenbubble.BmpWrap;
import com.nokia.frozenbubble.Rect;
import com.nokia.frozenbubble.Sprite;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class PenguinSprite
extends Sprite {
    public static final int STATE_TURN_LEFT = 0;
    public static final int STATE_TURN_RIGHT = 1;
    public static final int STATE_FIRE = 2;
    public static final int STATE_VOID = 3;
    public static final int STATE_GAME_WON = 4;
    public static final int STATE_GAME_LOST = 5;
    public static final int[][] LOST_SEQUENCE = new int[][]{{1, 0}, {2, 8}, {3, 9}, {4, 10}, {5, 11}, {6, 12}, {7, 13}, {5, 14}};
    public static final int[][] WON_SEQUENCE = new int[][]{{1, 0}, {2, 7}, {3, 6}, {4, 15}, {5, 16}, {6, 17}, {7, 18}, {4, 19}};
    private BmpWrap spritesImage;
    private int currentPenguin;
    private int count;
    private Random rand;
    private int finalState;
    private int nextPosition;

    public PenguinSprite(BmpWrap sprites, Random rand) {
        super(new Rect(361, 436, 416, 479));
        this.spritesImage = sprites;
        this.rand = rand;
        this.currentPenguin = 0;
        this.finalState = 3;
        this.nextPosition = 0;
    }

    public PenguinSprite(BmpWrap sprites, Random rand, int currentPenguin, int count, int finalState, int nextPosition) {
        super(new Rect(361, 436, 416, 479));
        this.spritesImage = sprites;
        this.rand = rand;
        this.currentPenguin = currentPenguin;
        this.count = count;
        this.finalState = finalState;
        this.nextPosition = nextPosition;
    }

    public void saveState(DataOutputStream data, Vector savedSprites) throws IOException {
        super.saveState(data, savedSprites);
        data.writeInt(this.currentPenguin);
        data.writeInt(this.count);
        data.writeInt(this.finalState);
        data.writeInt(this.nextPosition);
    }

    public int getTypeId() {
        return 4;
    }

    public void updateState(int state) {
        if (this.finalState != 3) {
            ++this.count;
            if (this.count % 6 == 0) {
                if (this.finalState == 5) {
                    this.currentPenguin = LOST_SEQUENCE[this.nextPosition][1];
                    this.nextPosition = LOST_SEQUENCE[this.nextPosition][0];
                } else if (this.finalState == 4) {
                    this.currentPenguin = WON_SEQUENCE[this.nextPosition][1];
                    this.nextPosition = WON_SEQUENCE[this.nextPosition][0];
                }
            }
        } else {
            ++this.count;
            switch (state) {
                case 0: {
                    this.count = 0;
                    this.currentPenguin = 3;
                    break;
                }
                case 1: {
                    this.count = 0;
                    this.currentPenguin = 2;
                    break;
                }
                case 2: {
                    this.count = 0;
                    this.currentPenguin = 1;
                    break;
                }
                case 3: {
                    if (this.currentPenguin >= 4 && this.currentPenguin <= 7) break;
                    this.currentPenguin = 0;
                    break;
                }
                case 4: 
                case 5: {
                    this.count = 0;
                    this.finalState = state;
                    this.currentPenguin = 0;
                    return;
                }
            }
            if (this.count > 100) {
                this.currentPenguin = 7;
            } else if (this.count % 15 == 0 && this.count > 25) {
                this.currentPenguin = this.rand.nextInt() % 3 + 4;
                if (this.currentPenguin < 4) {
                    this.currentPenguin = 0;
                }
            }
        }
    }

    public void paint(Graphics g, double scale, int dx, int dy) {
        Rect r = this.getSpriteArea();
        PenguinSprite.drawImageClipped(this.spritesImage, 360 - this.currentPenguin % 4 * 57, 435 - this.currentPenguin / 4 * 45, r, g, scale, dx, dy);
    }
}

