/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.frozenbubble;

import com.nokia.frozenbubble.BmpWrap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class Compressor {
    private BmpWrap compressorHead;
    private BmpWrap compressor;
    private int steps;

    public Compressor(BmpWrap compressorHead, BmpWrap compressor) {
        this.compressorHead = compressorHead;
        this.compressor = compressor;
        this.steps = 0;
    }

    public void saveState(DataOutputStream data) throws IOException {
        data.writeInt(this.steps);
    }

    public void restoreState(DataInputStream data) throws IOException {
        this.steps = data.readInt();
    }

    public void moveDown() {
        ++this.steps;
    }

    public boolean hasMoved() {
        return this.steps > 0;
    }

    public void paint(Graphics g, double scale, int dx, int dy) {
        int extraSteps;
        for (int i = extraSteps = dy > 0 ? -(dy / (int)(28.0 * scale) + 1) : 0; i < this.steps; ++i) {
            g.drawImage(this.compressor.bmp, (int)(235.0 * scale + (double)dx), (int)((double)(28 * i - 4) * scale + (double)dy), 20);
            g.drawImage(this.compressor.bmp, (int)(391.0 * scale + (double)dx), (int)((double)(28 * i - 4) * scale + (double)dy), 20);
        }
        g.drawImage(this.compressorHead.bmp, (int)(160.0 * scale + (double)dx), (int)((double)(-7 + 28 * this.steps) * scale + (double)dy), 20);
    }
}

