/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.frozenbubble;

import com.nokia.frozenbubble.BmpWrap;
import com.nokia.frozenbubble.BubbleManager;
import com.nokia.frozenbubble.FrozenGame;
import com.nokia.frozenbubble.Point;
import com.nokia.frozenbubble.Rect;
import com.nokia.frozenbubble.SettingsManager;
import com.nokia.frozenbubble.SoundManager;
import com.nokia.frozenbubble.Sprite;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class BubbleSprite
extends Sprite {
    private static double FALL_SPEED = 1.0;
    private static double MAX_BUBBLE_SPEED = 8.0;
    private static double MINIMUM_DISTANCE = 841.0;
    private int color;
    private BmpWrap bubbleFace;
    private BmpWrap bubbleBlindFace;
    private BmpWrap frozenFace;
    private BmpWrap bubbleBlink;
    private BmpWrap[] bubbleFixed;
    private FrozenGame frozen;
    private BubbleManager bubbleManager;
    private double moveX;
    private double moveY;
    private double realX;
    private double realY;
    private boolean fixed;
    private boolean blink;
    private boolean released;
    private boolean checkJump;
    private boolean checkFall;
    private int fixedAnim;
    private SoundManager soundManager;

    public void saveState(DataOutputStream data, Vector savedSprites) throws IOException {
        super.saveState(data, savedSprites);
        data.writeInt(this.color);
        data.writeDouble(this.moveX);
        data.writeDouble(this.moveY);
        data.writeDouble(this.realX);
        data.writeDouble(this.realY);
        data.writeBoolean(this.fixed);
        data.writeBoolean(this.blink);
        data.writeBoolean(this.released);
        data.writeBoolean(this.checkJump);
        data.writeBoolean(this.checkFall);
        data.writeInt(this.fixedAnim);
        data.writeBoolean(this.bubbleFace == this.frozenFace);
    }

    public int getTypeId() {
        return 1;
    }

    public BubbleSprite(Rect area, int color, double moveX, double moveY, double realX, double realY, boolean fixed, boolean blink, boolean released, boolean checkJump, boolean checkFall, int fixedAnim, BmpWrap bubbleFace, BmpWrap bubbleBlindFace, BmpWrap frozenFace, BmpWrap[] bubbleFixed, BmpWrap bubbleBlink, BubbleManager bubbleManager, SoundManager soundManager, FrozenGame frozen) {
        super(area);
        this.color = color;
        this.moveX = moveX;
        this.moveY = moveY;
        this.realX = realX;
        this.realY = realY;
        this.fixed = fixed;
        this.blink = blink;
        this.released = released;
        this.checkJump = checkJump;
        this.checkFall = checkFall;
        this.fixedAnim = fixedAnim;
        this.bubbleFace = bubbleFace;
        this.bubbleBlindFace = bubbleBlindFace;
        this.frozenFace = frozenFace;
        this.bubbleFixed = bubbleFixed;
        this.bubbleBlink = bubbleBlink;
        this.bubbleManager = bubbleManager;
        this.soundManager = soundManager;
        this.frozen = frozen;
    }

    public BubbleSprite(Rect area, int direction, int color, BmpWrap bubbleFace, BmpWrap bubbleBlindFace, BmpWrap frozenFace, BmpWrap[] bubbleFixed, BmpWrap bubbleBlink, BubbleManager bubbleManager, SoundManager soundManager, FrozenGame frozen) {
        super(area);
        this.color = color;
        this.bubbleFace = bubbleFace;
        this.bubbleBlindFace = bubbleBlindFace;
        this.frozenFace = frozenFace;
        this.bubbleFixed = bubbleFixed;
        this.bubbleBlink = bubbleBlink;
        this.bubbleManager = bubbleManager;
        this.soundManager = soundManager;
        this.frozen = frozen;
        this.moveX = MAX_BUBBLE_SPEED * -Math.cos((double)direction * Math.PI / 40.0);
        this.moveY = MAX_BUBBLE_SPEED * -Math.sin((double)direction * Math.PI / 40.0);
        this.realX = area.left;
        this.realY = area.top;
        this.fixed = false;
        this.fixedAnim = -1;
    }

    public BubbleSprite(Rect area, int color, BmpWrap bubbleFace, BmpWrap bubbleBlindFace, BmpWrap frozenFace, BmpWrap bubbleBlink, BubbleManager bubbleManager, SoundManager soundManager, FrozenGame frozen) {
        super(area);
        this.color = color;
        this.bubbleFace = bubbleFace;
        this.bubbleBlindFace = bubbleBlindFace;
        this.frozenFace = frozenFace;
        this.bubbleBlink = bubbleBlink;
        this.bubbleManager = bubbleManager;
        this.soundManager = soundManager;
        this.frozen = frozen;
        this.realX = area.left;
        this.realY = area.top;
        this.fixed = true;
        this.fixedAnim = -1;
        bubbleManager.addBubble(bubbleFace);
    }

    Point currentPosition() {
        int posY = (int)Math.floor((this.realY - 28.0 - this.frozen.getMoveDown()) / 28.0);
        int posX = (int)Math.floor((this.realX - 174.0) / 32.0 + 0.5 * (double)(posY % 2));
        if (posX > 7) {
            posX = 7;
        }
        if (posX < 0) {
            posX = 0;
        }
        if (posY < 0) {
            posY = 0;
        }
        return new Point(posX, posY);
    }

    public void removeFromManager() {
        this.bubbleManager.removeBubble(this.bubbleFace);
    }

    public boolean fixed() {
        return this.fixed;
    }

    public boolean checked() {
        return this.checkFall;
    }

    public boolean released() {
        return this.released;
    }

    public void moveDown() {
        if (this.fixed) {
            this.realY += 28.0;
        }
        super.absoluteMove(new Point((int)this.realX, (int)this.realY));
    }

    public void move() {
        this.realX += this.moveX;
        if (this.realX >= 414.0) {
            this.moveX = -this.moveX;
            this.realX += 414.0 - this.realX;
            this.soundManager.playSound(4);
        } else if (this.realX <= 190.0) {
            this.moveX = -this.moveX;
            this.realX += 190.0 - this.realX;
            this.soundManager.playSound(4);
        }
        this.realY += this.moveY;
        Point currentPosition = this.currentPosition();
        Vector neighbors = this.getNeighbors(currentPosition);
        if (this.checkCollision(neighbors) || this.realY < 44.0 + this.frozen.getMoveDown()) {
            this.realX = 190.0 + (double)(currentPosition.x * 32) - (double)(currentPosition.y % 2 * 16);
            this.realY = 44.0 + (double)(currentPosition.y * 28) + this.frozen.getMoveDown();
            this.fixed = true;
            Vector jumps = new Vector();
            this.checkJump(jumps, neighbors);
            BubbleSprite[][] grid = this.frozen.getGrid();
            if (jumps.size() >= 3) {
                int i;
                this.released = true;
                for (i = 0; i < jumps.size(); ++i) {
                    BubbleSprite current = (BubbleSprite)jumps.elementAt(i);
                    Point currentPoint = current.currentPosition();
                    this.frozen.addJumpingBubble(current);
                    if (i > 0) {
                        current.removeFromManager();
                    }
                    grid[currentPoint.x][currentPoint.y] = null;
                }
                for (i = 0; i < 8; ++i) {
                    if (grid[i][0] == null) continue;
                    grid[i][0].checkFall();
                }
                for (i = 0; i < 8; ++i) {
                    for (int j = 0; j < 12; ++j) {
                        if (grid[i][j] == null || grid[i][j].checked()) continue;
                        this.frozen.addFallingBubble(grid[i][j]);
                        grid[i][j].removeFromManager();
                        grid[i][j] = null;
                    }
                }
                this.soundManager.playSound(3);
            } else {
                this.bubbleManager.addBubble(this.bubbleFace);
                grid[currentPosition.x][currentPosition.y] = this;
                this.moveX = 0.0;
                this.moveY = 0.0;
                this.fixedAnim = 0;
                this.soundManager.playSound(5);
            }
        }
        super.absoluteMove(new Point((int)this.realX, (int)this.realY));
    }

    Vector getNeighbors(Point p) {
        BubbleSprite[][] grid = this.frozen.getGrid();
        Vector<BubbleSprite> list = new Vector<BubbleSprite>();
        if (p.y % 2 == 0) {
            if (p.x > 0) {
                list.addElement(grid[p.x - 1][p.y]);
            }
            if (p.x < 7) {
                list.addElement(grid[p.x + 1][p.y]);
                if (p.y > 0) {
                    list.addElement(grid[p.x][p.y - 1]);
                    list.addElement(grid[p.x + 1][p.y - 1]);
                }
                if (p.y < 12) {
                    list.addElement(grid[p.x][p.y + 1]);
                    list.addElement(grid[p.x + 1][p.y + 1]);
                }
            } else {
                if (p.y > 0) {
                    list.addElement(grid[p.x][p.y - 1]);
                }
                if (p.y < 12) {
                    list.addElement(grid[p.x][p.y + 1]);
                }
            }
        } else {
            if (p.x < 7) {
                list.addElement(grid[p.x + 1][p.y]);
            }
            if (p.x > 0) {
                list.addElement(grid[p.x - 1][p.y]);
                if (p.y > 0) {
                    list.addElement(grid[p.x][p.y - 1]);
                    list.addElement(grid[p.x - 1][p.y - 1]);
                }
                if (p.y < 12) {
                    list.addElement(grid[p.x][p.y + 1]);
                    list.addElement(grid[p.x - 1][p.y + 1]);
                }
            } else {
                if (p.y > 0) {
                    list.addElement(grid[p.x][p.y - 1]);
                }
                if (p.y < 12) {
                    list.addElement(grid[p.x][p.y + 1]);
                }
            }
        }
        return list;
    }

    void checkJump(Vector jump, BmpWrap compare) {
        if (this.checkJump) {
            return;
        }
        this.checkJump = true;
        if (this.bubbleFace == compare) {
            this.checkJump(jump, this.getNeighbors(this.currentPosition()));
        }
    }

    void checkJump(Vector jump, Vector neighbors) {
        jump.addElement(this);
        for (int i = 0; i < neighbors.size(); ++i) {
            BubbleSprite current = (BubbleSprite)neighbors.elementAt(i);
            if (current == null) continue;
            current.checkJump(jump, this.bubbleFace);
        }
    }

    public void checkFall() {
        if (this.checkFall) {
            return;
        }
        this.checkFall = true;
        Vector v = this.getNeighbors(this.currentPosition());
        for (int i = 0; i < v.size(); ++i) {
            BubbleSprite current = (BubbleSprite)v.elementAt(i);
            if (current == null) continue;
            current.checkFall();
        }
    }

    boolean checkCollision(Vector neighbors) {
        for (int i = 0; i < neighbors.size(); ++i) {
            BubbleSprite current = (BubbleSprite)neighbors.elementAt(i);
            if (current == null || !this.checkCollision(current)) continue;
            return true;
        }
        return false;
    }

    boolean checkCollision(BubbleSprite sprite) {
        double value = ((double)sprite.getSpriteArea().left - this.realX) * ((double)sprite.getSpriteArea().left - this.realX) + ((double)sprite.getSpriteArea().top - this.realY) * ((double)sprite.getSpriteArea().top - this.realY);
        return value < MINIMUM_DISTANCE;
    }

    public void jump() {
        if (this.fixed) {
            this.moveX = -6.0 + this.frozen.getRandom().nextDouble() * 12.0;
            this.moveY = -5.0 - this.frozen.getRandom().nextDouble() * 10.0;
            this.fixed = false;
        }
        this.moveY += FALL_SPEED;
        this.realY += this.moveY;
        this.realX += this.moveX;
        super.absoluteMove(new Point((int)this.realX, (int)this.realY));
        if (this.realY >= 680.0) {
            this.frozen.deleteJumpingBubble(this);
        }
    }

    public void fall() {
        if (this.fixed) {
            this.moveY = this.frozen.getRandom().nextDouble() * 5.0;
        }
        this.fixed = false;
        this.moveY += FALL_SPEED;
        this.realY += this.moveY;
        super.absoluteMove(new Point((int)this.realX, (int)this.realY));
        if (this.realY >= 680.0) {
            this.frozen.deleteFallingBubble(this);
        }
    }

    public void blink() {
        this.blink = true;
    }

    public void frozenify() {
        this.changeSpriteArea(new Rect(this.getSpritePosition().x - 1, this.getSpritePosition().y - 1, 34, 42));
        this.bubbleFace = this.frozenFace;
    }

    public final void paint(Graphics g, double scale, int dx, int dy) {
        this.checkJump = false;
        this.checkFall = false;
        Point p = this.getSpritePosition();
        if (this.blink && this.bubbleFace != this.frozenFace) {
            this.blink = false;
            BubbleSprite.drawImage(this.bubbleBlink, p.x, p.y, g, scale, dx, dy);
        } else if (SettingsManager.isNormalMode() || this.bubbleFace == this.frozenFace) {
            BubbleSprite.drawImage(this.bubbleFace, p.x, p.y, g, scale, dx, dy);
        } else {
            BubbleSprite.drawImage(this.bubbleBlindFace, p.x, p.y, g, scale, dx, dy);
        }
        if (this.fixedAnim != -1) {
            BubbleSprite.drawImage(this.bubbleFixed[this.fixedAnim], p.x, p.y, g, scale, dx, dy);
            ++this.fixedAnim;
            if (this.fixedAnim == 6) {
                this.fixedAnim = -1;
            }
        }
    }
}

