/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.screens;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.audio.SoundSystem;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.engine.Bitmap;
import com.ximad.braincube2.engine.CustomManager;
import com.ximad.braincube2.screens.GameScreen;
import javax.microedition.lcdui.Graphics;

public class TurboGameScreen
extends GameScreen {
    private static TurboGameScreen instance_turbo;

    private TurboGameScreen(int iWorld, int iLevel) {
        super(iWorld, iLevel);
        this.bg = new Bitmap("/img/backgrounds/background_" + this.world + ".jpg");
        ImagesResources.loadTurbo();
        this.layoutManager = new CustomManager(){

            protected void paint(Graphics g) {
                if (TurboGameScreen.this.camera.isAnimationInProgress) {
                    TurboGameScreen.this.camera.makeSmoothAnimation();
                }
                TurboGameScreen.this.drawBackgroundEffect(g);
                TurboGameScreen.this.drawBoard(g);
                if (TurboGameScreen.this.isScrollingMode) {
                    ImagesResources.scrollingImage.draw(g, 0, 0);
                } else {
                    g.setColor(0xFFFFFF);
                    g.setFont(TurboGameScreen.this.boldOblicueFont);
                    int width = TurboGameScreen.this.boldOblicueFont.stringWidth(TurboGameScreen.this.moveCount);
                    g.drawString(TurboGameScreen.this.moveCount, 640 - width - 7, Constants.GAME_SCREEN_COORDS[3][1], 0);
                }
                super.onPaint(g);
            }

            public void execute(int code) {
            }
        };
        this.layoutManager.add(this.pauseButton, Constants.GAME_SCREEN_COORDS[4][0], Constants.GAME_SCREEN_COORDS[4][1]);
        this.layoutManager.add(this.scrollButton, Constants.GAME_SCREEN_COORDS[5][0], Constants.GAME_SCREEN_COORDS[5][1]);
        this.startGame();
        this.layoutManager.execute(0);
    }

    public void exitLevel() {
        SoundSystem.stopTurbo();
        super.exitLevel();
    }

    public void openWorldSelector() {
        SoundSystem.stopTurbo();
        super.openWorldSelector();
    }

    public void reloadLevel() {
        SoundSystem.stopTurbo();
        super.reloadLevel();
    }

    public void onPaint(Graphics g) {
        this.layoutManager.onPaint(g);
    }

    public static TurboGameScreen getInstance(int iWorld, int iLevel) {
        if (instance_turbo == null) {
            instance_turbo = new TurboGameScreen(iWorld, iLevel);
        } else {
            instance_turbo.reinitialize(iWorld, iLevel);
        }
        return instance_turbo;
    }

    protected void reinitialize(int iWorld, int iLevel) {
        super.reinitialize(iWorld, iLevel);
        this.bg = new Bitmap("/img/backgrounds/background_" + this.world + ".jpg");
        ImagesResources.loadTurbo();
        this.startGame();
        this.layoutManager.execute(0);
    }
}

