/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.screens;

import com.ximad.braincube2.audio.SoundSystem;
import com.ximad.braincube2.components.CustomTextBox;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.engine.Application;
import com.ximad.braincube2.engine.CustomButton;
import com.ximad.braincube2.engine.CustomManager;
import com.ximad.braincube2.engine.UiScreen;
import com.ximad.braincube2.utils.Utils;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class RateScreen
extends UiScreen {
    private static RateScreen instance;
    CustomManager manager;
    private CustomButton rateButton;
    private CustomButton cancelButton;
    private CustomTextBox bodyLabel;
    private Font bodyFont;
    private static long rateClickTime;
    private static boolean stopFlag;
    private UiScreen prevScreen;

    private RateScreen(UiScreen prevScreen) {
        this.prevScreen = prevScreen;
        ImagesResources.initRateImages();
        ImagesResources.initCommonPupupButtons();
        stopFlag = false;
        this.bodyLabel = new CustomTextBox(560, 145, Utils.getFont(64, 0, 28), 1);
        this.bodyLabel.setText("Do you like the app?\nFeel free to rate it.\nThanks for your support!");
        this.bodyLabel.setFontColor(0xFFFFFF);
        this.rateButton = new CustomButton(ImagesResources.commonPopupButtons[0][0], ImagesResources.commonPopupButtons[0][1], null, null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                Application.isRating = true;
                try {
                    Application.getInstance().platformRequest("http://store.ovi.com/content/278051");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.cancelButton = new CustomButton(ImagesResources.commonPopupButtons[1][0], ImagesResources.commonPopupButtons[1][1], null, null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                try {
                    RateScreen.this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.manager = new CustomManager(){

            public void onPaint(Graphics g) {
                ImagesResources.shadowImage.draw(g, (640 - ImagesResources.shadowImage.getWidth()) / 2, (360 - ImagesResources.shadowImage.getHeight()) / 2);
                ImagesResources.rateImage.draw(g, 210, 36);
                super.onPaint(g);
            }
        };
        this.manager.add(this.bodyLabel, (640 - this.bodyLabel.getWidth()) / 2, 155);
        this.manager.add(this.rateButton, 170, 260);
        this.manager.add(this.cancelButton, 400, 260);
    }

    public void touchEvent(int touchEventType, int eventX, int eventY) {
        this.manager.touchEvent(touchEventType, eventX, eventY);
    }

    public void close() {
        stopFlag = true;
        Application.setScreen(this.prevScreen);
    }

    public void onPaint(Graphics g) {
        if (this.prevScreen != null) {
            this.prevScreen.onPaint(g);
        }
        this.manager.onPaint(g);
    }

    public static RateScreen getInstance(UiScreen prevScreen) {
        if (instance == null) {
            instance = new RateScreen(prevScreen);
        } else {
            instance.reinitialize(prevScreen);
        }
        return instance;
    }

    private void reinitialize(UiScreen prevScreen) {
        this.prevScreen = prevScreen;
        ImagesResources.initRateImages();
        ImagesResources.initCommonPupupButtons();
        stopFlag = false;
    }
}

