/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.engine;

import com.flurry.javame.FlurryAgent;
import com.ximad.braincube2.Constants;
import com.ximad.braincube2.components.Achievements;
import com.ximad.braincube2.engine.AppSettings;
import com.ximad.braincube2.utils.Utils;
import java.util.Vector;

public class DataManager {
    private static AppSettings appSettings;
    public static boolean isSoundEffectsEnabled;
    public static boolean isSoundMusicEnabled;
    public static int currentSoundLevel;
    private static int numberOfLaunches;
    public static int lastOpened;
    public static boolean isRated;
    private static Vector helpDialogInfo;
    public static boolean isAdsEnable;
    public static boolean episode2Enable;
    public static int[] achievements;
    public static int[] levelsOpenIndicator;
    public static boolean isAdPopupNeeded;
    public static boolean isVideoAdReady;
    public static int clearedLevelsNumber;
    public static boolean isNextLevel;
    public static boolean isPopupAllowed;

    public DataManager() {
        appSettings = new AppSettings();
        appSettings.init("0xc096520e7038ab5eL");
        DataManager.setDefaultSettings();
        DataManager.loadSettings();
    }

    public static void setDefaultSettings() {
        int i;
        isSoundEffectsEnabled = true;
        isSoundMusicEnabled = true;
        currentSoundLevel = 50;
        numberOfLaunches = 0;
        isAdPopupNeeded = true;
        isRated = false;
        helpDialogInfo = new Vector();
        isAdsEnable = true;
        episode2Enable = false;
        achievements = new int[Achievements.ACHIEVENTS_NUMBER];
        for (i = 0; i < Achievements.ACHIEVENTS_NUMBER; ++i) {
            DataManager.achievements[i] = 0;
        }
        levelsOpenIndicator = new int[3];
        for (i = 0; i < 3; ++i) {
            DataManager.levelsOpenIndicator[i] = 0;
        }
    }

    public static boolean loadSettings() {
        try {
            int delim;
            int index;
            int counter;
            String temp;
            if (appSettings.containsItem("SoundEffectsState")) {
                isSoundEffectsEnabled = (Boolean)appSettings.getItem("SoundEffectsState");
            }
            if (appSettings.containsItem("SoundMusicState")) {
                isSoundMusicEnabled = (Boolean)appSettings.getItem("SoundMusicState");
            }
            if (appSettings.containsItem("SoundLevel")) {
                currentSoundLevel = Integer.parseInt(appSettings.getItem("SoundLevel").toString());
            }
            if (appSettings.containsItem("NumberOfLaunches")) {
                numberOfLaunches = Integer.parseInt(appSettings.getItem("NumberOfLaunches").toString());
            }
            if (appSettings.containsItem("isRated")) {
                isRated = (Boolean)appSettings.getItem("isRated");
            }
            if (appSettings.containsItem("HelpDialogInfo")) {
                temp = appSettings.getItem("HelpDialogInfo").toString();
                counter = 0;
                while (counter < temp.length()) {
                    int delim2 = temp.indexOf("_", counter);
                    helpDialogInfo.addElement(Integer.valueOf(temp.substring(counter, delim2)));
                    counter = delim2 + 1;
                }
            }
            if (appSettings.containsItem("isAdsEnable")) {
                isAdsEnable = (Boolean)appSettings.getItem("isAdsEnable");
            }
            if (appSettings.containsItem("episode2Enable")) {
                episode2Enable = (Boolean)appSettings.getItem("episode2Enable");
            }
            if (!episode2Enable && DataManager.getTotalBatteries() >= Constants.MIN_BATTARIES[0]) {
                DataManager.enableEpisode2();
            }
            if (appSettings.containsItem("achievements")) {
                temp = appSettings.getItem("achievements").toString();
                counter = 0;
                index = 0;
                while (counter < temp.length()) {
                    delim = temp.indexOf("_", counter);
                    DataManager.achievements[index] = Integer.valueOf(temp.substring(counter, delim));
                    counter = delim + 1;
                    ++index;
                }
            }
            if (appSettings.containsItem("levelsOpenIndicator")) {
                temp = appSettings.getItem("levelsOpenIndicator").toString();
                counter = 0;
                index = 0;
                while (counter < temp.length()) {
                    delim = temp.indexOf("_", counter);
                    DataManager.levelsOpenIndicator[index] = Integer.valueOf(temp.substring(counter, delim));
                    counter = delim + 1;
                    ++index;
                }
            }
        }
        catch (Exception e) {
            Utils.showMessage("Load settings error:   " + e.toString());
        }
        return true;
    }

    public static int[][] loadLevelsScore(int world) {
        int[][] data = new int[25][3];
        try {
            for (int i = 0; i < 25; ++i) {
                if (appSettings.containsItem("w_" + world + "_l_" + i)) {
                    String temp = appSettings.getItem("w_" + world + "_l_" + i).toString();
                    int delim1 = temp.indexOf(":");
                    int delim2 = temp.indexOf("-");
                    data[i][0] = Integer.parseInt(temp.substring(0, delim1));
                    data[i][1] = Integer.parseInt(temp.substring(delim1 + 1, delim2));
                    data[i][2] = Integer.parseInt(temp.substring(delim2 + 1, temp.length()));
                    continue;
                }
                data[i][0] = 0;
                data[i][1] = 0;
                data[i][2] = 0;
            }
        }
        catch (Exception e) {
            Utils.showMessage("Load level scores error:   " + e.toString());
        }
        return data;
    }

    public static int[] getLevelScore(int world, int level) {
        int[] val = new int[3];
        if (appSettings.containsItem("w_" + world + "_l_" + level)) {
            String temp = appSettings.getItem("w_" + world + "_l_" + level).toString();
            int delim1 = temp.indexOf(":");
            int delim2 = temp.indexOf("-");
            val[0] = Integer.parseInt(temp.substring(0, delim1));
            val[1] = Integer.parseInt(temp.substring(delim1 + 1, delim2));
            val[2] = Integer.parseInt(temp.substring(delim2 + 1, temp.length()));
        }
        return val;
    }

    public static void storeLevelScore(int world, int level, int score, int batteries, int totalBatteries) {
        if (appSettings.containsItem("w_" + world + "_l_" + level)) {
            appSettings.removeItem("w_" + world + "_l_" + level);
        }
        String val = score + ":" + batteries + "-" + totalBatteries;
        appSettings.setItem("w_" + world + "_l_" + level, val);
        appSettings.commit();
        if (score == 1000) {
            int n = Achievements.PERFECT_LEVELS;
            achievements[n] = achievements[n] + 1;
            if (achievements[Achievements.PERFECT_LEVELS] == 3) {
                Achievements.makeAchivment(Achievements.THREE_LEVEL_1000, 1);
            }
            Achievements.makeAchivment(Achievements.ONE_LEVEL_1000, 1);
        }
    }

    public static int getTotalScore() {
        int val = 0;
        if (appSettings.containsItem("totalScore")) {
            val = Integer.parseInt(appSettings.getItem("totalScore").toString());
        }
        return val;
    }

    public static void storeTotalScore(int score) {
        if (appSettings.containsItem("totalScore")) {
            appSettings.removeItem("totalScore");
        }
        appSettings.setItem("totalScore", new Integer(score));
        appSettings.commit();
        if (score >= 10000) {
            Achievements.makeAchivment(Achievements.TOTAL_SCORE_10000, 1);
        }
        if (score >= 25000) {
            Achievements.makeAchivment(Achievements.TOTAL_SCORE_25000, 1);
        }
        if (score >= 40000) {
            Achievements.makeAchivment(Achievements.TOTAL_SCORE_40000, 1);
        }
    }

    public static int getTotalBatteries() {
        int val = 0;
        if (appSettings.containsItem("totalBatteries")) {
            val = Integer.parseInt(appSettings.getItem("totalBatteries").toString());
        } else {
            int[][] bat_1 = DataManager.loadLevelsScore(0);
            for (int i = 0; i < 25; ++i) {
                if (bat_1[i][1] == 0) continue;
                val += bat_1[i][1];
            }
        }
        return val;
    }

    public static void storeTotalBatteries(int score) {
        if (appSettings.containsItem("totalBatteries")) {
            appSettings.removeItem("totalBatteries");
        }
        appSettings.setItem("totalBatteries", new Integer(score));
        appSettings.commit();
        if (score >= Constants.MIN_BATTARIES[0]) {
            DataManager.enableEpisode2();
        }
        if (score >= 1) {
            Achievements.makeAchivment(Achievements.BATTERY_GET_1, 1);
        }
        if (score >= 10) {
            Achievements.makeAchivment(Achievements.BATTERY_GET_10, 1);
        }
        if (score >= 20) {
            Achievements.makeAchivment(Achievements.BATTERY_GET_20, 1);
        }
    }

    public static int getCurrentSoundLvl() {
        return currentSoundLevel;
    }

    public static void setCurrentSoundLvl(int lvl) {
        currentSoundLevel = lvl;
        if (appSettings.containsItem("SoundLevel")) {
            appSettings.removeItem("SoundLevel");
        }
        appSettings.setItem("SoundLevel", new Integer(currentSoundLevel));
    }

    public static int getNumberOfLaunches() {
        ++numberOfLaunches;
        if (appSettings.containsItem("NumberOfLaunches")) {
            appSettings.removeItem("NumberOfLaunches");
        }
        appSettings.setItem("NumberOfLaunches", new Integer(numberOfLaunches));
        appSettings.commit();
        return numberOfLaunches;
    }

    public static void saveSoundEffectsState(boolean state) {
        if (appSettings.containsItem("SoundEffectsState")) {
            appSettings.removeItem("SoundEffectsState");
        }
        appSettings.setItem("SoundEffectsState", new Boolean(state));
        isSoundEffectsEnabled = state;
    }

    public static void saveSoundMusicState(boolean state) {
        if (appSettings.containsItem("SoundMusicState")) {
            appSettings.removeItem("SoundMusicState");
        }
        appSettings.setItem("SoundMusicState", new Boolean(state));
        isSoundMusicEnabled = state;
    }

    public static void rateApp() {
        isRated = true;
        if (appSettings.containsItem("isRated")) {
            appSettings.removeItem("isRated");
        }
        appSettings.setItem("isRated", new Boolean(isRated));
        appSettings.commit();
    }

    public static boolean isNeedToShowHelp(int page) {
        boolean isNeedToShow = true;
        for (int i = 0; i < helpDialogInfo.size(); ++i) {
            int pg = (Integer)helpDialogInfo.elementAt(i);
            if (pg != page) continue;
            isNeedToShow = false;
            break;
        }
        return isNeedToShow;
    }

    public static void showHelpDialog(int page) {
        helpDialogInfo.addElement(new Integer(page));
        String temp = "";
        for (int i = 0; i < helpDialogInfo.size(); ++i) {
            String pg = ((Integer)helpDialogInfo.elementAt(i)).toString();
            temp = temp + pg + "_";
        }
        if (appSettings.containsItem("HelpDialogInfo")) {
            appSettings.removeItem("HelpDialogInfo");
        }
        appSettings.setItem("HelpDialogInfo", temp);
        appSettings.commit();
    }

    public static void enableEpisode2() {
        if (appSettings.containsItem("episode2Enable")) {
            appSettings.removeItem("episode2Enable");
        }
        appSettings.setItem("episode2Enable", new Boolean(true));
        episode2Enable = true;
        appSettings.commit();
    }

    public static boolean saveAchievment(int index, int value) {
        if (achievements[index] == 0) {
            DataManager.achievements[index] = value;
            String temp = "";
            for (int i = 0; i < achievements.length; ++i) {
                temp = temp + achievements[i] + "_";
            }
            if (appSettings.containsItem("achievements")) {
                appSettings.removeItem("achievements");
            }
            appSettings.setItem("achievements", temp);
            appSettings.commit();
            FlurryAgent.onEvent("ACHIEVMENT_" + index);
            return true;
        }
        return false;
    }

    public static void unlockLevel(int episode) {
        if (levelsOpenIndicator[episode] == 0) {
            DataManager.levelsOpenIndicator[episode] = 1;
            String temp = "";
            for (int i = 0; i < levelsOpenIndicator.length; ++i) {
                temp = temp + levelsOpenIndicator[i] + "_";
            }
            if (appSettings.containsItem("levelsOpenIndicator")) {
                appSettings.removeItem("levelsOpenIndicator");
            }
            appSettings.setItem("levelsOpenIndicator", temp);
            appSettings.commit();
        }
    }

    public static void saveSettings() {
        try {
            appSettings.setItem("GameSpeed", new Integer(0));
            appSettings.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void onChangeVolume() {
    }
}

