/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.components;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.component.Field;
import com.ximad.braincube2.components.Achievements;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.utils.Utils;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class AchievementsButton
extends Field {
    public int type;
    private Font titleFont;
    private Font descriptionFont;
    private boolean isVisible = true;

    public AchievementsButton(int iType) {
        this.type = iType;
        this.titleFont = Utils.getFont(64, 1, Constants.achievementItemProps[4][0]);
        this.descriptionFont = Utils.getFont(0, 0, 8);
        this.width = ImagesResources.endGameImages[5][0].getWidth();
        this.height = ImagesResources.endGameImages[5][0].getHeight();
    }

    public void onPaint(Graphics g) {
        if (this.isVisible) {
            ImagesResources.endGameImages[5][0].draw(g, this.left, this.top);
            ImagesResources.achievementImages[this.type].draw(g, this.left + Constants.achievementItemProps[0][0], this.top + Constants.achievementItemProps[0][1]);
            g.setColor(15258368);
            g.setFont(this.titleFont);
            g.drawString(Achievements.description[this.type][0], this.left + Constants.achievementItemProps[1][0], this.top + Constants.achievementItemProps[1][1], 20);
            g.setColor(0xD4D4D4);
            g.setFont(this.descriptionFont);
            g.drawString(Achievements.description[this.type][1], this.left + Constants.achievementItemProps[2][0], this.top + Constants.achievementItemProps[2][1], 20);
        }
    }

    public boolean isFocusable() {
        return false;
    }

    public void setType(int iType) {
        this.type = iType;
        this.repaint();
    }

    public boolean touchEvent(int touchEventType, int eventX, int eventY) {
        if (!this.isVisible && touchEventType != 1) {
            return false;
        }
        boolean out = false;
        if (eventX < this.left || eventX > this.left + this.width || eventY < this.top || eventY > this.top + this.height) {
            out = true;
        }
        switch (touchEventType) {
            case 2: {
                if (out) {
                    return false;
                }
                this.repaint();
                break;
            }
            case 1: {
                if (!out && this.status == 1) {
                    this.touchAction();
                    this.status = 0;
                    this.repaint();
                    break;
                }
                if (this.status == 1) {
                    this.status = 0;
                    this.repaint();
                    break;
                }
                this.status = 0;
            }
        }
        return !out;
    }

    protected void touchAction() {
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
        this.repaint();
    }
}

