/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.audio;

import com.ximad.braincube2.audio.Sound;
import com.ximad.braincube2.audio.SoundManager;
import com.ximad.braincube2.engine.DataManager;
import com.ximad.braincube2.utils.Utils;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class SoundSystem {
    public static boolean isInited = false;
    public static SoundManager sm;
    public static SoundManager mm;
    public static Sound SOUND_COINS;
    private static Sound[] clipsMap;
    private static Sound backgroundSoundPlayer;
    private static Thread backgroundSoundPlayerThread;
    public static boolean isPlayerActive;
    public static boolean isNeedToPlaySound;
    public static int NUM_OF_SOUNDS;
    public static boolean globalLock;
    public static boolean turboPlayerStare;
    public static final int ROLLING_SOUND_0 = 0;
    public static final int ROLLING_SOUND_1 = 1;
    public static final int ROLLING_SOUND_2 = 2;
    public static final int ROLLING_SOUND_3 = 3;
    public static final int CUBE_IN = 4;
    public static final int CUBE_OUT = 5;
    public static final int FINISH_SOUND = 6;
    public static final int LASER_BRIDGE_ON_SOUND = 7;
    public static final int LASER_BRIDGE_OFF_SOUND = 8;
    public static final int CONSTANT_BRIDGE_ON_SOUND = 9;
    public static final int SPRING_SOUND = 10;
    public static final int ARROW_SOUND = 11;
    public static final int ROTATOR_SOUND = 12;
    public static final int BATTERY_IN_SOUND = 13;
    public static final int BATTERY_OUT_SOUND = 14;
    public static final int BATTERY_GET_SOUND = 15;
    public static final int MAGNETO_IN_SOUND = 16;
    public static final int MAGNETO_OUT_SOUND = 17;
    public static final int MAGNETO_CUBE_SOUND = 18;
    public static final int MENU_CLICK_SOUND = 19;
    public static final int TURBO_SOUND = 20;
    public static final int TURBO_FALL_BLOCK = 21;
    public static final int MENU_BUTTON_CLICK_1 = 22;
    public static final int MENU_BUTTON_CLICK_2 = 23;
    private static PlayerListener pl;

    public static void init() {
        sm = new SoundManager();
        mm = new SoundManager();
        clipsMap = new Sound[NUM_OF_SOUNDS];
        isPlayerActive = false;
        isNeedToPlaySound = true;
        globalLock = false;
        turboPlayerStare = false;
        pl = new PlayerListener(){

            public void playerUpdate(Player player, String event, Object eventData) {
                if (event.equals("endOfMedia")) {
                    isPlayerActive = false;
                }
            }
        };
        isInited = true;
    }

    public static void initSounds() {
        for (int i = 0; i < NUM_OF_SOUNDS; ++i) {
            if (clipsMap[i] != null) continue;
            SoundSystem.clipsMap[i] = SoundSystem.loadPlayer(i);
        }
    }

    public static void initMusic() {
        if (backgroundSoundPlayer == null) {
            backgroundSoundPlayer = new Sound(mm, "/sounds/sound_bg.mp3");
        }
    }

    public static void playButtonSound() {
        if (Utils.random() > 0.5f) {
            SoundSystem.play(22);
        } else {
            SoundSystem.play(23);
        }
    }

    public static void playBackgroundMusic() {
        if (backgroundSoundPlayer == null) {
            SoundSystem.initMusic();
        }
        if (backgroundSoundPlayer != null) {
            backgroundSoundPlayer.playInLoop();
        }
    }

    public static void stopBackgroundMusic() {
        if (backgroundSoundPlayer != null) {
            backgroundSoundPlayer.stop();
        }
    }

    public static void stopSounds() {
        for (int i = 0; i < NUM_OF_SOUNDS; ++i) {
            if (clipsMap[i] == null) continue;
            clipsMap[i].stop();
            clipsMap[i].setMediaTime(0);
        }
        isPlayerActive = false;
        isNeedToPlaySound = true;
    }

    private static Sound loadPlayer(int index) {
        Sound player = null;
        try {
            String fn = "/sounds/sound_" + index + ".mp3";
            player = new Sound(sm, fn);
            player.addPlayerListener(pl);
        }
        catch (Exception e) {
            System.out.println("Could not load index " + index);
        }
        return player;
    }

    public static void play(int index) {
        Sound player;
        if (!globalLock && (player = clipsMap[index]) != null && !isPlayerActive && DataManager.isSoundEffectsEnabled) {
            isPlayerActive = true;
            player.play();
        }
    }

    public static void playRollingSound(int mode) {
        int index = 0;
        switch (mode) {
            case 0: {
                index = Utils.getRandomNumber(4);
                break;
            }
            case 1: {
                index = Utils.getRandomNumber(4);
            }
        }
        SoundSystem.play(index);
    }

    public static void startTurbo() {
        globalLock = true;
        Sound player = clipsMap[20];
        player.playInLoop();
    }

    public static void stopTurbo() {
        globalLock = false;
        Sound player = clipsMap[20];
        if (clipsMap[20] != null) {
            clipsMap[20].stop();
        }
    }

    public static void cleanup() {
        if (backgroundSoundPlayer != null) {
            backgroundSoundPlayer.stop();
            backgroundSoundPlayer = null;
        }
        for (int i = 0; i < NUM_OF_SOUNDS; ++i) {
            if (clipsMap[i] == null) continue;
            clipsMap[i].stop();
            SoundSystem.clipsMap[i] = null;
        }
    }

    public static void release() {
        sm.releaseAll();
        mm.releaseAll();
        isInited = false;
    }

    static {
        isPlayerActive = false;
        NUM_OF_SOUNDS = 24;
    }
}

