/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class Menu
extends Canvas
implements Runnable {
    public static boolean[] keys = new boolean[7];
    public static int UP = 0;
    public static int DOWN = 1;
    public static int LEFT = 2;
    public static int RIGHT = 3;
    public static int FIRE = 4;
    public static int SOFT_L = 5;
    public static int SOFT_R = 6;
    private static long LOGO_DELAY = 3000L;
    private static long lastTime;
    protected static boolean active;
    public static Menu instance;
    private boolean running;
    public static int W;
    public static int H;
    private int key_right;
    private int key_left;
    private int key_up;
    private int key_down;
    private int key_fire;
    private int key_softL;
    private int key_softR;
    public static final int SCENE_MAIN = 0;
    public static final int SCENE_HELP = 1;
    public static final int SCENE_ABOUT = 2;
    public static final int SCENE_SOUND_QUERY = 3;
    public static final int SCENE_LOAD = 4;
    public static final int SCENE_LOGO = 5;
    public static final int SCENE_OPTIONS = 6;
    public static final int SCENE_EXIT_QUERY = 7;
    public static final int SCENE_GAME = 8;
    public static final int SCENE_CONTINUE = 9;
    public static final int SCENE_LANG = 10;
    public static int curScene;
    public static final int SC_TYPE_LIST = 0;
    public static final int SC_TYPE_LOGO = -2;
    public static final int SC_TYPE_LOAD = -1;
    public static final int SC_TYPE_TEXT = 2;
    public static final int SC_TYPE_GAME = -3;
    public static Image img;
    public static final short[][] SC_DATA;
    public static final int[][] itemList;
    public static int itemMaxVis;
    public static int itemCnt;
    public static int curItem;
    public static int itemShift;
    public static int[] curList;
    public static int itemTop;
    public static int header;
    public static int softL;
    public static int softR;
    public static short[] parsed;
    public static byte[] txt;
    public static int scroll;
    public static int itemH;
    public static int loadCnt;
    public static long lastSoundTime;
    public static long SoundStoppedTime;
    public static final String RS_GAME = "bobr.save";
    public static final String RS_OPT = "bobr.save.opt";

    private static void drawBox(Graphics g2, int x2, int y2, int w2, int h2) {
        g2.setClip(x2, y2, w2, h2);
        g2.setColor(2630685);
        g2.fillRect(x2, y2, w2, h2);
        g2.setColor(0);
        g2.drawRect(x2, y2, w2, h2);
    }

    private static void drawButton(Graphics g2, int x2, int y2, boolean active, int w2, int txt) {
        g2.drawImage(active ? LocalMenu.button_active : LocalMenu.button_pasive, Game.W / 2, y2, 1 | 0x10);
        FontText.renderText(g2, txt, Game.W / 2, y2 + LocalMenu.button_active.getHeight() / 2, 5, FontText.font_big_id);
    }

    private static void drawHeader(Graphics g2, int header) {
        g2.drawImage(LocalMenu.header_left, 0, 0, 4 | 0x10);
        for (int i2 = 0; i2 < (Game.W - LocalMenu.header_left.getWidth() - LocalMenu.header_right.getWidth()) / LocalMenu.header_middle.getWidth() + 1; ++i2) {
            g2.drawImage(LocalMenu.header_middle, LocalMenu.header_left.getWidth() + i2 * LocalMenu.header_middle.getWidth(), 0, 4 | 0x10);
        }
        g2.drawImage(LocalMenu.header_right, Game.W, 0, 8 | 0x10);
        FontText.renderText(g2, header, W / 2, LocalMenu.header_middle.getHeight() / 2, 5, FontText.font_big_id);
    }

    public static void drawLoadBar(Graphics g2) {
        g2.setClip(0, 0, W, H);
        g2.drawImage(img, 0, 0, 4 | 0x10);
        g2.setColor(0);
        g2.fillRect(0, H - 4, W, 4);
        g2.setColor(255, 191, 0);
        g2.fillRect(0, H - 3, W * curItem / (loadCnt + 2), 3);
    }

    public static void drawSoftBar(Graphics g2, int softL, int softR) {
        int i2;
        if (SC_DATA[curScene][0] == -2 || SC_DATA[curScene][0] == -1) {
            return;
        }
        g2.drawImage(LocalMenu.soft_left, 0, Game.H, 4 | 0x20);
        for (i2 = 0; i2 < (Game.W / 2 - 5 - LocalMenu.soft_left.getWidth() - LocalMenu.soft_right.getWidth()) / LocalMenu.soft_middle.getWidth() + 1; ++i2) {
            g2.drawImage(LocalMenu.soft_middle, LocalMenu.soft_left.getWidth() + i2 * LocalMenu.soft_middle.getWidth(), Game.H, 4 | 0x20);
        }
        g2.drawImage(LocalMenu.soft_right, Game.W / 2 - 5, Game.H, 8 | 0x20);
        g2.drawImage(LocalMenu.soft_left, Game.W / 2 + 5, Game.H, 4 | 0x20);
        for (i2 = 0; i2 < (Game.W / 2 - 5 - LocalMenu.soft_left.getWidth() - LocalMenu.soft_right.getWidth()) / LocalMenu.soft_middle.getWidth() + 1; ++i2) {
            g2.drawImage(LocalMenu.soft_middle, Game.W / 2 + 5 + LocalMenu.soft_left.getWidth() + i2 * LocalMenu.soft_middle.getWidth(), Game.H, 4 | 0x20);
        }
        g2.drawImage(LocalMenu.soft_right, Game.W, Game.H, 8 | 0x20);
        if (softL != -1) {
            Menu.drawSoftL(g2, softL);
        }
        if (softR != -1) {
            Menu.drawSoftR(g2, softR);
        }
    }

    public static void drawSoftL(Graphics g2, int softL) {
        if (W == 128 && (FontText.curLang == 2 || FontText.curLang == 4 || FontText.curLang == 6)) {
            FontText.renderText(g2, softL, 3, H - LocalMenu.soft_middle.getHeight() / 2, 4, FontText.font_big_id);
        } else {
            FontText.renderText(g2, softL, (W / 2 - 5) / 2, H - LocalMenu.soft_middle.getHeight() / 2, 5, FontText.font_big_id);
        }
    }

    public static void drawSoftR(Graphics g2, int softR) {
        FontText.renderText(g2, softR, W - (W / 2 - 5) / 2, H - LocalMenu.soft_middle.getHeight() / 2, 5, FontText.font_big_id);
    }

    private static boolean isActive() {
        return active;
    }

    public void nextLoadPhase(int i2) {
    }

    public void newGame() {
        active = true;
    }

    public void pauseGame() {
    }

    public void resumeGame() {
    }

    public Menu() {
        k.a(this);
        this.key_right = -4;
        this.key_left = -3;
        this.key_up = -1;
        this.key_down = -2;
        this.key_fire = -5;
        this.key_softL = -6;
        this.key_softR = -7;
        instance = this;
        this.setFullScreenMode(true);
        new Thread(this).start();
    }

    protected void paint(Graphics g2) {
        if (!this.running) {
            return;
        }
        if (SC_DATA[curScene][0] == -3) {
            this.gameLoop(g2);
            return;
        }
        Menu.updateScene();
        this.drawBG(g2);
        Menu.renderScene(g2);
    }

    public void run() {
        W = this.getWidth();
        H = this.getHeight();
        Menu.setNextScene(5);
        this.running = true;
        while (true) {
            this.repaint();
        }
    }

    private static void resetKeys() {
        for (int i2 = 0; i2 < keys.length; ++i2) {
            Menu.keys[i2] = false;
        }
    }

    protected void keyReleased(int key) {
        if (key == 54 || key == this.key_right || key == -this.key_right) {
            Menu.keys[Menu.RIGHT] = false;
            this.numKeyReleased(6);
        } else if (key == 52 || key == this.key_left || key == -this.key_left) {
            Menu.keys[Menu.LEFT] = false;
            this.numKeyReleased(4);
        } else if (key == 50 || key == this.key_up || key == -this.key_up) {
            Menu.keys[Menu.UP] = false;
            this.numKeyReleased(2);
        } else if (key == 56 || key == this.key_down || key == -this.key_down) {
            Menu.keys[Menu.DOWN] = false;
            this.numKeyReleased(8);
        } else if (key == 57) {
            this.numKeyReleased(9);
        } else if (key == 51) {
            this.numKeyReleased(3);
        } else if (key == 49) {
            this.numKeyReleased(1);
        } else if (key == 48) {
            this.numKeyReleased(0);
        } else if (key == 35) {
            this.numKeyReleased(11);
        } else if (key == 42) {
            this.numKeyReleased(10);
        } else if (key == 55) {
            this.numKeyReleased(7);
        } else if (key == 53 || key == this.key_fire || key == -this.key_fire) {
            Menu.keys[Menu.FIRE] = false;
            this.numKeyReleased(5);
        }
    }

    protected void keyPressed(int key) {
        if (key == 54 || key == this.key_right || key == -this.key_right) {
            Menu.keys[Menu.RIGHT] = true;
            this.gameKey(RIGHT);
            this.numKeyPressed(6);
        } else if (key == 52 || key == this.key_left || key == -this.key_left) {
            Menu.keys[Menu.LEFT] = true;
            this.gameKey(LEFT);
            this.numKeyPressed(4);
        } else if (key == 50 || key == this.key_up || key == -this.key_up) {
            Menu.keys[Menu.UP] = true;
            this.gameKey(UP);
            this.numKeyPressed(2);
        } else if (key == 56 || key == this.key_down || -key == this.key_down) {
            Menu.keys[Menu.DOWN] = true;
            this.gameKey(DOWN);
            this.numKeyPressed(8);
        } else if (key == 57) {
            this.numKeyPressed(9);
        } else if (key == 51) {
            this.numKeyPressed(3);
        } else if (key == 49) {
            this.numKeyPressed(1);
        } else if (key == 48) {
            this.numKeyPressed(0);
        } else if (key == 35) {
            this.numKeyPressed(11);
        } else if (key == 42) {
            this.numKeyPressed(10);
        } else if (key == 55) {
            this.numKeyPressed(7);
        } else if (key == 53 || key == this.key_fire || -key == this.key_fire) {
            Menu.keys[Menu.FIRE] = true;
            this.gameKey(FIRE);
            this.numKeyPressed(5);
        } else if (key == this.key_softL || key == -this.key_softL) {
            Menu.keys[Menu.SOFT_L] = true;
            this.gameKey(SOFT_L);
        } else if (key == this.key_softR || key == -this.key_softR) {
            Menu.keys[Menu.SOFT_R] = true;
            this.gameKey(SOFT_R);
        }
    }

    public void drawBG(Graphics g2) {
        try {
            g2.drawImage(LocalMenu.background, 0, 0, 4 | 0x10);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void gameKey(int key) {
    }

    public void numKeyReleased(int key) {
    }

    public void numKeyPressed(int key) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setNextScene(int nextScene) {
        Menu.resetKeys();
        if (nextScene == 0) {
            if (SC_DATA[curScene][0] == -2) {
                instance.loadGame();
            }
            Menu.sndPlay(0);
            lastSoundTime = System.currentTimeMillis();
        } else {
            Menu.stopSounds();
        }
        if (curScene == 6 || curScene == 10) {
            Menu.saveOpt();
        }
        if (nextScene == -1) {
            return;
        }
        Menu.constructScene(nextScene);
        curScene = nextScene;
        try {
            if (nextScene == 4) {
                img = Image.createImage((String)"/splash.png");
                return;
            }
            if (SC_DATA[curScene][0] != -3) return;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void constructScene(int scene) {
        short[] data = SC_DATA[scene];
        short type = data[0];
        header = data[1];
        softL = data[2];
        softR = data[3];
        if (data[4] != -1) {
            try {
                img = Image.createImage((String)("/" + data[4] + ".png"));
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        } else {
            img = null;
        }
        switch (type) {
            case 0: {
                itemTop = itemH;
                if (img != null) {
                    itemTop += img.getHeight();
                }
                curItem = 0;
                itemShift = 0;
                if (data[8] == -1) {
                    curList = new int[FontText.getFontCng() * 2];
                    for (int i2 = 0; i2 < curList.length; ++i2) {
                        Menu.curList[i2] = -10 - i2 / 2;
                    }
                } else {
                    curList = itemList[data[8]];
                    if (Menu.hasRS(RS_GAME) && scene == 0) {
                        curList = itemList[data[8] + 1];
                    }
                }
                itemCnt = curList.length / 2;
                itemMaxVis = Math.min(itemCnt, (H - itemH - itemTop) / (itemH + 3));
                itemTop = H / 2 + itemTop / 2 - itemMaxVis * (itemH + 3) / 2;
                break;
            }
            case -2: {
                curItem = 0;
                lastTime = 0L;
                break;
            }
            case 2: {
                parsed = FontText.parseText(data[7], W, FontText.font_big_id);
                break;
            }
            case -1: {
                curItem = 0;
                break;
            }
            case -3: {
                if (scene == 8) {
                    instance.newGame();
                } else if (Menu.isActive()) {
                    instance.resumeGame();
                } else {
                    instance.loadGame();
                }
                try {
                    if (Game.STAGE == 2 || Game.STAGE == 0) {
                        parsed = FontText.parseText(75 + Game.LEV * 2, Hud.paper.getWidth() - 40, FontText.font_small_id);
                        break;
                    }
                    if (Game.STAGE != 3) break;
                    parsed = FontText.parseText(76 + Game.LEV * 2, Hud.paper.getWidth() - 40, FontText.font_small_id);
                    break;
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
        }
    }

    public static void renderScene(Graphics g2) {
        if (curScene == 0 && Menu.sndEnabled()) {
            if (System.currentTimeMillis() - lastSoundTime > 31300L) {
                lastSoundTime = System.currentTimeMillis();
                Menu.sndPlay(0);
            } else if (System.currentTimeMillis() - lastSoundTime > 31000L) {
                Menu.stopSounds();
            }
        }
        int buttH = itemH;
        if (header != -1) {
            Menu.drawHeader(g2, header);
        }
        Menu.drawSoftBar(g2, softL, softR);
        switch (SC_DATA[curScene][0]) {
            case 0: {
                for (int i2 = 0; i2 < itemMaxVis; ++i2) {
                    Menu.drawButton(g2, W / 20, itemTop + i2 * (buttH + 3) - 8, i2 + itemShift == curItem, W * 9 / 10, curList[(i2 + itemShift) * 2]);
                }
                break;
            }
            case 2: {
                scroll = FontText.renderParseText(g2, parsed, scroll, new int[]{0, buttH, W, H - buttH}, 5, FontText.font_big_id);
                break;
            }
            case -2: {
                g2.setClip(0, 0, W, H);
                g2.setColor(-1);
                g2.fillRect(0, 0, W, H);
                g2.drawImage(img, W / 2, H / 2, 3);
                break;
            }
            case -1: {
                Menu.drawLoadBar(g2);
            }
        }
    }

    public static void updateScene() {
        if (SC_DATA[curScene][0] == -1) {
            switch (curItem) {
                case 0: {
                    FontText.loadFonts("f");
                    break;
                }
                case 1: {
                    FontText.loadTexts("t");
                    break;
                }
                default: {
                    if (curItem > loadCnt + 1) {
                        if (Menu.hasRS(RS_OPT)) {
                            Menu.loadOpt();
                            Menu.setNextScene(0);
                        } else {
                            Menu.setNextScene(10);
                        }
                        return;
                    }
                    instance.nextLoadPhase(curItem - 2);
                }
            }
            ++curItem;
            return;
        }
        if (SC_DATA[curScene][0] == -2) {
            try {
                W = instance.getWidth();
                H = instance.getHeight();
                long time = System.currentTimeMillis();
                if (time - lastTime > LOGO_DELAY) {
                    img = Image.createImage((String)("/l" + curItem + ".png"));
                    ++curItem;
                    lastTime = time;
                }
                if (curItem == 3) {
                    Menu.setNextScene(4);
                }
                return;
            }
            catch (Exception e2) {
                try {
                    img = Image.createImage((String)"/splash.png");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Menu.setNextScene(4);
            }
        } else if (SC_DATA[curScene][0] == 0) {
            if (keys[UP]) {
                Menu.keys[Menu.UP] = false;
                if (curItem <= itemShift) {
                    if (itemShift > 0) {
                        --itemShift;
                        --curItem;
                    } else {
                        curItem = itemCnt - 1;
                        itemShift = Math.max(itemCnt - itemMaxVis, 0);
                    }
                } else {
                    --curItem;
                }
            } else if (keys[DOWN]) {
                Menu.keys[Menu.DOWN] = false;
                if (curItem < itemMaxVis + itemShift - 1) {
                    curItem = curItem < itemCnt - 1 ? ++curItem : 0;
                } else if (itemShift < itemCnt - itemMaxVis) {
                    ++itemShift;
                    ++curItem;
                } else {
                    curItem = 0;
                    itemShift = 0;
                }
            }
        }
        Menu.processSoft();
    }

    public static void processSoft() {
        if (keys[SOFT_R]) {
            Menu.keys[Menu.SOFT_R] = false;
            if (curScene == 10) {
                return;
            }
            Menu.setNextScene(SC_DATA[curScene][5]);
        } else if (keys[SOFT_L] || keys[FIRE]) {
            Menu.keys[Menu.FIRE] = false;
            Menu.keys[Menu.SOFT_L] = false;
            if (curScene == 3) {
                Data.isSoundOn = true;
                Menu.setNextScene(0);
                return;
            }
            if (curScene == 10) {
                System.out.println("item " + curItem);
                FontText.curLang = curItem;
                if (Menu.hasRS(RS_OPT)) {
                    Menu.setNextScene(0);
                } else {
                    Menu.setNextScene(3);
                }
                return;
            }
            if (curScene == 6) {
                if (curItem == 0) {
                    Data.isSoundOn = !Data.isSoundOn;
                } else {
                    Menu.setNextScene(10);
                }
                Menu.saveOpt();
                return;
            }
            if (curScene == 7) {
                Menu.saveOpt();
                try {
                    Mid.ins.destroyApp(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return;
            }
            int next = SC_DATA[curScene][6];
            if (SC_DATA[curScene][0] == 0) {
                next = curList[curItem * 2 + 1];
            }
            Menu.setNextScene(next);
        }
    }

    public void gameLoop(Graphics g2) {
    }

    public static void setloadCnt(int i2) {
        loadCnt = i2 + 2;
    }

    public void loadGame() {
        DataInputStream dis = Menu.recordGet(RS_GAME);
        try {
            System.out.println("SoundLoaded");
            Game.LEV = (byte)dis.readInt();
            int map_height = dis.readInt();
            int map_width = dis.readInt();
            Map.race = null;
            System.gc();
            Map.race = new int[map_height][map_width];
            for (int i2 = 0; i2 > map_height; ++i2) {
                for (int j2 = 0; j2 < map_width; ++j2) {
                    int lev;
                    Map.race[i2][j2] = dis.readInt();
                    Map.obj_type[i2][j2] = dis.readInt();
                    if (Map.obj_type[i2][j2] == 0) {
                        dis.readInt();
                        dis.readInt();
                        continue;
                    }
                    if (Map.obj_type[i2][j2] == 3) {
                        Capital.create(j2, i2);
                        dis.readInt();
                        continue;
                    }
                    if (Map.obj_type[i2][j2] == 4) {
                        Gold.create(j2, i2);
                        dis.readInt();
                        continue;
                    }
                    if (Map.obj_type[i2][j2] == 5) {
                        int kind = dis.readInt();
                        Tree.create(j2, i2, kind);
                        continue;
                    }
                    if (Map.obj_type[i2][j2] == 1) {
                        lev = dis.readInt();
                        Map.activeHexX = j2;
                        Map.activeHexX = i2;
                        Unit.create();
                        Unit.level[Unit.number - 1] = lev;
                        continue;
                    }
                    if (Map.obj_type[i2][j2] != 2) continue;
                    lev = dis.readInt();
                    Map.activeHexX = j2;
                    Map.activeHexX = i2;
                    Tower.create();
                    Tower.level[Tower.number - 1] = lev;
                }
            }
            int num_of_players = dis.readInt();
            Players.players = new Player[num_of_players];
            for (int i3 = 0; i3 < num_of_players; ++i3) {
                int race_of_player = dis.readInt();
                Players.players[i3] = new Player(race_of_player);
                Players.players[i3].buildTerritories();
                int num_fo_ter = dis.readInt();
                for (int j3 = 0; j3 < num_fo_ter; ++j3) {
                    Players.players[i3].money[j3] = dis.readInt();
                }
            }
            System.out.println("load level " + Game.LEV + 1);
            dis.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void saveGame() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            int j2;
            int i2;
            System.out.println("Sound_Saved");
            dos.writeInt(Game.LEV);
            dos.writeInt(Map.race.length);
            dos.writeInt(Map.race[0].length);
            for (i2 = 0; i2 < Map.race.length; ++i2) {
                for (j2 = 0; j2 < Map.race[0].length; ++j2) {
                    dos.writeInt(Map.race[i2][j2]);
                    if (Map.obj_type[i2][j2] == 0) {
                        dos.writeInt(-1);
                        dos.writeInt(-1);
                        continue;
                    }
                    if (Map.obj_type[i2][j2] == 3 || Map.obj_type[i2][j2] == 4) {
                        dos.writeInt(Map.obj_type[i2][j2]);
                        dos.writeInt(-1);
                        continue;
                    }
                    if (Map.obj_type[i2][j2] == 5) {
                        dos.writeInt(Map.obj_type[i2][j2]);
                        dos.writeInt(Tree.kind[Map.obj_number[i2][j2]]);
                        continue;
                    }
                    if (Map.obj_type[i2][j2] == 1) {
                        dos.writeInt(Map.obj_type[i2][j2]);
                        dos.writeInt(Unit.level[Map.obj_number[i2][j2]]);
                        continue;
                    }
                    if (Map.obj_type[i2][j2] != 2) continue;
                    dos.writeInt(Map.obj_type[i2][j2]);
                    dos.writeInt(Tower.level[Map.obj_number[i2][j2]]);
                }
            }
            dos.writeInt(Players.num_of_players);
            for (i2 = 0; i2 < Players.num_of_players; ++i2) {
                dos.writeInt(Players.players[i2].race);
                dos.writeInt(Players.players[i2].num_of_territories);
                for (j2 = 0; j2 < Players.players[i2].num_of_territories; ++j2) {
                    dos.writeInt(Players.players[i2].money[j2]);
                }
            }
            System.out.println("save " + Game.LEV + 1);
            Menu.recordSet(baos, RS_GAME);
            dos.close();
            baos.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void loadOpt() {
        DataInputStream dis = Menu.recordGet(RS_OPT);
        try {
            Data.isSoundOn = dis.readBoolean();
            FontText.curLang = dis.readByte();
            dis.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void saveOpt() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeBoolean(Data.isSoundOn);
            dos.writeByte(FontText.curLang);
            Menu.recordSet(baos, RS_OPT);
            dos.close();
            baos.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private static final DataInputStream recordGet(String recordName) {
        try {
            RecordStore record = RecordStore.openRecordStore((String)recordName, (boolean)false);
            byte[] data = record.getRecord(1);
            record.closeRecordStore();
            return new DataInputStream(new ByteArrayInputStream(data));
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static final boolean hasRS(String a_name) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)a_name, (boolean)false);
            rs.closeRecordStore();
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static boolean recordSet(ByteArrayOutputStream baos, String name) {
        boolean result = false;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)name, (boolean)true);
            try {
                rs.setRecord(1, baos.toByteArray(), 0, baos.size());
            }
            catch (Exception e2) {
                rs.addRecord(baos.toByteArray(), 0, baos.size());
                e2.printStackTrace();
            }
            rs.closeRecordStore();
            result = true;
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        return result;
    }

    public static boolean fileExist(String fileName) {
        boolean result = false;
        try {
            InputStream is = ((Object)((Object)Mid.ins)).getClass().getResourceAsStream(fileName);
            if (is != null) {
                result = true;
                is.close();
            }
        }
        catch (Exception e2) {
            result = false;
        }
        return result;
    }

    protected void hideNotify() {
        this.pauseGame();
        Menu.stopSounds();
    }

    protected void showNotify() {
        Menu.sndPlay(0);
        if (SC_DATA[curScene][0] == -3) {
            Menu.setNextScene(0);
        }
    }

    public static void loadSounds() {
        new Snd();
        Snd.load_sounds();
    }

    public static void sndPlay(int sndID) {
        Snd.sndPlay(sndID);
    }

    public static void stopSounds() {
        Snd.stopAllSounds();
    }

    public static boolean sndEnabled() {
        return Snd.isEnabled();
    }

    static {
        active = false;
        curScene = 0;
        SC_DATA = new short[][]{{0, 9, 23, 7, -1, 7, -1, -1, 0}, {2, 4, -1, 9, -1, 0, -1, 26}, {2, 5, -1, 9, -1, 0, -1, 27}, {2, 11, 21, 22, 0, 0, -1, 28}, {-1, -1, -1, -1, -1, -1, -1, -1}, {-2, -1, -1, -1, -1, -1, -1, -1}, {0, 3, 23, 10, -1, 0, -1, -1, 2}, {2, 7, 21, 22, -1, 0, -1, 7}, {-3, -1, -1, -1, -1, -1, -1}, {-3, -1, -1, -1, -1, -1, -1}, {0, 14, 23, -1, -1, 3, -1, -1, -1}};
        itemList = new int[][]{{2, 8, 3, 6, 5, 2, 4, 1, 7, 7}, {8, 9, 2, 8, 3, 6, 5, 2, 4, 1, 7, 7}, {-2, -1, 14, -1}};
        itemMaxVis = 0;
        itemCnt = 0;
        curItem = 0;
        itemShift = 0;
        itemTop = 0;
        header = 0;
        softL = 0;
        softR = 0;
        itemH = 28;
        loadCnt = 0;
        lastSoundTime = 0L;
        SoundStoppedTime = 0L;
    }
}

