/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Map {
    public static final int obj_none = 0;
    public static final int obj_unit = 1;
    public static final int obj_tower = 2;
    public static final int obj_capital = 3;
    public static final int obj_gold = 4;
    public static final int obj_tree = 5;
    public static int hex_half_widht_global = 0;
    public static int hex_half_height_global = 0;
    public static int hex_half_widht_local = 0;
    public static int hex_half_height_local = 0;
    public static int local_map_width = 4;
    public static int local_map_height = 0;
    public static int global_DX = 0;
    public static int global_DY = 0;
    public static int[][] race;
    public static int[][] territory;
    public static int[][] obj_type;
    public static int[][] obj_number;
    public static int activeHexX;
    public static int activeHexY;
    public static boolean global;
    public static Image[] hexIm;
    public static Image waterIm;
    public static Image waterLeft;
    public static Image waterRight;
    public static Image waterDownLeft;
    public static Image waterDownRight;
    public static Image hexFrameIm;

    public static void loadImages() {
        hexIm = new Image[5];
        try {
            Map.hexIm[0] = Image.createImage((String)"/h_hex.png");
            Map.hexIm[1] = Image.createImage((String)"/o_hex.png");
            Map.hexIm[2] = Image.createImage((String)"/e_hex.png");
            Map.hexIm[3] = Image.createImage((String)"/u_hex.png");
            Map.hexIm[4] = Image.createImage((String)"/n_hex.png");
            waterIm = Image.createImage((String)"/t_water.png");
            waterLeft = Image.createImage((String)"/wat_left.png");
            waterRight = Image.createImage((String)"/wat_right.png");
            waterDownLeft = Image.createImage((String)"/wat_down_left.png");
            waterDownRight = Image.createImage((String)"/wat_down_right.png");
            hexFrameIm = Image.createImage((String)"/obvodka_hexa.png");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void loadMap() {
        int i2;
        Players.num_of_players = 0;
        for (i2 = 0; i2 < Players.race_active.length; ++i2) {
            Players.race_active[i2] = false;
        }
        global = false;
        hex_half_widht_global = (Game.W - 10 - 10) / ((MapsInit.race[Game.LEV][0].length + 1) * 2);
        hex_half_height_global = hex_half_widht_global * 1000 / 866 / 2;
        if (Game.H - 120 < hex_half_height_global * 3 * MapsInit.race[Game.LEV].length) {
            hex_half_height_global = (Game.H - 120) / MapsInit.race[Game.LEV].length / 3;
            hex_half_widht_global = hex_half_height_global * 866 * 2 / 1000;
        }
        hex_half_widht_local = Game.W / 2 / local_map_width;
        hex_half_height_local = hex_half_widht_local * 1000 / 866 / 2;
        race = null;
        territory = null;
        obj_number = null;
        obj_type = null;
        System.gc();
        race = new int[MapsInit.race[Game.LEV].length][MapsInit.race[Game.LEV][0].length];
        territory = new int[MapsInit.race[Game.LEV].length][MapsInit.race[Game.LEV][0].length];
        obj_type = new int[MapsInit.race[Game.LEV].length][MapsInit.race[Game.LEV][0].length];
        obj_number = new int[MapsInit.race[Game.LEV].length][MapsInit.race[Game.LEV][0].length];
        for (i2 = 0; i2 < MapsInit.race[Game.LEV].length; ++i2) {
            for (int j2 = 0; j2 < MapsInit.race[Game.LEV][0].length; ++j2) {
                Map.race[i2][j2] = MapsInit.race[Game.LEV][i2][j2];
                Map.territory[i2][j2] = 10;
                if (race[i2][j2] == 100 || race[i2][j2] == 4 || Players.race_active[race[i2][j2]]) continue;
                ++Players.num_of_players;
                Players.race_active[Map.race[i2][j2]] = true;
            }
        }
        activeHexX = race[0].length / 2;
        activeHexY = race.length / 2;
        global_DX = (Game.W - 10 - 10 - hex_half_widht_global * (race[0].length * 2 + 1)) / 2;
        global_DY = (Game.H - 40 - 37 - hex_half_height_global * (race.length * 3 + 1)) / 2;
        Gold.init();
        Tree.init();
        Unit.init();
        Tower.init();
        Players.initPlayers();
        Players.step = 0;
        TurnCounter.newTurn();
        for (i2 = 0; i2 < Players.num_of_players; ++i2) {
            Players.players[i2].recountBalance();
        }
        System.out.println("active" + Players.num_of_players);
    }

    public static void drawGlobalMap(Graphics g2) {
        g2.setClip(0, 0, Game.W, Game.H);
        g2.setColor(0);
        g2.fillRect(0, 0, Game.W, Game.H);
        Map.drawWater(g2);
        for (int i2 = 0; i2 < race.length; ++i2) {
            for (int j2 = 0; j2 < race[0].length; ++j2) {
                if (race[i2][j2] == 100) continue;
                Map.drawGlobalHex(g2, i2, j2);
            }
        }
        Map.drawFrames(g2);
        Hud.draw(g2);
    }

    public static void drawWater(Graphics g2) {
        for (int i2 = 0; i2 < Game.H / waterIm.getHeight() + 1; ++i2) {
            for (int j2 = 0; j2 < Game.W / waterIm.getWidth() + 1; ++j2) {
                g2.drawImage(waterIm, j2 * waterIm.getWidth(), i2 * waterIm.getHeight(), 4 | 0x10);
            }
        }
    }

    public static void drawLocalMap(Graphics g2) {
        int j2;
        int i2;
        Map.drawWater(g2);
        local_map_width = Game.W / hexIm[0].getWidth() + 2;
        hex_half_widht_local = hexIm[0].getWidth() / 2;
        hex_half_height_local = hexIm[0].getHeight() / 4;
        local_map_height = Game.H / hex_half_height_local / 3 + 2;
        for (i2 = activeHexY - local_map_height / 2; i2 <= activeHexY + local_map_height / 2; i2 += 2) {
            for (j2 = activeHexX - local_map_width / 2; j2 <= activeHexX + local_map_width / 2; ++j2) {
                if (j2 < 0 || j2 >= race[0].length || i2 < 0 || i2 >= race.length || race[i2][j2] == 100) continue;
                Map.drawLocalHex(g2, i2, j2);
            }
        }
        for (i2 = activeHexY - local_map_height / 2 + 1; i2 <= activeHexY + local_map_height / 2 - 1; i2 += 2) {
            for (j2 = activeHexY % 2 == 0 ? activeHexX - local_map_width / 2 - 1 : activeHexX - local_map_width / 2; j2 <= (activeHexY % 2 == 0 ? activeHexX + local_map_width / 2 : activeHexX + local_map_width / 2 + 1 + 2); ++j2) {
                if (j2 < 0 || j2 >= race[0].length || i2 < 0 || i2 >= race.length || race[i2][j2] == 100) continue;
                Map.drawLocalHex(g2, i2, j2);
            }
        }
        g2.drawImage(hexFrameIm, Game.W / 2, Game.H / 2, 2 | 1);
        Map.drawObjects(g2);
        Hud.draw(g2);
    }

    public static void drawObjects(Graphics g2) {
        for (int i2 = 0; i2 < race.length; ++i2) {
            for (int j2 = 0; j2 < race[0].length; ++j2) {
                if (race[i2][j2] == 100) continue;
                try {
                    switch (obj_type[i2][j2]) {
                        case 1: {
                            Unit.drawOne(g2, obj_number[i2][j2]);
                            break;
                        }
                        case 3: {
                            Capital.drawOne(g2, obj_number[i2][j2]);
                            break;
                        }
                        case 4: {
                            Gold.drawOne(g2, obj_number[i2][j2]);
                            break;
                        }
                        case 5: {
                            Tree.drawOne(g2, obj_number[i2][j2]);
                            break;
                        }
                        case 2: {
                            Tower.drawOne(g2, obj_number[i2][j2]);
                        }
                    }
                    continue;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    if (j2 > activeHexX + local_map_width / 2 || j2 < activeHexX - local_map_width / 2 || i2 > activeHexY + local_map_height / 2 || i2 < activeHexY - local_map_height / 2) {
                        return;
                    }
                    int x2 = Game.W / 2 + 2 * hex_half_widht_local * (j2 - activeHexX);
                    int y2 = Game.H / 2 + 3 * hex_half_height_local * (i2 - activeHexY);
                    if ((i2 - activeHexY) % 2 != 1 && (activeHexY - i2) % 2 != 1) continue;
                    if (i2 % 2 == 0) {
                        x2 -= hex_half_widht_local;
                        continue;
                    }
                    x2 += hex_half_widht_local;
                }
            }
        }
    }

    public static void drawLocalHex(Graphics g2, int Y, int X) {
        int x2 = hex_half_widht_local;
        int d2 = hex_half_height_local;
        int xc = 0;
        int yc = 0;
        xc = Game.W / 2 + 2 * x2 * (X - activeHexX);
        if ((Y - activeHexY >= 0 ? Y - activeHexY : activeHexY - Y) % 2 == 1) {
            xc = Y % 2 == 0 ? (xc -= x2) : (xc += x2);
        }
        yc = Game.H / 2 + 3 * d2 * (Y - activeHexY);
        try {
            g2.drawImage(hexIm[race[Y][X]], xc, yc, 1 | 2);
        }
        catch (Exception e2) {
            System.out.println(race[Y][X]);
            e2.printStackTrace();
        }
        if (X != activeHexX || Y == activeHexY) {
            // empty if block
        }
        if (X == 0 || race[Y][X - 1] == 100) {
            g2.drawImage(waterLeft, xc - x2, yc - d2, 0x10 | 8);
        }
        if (X == race[0].length - 1 || race[Y][X + 1] == 100) {
            g2.drawImage(waterRight, xc + x2, yc - d2, 0x10 | 4);
        }
        if (Y == race.length - 1) {
            g2.drawImage(waterDownLeft, xc, yc + d2 - 2, 0x10 | 8);
        } else if (X == 0) {
            if (Y % 2 == 0) {
                g2.drawImage(waterDownLeft, xc, yc + d2 - 2, 0x10 | 8);
            }
        } else if (race[Y + 1][Y % 2 == 0 ? X - 1 : X] == 100) {
            g2.drawImage(waterDownLeft, xc, yc + d2 - 2, 0x10 | 8);
        }
        if (Y == race.length - 1) {
            g2.drawImage(waterDownRight, xc, yc + d2 - 1, 0x10 | 4);
        } else if (X == race[0].length - 1) {
            if (Y % 2 == 1) {
                g2.drawImage(waterDownRight, xc, yc + d2 - 1, 0x10 | 4);
            }
        } else if (race[Y + 1][Y % 2 == 0 ? X : X + 1] == 100) {
            g2.drawImage(waterDownRight, xc, yc + d2 - 1, 0x10 | 4);
        }
    }

    public static void drawGlobalHex(Graphics g2, int Y, int X) {
        int x2 = hex_half_widht_global;
        int d2 = hex_half_height_global;
        int xc = 0;
        int yc = 0;
        xc = Y % 2 == 0 ? x2 * (1 + X * 2) : x2 * (2 + X * 2);
        yc = d2 * (2 + Y * 3);
        g2.setColor(Data.RACECOLOR[race[Y][X]]);
        g2.fillTriangle(xc += 10 + global_DX, yc += 40 + global_DY, xc - x2, yc - d2, xc, yc - 2 * d2);
        g2.fillTriangle(xc, yc, xc, yc - 2 * d2, xc + x2, yc - d2);
        g2.fillTriangle(xc, yc, xc + x2, yc - d2, xc + x2, yc + d2);
        g2.fillTriangle(xc, yc, xc + x2, yc + d2, xc, yc + 2 * d2);
        g2.fillTriangle(xc, yc, xc, yc + 2 * d2, xc - x2, yc + d2);
        g2.fillTriangle(xc, yc, xc - x2, yc + d2, xc - x2, yc - d2);
        g2.setColor(65280);
        if (race[Y][X] == Players.players[Players.turns].race && obj_type[Y][X] == 1 && Unit.is_active[obj_number[Y][X]]) {
            g2.fillArc(xc - x2 / 4, yc - x2 / 4, x2 / 2, x2 / 2, 0, 360);
        }
    }

    public static void drawFrames(Graphics g2) {
        int x2 = hex_half_widht_global;
        int d2 = hex_half_height_global;
        int xc = 0;
        int yc = 0;
        xc = activeHexY % 2 == 0 ? x2 * (1 + activeHexX * 2) : x2 * (2 + activeHexX * 2);
        yc = d2 * (2 + activeHexY * 3);
        g2.setColor(0xFFFF00);
        g2.drawLine((xc += 10 + global_DX) - x2, (yc += 40 + global_DY) - d2, xc, yc - 2 * d2);
        g2.drawLine(xc, yc - 2 * d2, xc + x2, yc - d2);
        g2.drawLine(xc + x2, yc - d2, xc + x2, yc + d2);
        g2.drawLine(xc + x2, yc + d2, xc, yc + 2 * d2);
        g2.drawLine(xc, yc + 2 * d2, xc - x2, yc + d2);
        g2.drawLine(xc - x2, yc + d2, xc - x2, yc - d2);
        g2.drawLine(xc - x2 - 1, yc - d2, xc, yc - 2 * d2 - 1);
        g2.drawLine(xc, yc - 2 * d2 - 1, xc + x2 + 1, yc - d2);
        g2.drawLine(xc + x2 + 1, yc - d2, xc + x2 + 1, yc + d2);
        g2.drawLine(xc + x2 + 1, yc + d2, xc, yc + 2 * d2 + 1);
        g2.drawLine(xc, yc + 2 * d2 + 1, xc - x2 - 1, yc + d2);
        g2.drawLine(xc - x2 - 1, yc + d2, xc - x2 - 1, yc - d2);
        int w2 = x2 * 2 * local_map_width;
        int h2 = w2 * Game.H / Game.W;
        g2.drawLine(xc - w2 / 2, yc - h2 / 2, xc + w2 / 2, yc - h2 / 2);
        g2.drawLine(xc - w2 / 2, yc + h2 / 2, xc + w2 / 2, yc + h2 / 2);
        g2.drawLine(xc - w2 / 2, yc - h2 / 2, xc - w2 / 2, yc + h2 / 2);
        g2.drawLine(xc + w2 / 2, yc - h2 / 2, xc + w2 / 2, yc + h2 / 2);
    }

    public static void jumpLeft() {
        if (activeHexX == 0) {
            return;
        }
        int findx = activeHexX;
        do {
            if (race[activeHexY][--findx] == 100) continue;
            activeHexX = findx;
            return;
        } while (race[activeHexY][findx] == 100 && findx > 0);
    }

    public static void jumpRight() {
        if (activeHexX == race[0].length - 1) {
            return;
        }
        int findx = activeHexX;
        do {
            if (race[activeHexY][++findx] == 100) continue;
            activeHexX = findx;
            return;
        } while (race[activeHexY][findx] == 100 && findx < race[0].length - 1);
    }

    public static void jumpUp() {
        if (activeHexY == 0) {
            return;
        }
        int findy = activeHexY;
        do {
            if (race[--findy][activeHexX] == 100) continue;
            activeHexY = findy;
            return;
        } while (race[findy][activeHexX] == 100 && findy > 0);
    }

    public static void jumpDown() {
        if (activeHexY == race.length - 1) {
            return;
        }
        int findy = activeHexY;
        do {
            if (race[++findy][activeHexX] == 100) continue;
            activeHexY = findy;
            return;
        } while (race[findy][activeHexX] == 100 && findy < race.length - 1);
    }

    public static void jumpLeftUp() {
        if (activeHexY == 0 || activeHexY % 2 == 0 && activeHexX == 0) {
            return;
        }
        int findx = activeHexX;
        int findy = activeHexY;
        do {
            if (findy % 2 == 0) {
                --findx;
            }
            if (race[--findy][findx] == 100) continue;
            activeHexX = findx;
            activeHexY = findy;
            return;
        } while (race[findy][findx] == 100 && findy > 0 && (findx > 0 || findy % 2 == 1));
    }

    public static void jumpRightUp() {
        if (activeHexY == 0 || activeHexY % 2 == 1 && activeHexX == race[0].length - 1) {
            return;
        }
        int findx = activeHexX;
        int findy = activeHexY;
        do {
            if (findy % 2 == 1) {
                ++findx;
            }
            if (race[--findy][findx] == 100) continue;
            activeHexX = findx;
            activeHexY = findy;
            return;
        } while (race[findy][findx] == 100 && findy > 0 && (findx < race[0].length - 1 || findy % 2 == 0));
    }

    public static void jumpLeftDown() {
        if (activeHexY == race.length - 1 || activeHexY % 2 == 0 && activeHexX == 0) {
            return;
        }
        int findx = activeHexX;
        int findy = activeHexY;
        do {
            if (findy % 2 == 0) {
                --findx;
            }
            if (race[++findy][findx] == 100) continue;
            activeHexX = findx;
            activeHexY = findy;
            return;
        } while (race[findy][findx] == 100 && findy < race.length - 1 && (findx > 0 || findy % 2 == 1));
    }

    public static void jumpRightDown() {
        if (activeHexY == race.length - 1 || activeHexY % 2 == 1 && activeHexX == race[0].length - 1) {
            return;
        }
        int findx = activeHexX;
        int findy = activeHexY;
        do {
            if (findy % 2 == 1) {
                ++findx;
            }
            if (race[++findy][findx] == 100) continue;
            activeHexX = findx;
            activeHexY = findy;
            return;
        } while (race[findy][findx] == 100 && findy < race.length - 1 && (findx < race[0].length - 1 || findy % 2 == 0));
    }

    static {
        activeHexX = 0;
        activeHexY = 0;
    }
}

