#
# Table structure for table admins
#

CREATE TABLE `admins` (
  `Id` int(6) unsigned NOT NULL auto_increment,
  `login` varchar(50) default NULL,
  `password` varchar(50) default NULL,
  PRIMARY KEY  (`Id`)
) TYPE=MyISAM;

#
# Dumping data for table admins
#

INSERT INTO `admins` VALUES (1,'admin','21232f297a57a5a743894a0e4a801fc3');

#
# Table structure for table advertising_links
#

CREATE TABLE `advertising_links` (
  `Id` int(6) unsigned NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `url` varchar(255) default NULL,
  PRIMARY KEY  (`Id`)
) TYPE=MyISAM;

#
# Table structure for table config
#

CREATE TABLE `config` (
  `id` int(6) unsigned NOT NULL default '0',
  `block_limit` int(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

#
# Table structure for table counter
#

CREATE TABLE `counter` (
  `id` int(6) unsigned NOT NULL default '0',
  `today` int(4) NOT NULL default '0',
  `total` int(4) NOT NULL default '0',
  `last_date` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

#
# Table structure for table counter_ips
#

CREATE TABLE `counter_ips` (
  `id` int(6) unsigned NOT NULL default '0',
  `ip` char(15) NOT NULL default '',
  `last_date` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`id`,`ip`)
) TYPE=MyISAM;

#
# Table structure for table guest_book
#

CREATE TABLE `guest_book` (
  `id` int(6) unsigned NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `email` varchar(255) default NULL,
  `text` text,
  `date` datetime default NULL,
  `user_id` int(6) default NULL,
  PRIMARY KEY  (`id`),
  KEY `user_id` (`user_id`)
) TYPE=MyISAM;

#
# Table structure for table links
#

CREATE TABLE `links` (
  `id` int(6) unsigned NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `url` varchar(255) default NULL,
  `user_id` int(6) default NULL,
  PRIMARY KEY  (`id`),
  KEY `user_id` (`user_id`)
) TYPE=MyISAM;

#
# Table structure for table news
#

CREATE TABLE `news` (
  `id` int(6) unsigned NOT NULL auto_increment,
  `text` text,
  `date` datetime default NULL,
  `user_id` int(6) default NULL,
  PRIMARY KEY  (`id`),
  KEY `user_id` (`user_id`)
) TYPE=MyISAM;

#
# Table structure for table polls_answers
#

CREATE TABLE `polls_answers` (
  `qid` int(10) unsigned NOT NULL default '0',
  `aid` int(10) unsigned NOT NULL default '0',
  `answer` varchar(255) NOT NULL default '',
  `votes` int(10) unsigned NOT NULL default '0',
  KEY `pid` (`qid`)
) TYPE=MyISAM;

#
# Table structure for table polls_questions
#

CREATE TABLE `polls_questions` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `question` varchar(250) NOT NULL default '',
  `date` datetime default NULL,
  `user_id` int(6) default NULL,
  PRIMARY KEY  (`id`),
  KEY `user_id` (`user_id`)
) TYPE=MyISAM;

#
# Table structure for table users
#

CREATE TABLE `users` (
  `id` int(11) NOT NULL auto_increment,
  `login` varchar(50) NOT NULL default '',
  `password` varchar(50) NOT NULL default '',
  `name` varchar(50) NOT NULL default '',
  `surname` varchar(50) NOT NULL default '',
  `email` varchar(50) NOT NULL default '',
  `banner` enum('top','bottom','none') NOT NULL default 'top',
  `active` enum('0','1') NOT NULL default '1',
  `block_date` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

