/*
 * Decompiled with CFR 0.152.
 */
package com.movaya.license.structure;

import com.movaya.license.structure.Array;
import com.movaya.license.structure.BaseBlock;
import com.movaya.license.structure.Block;
import com.movaya.license.structure.BuyBlock;
import com.movaya.license.structure.CarrierBlock;
import com.movaya.license.structure.FeatureBlock;
import com.movaya.license.structure.FeatureRelationBlock;
import com.movaya.license.structure.HistoryBlock;
import com.movaya.license.structure.LicenseBlock;
import com.movaya.license.structure.ProductInfoBlock;
import com.movaya.license.structure.ReferenceBlock;
import com.movaya.license.structure.RelationBlock;
import com.movaya.license.structure.TrialBlock;
import com.movaya.license.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class Generate {
    byte[] generateArrays(Array array, int dataLen, int flag) {
        ByteArrayOutputStream baos = null;
        baos = new ByteArrayOutputStream();
        DataOutputStream dos = null;
        dos = new DataOutputStream(baos);
        Object obj = null;
        try {
            int i = 0;
            while (i < array.size()) {
                obj = array.elementAt(i);
                if (obj instanceof Array) {
                    ((OutputStream)dos).write(this.generateArrays(obj, 0, 1));
                } else if (obj instanceof Block) {
                    ((OutputStream)dos).write(this.generateBlocks(obj));
                } else if (obj instanceof String) {
                    dos.writeUTF(obj);
                } else {
                    ((OutputStream)dos).write(((String)obj).getBytes());
                }
                ++i;
            }
            byte[] byArray = this.getArrayResult(baos.toByteArray(), dataLen, flag);
            return byArray;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
        finally {
            Utils.closeOut(baos);
            Utils.closeOut(dos);
        }
    }

    private byte[] getArrayResult(byte[] data, int dataLen, int flag) {
        ByteArrayOutputStream baos = null;
        baos = new ByteArrayOutputStream();
        DataOutputStream dos = null;
        dos = new DataOutputStream(baos);
        try {
            dos.writeInt(flag);
            dos.writeInt(data.length);
            dos.writeInt(dataLen);
            ((OutputStream)dos).write(data);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
        finally {
            Utils.closeOut(baos);
            Utils.closeOut(dos);
        }
    }

    private byte[] getBlockResult(byte[] data, int flag) {
        ByteArrayOutputStream baos = null;
        baos = new ByteArrayOutputStream();
        DataOutputStream dos = null;
        dos = new DataOutputStream(baos);
        try {
            dos.writeInt(flag);
            dos.writeInt(data.length);
            ((OutputStream)dos).write(data);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
        finally {
            Utils.closeOut(baos);
            Utils.closeOut(dos);
        }
    }

    private byte[] generateBlocks(Block block) {
        byte[] buf = null;
        if (block instanceof BaseBlock) {
            buf = this.generateBase(block);
        } else if (block instanceof FeatureRelationBlock) {
            buf = this.generateFeatureRelation(block);
        } else if (block instanceof FeatureBlock) {
            buf = this.generateFeature(block);
        } else if (block instanceof TrialBlock) {
            buf = this.generateTrial(block);
        } else if (block instanceof BuyBlock) {
            buf = this.generateBuy(block);
        } else if (block instanceof ProductInfoBlock) {
            buf = this.generateProductInfo(block);
        } else if (block instanceof RelationBlock) {
            buf = this.generateRelation(block);
        } else if (block instanceof HistoryBlock) {
            buf = this.generateHistory(block);
        } else if (block instanceof ReferenceBlock) {
            buf = this.generateReference(block);
        } else if (block instanceof CarrierBlock) {
            buf = this.generateCarrier(block);
        }
        return buf;
    }

    private byte[] generateBase(Block block) {
        BaseBlock baseBlock = null;
        baseBlock = (BaseBlock)block;
        ByteArrayOutputStream baos = null;
        baos = new ByteArrayOutputStream();
        DataOutputStream dos = null;
        dos = new DataOutputStream(baos);
        try {
            dos.writeInt(baseBlock.getId());
            dos.writeInt(baseBlock.getUniqueKey());
            dos.writeUTF(baseBlock.getUnlockKey());
            if (!LicenseBlock.useRmsData) {
                dos.writeUTF(baseBlock.getReferenceId());
                dos.writeUTF(baseBlock.getAppEnv());
                dos.writeLong(baseBlock.getVerifyKey());
                dos.writeLong(baseBlock.getCreateTime());
                dos.writeLong(baseBlock.getUpdateTime());
                dos.writeUTF(baseBlock.getLicenseServerURL());
                dos.writeInt(baseBlock.getDeviceID());
                dos.writeInt(baseBlock.getCarrierID());
                dos.writeUTF(baseBlock.getPhoneNo());
                dos.writeUTF(baseBlock.getShortCode());
            }
            byte[] byArray = this.getBlockResult(baos.toByteArray(), 10000);
            return byArray;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
        finally {
            Utils.closeOut(baos);
            Utils.closeOut(dos);
        }
    }

    private byte[] generateFeatureRelation(Block block) {
        FeatureRelationBlock featureRelationBlock = null;
        featureRelationBlock = (FeatureRelationBlock)block;
        ByteArrayOutputStream baos = null;
        baos = new ByteArrayOutputStream();
        DataOutputStream dos = null;
        dos = new DataOutputStream(baos);
        try {
            dos.writeInt(featureRelationBlock.getId());
            ((OutputStream)dos).write(this.generateArrays(featureRelationBlock.getFeature(), 0, 1));
            if (!LicenseBlock.useRmsData) {
                ((OutputStream)dos).write(this.generateArrays(featureRelationBlock.getRelation(), 0, 1));
            }
            byte[] byArray = this.getBlockResult(baos.toByteArray(), 20000);
            return byArray;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
        finally {
            Utils.closeOut(baos);
            Utils.closeOut(dos);
        }
    }

    private byte[] generateFeature(Block block) {
        FeatureBlock featureBlock = null;
        featureBlock = (FeatureBlock)block;
        ByteArrayOutputStream baos = null;
        baos = new ByteArrayOutputStream();
        DataOutputStream dos = null;
        dos = new DataOutputStream(baos);
        try {
            dos.writeInt(featureBlock.getId());
            dos.writeUTF(featureBlock.getFeatureId());
            if (!LicenseBlock.useRmsData) {
                dos.writeUTF(featureBlock.getFeatureName());
            }
            ((OutputStream)dos).write(this.generateArrays(featureBlock.getTrial(), 0, 1));
            ((OutputStream)dos).write(this.generateArrays(featureBlock.getBuy(), 0, 1));
            byte[] byArray = this.getBlockResult(baos.toByteArray(), 21000);
            return byArray;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
        finally {
            Utils.closeOut(baos);
            Utils.closeOut(dos);
        }
    }

    private byte[] generateTrial(Block block) {
        TrialBlock trialBlock = null;
        trialBlock = (TrialBlock)block;
        ByteArrayOutputStream baos = null;
        baos = new ByteArrayOutputStream();
        DataOutputStream dos = null;
        dos = new DataOutputStream(baos);
        try {
            dos.writeInt(trialBlock.getId());
            dos.writeInt(trialBlock.getTrialFlag());
            dos.writeLong(trialBlock.getTrialInfo());
            dos.writeLong(trialBlock.getTrialUsed());
            dos.writeLong(trialBlock.getTrialRemindKey());
            byte[] byArray = this.getBlockResult(baos.toByteArray(), 21100);
            return byArray;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
        finally {
            Utils.closeOut(baos);
            Utils.closeOut(dos);
        }
    }

    private byte[] generateBuy(Block block) {
        BuyBlock buyBlock = null;
        buyBlock = (BuyBlock)block;
        ByteArrayOutputStream baos = null;
        baos = new ByteArrayOutputStream();
        DataOutputStream dos = null;
        dos = new DataOutputStream(baos);
        try {
            dos.writeInt(buyBlock.getId());
            dos.writeInt(buyBlock.getBuyFlag());
            dos.writeLong(buyBlock.getBuyInfo());
            dos.writeLong(buyBlock.getBuyUsed());
            dos.writeLong(buyBlock.getBuyRemindKey());
            if (!LicenseBlock.useRmsData) {
                dos.writeInt(buyBlock.getPNumber());
                ((OutputStream)dos).write(this.generateArrays(buyBlock.getProductinfo(), 0, 1));
            }
            byte[] byArray = this.getBlockResult(baos.toByteArray(), 21200);
            return byArray;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
        finally {
            Utils.closeOut(baos);
            Utils.closeOut(dos);
        }
    }

    private byte[] generateProductInfo(Block block) {
        ProductInfoBlock productInfoBlock = null;
        productInfoBlock = (ProductInfoBlock)block;
        ByteArrayOutputStream baos = null;
        baos = new ByteArrayOutputStream();
        DataOutputStream dos = null;
        dos = new DataOutputStream(baos);
        try {
            dos.writeInt(productInfoBlock.getId());
            dos.writeUTF(productInfoBlock.getProductId());
            dos.writeInt(productInfoBlock.getProductPrice());
            dos.writeLong(productInfoBlock.getProductKey());
            dos.writeUTF(productInfoBlock.getDisplayName());
            byte[] byArray = this.getBlockResult(baos.toByteArray(), 21210);
            return byArray;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
        finally {
            Utils.closeOut(baos);
            Utils.closeOut(dos);
        }
    }

    private byte[] generateRelation(Block block) {
        RelationBlock relationBlock = null;
        relationBlock = (RelationBlock)block;
        ByteArrayOutputStream baos = null;
        baos = new ByteArrayOutputStream();
        DataOutputStream dos = null;
        dos = new DataOutputStream(baos);
        try {
            dos.writeInt(relationBlock.getId());
            dos.writeUTF(relationBlock.getRelationName());
            dos.writeInt(relationBlock.getRelationFlag());
            ((OutputStream)dos).write(this.generateArrays(relationBlock.getFeatureIds(), 0, 2));
            byte[] byArray = this.getBlockResult(baos.toByteArray(), 22000);
            return byArray;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
        finally {
            Utils.closeOut(baos);
            Utils.closeOut(dos);
        }
    }

    private byte[] generateHistory(Block block) {
        HistoryBlock historyBlock = null;
        historyBlock = (HistoryBlock)block;
        ByteArrayOutputStream baos = null;
        baos = new ByteArrayOutputStream();
        DataOutputStream dos = null;
        dos = new DataOutputStream(baos);
        try {
            dos.writeInt(historyBlock.getId());
            dos.writeInt(historyBlock.getBuyFlag());
            dos.writeLong(historyBlock.getBuyInfo());
            dos.writeLong(historyBlock.getBuyTime());
            dos.writeInt(historyBlock.getProductPrice());
            dos.writeUTF(historyBlock.getProductId());
            dos.writeUTF(historyBlock.getReferenceId());
            byte[] byArray = this.getBlockResult(baos.toByteArray(), 30000);
            return byArray;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
        finally {
            Utils.closeOut(baos);
            Utils.closeOut(dos);
        }
    }

    private byte[] generateReference(Block block) {
        ReferenceBlock referenceBlock = null;
        referenceBlock = (ReferenceBlock)block;
        ByteArrayOutputStream baos = null;
        baos = new ByteArrayOutputStream();
        DataOutputStream dos = null;
        dos = new DataOutputStream(baos);
        try {
            dos.writeInt(referenceBlock.getId());
            ((OutputStream)dos).write(this.generateArrays(referenceBlock.getCarriers(), 0, 1));
            byte[] byArray = this.getBlockResult(baos.toByteArray(), 40000);
            return byArray;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
        finally {
            Utils.closeOut(baos);
            Utils.closeOut(dos);
        }
    }

    private byte[] generateCarrier(Block block) {
        CarrierBlock carrierBlock = null;
        carrierBlock = (CarrierBlock)block;
        ByteArrayOutputStream baos = null;
        baos = new ByteArrayOutputStream();
        DataOutputStream dos = null;
        dos = new DataOutputStream(baos);
        try {
            dos.writeInt(carrierBlock.getId());
            dos.writeUTF(carrierBlock.getCarrierDName());
            byte[] byArray = this.getBlockResult(baos.toByteArray(), 41000);
            return byArray;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
        finally {
            Utils.closeOut(baos);
            Utils.closeOut(dos);
        }
    }
}

