/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class MapCanvas
extends Canvas
implements CommandListener {
    MobileMap main;
    int screenWidth;
    int screenHeight;
    int x;
    int y;
    int size;
    int scale;
    int initScale;
    int level;
    short marker;
    int selectedStreetIndex;
    int[] minLevelScale;
    Font font;
    Font fontMed;
    int fontWidth;
    int fontHeight;
    int showNames;
    static final int MAX_COORD_BITS = 16;
    static final int MAX_COORD = 65535;
    static final int STREETS_PER_SCREEN = 20;
    static final int BACKGROUND_COLOR = 15777651;
    static final int SELECTION_COLOR = 49152;
    static final int FOREST_COLOR = 49152;
    static final int SQUARE_COLOR = 10837504;
    static final int RAILROAD_COLOR = 0;
    static final int METRO_COLOR = 0xFF0000;
    static final int RIVER_COLOR = 255;
    static final int NAME_COLOR = 0;
    static final int NAME_COLOR_VERT = 7285754;
    static final int NAME_COLOR_HORZ = 5065745;
    static final int ROAD_COLOR_MIN = 16243633;
    static final int ROAD_COLOR = 0xFFFFFF;

    MapCanvas(MobileMap main) {
        this.main = main;
        this.showNames = 1;
        this.selectedStreetIndex = -1;
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.initScale = this.screenWidth < this.screenHeight ? this.screenWidth : this.screenHeight;
        this.minLevelScale = new int[main.nLevels];
        int nStreets = main.nLevelStreets[0];
        int scale = 1;
        for (int i = 1; i < this.minLevelScale.length; ++i) {
            nStreets += main.nLevelStreets[i];
            while (scale * scale < nStreets / 20) {
                ++scale;
            }
            this.minLevelScale[i] = this.initScale * scale;
        }
        this.reset();
        this.setCommandListener(this);
        this.addCommand(MobileMap.SEARCH_CMD);
        this.addCommand(MobileMap.OBJECTS_CMD);
        this.addCommand(MobileMap.OPTIONS_CMD);
        this.addCommand(MobileMap.HELP_CMD);
        this.addCommand(MobileMap.ABOUT_CMD);
        this.addCommand(MobileMap.QUIT_CMD);
        Display.getDisplay((MIDlet)main).setCurrent((Displayable)this);
    }

    protected void paint(Graphics g) {
        int j;
        int i;
        this.font = this.main.Option_ShowFont1 == 1 ? Font.getFont((int)0, (int)0, (int)8) : Font.getFont((int)0, (int)0, (int)0);
        this.fontMed = this.main.Option_ShowFont2 == 1 ? Font.getFont((int)0, (int)1, (int)8) : Font.getFont((int)0, (int)1, (int)0);
        this.fontWidth = this.font.charWidth('w');
        this.fontHeight = this.font.getHeight() * 2 / 3;
        g.setColor(15777651);
        g.fillRect(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
        this.marker = (short)(this.marker + 1);
        int x0 = this.x >>> 13;
        int x1 = Math.min(65535, this.x + (this.screenWidth << 16) / this.scale) >>> 13;
        int y0 = this.y >>> 13;
        int y1 = Math.min(65535, this.y + (this.screenHeight << 16) / this.scale) >>> 13;
        for (i = x0; i <= x1; ++i) {
            for (j = y0; j <= y1; ++j) {
                this.drawCell(i, j, g, false);
            }
        }
        this.marker = (short)(this.marker + 1);
        for (i = x0; i <= x1; ++i) {
            for (j = y0; j <= y1; ++j) {
                this.drawCell(i, j, g, true);
            }
        }
    }

    void drawCell(int i, int j, Graphics g, boolean printNames) {
        Segment[] segments = this.main.cells[i][j];
        block0: for (int k = 0; k < segments.length; ++k) {
            Segment s = segments[k];
            if (s.level > this.level && s.streetIndex != this.selectedStreetIndex || s.marker == this.marker) continue;
            s.marker = this.marker;
            Street street = this.main.streets[s.streetIndex];
            String name = street.name;
            int nameLen = name.length();
            int firstPoint = 0;
            if (printNames && s.x.length != 1) {
                if (s.maxLength <= nameLen * this.fontWidth >> 1) continue;
                for (int l = 0; l < street.segments.length; ++l) {
                    if (street.segments[l].marker == this.marker - 1 && street.segments[l].maxLength > s.maxLength) continue block0;
                    if (street.segments[l].x.length == 1) continue;
                    street.segments[l].marker = this.marker;
                }
                firstPoint = s.firstPoint & 0xFF;
            }
            int namePos = 0;
            short[] xa = s.x;
            short[] ya = s.y;
            int prevX = ((xa[firstPoint] & 0xFFFF) - this.x) * this.scale >> 16;
            int prevY = ((ya[firstPoint] & 0xFFFF) - this.y) * this.scale >> 16;
            int len = 0;
            int maxLen = 0;
            int maxFirstPoint = 0;
            if (street.TypeLine == 7) {
                g.setFont(this.fontMed);
            } else {
                g.setFont(this.font);
            }
            if (xa.length == 1) {
                g.setColor(s.streetIndex == this.selectedStreetIndex ? 49152 : (street.TypeLine == 1 ? 49152 : (street.TypeLine == 2 ? 0xFFFFFF : (street.TypeLine == 3 ? 10837504 : (street.TypeLine == 4 ? 16243633 : (street.TypeLine == 5 ? 255 : (street.TypeLine == 6 ? 0 : (street.TypeLine == 7 ? 0xFF0000 : (street.TypeLine == 8 ? 0xFF0000 : 7285754)))))))));
                if (prevX < 0 || prevX >= this.screenWidth || prevY < 0 || prevY >= this.screenHeight) continue;
                if (this.level == 0) {
                    if (s.streetIndex != this.selectedStreetIndex && s.level != 0 || street.TypeLine == 3 || street.TypeLine == 1) continue;
                    if (street.TypeLine == 8) {
                        g.drawChar('\u043c', prevX, prevY, 65);
                        continue;
                    }
                    g.drawLine(prevX, prevY, prevX + 3, prevY);
                    g.drawLine(prevX + 3, prevY, prevX + 3, prevY + 3);
                    g.drawLine(prevX + 3, prevY + 3, prevX, prevY + 3);
                    g.drawLine(prevX, prevY + 3, prevX, prevY);
                    continue;
                }
                if (!printNames) {
                    if (street.TypeLine == 3 || street.TypeLine == 1) continue;
                    if (street.TypeLine == 8) {
                        g.drawChar('\u043c', prevX, prevY, 17);
                        continue;
                    }
                    g.drawLine(prevX, prevY, prevX + 3, prevY);
                    g.drawLine(prevX + 3, prevY, prevX + 3, prevY + 3);
                    g.drawLine(prevX + 3, prevY + 3, prevX, prevY + 3);
                    g.drawLine(prevX, prevY + 3, prevX, prevY);
                    continue;
                }
                if (this.showNames == 0 && s.streetIndex != this.selectedStreetIndex) continue;
                g.drawString(name, prevX, prevY, 33);
                continue;
            }
            g.setColor(printNames ? 0 : (s.streetIndex == this.selectedStreetIndex ? 49152 : (street.TypeLine == 1 ? 49152 : (street.TypeLine == 2 ? 0xFFFFFF : (street.TypeLine == 3 ? 10837504 : (street.TypeLine == 4 ? 16243633 : (street.TypeLine == 5 ? 255 : (street.TypeLine == 6 ? 0 : 5065745))))))));
            int cx = -1;
            int cy = -1;
            for (int p = firstPoint + 1; p <= xa.length; ++p) {
                int y1;
                int x1;
                int x0 = prevX;
                int y0 = prevY;
                if (street.TypeLine == 3 || street.TypeLine == 1) {
                    if (p < xa.length) {
                        x1 = ((xa[p] & 0xFFFF) - this.x) * this.scale >> 16;
                        y1 = ((ya[p] & 0xFFFF) - this.y) * this.scale >> 16;
                    } else {
                        x1 = ((xa[0] & 0xFFFF) - this.x) * this.scale >> 16;
                        y1 = ((ya[0] & 0xFFFF) - this.y) * this.scale >> 16;
                    }
                } else {
                    if (p >= xa.length) continue;
                    x1 = ((xa[p] & 0xFFFF) - this.x) * this.scale >> 16;
                    y1 = ((ya[p] & 0xFFFF) - this.y) * this.scale >> 16;
                }
                prevX = x1;
                prevY = y1;
                if (this.level == 0) {
                    g.drawLine(x0, y0, x1, y1);
                    continue;
                }
                if (x0 < 0) {
                    len = 0;
                    firstPoint = p - 1;
                    if (x1 < 0) continue;
                    y0 += (y1 - y0) * -x0 / (x1 - x0);
                    x0 = 0;
                } else if (x0 > this.screenWidth) {
                    len = 0;
                    firstPoint = p - 1;
                    if (x1 > this.screenWidth) continue;
                    y0 += (y1 - y0) * (this.screenWidth - x0) / (x1 - x0);
                    x0 = this.screenWidth;
                }
                if (x1 < 0) {
                    y1 += (y0 - y1) * -x1 / (x0 - x1);
                    x1 = 0;
                } else if (x1 > this.screenWidth) {
                    y1 += (y0 - y1) * (this.screenWidth - x1) / (x0 - x1);
                    x1 = this.screenWidth;
                }
                if (y0 < 0) {
                    len = 0;
                    firstPoint = p - 1;
                    if (y1 < 0) continue;
                    x0 += (x1 - x0) * -y0 / (y1 - y0);
                    y0 = 0;
                } else if (y0 > this.screenHeight) {
                    len = 0;
                    firstPoint = p - 1;
                    if (y1 > this.screenHeight) continue;
                    x0 += (x1 - x0) * (this.screenHeight - y0) / (y1 - y0);
                    y0 = this.screenHeight;
                }
                if (y1 < 0) {
                    x1 += (x0 - x1) * -y1 / (y0 - y1);
                    y1 = 0;
                } else if (y1 > this.screenHeight) {
                    x1 += (x0 - x1) * (this.screenHeight - y1) / (y0 - y1);
                    y1 = this.screenHeight;
                }
                if (!printNames) {
                    g.drawLine(x0, y0, x1, y1);
                }
                int width = this.level - s.level + 1;
                int dx = 0;
                int dy = 0;
                if (Math.abs(x1 - x0) >= Math.abs(y1 - y0)) {
                    if (!printNames) {
                        dy = 1;
                        g.drawLine(x0, y0, x1, y1);
                        g.drawLine(x0, y0 + dy, x1, y1 + dy);
                        if ((len += Math.abs(x1 - x0)) <= maxLen) continue;
                        maxLen = len;
                        maxFirstPoint = firstPoint;
                        continue;
                    }
                    if (x0 == x1 || street.TypeLine == 1 || street.TypeLine == 3 || street.TypeLine == 5 || street.TypeLine == 6) continue;
                    int n = dx = x0 < x1 ? this.fontWidth : -this.fontWidth;
                    if (dx < 0 && namePos == 0) {
                        int suffixLen = s.maxLength / this.fontWidth;
                        if (suffixLen > nameLen) {
                            suffixLen = nameLen;
                        }
                        char[] chars = new char[suffixLen];
                        for (int cp = 0; cp < suffixLen; ++cp) {
                            chars[suffixLen - cp - 1] = name.charAt(cp);
                        }
                        name = new String(chars);
                        nameLen = suffixLen;
                    }
                    if (cx < 0 || (cx - x0 ^ cx - x1) >= 0) {
                        cx = x0 + (dx >> 1);
                    }
                    while (namePos < nameLen && (cx - x0 ^ cx - x1) < 0) {
                        g.drawChar(name.charAt(namePos++), cx, y0 + (y1 - y0) * (cx - x0) / (x1 - x0) + (this.fontHeight >> 1), 33);
                        cx += dx;
                    }
                    continue;
                }
                if (!printNames) {
                    dx = 1;
                    g.drawLine(x0, y0, x1, y1);
                    g.drawLine(x0 + dx, y0, x1 + dx, y1);
                    if ((len += Math.abs(y1 - y0)) <= maxLen) continue;
                    maxLen = len;
                    maxFirstPoint = firstPoint;
                    continue;
                }
                if (y0 == y1 || street.TypeLine == 1 || street.TypeLine == 3 || street.TypeLine == 5 || street.TypeLine == 6) continue;
                int n = dy = y0 < y1 ? this.fontHeight : -this.fontHeight;
                if (cy < 0 || (cy - y0 ^ cy - y1) >= 0) {
                    cy = y0 + (dy >> 1);
                }
                while (namePos < nameLen && (cy - y0 ^ cy - y1) < 0) {
                    g.drawChar(name.charAt(namePos++), x0 + (x1 - x0) * (cy - y0) / (y1 - y0), cy + (this.fontHeight >> 1), 33);
                    cy += dy;
                }
            }
            s.maxLength = (short)maxLen;
            s.firstPoint = (byte)maxFirstPoint;
        }
    }

    public void keyPressed(int keyCode) {
        int step = this.size >> 2;
        block0 : switch (keyCode) {
            case 48: {
                this.selectedStreetIndex = -1;
                this.reset();
                break;
            }
            case 49: {
                this.decrease();
                break;
            }
            case 50: {
                this.y -= step;
                break;
            }
            case 51: {
                this.increase();
                break;
            }
            case 52: {
                this.x -= step;
                break;
            }
            case 53: {
                new SearchBox(this);
                return;
            }
            case 54: {
                this.x += step;
                break;
            }
            case 55: {
                new StreetList(this);
                break;
            }
            case 56: {
                this.y += step;
                break;
            }
            case 57: {
                this.showNames = this.showNames == 0 ? 1 : 0;
                break;
            }
            case 42: {
                break;
            }
            case 35: {
                break;
            }
            default: {
                switch (this.getGameAction(keyCode)) {
                    case 2: {
                        this.x -= step;
                        break block0;
                    }
                    case 5: {
                        this.x += step;
                        break block0;
                    }
                    case 1: {
                        this.y -= step;
                        break block0;
                    }
                    case 6: {
                        this.y += step;
                        break block0;
                    }
                }
                return;
            }
        }
        this.checkCoordinates();
        this.repaint();
    }

    public void commandAction(Command c, Displayable d) {
        if (c == MobileMap.QUIT_CMD) {
            this.main.quit();
        } else if (c == MobileMap.RESET_CMD) {
            this.reset();
            this.repaint();
        } else if (c == MobileMap.SEARCH_CMD) {
            new SearchBox(this);
        } else if (c == MobileMap.OBJECTS_CMD) {
            new StreetList(this);
        } else if (c == MobileMap.OPTIONS_CMD) {
            new OptionsList(this);
        } else if (c == MobileMap.HELP_CMD) {
            this.showHelp();
        } else if (c == MobileMap.ABOUT_CMD) {
            this.showAbout();
        }
    }

    void showHelp() {
        Alert alert = new Alert("\u041f\u043e\u043c\u043e\u0449\u044c", "\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435:\n[1] \u0443\u043c\u0435\u043d\u044c\u0448\u0438\u0442\u044c\n[2] \u0432\u0432\u0435\u0440\u0445\n[3] \u0443\u0432\u0435\u043b\u0438\u0447\u0438\u0442\u044c\n[4] \u043d\u0430\u043b\u0435\u0432\u043e\n[5] \u043f\u043e\u0438\u0441\u043a\n[6] \u043d\u0430\u043f\u0440\u0430\u0432\u043e\n[7] \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432\n[8] \u0432\u043d\u0438\u0437\n[9] \u0440\u0435\u0436\u0438\u043c \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0439\n[0] \u043e\u0431\u0449\u0438\u0439 \u043f\u043b\u0430\u043d\n", null, AlertType.INFO);
        Display.getDisplay((MIDlet)this.main).setCurrent(alert, (Displayable)this);
    }

    void showAbout() {
        Alert alert = new Alert("\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435", "MobileMap \u041d\u043e\u0432\u043e\u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a 1.2.\n\n\u0421\u043e\u0437\u0434\u0430\u043d\u0430 \u043d\u0430 \u043e\u0441\u043d\u043e\u0432\u0435 MobileMap (http://www.garret.ru/~knizhnik)\n\u0420\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u043a\u0430 - \u041d\u043e\u0432\u0438\u043a\u043e\u0432 \u0421\u0435\u043c\u0435\u043d - 2006 \u0433.\ne-mail: MobileMap@yandex.ru\n", null, AlertType.INFO);
        Display.getDisplay((MIDlet)this.main).setCurrent(alert, (Displayable)this);
    }

    void checkCoordinates() {
        if (this.x < 0) {
            this.x = 0;
        } else if (this.x + this.size > 65535) {
            this.x = 65535 - this.size;
        }
        if (this.y < 0) {
            this.y = 0;
        } else if (this.y + this.size > 65535) {
            this.y = 65535 - this.size;
        }
    }

    void reset() {
        this.scale = this.initScale;
        this.y = 0;
        this.x = 0;
        this.size = 65535;
        this.level = 0;
    }

    void selectStreet(int index) {
        this.selectedStreetIndex = index;
        if (index >= 0) {
            Street street = this.main.streets[index];
            Segment[] segments = street.segments;
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            byte streetLevel = 0;
            for (int i = 0; i < segments.length; ++i) {
                Segment s = segments[i];
                streetLevel = s.level;
                for (int j = 0; j < s.x.length; ++j) {
                    int x = s.x[j] & 0xFFFF;
                    int y = s.y[j] & 0xFFFF;
                    if (x < minX) {
                        minX = x;
                    }
                    if (x > maxX) {
                        maxX = x;
                    }
                    if (y < minY) {
                        minY = y;
                    }
                    if (y <= maxY) continue;
                    maxY = y;
                }
            }
            int width = maxX - minX;
            int height = maxY - minY;
            int wrapSize = (width > height ? width : height) << 1;
            this.size = 65535;
            this.scale = this.initScale;
            while (this.size > wrapSize) {
                this.size >>= 1;
                this.scale <<= 1;
            }
            this.setLevel();
            if (minX == maxX && minY == maxY) {
                this.scale = this.initScale << 4;
                this.setLevel();
                this.size = 4095;
                this.x = minX - this.size / 2;
                this.y = minY - this.size / 2;
            } else {
                this.x = minX + (width >> 1) - (this.size >> 1);
                this.y = minY + (height >> 1) - (this.size >> 1);
            }
            this.checkCoordinates();
        }
        this.repaint();
    }

    void setLevel() {
        this.level = 0;
        for (int i = 1; i < this.minLevelScale.length && this.minLevelScale[i] < this.scale; ++i) {
            ++this.level;
        }
    }

    void increase() {
        if (this.scale >>> 14 == 0) {
            this.scale <<= 1;
            this.setLevel();
            this.size >>= 1;
            this.x += this.size >> 1;
            this.y += this.size >> 1;
        }
    }

    void decrease() {
        this.scale >>= 1;
        if (this.scale <= this.initScale) {
            this.reset();
        } else {
            this.setLevel();
            this.x -= this.size >> 1;
            this.y -= this.size >> 1;
            this.size <<= 1;
        }
    }
}

