/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SSAnimation {
    private int numSprites;
    private int numFrames;
    private int numAnimations;
    private Image imageAnimation;
    private byte[] sprites;
    private short[][] frames;
    private short[][] animations;

    public SSAnimation(DataInputStream dis) {
        try {
            int i;
            this.numSprites = dis.readUnsignedByte();
            this.sprites = new byte[this.numSprites << 2];
            for (i = 0; i < this.numSprites; ++i) {
                byte x = (byte)dis.readUnsignedByte();
                byte y = (byte)dis.readUnsignedByte();
                byte width = (byte)dis.readUnsignedByte();
                byte height = (byte)dis.readUnsignedByte();
                this.sprites[(i << 2) + 0] = x;
                this.sprites[(i << 2) + 1] = y;
                this.sprites[(i << 2) + 2] = width;
                this.sprites[(i << 2) + 3] = height;
            }
            this.numFrames = dis.readUnsignedByte();
            this.frames = new short[this.numFrames][];
            for (i = 0; i < this.numFrames; ++i) {
                int numSpritesFrame = dis.readUnsignedByte();
                this.frames[i] = new short[numSpritesFrame * 3];
                for (int j = 0; j < numSpritesFrame; ++j) {
                    short index = (short)dis.readUnsignedByte();
                    short x = dis.readShort();
                    short y = dis.readShort();
                    this.frames[i][j * 3 + 0] = index;
                    this.frames[i][j * 3 + 1] = x;
                    this.frames[i][j * 3 + 2] = y;
                }
            }
            this.numAnimations = dis.readUnsignedByte();
            this.animations = new short[this.numAnimations][];
            for (i = 0; i < this.numAnimations; ++i) {
                short lengthAnimation = 0;
                int numFramesAnimation = dis.readUnsignedByte();
                this.animations[i] = new short[(numFramesAnimation << 1) + 1];
                for (int j = 0; j < numFramesAnimation; ++j) {
                    short index = (short)dis.readUnsignedByte();
                    short time = dis.readShort();
                    this.animations[i][1 + (j << 1) + 0] = index;
                    this.animations[i][1 + (j << 1) + 1] = time;
                    lengthAnimation = (short)(lengthAnimation + time);
                }
                this.animations[i][0] = lengthAnimation;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[128];
            int readed = dis.read(buffer);
            while (readed != -1) {
                baos.write(buffer, 0, readed);
                readed = dis.read(buffer);
            }
            buffer = baos.toByteArray();
            this.imageAnimation = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
            baos.close();
            dis.close();
            baos = null;
            dis = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void drawAnimation(Graphics g, int animation, long timeAnimation, int x, int y, boolean cyclical) {
        try {
            int numFrame = this.getFramePos(animation, Math.abs(timeAnimation), cyclical);
            this.drawFrame(g, numFrame, x, y);
        }
        catch (Exception e) {
            System.out.println("Time = " + timeAnimation);
        }
    }

    public void drawAnimation(Graphics g, int animation, long timeAnimation, int x, int y, int minY, boolean cyclical) {
        try {
            int numFrame = this.getFramePos(animation, Math.abs(timeAnimation), cyclical);
            this.drawFrame(g, numFrame, x, y, minY);
        }
        catch (Exception e) {
            System.out.println("Time = " + timeAnimation);
        }
    }

    public void drawFrame(Graphics g, int numFrame, int x, int y) {
        short[] spritesFrame = this.frames[numFrame];
        for (int i = 0; i < spritesFrame.length / 3; ++i) {
            short numSprite = spritesFrame[i * 3 + 0];
            short spriteX = spritesFrame[i * 3 + 1];
            short spriteY = spritesFrame[i * 3 + 2];
            this.drawSprite(g, numSprite, x + spriteX, y + spriteY);
        }
    }

    public void drawFrame(Graphics g, int numFrame, int x, int y, int minY) {
        short[] spritesFrame = this.frames[numFrame];
        for (int i = 0; i < spritesFrame.length / 3; ++i) {
            short numSprite = spritesFrame[i * 3 + 0];
            short spriteX = spritesFrame[i * 3 + 1];
            short spriteY = spritesFrame[i * 3 + 2];
            this.drawSprite(g, numSprite, x + spriteX, y + spriteY, minY);
        }
    }

    public void drawSprite(Graphics g, int numSprite, int x, int y) {
        int spriteX = this.sprites[(numSprite << 2) + 0] & 0xFF;
        int spriteY = this.sprites[(numSprite << 2) + 1] & 0xFF;
        int width = this.sprites[(numSprite << 2) + 2] & 0xFF;
        int height = this.sprites[(numSprite << 2) + 3] & 0xFF;
        g.setClip(x, y, width, height);
        g.drawImage(this.imageAnimation, x - spriteX, y - spriteY, 20);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void drawSprite(Graphics g, int numSprite, int x, int y, int minY) {
        int spriteX = this.sprites[(numSprite << 2) + 0] & 0xFF;
        int spriteY = this.sprites[(numSprite << 2) + 1] & 0xFF;
        int width = this.sprites[(numSprite << 2) + 2] & 0xFF;
        int height = this.sprites[(numSprite << 2) + 3] & 0xFF;
        if (y < minY) {
            int h = height - (minY - y);
            if (h <= 0) return;
            g.setClip(x, minY, width, h);
        } else {
            g.setClip(x, y, width, height);
        }
        g.drawImage(this.imageAnimation, x - spriteX, y - spriteY, 20);
    }

    private int getFramePos(int animation, long time, boolean cyclical) {
        int posFrame;
        long timeActual = 0L;
        if (cyclical) {
            time %= (long)this.animations[animation][0];
        }
        int maxFrames = this.animations[animation].length - 1 >> 1;
        for (posFrame = 0; timeActual <= time && posFrame < maxFrames; timeActual += (long)this.animations[animation][1 + (posFrame << 1) + 1], ++posFrame) {
        }
        return this.animations[animation][1 + (posFrame - 1 << 1)];
    }

    public int getFrameWidth(int numFrame) {
        short[] spritesFrame = this.frames[numFrame];
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        for (int i = 0; i < spritesFrame.length / 3; ++i) {
            short numSprite = spritesFrame[i * 3 + 0];
            short spriteX = spritesFrame[i * 3 + 1];
            int width = this.sprites[(numSprite << 2) + 2] & 0xFF;
            minX = Math.min(minX, spriteX);
            maxX = Math.max(maxX, spriteX + width);
        }
        return Math.abs(maxX - minX);
    }

    public int getFrameHeight(int numFrame) {
        short[] spritesFrame = this.frames[numFrame];
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (int i = 0; i < spritesFrame.length / 3; ++i) {
            short numSprite = spritesFrame[i * 3 + 0];
            short spriteY = spritesFrame[i * 3 + 2];
            int height = this.sprites[(numSprite << 2) + 3] & 0xFF;
            minY = Math.min(minY, spriteY);
            maxY = Math.max(maxY, spriteY + height);
        }
        return Math.abs(maxY - minY);
    }
}

