/*
 * Decompiled with CFR 0.152.
 */
package microforms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import microforms.Decompressor;
import microforms.MicroForms;
import microforms.MoveDown;
import microforms.OneRecord;

public class RecordsView
extends Form
implements CommandListener {
    Alert alert;
    MicroForms midlet;
    int current = -1;
    String caption;
    Command up;
    Command down;
    Command filter;
    Command help;
    Command exit;
    Vector cache = new Vector();
    String rowCount = "0";
    Image icon = null;
    char b;
    StringBuffer sb = new StringBuffer();
    Reader reader = null;
    String str;
    String filterString;
    Object o;
    StringBuffer buf;
    String value;
    int n = this.current;
    String s;
    String label;
    Vector r;
    Vector copy;
    int c;
    String cKey;
    int i;
    String cValue;
    boolean cacheFull = false;
    Decompressor decompressor;
    ByteArrayOutputStream scanBuffer = new ByteArrayOutputStream();

    public RecordsView(MicroForms m) {
        super("...");
        this.midlet = m;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.midlet.showErrorAlert("RecordsView: " + e.toString());
        }
    }

    public RecordsView() {
        this(null);
    }

    private void jbInit() throws Exception {
        this.decompressor = new Decompressor(this.midlet, "0.properties");
        this.midlet.fieldDelimiter = this.midlet.getLabel("InsertEmptyLine").equals("yes") ? "\n\n" : "\n";
        this.midlet.skipEmptyField = this.midlet.getLabel("HideEmptyFields").equals("yes");
        this.setCommandListener(this);
        try {
            this.icon = Image.createImage((String)"/icons/microForms.png");
        }
        catch (Throwable t) {
            // empty catch block
        }
        String caption = this.midlet.getLabel("InfoFormCaption");
        this.rowCount = this.midlet.getLabel("RowCount");
        String help_text = this.midlet.readFile("help.txt") + "\n\nPowered by microForms v1.2.14" + "\nhttp://microforms.mobile-mir.com" + "\n\n" + new Long(Runtime.getRuntime().freeMemory()).toString() + "b/" + new Long(Runtime.getRuntime().totalMemory()).toString() + "b\n" + System.getProperty("microedition.configuration") + "/" + System.getProperty("microedition.profiles");
        AlertType type = AlertType.INFO;
        this.alert = new Alert(caption);
        this.alert.setString(help_text);
        this.alert.setType(type);
        this.alert.setImage(this.icon);
        this.alert.setTimeout(-2);
        this.caption = this.midlet.getLabel("ViewFormCaption");
        this.down = new Command(this.midlet.getLabel("GoDownLabel"), 3, 1);
        this.up = new Command(this.midlet.getLabel("GoUpLabel"), 8, 2);
        this.filter = new Command(this.midlet.getLabel("OpenFilterLabel"), 8, 3);
        this.help = new Command(this.midlet.getLabel("HelpLabel"), 8, 4);
        this.exit = new Command(this.midlet.getLabel("ExitLabel"), 8, 5);
        this.addCommand(this.up);
        this.addCommand(this.down);
        this.addCommand(this.exit);
        this.addCommand(this.filter);
        this.addCommand(this.help);
        this.readHeaders();
        this.composeBlancForm();
        this.moveDown();
    }

    void moveDown() throws IOException {
        this.midlet.waitForm.tick.setText("");
        if (this.current + 2 > this.cache.size()) {
            if (!this.cacheFull) {
                this.cacheFull = true;
                int columnCounter = 0;
                int recordCount = 0;
                Vector<String> record = new Vector<String>();
                if (this.current > -1) {
                    recordCount = ((OneRecord)this.cache.elementAt((int)this.current)).nn;
                }
                String field = this.readNextField();
                while (field.length() > 0) {
                    if (field.endsWith("\n")) {
                        record.addElement(field.substring(0, field.length() - 1));
                        Vector one = this.copyRecord(record);
                        record.removeAllElements();
                        if (++recordCount % 100 == 0) {
                            this.midlet.waitForm.tick.setText(new Integer(recordCount).toString());
                        }
                        if (this.checkFilter(one)) {
                            this.cache.addElement(new OneRecord(recordCount, one));
                            ++this.current;
                            this.cacheFull = false;
                            break;
                        }
                        columnCounter = 0;
                    } else {
                        record.addElement(field.substring(0, field.length() - 1));
                        ++columnCounter;
                    }
                    field = this.readNextField();
                }
            }
        } else {
            ++this.current;
        }
        this.fillForm();
        this.midlet.display.setCurrent((Displayable)this.midlet.recordsForm);
    }

    boolean checkFilter(Vector r) {
        for (int i = 0; i < this.midlet.headers.size(); ++i) {
            this.o = r.elementAt(i);
            this.str = this.o == null ? "" : this.o.toString();
            this.filterString = this.midlet.filter.elementAt(i).toString();
            this.filterString = this.lowerCase(this.filterString);
            this.str = this.lowerCase(this.str);
            if (this.filterString.equals("") || this.str.indexOf(this.filterString) >= 0) continue;
            return false;
        }
        return true;
    }

    public String lowerCase(String s) {
        this.buf = new StringBuffer(s.toLowerCase());
        int n = this.buf.length();
        for (int k = 0; k < n; ++k) {
            char ch = this.buf.charAt(k);
            this.buf.setCharAt(k, ch >= '\u0410' && ch <= '\u042f' ? (char)(ch - 1040 + 1072) : (ch == '\u0401' ? (char)'\u0451' : (char)ch));
        }
        return this.buf.toString();
    }

    void moveUp() {
        if (this.current > 0) {
            --this.current;
            this.fillForm();
        }
    }

    void fillForm() {
        this.deleteAll();
        this.value = "";
        this.n = this.current;
        if (this.n < this.cache.size() && this.n > -1) {
            this.r = ((OneRecord)this.cache.elementAt((int)this.n)).data;
            for (int i = 0; i < this.midlet.headers.size(); ++i) {
                this.label = this.midlet.headers.elementAt(i).toString() + ": ";
                this.s = (String)this.r.elementAt(i);
                if (this.s == null) {
                    this.s = "";
                }
                if (this.s.length() <= 0 && this.midlet.skipEmptyField) continue;
                if (this.s.startsWith("#")) {
                    this.s = "/pictures/" + this.s.substring(1);
                    try {
                        this.append((Item)new ImageItem(null, Image.createImage((String)this.s), 1, this.s));
                        this.append((Item)new StringItem("", this.midlet.fieldDelimiter));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    continue;
                }
                this.s = this.s + this.midlet.fieldDelimiter;
                this.append((Item)new StringItem(this.label, this.s));
            }
            this.setFormTitle(((OneRecord)this.cache.elementAt((int)this.n)).nn);
        }
    }

    public void setFormTitle(int nn) {
        this.setTitle(new Integer(nn).toString() + "/" + this.rowCount + " " + this.caption);
    }

    void composeBlancForm() {
        this.setTitle("*/" + this.rowCount + " " + this.caption);
        this.value = "";
        for (int i = 0; i < this.midlet.headers.size(); ++i) {
            this.label = this.midlet.headers.elementAt(i).toString();
            this.value = this.value + this.label + ":" + this.midlet.fieldDelimiter;
        }
    }

    String readNextField() throws IOException {
        String s = "";
        this.scanBuffer.reset();
        int i = this.decompressor.read();
        while (i > -1) {
            this.scanBuffer.write(i);
            if ((char)i == '\n' || (char)i == ';') {
                try {
                    s = new String(this.scanBuffer.toByteArray(), "UTF-8");
                }
                catch (Throwable t) {
                    this.midlet.showErrorAlert("readNextField: " + t.toString());
                    t.printStackTrace();
                }
                break;
            }
            i = this.decompressor.read();
        }
        return s;
    }

    public void readHeaders() throws IOException {
        this.decompressor.resetData();
        String one = this.readNextField();
        this.midlet.headers = new Vector();
        while (one.length() > 0) {
            this.midlet.headers.addElement(one.substring(0, one.length() - 1));
            if (one.endsWith("\n")) break;
            one = this.readNextField();
        }
        this.midlet.filter = new Vector();
        for (int i = 0; i < this.midlet.headers.size(); ++i) {
            this.midlet.filter.addElement("");
        }
    }

    public void skipHeaders() throws IOException {
        this.decompressor.resetData();
        String one = this.readNextField();
        while (one.length() > 0 && !one.endsWith("\n")) {
            one = this.readNextField();
        }
    }

    Vector copyRecord(Vector record) {
        this.copy = new Vector(this.midlet.headers.size());
        this.c = this.midlet.headers.size();
        for (int i = 0; i < this.c; ++i) {
            this.label = this.midlet.headers.elementAt(i).toString();
            this.value = i < record.size() ? record.elementAt(i).toString() : "";
            this.copy.addElement(this.value);
        }
        return this.copy;
    }

    String getHeader(int i) {
        if (this.midlet.headers.size() > i) {
            this.o = this.midlet.headers.elementAt(i);
            return this.o.toString();
        }
        return "?";
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exit) {
            MicroForms.quitApp();
        } else if (command == this.help) {
            this.midlet.display.setCurrent(this.alert, (Displayable)this);
        } else if (command == this.down) {
            this.midlet.display.setCurrent((Displayable)this.midlet.waitForm);
            new Timer().schedule((TimerTask)new MoveDown(this.midlet), 123L);
        } else if (command == this.up) {
            this.moveUp();
        } else if (command == this.filter) {
            this.midlet.display.setCurrent((Displayable)this.midlet.filterForm);
        }
    }
}

