/*
 * Decompiled with CFR 0.152.
 */
package microforms;

import java.io.IOException;
import java.io.InputStream;
import microforms.MicroForms;

public class Decompressor {
    int currentPosition = 0;
    int cBufferSize = 4096;
    byte[] cache;
    byte[] tmpArr = new byte[this.cBufferSize];
    int lastReaded = 0;
    InputStream is;
    byte[] symbolArray = new byte[2];
    String resourceName;
    MicroForms midlet;

    public Decompressor(MicroForms m, String resName) {
        this.midlet = m;
        this.resourceName = resName;
        this.cache = new byte[2 * this.cBufferSize];
    }

    public int read() throws IOException {
        int i = -1;
        try {
            if (this.lastReaded >= this.currentPosition) {
                if (this.decompressNext()) {
                    ++this.lastReaded;
                    i = this.cache[this.lastReaded - 1];
                }
            } else {
                ++this.lastReaded;
                i = this.cache[this.lastReaded - 1];
            }
            if (i != -1 && i < 0) {
                i = 256 + i;
            }
        }
        catch (Throwable t) {
            this.midlet.showErrorAlert("read: " + t.toString() + "\ni=" + i + "\nthis.lastReaded=" + this.lastReaded + "\nthis.currentPosition=" + this.currentPosition + "\nthis.cache.length=" + this.cache.length);
            t.printStackTrace();
        }
        return i;
    }

    public void resetData() {
        try {
            this.currentPosition = 0;
            this.lastReaded = 0;
            this.is = null;
            System.gc();
            this.is = this.getClass().getResourceAsStream(this.resourceName);
        }
        catch (Throwable t) {
            this.midlet.showErrorAlert("resetData: " + t.toString());
            t.printStackTrace();
        }
    }

    boolean decompressNext() throws IOException {
        this.shiftBuffer();
        int i = this.is.read();
        if (i < 0) {
            return false;
        }
        int flag = i >> 7;
        int size = i >> 4;
        size &= 7;
        ++size;
        int dist256 = i & 0xF;
        dist256 *= 256;
        if (flag == 0) {
            this.appendRaw(size);
        } else {
            int distance = this.is.read();
            this.appendLink(distance |= dist256, size);
        }
        return true;
    }

    void appendRaw(int size) throws IOException {
        byte[] w = new byte[size];
        for (int k = 0; k < size; ++k) {
            int b = this.is.read();
            w[k] = (byte)b;
            this.appendBuffer((byte)b);
        }
    }

    void appendLink(int distance, int size) throws IOException {
        int i;
        int begin = this.currentPosition - distance;
        byte[] b = new byte[size];
        for (i = begin; i < begin + size; ++i) {
            b[i - begin] = this.cache[i];
        }
        for (i = 0; i < b.length; ++i) {
            this.appendBuffer(b[i]);
        }
    }

    void appendBuffer(byte b) throws IOException {
        this.cache[this.currentPosition] = b;
        ++this.currentPosition;
    }

    void shiftBuffer() {
        if (this.currentPosition >= 2 * this.cBufferSize - 8) {
            System.arraycopy(this.cache, this.cBufferSize, this.tmpArr, 0, this.cBufferSize);
            System.arraycopy(this.tmpArr, 0, this.cache, 0, this.cBufferSize);
            this.currentPosition -= this.cBufferSize;
            this.lastReaded -= this.cBufferSize;
        }
    }
}

