/*
 * Decompiled with CFR 0.152.
 */
package persistancy;

import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import persistancy.PersistantObject;

public final class PersistantObjectManager {
    protected static Hashtable objectHashtable = new Hashtable();

    public static boolean manages(PersistantObject persistantObject) {
        return objectHashtable.containsKey(new Integer(persistantObject.hashCode()));
    }

    static void objectChanged(PersistantObject persistantObject) throws Exception {
        if (PersistantObjectManager.manages(persistantObject)) {
            RecordStore recordStore = RecordStore.openRecordStore((String)persistantObject.getClass().getName(), (boolean)false);
            recordStore.setRecord(((Integer)objectHashtable.get(new Integer(persistantObject.hashCode()))).intValue(), persistantObject.writeObject(), 0, persistantObject.writeObject().length);
            recordStore.closeRecordStore();
        }
    }

    public static void addObject(PersistantObject persistantObject) throws Exception {
        RecordStore recordStore = RecordStore.openRecordStore((String)persistantObject.getClass().getName(), (boolean)true);
        int n = recordStore.addRecord(persistantObject.writeObject(), 0, persistantObject.writeObject().length);
        PersistantObjectManager.addToObjectHashtable(persistantObject, n);
        recordStore.closeRecordStore();
    }

    public static void removeObject(PersistantObject persistantObject) throws Exception {
        RecordStore recordStore = RecordStore.openRecordStore((String)persistantObject.getClass().getName(), (boolean)false);
        recordStore.deleteRecord(((Integer)objectHashtable.get(new Integer(persistantObject.hashCode()))).intValue());
        objectHashtable.remove(new Integer(persistantObject.hashCode()));
        recordStore.closeRecordStore();
    }

    protected static void addToObjectHashtable(PersistantObject persistantObject, int n) {
        if (!PersistantObjectManager.manages(persistantObject)) {
            objectHashtable.put(new Integer(persistantObject.hashCode()), new Integer(n));
        }
    }

    public static Vector getAllObjectsByClass(Class clazz) throws Exception {
        Vector<PersistantObject> vector = new Vector<PersistantObject>();
        if (Class.forName("persistancy.PersistantObject").isAssignableFrom(clazz)) {
            RecordStore recordStore;
            try {
                recordStore = RecordStore.openRecordStore((String)clazz.getName(), (boolean)false);
            }
            catch (Exception exception) {
                return null;
            }
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                PersistantObject persistantObject = (PersistantObject)clazz.newInstance();
                persistantObject.readObject(recordStore.getRecord(n));
                vector.addElement(persistantObject);
                PersistantObjectManager.addToObjectHashtable(persistantObject, n);
            }
            recordStore.closeRecordStore();
            return vector;
        }
        return null;
    }
}

