/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class Tetris {
    static Random rnd = new Random();
    private static final int STATE_NONE = 0;
    private static final int STATE_MENU = 1;
    private static final int STATE_PLAY = 3;
    private static final int STATE_RESULT = 4;
    private static final int STATE_DRAW_SCORE = 5;
    private static final int STATE_ABORT_GAME = 6;
    private static final int STATE_LEVEL_MENU = 7;
    private static final int STATE_QUESTION_ABORT_GAME = 8;
    private static final int STATE_NEW_GAME = 9;
    private static final int STATE_PROGRESS_BACK = 10;
    private static final int STATE_SHOW_SPLASH = 12;
    private static final int STATE_DRAW_INFO = 13;
    private static final int STATE_ENTER_NAME = 14;
    private static final int STATE_INIT_BRIEFING = 15;
    private static final int STATE_BRIEFING = 16;
    private static final int STATE_QUEST_SMS = 17;
    private static final int STATE_SMS_UPLOAD_RESULT = 18;
    private static final int STATE_UPLOAD = 19;
    private static final int STATE_UPLOAD_BACK = 20;
    private static final int MENU_STATE_PLAY = 0;
    private static final int MENU_STATE_SOUND = 1;
    private static final int MENU_STATE_SCORE = 2;
    private static final int MENU_STATE_HELP = 3;
    private static final int MENU_STATE_ABOUT = 4;
    static final int MENU_STATE_WAP = 5;
    private static final int MENU_STATE_EXIT = 6;
    static final int MENU_STATE_CONTINUE = 7;
    static boolean fContinue;
    static int currState;
    static int lastState;
    static boolean resizeGraph;
    static boolean messGraphResize;
    private static int sndMusic;
    private static int sndDrop;
    private static int sndRolLastic;
    private static int sndSpray;
    private static int sndBucket;
    private static int sndLiquid;
    private static int sndWin;
    private static int sndLevNext;
    private static int sndOver;
    static boolean fDrawProgressBar;
    static int iCurrProgress;
    private static int[] cheat;
    private static boolean fGirlCanOpen;
    private static int cheatPos;
    private static final String[] SHAPE_DATA_COMMON;
    private static final String[] SHAPE_DATA_LIQUID;
    private static final int[] AREA_FOR_LEVELS;
    private static final int[] SPEED_FOR_LEVELS;
    private static final int GAME_STATE_NONE = 0;
    private static final int GAME_STATE_REINIT = 1;
    private static final int GAME_STATE_PLAY = 2;
    private static final int GAME_STATE_LIQUID = 3;
    private static final int GAME_STATE_RESULT = 4;
    private static final int GAME_STATE_BRIEFING = 5;
    private static final int GAME_STATE_BONUS_PROC = 6;
    private static final int GAME_STATE_DRAWGIRL = 7;
    private static final int SHAPE_TYPE_COMMON = 0;
    private static final int SHAPE_TYPE_LIQUID = 1;
    private static final int SHAPE_TYPE_BONUS = 2;
    private static final int BONUS_TYPE_ROLLER = 0;
    private static final int BONUS_TYPE_LASTIC = 1;
    private static final int BONUS_TYPE_BUCKET = 2;
    private static final int BONUS_TYPE_SPRAY = 3;
    private static final int BONUS_TYPE_JIN = 4;
    static int currGameState;
    private static Image backGroundTile;
    private static Image imgGirl;
    private static int[][] girlsCoords;
    private static int imgGirlXPos;
    private static int imgGirlYPos;
    private static int fldGameXPos;
    private static int fldGameYPos;
    private static int initShapeXPos;
    private static int initShapeYPos;
    private static GameImage box;
    private static GameImage freeBox;
    private static GameImage[] liquidBox;
    private static GameImage[][] bonusBox;
    private static GameImage[] bonusIcons;
    private static GameImage zigzagBox;
    private static GameImage[] starsEffect;
    private static GameImage[] explEffect;
    private static boolean[][] fld;
    private static boolean[][] currShape;
    private static boolean[][] nextShape;
    private static int currShapeX;
    private static int currShapeY;
    private static int currShapeYS;
    private static int currShapeYSAdd;
    private static int maxShapeHeight;
    private static int currShapeType;
    private static int nextShapeType;
    private static int aniStep;
    private static int currFieldRate;
    private static int currLevel;
    private static int currScore;
    private static int maxScore;
    private static int currDifficulty;
    private static int allScore;
    private static int[][] liquidProcessData;
    private static int bonusType;
    private static int keyLeftDelay;
    private static int keyRightDelay;
    private static boolean toLeft;
    private static boolean toRight;
    private static final int ZIGZAG_STATE_NONE = 0;
    private static final int ZIGZAG_STATE_FILL = 1;
    private static final int ZIGZAG_STATE_CLEAR = 2;
    private static int zigzagState;
    private static boolean[] zigzagLine;
    private static final int SPRAY_STATE_NONE = 0;
    private static final int SPRAY_STATE_DOWN = 1;
    private static final int SPRAY_STATE_FILL = 2;
    private static int sprayState;
    private static int aniSpray;
    private static final int JIN_STATE_NONE = 0;
    private static final int JIN_STATE_MOVE = 1;
    private static int jinState;
    private static int jinStep;
    private static int jinX;
    private static int jinY;
    private static int[][] jinArrayKernel;
    private static int[][] jinFldKernel;
    private static boolean[] jinFldKernelInit;
    private static int jinFldKernelActiveNum;
    private static int speedKernelFly;
    private static final int[] trigValue;

    Tetris() {
    }

    void init() {
        String[] soundNames = null;
        if (Z.getProperty("_initSndAll", 1) == 1) {
            soundNames = new String[9];
            soundNames[Tetris.sndMusic] = "music";
            soundNames[Tetris.sndDrop] = "click";
            soundNames[Tetris.sndRolLastic] = "lastic";
            soundNames[Tetris.sndSpray] = "spray";
            soundNames[Tetris.sndBucket] = "bucket";
            soundNames[Tetris.sndLiquid] = "liquid";
            soundNames[Tetris.sndWin] = "win";
            soundNames[Tetris.sndLevNext] = "levNext";
            soundNames[Tetris.sndOver] = "over";
        } else {
            soundNames = new String[4];
            soundNames[Tetris.sndMusic] = "music";
            soundNames[Tetris.sndDrop] = "click";
            soundNames[Tetris.sndRolLastic] = "lastic";
            soundNames[Tetris.sndSpray] = "spray";
            sndBucket = sndDrop;
            sndLiquid = sndDrop;
            sndWin = sndDrop;
            sndLevNext = sndDrop;
            sndOver = sndDrop;
        }
        SoundManager.init(soundNames);
        int sch = Z.getProperty("backBufferH", 0);
        if (sch == 0) {
            sch = ScreenCanvas.height;
        } else {
            messGraphResize = ScreenCanvas.height != Z.getProperty("backBufferH", 0);
        }
        backGroundTile = Image.createImage((int)ScreenCanvas.width, (int)sch);
        Graphics g = backGroundTile.getGraphics();
        Image tmpImage = GameImage.loadImageFromPak("menu.pack", "tile");
        for (int j = 0; j < backGroundTile.getHeight(); j += tmpImage.getHeight()) {
            for (int i = 0; i < backGroundTile.getWidth(); i += tmpImage.getWidth()) {
                g.drawImage(tmpImage, i, j, 0);
            }
        }
        tmpImage = GameImage.loadImageFromPak("menu.pack", "girl_03");
        int tmpY = ScreenCanvas.height - tmpImage.getHeight();
        g.drawImage(tmpImage, 0, tmpY, 0);
        tmpImage = GameImage.loadImageFromPak("menu.pack", "girl_01");
        int tmpX = tmpImage.getWidth();
        g.drawImage(tmpImage, 0, tmpY - tmpImage.getHeight(), 0);
        tmpY = tmpImage.getHeight();
        tmpImage = GameImage.loadImageFromPak("menu.pack", "logo");
        if (tmpX > ScreenCanvas.width - tmpImage.getWidth() - 10) {
            tmpX = ScreenCanvas.width - tmpImage.getWidth() - 10;
        }
        if ((tmpY = tmpY - tmpImage.getHeight() >> 1) < 0) {
            tmpY = 5;
        }
        g.drawImage(tmpImage, tmpX, tmpY, 20);
        long lastTime = System.currentTimeMillis();
        currState = 12;
        Z.libCanvas.redraw();
        tmpImage = null;
        backGroundTile = null;
        Z.sleep(10L);
        int menuCount = 7 + Z.getProperty("WAP", 0);
        GameMenu.initGameMenu(menuCount);
        Tetris.loadOptions();
        GameMenu.addMenuItem(Z.getProperty("_mnuCont"), 7, 0);
        GameMenu.addMenuItem(Z.getProperty("_mnuPlay"), 0, 0);
        GameMenu.addMenuItem(Z.getProperty("_mnuSound"), 1, SoundManager.SoundIsOn() ? 1 : 0);
        GameMenu.addMenuItem(Z.getProperty("_mnuScore"), 2, 0);
        GameMenu.addMenuItem(Z.getProperty("_mnuHelp"), 3, 0);
        GameMenu.addMenuItem(Z.getProperty("_mnuAbout"), 4, 0);
        if (Z.getProperty("_WAP", 0) != 0) {
            GameMenu.addMenuItem(Z.getProperty("_mnuWap"), 5, 0);
        }
        GameMenu.addMenuItem(Z.getProperty("_mnuExit"), 6, 0);
        Z.sleep(Z.SPLASH - (System.currentTimeMillis() - lastTime));
        SoundManager.play(sndMusic, true);
        currState = 1;
    }

    static void playSound(int sndNum, boolean rep) {
        if (SoundManager.SoundIsOn()) {
            SoundManager.stop();
            SoundManager.play(sndNum, rep);
        }
    }

    static void redrawProgress(int proc) {
        Z.sleep(5L);
        iCurrProgress = proc;
        fDrawProgressBar = true;
        Z.libCanvas.redraw();
        fDrawProgressBar = false;
    }

    static void drawProgress(Graphics g) {
        int mul = ScreenCanvas.width / 100;
        int w = mul * 100;
        int h = ScreenCanvas.height / 20;
        int x = ScreenCanvas.width - w >> 1;
        int y = ScreenCanvas.height - h >> 1;
        g.setColor(8823);
        g.fillRoundRect(x - 1, y - 1, w + 2, h + 2, 3, 3);
        g.setColor(21930);
        g.drawRoundRect(x - 1, y - 1, w + 2, h + 2, 3, 3);
        g.setColor(0xDDBB22);
        g.fillRoundRect(x + 1, y + 1, iCurrProgress * mul - 2, h - 1, 3, 3);
    }

    void deinit() {
        SoundManager.destroy();
    }

    void draw() {
        if (iCurrProgress > 0) {
            if (fDrawProgressBar) {
                GameMenu.drawAltMenu(ScreenCanvas.g);
                Tetris.drawProgress(ScreenCanvas.g);
            }
            if (iCurrProgress == 100) {
                iCurrProgress = 0;
            }
        } else {
            switch (currState) {
                case 0: {
                    break;
                }
                case 1: {
                    GameMenu.drawMenu(ScreenCanvas.g);
                    break;
                }
                case 3: {
                    if (messGraphResize) break;
                    Tetris.drawGame(ScreenCanvas.g);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 20: {
                    GameMenu.drawAltMenu(ScreenCanvas.g);
                    break;
                }
                case 12: {
                    if (backGroundTile != null) {
                        System.out.println("drawSplash...");
                        ScreenCanvas.g.drawImage(backGroundTile, 0, 0, 20);
                    }
                    ScreenCanvas.g.setClip(0, 0, ScreenCanvas.width, ScreenCanvas.height);
                }
            }
        }
    }

    static void callResizeGraph() {
        resizeGraph = true;
    }

    static void resizeGraphProc() {
        messGraphResize = ScreenCanvas.height != Z.getProperty("backBufferH", 0);
        System.out.println("Z.getProperty(\"backBufferH\",0):".concat(String.valueOf(String.valueOf(Z.getProperty("backBufferH", 0)))));
        System.out.println("ScreenCanvas.height:".concat(String.valueOf(String.valueOf(ScreenCanvas.height))));
        switch (currState) {
            case 3: {
                break;
            }
            case 1: {
                GameMenu.initGraph();
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                GameMenu.reinitGraphAltMenu();
            }
        }
        resizeGraph = false;
    }

    void process() {
        if (resizeGraph) {
            Tetris.resizeGraphProc();
        }
        block0 : switch (currState) {
            case 0: {
                break;
            }
            case 1: {
                switch (GameMenu.processMenu()) {
                    case 0: {
                        SoundManager.stop();
                        if (!fContinue) {
                            currState = 9;
                            break block0;
                        }
                        GameMenu.initAltMenu(Z.getProperty("__titleAbort"), Z.getProperty("strNo"), Z.getProperty("strYes"), Z.getProperty("__textAbort"), null, GameMenu.currAltItemNum);
                        currState = 8;
                        break block0;
                    }
                    case 7: {
                        SoundManager.stop();
                        if (!fContinue) break block0;
                        currState = 3;
                        break block0;
                    }
                    case 1: {
                        if (SoundManager.SoundIsOn()) {
                            SoundManager.stop();
                        }
                        SoundManager.setSound(!SoundManager.SoundIsOn());
                        GameMenu.paramSW(SoundManager.SoundIsOn() ? 1 : 0);
                        if (!SoundManager.SoundIsOn()) break block0;
                        Tetris.playSound(sndMusic, true);
                        break block0;
                    }
                    case 3: {
                        lastState = currState;
                        GameMenu.initAltMenu(Z.getProperty("__titleHelp"), Z.getProperty("strMenu"), null, Z.getProperty("__textHelp"), null, GameMenu.currAltItemNum);
                        currState = 13;
                        break block0;
                    }
                    case 2: {
                        lastState = currState;
                        GameMenu.initScore(true);
                        currState = 5;
                        break block0;
                    }
                    case 4: {
                        lastState = currState;
                        GameMenu.initAbout();
                        currState = 13;
                        Tetris.playSound(sndMusic, true);
                        break block0;
                    }
                    case 5: {
                        Z.isActive = !ScreenCanvas.platformRequest(Z.getProperty("URL"));
                        break block0;
                    }
                    case 6: {
                        Z.isActive = false;
                        return;
                    }
                }
                break;
            }
            case 3: {
                if (currGameState == 1) {
                    iCurrProgress = messGraphResize ? 0 : 1;
                }
                if (messGraphResize) {
                    lastState = 3;
                    GameMenu.initAltMenu(Z.getProperty("__titleResize"), Z.getProperty("__strOk"), null, Z.getProperty("__textResize"), null, GameMenu.currAltItemNum);
                    currState = 13;
                    break;
                }
                if (Z.SoftLeft) {
                    Z.SoftLeft = false;
                    currState = 1;
                    if (SoundManager.SoundIsOn()) {
                        Tetris.playSound(sndMusic, true);
                    }
                    GameMenu.initGraph();
                }
                Tetris.processGame();
                break;
            }
            case 4: {
                GameMenu.itemsSW(0, 0, true);
                GameMenu.initEnterName(currScore);
                currState = 14;
                SoundManager.play(sndOver, false);
                break;
            }
            case 8: {
                int retLevMenu = GameMenu.processAltMenu(false);
                if (retLevMenu == -1) {
                    currState = 1;
                }
                if (retLevMenu != -2) break;
                currState = 6;
                break;
            }
            case 7: {
                int retLevMenu = GameMenu.processAltMenu(true);
                if (retLevMenu == -1) {
                    currState = 1;
                }
                if (retLevMenu != -2 && retLevMenu != -3) break;
                fContinue = true;
                currDifficulty = GameMenu.currAltItemNum;
                currState = 15;
                SoundManager.play(sndDrop, false);
                System.out.println("currDifficulty:".concat(String.valueOf(String.valueOf(currDifficulty))));
                break;
            }
            case 6: {
                fContinue = false;
                currState = 9;
                break;
            }
            case 9: {
                GameMenu.initAltMenu(Z.getProperty("__mnuTitleLevel"), Z.getProperty("strMenu"), Z.getProperty("strPlay"), "", new String[]{Z.getProperty("__mnuItemEASY"), Z.getProperty("__mnuItemNORM"), Z.getProperty("__mnuItemHARD")}, GameMenu.currAltItemNum);
                currGameState = 1;
                allScore = 0;
                currScore = 0;
                currLevel = 0;
                GameMenu.itemsSW(0, 0, true);
                currState = 7;
                break;
            }
            case 15: {
                int iGirls = 4 - (Z.getProperty("bab3", 0) == 0 ? 0 : 1);
                int girlNum = currLevel / iGirls + 1;
                int thingsCount = currLevel % iGirls + 1;
                GameMenu.initAltMenu(Z.getProperty("__titleBrief"), Z.getProperty("strMenu"), Z.getProperty("strPlay"), String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Z.getProperty("__textBrief0")))).append(" ").append(girlNum).append("-").append(thingsCount).append(Z.getProperty("__textBrief1")).append(" ").append(AREA_FOR_LEVELS[currLevel % AREA_FOR_LEVELS.length]).append(Z.getProperty("__textBrief2")))), null, GameMenu.currAltItemNum);
                currState = 16;
                SoundManager.play(sndLevNext, false);
                break;
            }
            case 16: {
                int retLevMenu = GameMenu.processAltMenu(false);
                if (retLevMenu == -1) {
                    currState = 1;
                }
                if (retLevMenu != -2 && retLevMenu != -3) break;
                currState = 3;
                iCurrProgress = 1;
                break;
            }
            case 5: {
                int retLevMenu = GameMenu.processAltMenu(false);
                if (retLevMenu == -1 || retLevMenu == -3) {
                    currState = lastState;
                }
                if (retLevMenu != -2) break;
                currState = 19;
                break;
            }
            case 13: {
                int retLevMenu;
                if (Z.isCheatingOn && Z.AnyKey) {
                    int key = -1;
                    if (Z.KeyDownLeft) {
                        key = 7;
                    }
                    if (Z.KeyUp) {
                        key = 2;
                    }
                    if (Z.KeyDown) {
                        key = 8;
                    }
                    if (Z.KeyFire) {
                        key = 5;
                    }
                    if (Z.KeyRight) {
                        key = 6;
                    }
                    Z.clearKeys();
                    if (cheat[cheatPos] != key) {
                        Z.isCheatingOn = false;
                        cheatPos = 0;
                    } else if (++cheatPos == cheat.length) {
                        fGirlCanOpen = true;
                        Z.isCheatingOn = false;
                        cheatPos = 0;
                    }
                }
                if (Z.isCheatingOn) break;
                if (Z.KeyPound) {
                    Z.isCheatingOn = true;
                    System.out.println("Mode Cheat On.");
                    Z.clearKeys();
                }
                if ((retLevMenu = GameMenu.processAltMenu(false)) != -1 && retLevMenu != -3) break;
                currState = lastState;
                Z.clearKeys();
                break;
            }
            case 14: {
                if (GameMenu.processEnterName()) {
                    if (Z.getProperty("SMS", 0) == 1) {
                        lastState = currState;
                        GameMenu.initAltMenu(Z.getProperty("__titleSMS"), Z.getProperty("strNo"), Z.getProperty("strYes"), Z.getProperty("SMS_STR"), null, GameMenu.currAltItemNum);
                        currState = 17;
                        fContinue = false;
                    } else {
                        lastState = 6;
                        GameMenu.initScore(true);
                        GameMenu.addScore(GameMenu.strLastName, currScore);
                        currState = 5;
                        fContinue = false;
                    }
                }
                Z.clearKeys();
                break;
            }
            case 17: {
                int retLevMenu = GameMenu.processAltMenu(false);
                if (retLevMenu == -1) {
                    lastState = 6;
                    GameMenu.initScore(true);
                    GameMenu.addScore(GameMenu.strLastName, currScore);
                    currState = 5;
                }
                if (retLevMenu == -2) {
                    lastState = 17;
                    GameMenu.initAltMenu(Z.getProperty("__titleSMS"), Z.getProperty("__strOk"), null, Z.getProperty(GameMenu.sendSMS(currScore) ? "__textSMSOk" : "__textSMSError"), null, GameMenu.currAltItemNum);
                    currState = 18;
                }
                Z.clearKeys();
                break;
            }
            case 18: {
                int retLevMenu = GameMenu.processAltMenu(false);
                if (retLevMenu == -1 || retLevMenu == -3) {
                    GameMenu.initScore(true);
                    if (lastState == 17) {
                        GameMenu.addScore(GameMenu.strLastName, currScore);
                    }
                    lastState = 6;
                    currState = 5;
                }
                Z.clearKeys();
                break;
            }
            case 19: {
                GameMenu.initAltMenu(Z.getProperty("__titleUpload"), null, null, Z.getProperty("__textUpload"), null, GameMenu.currAltItemNum);
                currState = 20;
                Z.libCanvas.redraw();
                currState = 19;
                GameMenu.initAltMenu(Z.getProperty("__titleUpload"), Z.getProperty("__strOk"), null, Z.getProperty(GameMenu.UploadScores() ? "__textUploadOk" : "__textUploadEr"), null, GameMenu.currAltItemNum);
                lastState = 19;
                currState = 18;
                Z.clearKeys();
                break;
            }
        }
    }

    private static void initGame() {
        Z.sleep(10L);
        GameMenu.initAltMenu(Z.getProperty("strLoading"), null, null, "", null, GameMenu.currAltItemNum);
        currState = 10;
        Z.libCanvas.redraw();
        currState = 3;
        Tetris.redrawProgress(1);
        Tetris.initGFXGirl(currLevel);
        Tetris.redrawProgress(30);
        Tetris.initBackGround();
        Tetris.redrawProgress(60);
        Tetris.initGFXGame();
        Tetris.redrawProgress(90);
        if (fld == null) {
            fld = new boolean[fld.length][fld[0].length];
        } else {
            for (int j = 0; j < fld.length; ++j) {
                for (int i = 0; i < fld[0].length; ++i) {
                    Tetris.fld[j][i] = false;
                }
            }
        }
        currShape = null;
        nextShape = null;
        currFieldRate = 0;
        currScore = 0;
        maxScore = fld.length * fld[0].length * (1 + currDifficulty);
        int tmpSpeed = Z.getProperty("slowDevice", 0) == 1 ? (currLevel % SPEED_FOR_LEVELS.length < 1 ? 1 : currLevel % SPEED_FOR_LEVELS.length) : currLevel % SPEED_FOR_LEVELS.length;
        maxShapeHeight = SPEED_FOR_LEVELS[currLevel < SPEED_FOR_LEVELS.length ? tmpSpeed : SPEED_FOR_LEVELS.length - 1];
        Tetris.redrawProgress(100);
        Z.sleep(10L);
        currGameState = 2;
    }

    private static void initBackGround() {
        int j;
        int i;
        int fldHeight;
        if (backGroundTile != null) {
            return;
        }
        backGroundTile = Image.createImage((int)ScreenCanvas.width, (int)ScreenCanvas.height);
        Image imgBox = GameImage.loadImageFromPak("gfx.pack", "box");
        int boxW = imgBox.getWidth();
        int boxH = imgBox.getHeight();
        imgBox = null;
        GameImage.initManager("back.pack");
        GameImage bgTop = GameImage.getImage("tile_back_gr");
        GameImage bgLine = GameImage.getImage("tile_back_gr_l");
        GameImage bgBottom = GameImage.getImage("tile_back_bl");
        GameImage bgFrmV = GameImage.getImage("tile_frm_v");
        GameImage bgFrmH = GameImage.getImage("tile_frm_h");
        GameImage bgBottomImage = GameImage.getImage("herb");
        GameImage bgTopImage = GameImage.getImage("kat_up");
        int fldWidth = imgGirl.getWidth();
        if (fldWidth >= ScreenCanvas.width) {
            fldWidth = ScreenCanvas.width;
        }
        if ((fldHeight = imgGirl.getHeight()) >= ScreenCanvas.height) {
            fldHeight = ScreenCanvas.height;
        }
        int fldW = fldWidth / boxW;
        int fldH = fldHeight / boxH;
        int bgBottomWOffset = -(ScreenCanvas.width % bgBottom.width >> 1);
        int bgLineWOffset = -(ScreenCanvas.width % bgLine.width >> 1);
        int bgTopWOffset = -(ScreenCanvas.width % bgTop.width >> 1);
        imgGirlXPos = ScreenCanvas.width - imgGirl.getWidth() >> 1;
        imgGirlYPos = ScreenCanvas.height - imgGirl.getHeight();
        fldGameXPos = fldWidth - fldW * boxW >> 1;
        fldGameYPos = imgGirlYPos;
        imgGirlYPos = ScreenCanvas.height - imgGirl.getHeight() - (fldHeight - fldH * boxH >> 1);
        initShapeXPos = (fldW >> 1) - 1;
        initShapeYPos = -(fldGameYPos / boxH);
        fld = new boolean[fldH][fldW];
        Graphics g = backGroundTile.getGraphics();
        for (i = bgBottomWOffset; i < ScreenCanvas.width; i += bgBottom.width) {
            for (j = ScreenCanvas.height - imgGirl.getHeight(); j < ScreenCanvas.height; j += bgBottom.height) {
                bgBottom.draw(g, i, j);
            }
        }
        for (i = bgLineWOffset; i < ScreenCanvas.width; i += bgLine.width) {
            bgLine.draw(g, i, ScreenCanvas.height - imgGirl.getHeight() - bgLine.height);
        }
        for (i = bgTopWOffset; i < ScreenCanvas.width; i += bgTop.width) {
            j = ScreenCanvas.height - imgGirl.getHeight() - bgLine.height - bgTop.height;
            while (j + bgTop.height > 0) {
                bgTop.draw(g, i, j);
                j -= bgTop.height;
            }
        }
        if (bgBottomImage != null) {
            bgBottomImage.draw(g, ScreenCanvas.width - bgBottomImage.width >> 1, fldGameYPos + (ScreenCanvas.height - fldGameYPos - bgBottomImage.height >> 1));
        }
        if (bgTopImage != null) {
            int tyi = fldGameYPos - bgTopImage.height >> 1;
            if (tyi < 0) {
                tyi *= 2;
            }
            bgTopImage.draw(g, ScreenCanvas.width - bgTopImage.width >> 1, tyi);
        }
        int i2 = fldGameXPos - bgFrmV.width;
        int ii = fldGameXPos + fld[0].length * boxW;
        for (int j2 = 0; j2 < ScreenCanvas.height; j2 += bgFrmV.height) {
            bgFrmV.draw(g, i2, j2);
            bgFrmV.draw(g, ii, j2);
        }
        j = fldGameYPos + fld.length * boxH;
        for (i = fldGameXPos - bgFrmH.width; i < ScreenCanvas.width; i += bgFrmH.width) {
            bgFrmH.draw(g, i, j);
        }
        GameImage.deinitManager();
    }

    private static void initGFXGirl(int level) {
        GameImage.deinitManager();
        int iGirls = 4 - (Z.getProperty("bab3", 0) == 0 ? 0 : 1);
        int girlNum = level % iGirls;
        int thingsCount = 4 - level / iGirls % 5;
        if (Z.getProperty("dressed", 0) == 1 && thingsCount < 2) {
            thingsCount = 2;
        }
        if (girlsCoords == null) {
            Tetris.initGirlsCoords();
        }
        Image imgGirl_tmp = GameImage.loadImage("".concat(String.valueOf(String.valueOf(girlNum))));
        if (imgGirl == null) {
            imgGirl = Image.createImage((int)imgGirl_tmp.getWidth(), (int)(imgGirl_tmp.getHeight() - 4));
        }
        Graphics g = imgGirl.getGraphics();
        g.drawImage(imgGirl_tmp, 0, 0, 0);
        imgGirl_tmp = null;
        Z.sleep(5L);
        int firstThing = girlNum * 4;
        int i = 0;
        int n = firstThing;
        while (i < thingsCount) {
            Image img = GameImage.loadImageFromPak("dress.pack", String.valueOf(String.valueOf(new StringBuffer("").append(girlNum).append(i))));
            if (img != null) {
                g.drawImage(img, girlsCoords[n][0], girlsCoords[n][1], 0);
            } else {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("not loaded from \"dress.pack\" image ").append(girlNum).append(i))));
            }
            img = null;
            System.gc();
            ++i;
            ++n;
        }
    }

    private static void initGirlsCoords() {
        block6: {
            girlsCoords = new int[16][2];
            try {
                DataInputStream Reader = Z.getResourceAsStream("dress.dat");
                if (Reader == null) break block6;
                try {
                    for (int i = 0; i < 16; ++i) {
                        String line = Z.readLine(Reader);
                        if (line != null) {
                            String[] tmp = Z.SplitValue(line, false, ';');
                            Tetris.girlsCoords[i][0] = Integer.parseInt(tmp[0]);
                            Tetris.girlsCoords[i][1] = Integer.parseInt(tmp[1]);
                            continue;
                        }
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("dress.dat not found line ").append(i).append(" ..."))));
                    }
                }
                catch (Exception e) {
                    System.out.println("dress.dat not loaded...");
                    e.printStackTrace();
                }
                Reader.close();
                Reader = null;
                System.gc();
            }
            catch (Exception e) {
                System.out.println("dress.dat not opened...");
                e.printStackTrace();
            }
        }
    }

    private static void initGFXGame() {
        GameImage.initManager("gfx.pack");
        box = GameImage.getImage("box");
        freeBox = GameImage.getImage("box_down");
        zigzagBox = GameImage.getImage("roller_tile");
        liquidBox = Tetris.getImagesForAni("box_liq", false);
        bonusBox = new GameImage[5][];
        bonusIcons = new GameImage[5];
        Tetris.bonusBox[0] = Tetris.getImagesForAni("roller", true);
        Tetris.bonusIcons[0] = GameImage.getImage("rolleri");
        Tetris.bonusBox[1] = Tetris.getImagesForAni("lastic", true);
        Tetris.bonusIcons[1] = GameImage.getImage("lastici");
        Tetris.bonusBox[2] = Tetris.getImagesForAni("buck", true);
        Tetris.bonusIcons[2] = GameImage.getImage("bucki");
        Tetris.bonusBox[3] = Tetris.getImagesForAni("spray", true);
        Tetris.bonusIcons[3] = GameImage.getImage("sprayi");
        Tetris.bonusBox[4] = Tetris.getImagesForAni("jin", true);
        Tetris.bonusIcons[4] = GameImage.getImage("jini");
        starsEffect = Tetris.getImagesForAni("stars", false);
        explEffect = Tetris.getImagesForAni("expl", false);
    }

    private static GameImage[] getImagesForAni(String name, boolean aniRev) {
        int i;
        GameImage[] gia = new GameImage[10];
        int count = 0;
        for (int i2 = 0; i2 < gia.length; ++i2) {
            gia[i2] = GameImage.getImage(String.valueOf(String.valueOf(name)).concat(String.valueOf(String.valueOf(i2))));
            if (gia[i2] == null) {
                i2 = gia.length;
                continue;
            }
            ++count;
        }
        GameImage[] giaRet = new GameImage[count > 2 && aniRev ? (count << 1) - 2 : count];
        for (i = 0; i < count; ++i) {
            giaRet[i] = gia[i];
        }
        i = count;
        int ii = 0;
        while (i < giaRet.length) {
            giaRet[i] = gia[count - ii - 1];
            ++i;
            ++ii;
        }
        return giaRet;
    }

    private static void drawGame(Graphics g) {
        ++aniStep;
        if (backGroundTile != null && currGameState != 0 && currGameState != 1) {
            g.drawImage(backGroundTile, 0, 0, 0);
        }
        block0 : switch (currGameState) {
            case 0: 
            case 1: {
                break;
            }
            case 7: {
                g.setClip(fldGameXPos, fldGameYPos, fld[0].length * Tetris.box.width, fld.length * Tetris.box.height);
                g.drawImage(imgGirl, imgGirlXPos, imgGirlYPos, 0);
                g.setClip(0, 0, ScreenCanvas.width, ScreenCanvas.height);
                int tmpFont = (System.currentTimeMillis() & (long)512) > (long)256 ? 0 : 1;
                Z.drawString(tmpFont, Z.getProperty("strNext"), ScreenCanvas.width - 2, ScreenCanvas.height, 40);
                ScreenCanvas.setPointRect(1, ScreenCanvas.width - 2 - Z.stringWidth(1, Z.getProperty("strNext")), ScreenCanvas.height - Z.stringHeight(1), Z.stringWidth(1, Z.getProperty("strNext")), Z.stringHeight(1));
                break;
            }
            case 2: {
                int tmpFont;
                Tetris.drawFields(g);
                Tetris.drawNextShape(g);
                if (currShape != null) {
                    int xTShape = currShapeX * Tetris.box.width + fldGameXPos;
                    int yTShape = currShapeY * Tetris.box.height + Tetris.toInt(Tetris.div(currShapeYS * Tetris.box.height, maxShapeHeight)) + fldGameYPos;
                    if (currShapeType != 2) {
                        int j = 0;
                        int jj = yTShape;
                        while (j < currShape.length) {
                            int i = 0;
                            int ii = xTShape;
                            while (i < currShape[0].length) {
                                if (currShape[j][i]) {
                                    if (currShapeType == 0) {
                                        g.setClip(ii, jj, Tetris.box.width, Tetris.box.height);
                                        if (currShapeY + j < -1) {
                                            box.draw(g, ii, jj);
                                        } else if (currShapeY + j > -1) {
                                            g.drawImage(imgGirl, imgGirlXPos, imgGirlYPos, 0);
                                            freeBox.draw(g, ii, jj);
                                        } else {
                                            box.draw(g, ii, jj);
                                            g.setClip(ii, fldGameYPos, Tetris.box.width, jj + Tetris.box.height - fldGameYPos);
                                            g.drawImage(imgGirl, imgGirlXPos, imgGirlYPos, 0);
                                            freeBox.draw(g, ii, jj);
                                        }
                                    }
                                    if (currShapeType == 1) {
                                        int tmpx = Tetris.toInt(Tetris.sinA((jj << 8) / Tetris.box.height % 360) * (Tetris.box.width >> 2));
                                        if (aniStep >= liquidBox.length) {
                                            aniStep = 0;
                                        }
                                        liquidBox[aniStep].draw(g, ii + tmpx, jj);
                                    }
                                }
                                ++i;
                                ii += Tetris.box.width;
                            }
                            ++j;
                            jj += Tetris.box.height;
                        }
                        g.setClip(0, 0, ScreenCanvas.width, ScreenCanvas.height);
                    } else {
                        if (aniStep >= bonusBox[bonusType].length) {
                            aniStep = 0;
                        }
                        xTShape = bonusType == 2 ? (xTShape += (Tetris.box.width << 1) - Tetris.bonusBox[Tetris.bonusType][Tetris.aniStep].width >> 1) : (xTShape += Tetris.box.width - Tetris.bonusBox[Tetris.bonusType][Tetris.aniStep].width >> 1);
                        bonusBox[bonusType][aniStep].draw(g, xTShape, yTShape += (Tetris.box.height << 1) - Tetris.bonusBox[Tetris.bonusType][0].height);
                    }
                    ScreenCanvas.setPointRect(2, 0, 0, xTShape, ScreenCanvas.height);
                    ScreenCanvas.setPointRect(3, xTShape + currShape[0].length * Tetris.box.width, 0, ScreenCanvas.width, ScreenCanvas.height);
                    ScreenCanvas.setPointRect(4, xTShape, 0, currShape[0].length * Tetris.box.width, yTShape + currShape.length * Tetris.box.height);
                    ScreenCanvas.setPointRect(5, xTShape, yTShape + currShape.length * Tetris.box.height, currShape[0].length * Tetris.box.width, ScreenCanvas.height);
                } else {
                    ScreenCanvas.clearPointRect(2);
                    ScreenCanvas.clearPointRect(3);
                    ScreenCanvas.clearPointRect(4);
                    ScreenCanvas.clearPointRect(5);
                }
                int n = tmpFont = (System.currentTimeMillis() & (long)512) > (long)256 || currFieldRate < AREA_FOR_LEVELS[currLevel % AREA_FOR_LEVELS.length] ? 0 : 1;
                if (ScreenCanvas.width <= 132) {
                    Z.drawString(tmpFont, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Z.getProperty("strAREA")))).append("").append(currFieldRate).append("%"))), 0, 0, 0);
                    Z.drawString(0, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Z.getProperty("strSCORE")))).append("").append(currScore))), 0, Z.stringHeight(0), 0);
                } else {
                    Z.drawString(tmpFont, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Z.getProperty("strAREA")))).append("").append(currFieldRate).append("%"))), 0, 5, 0);
                    Z.drawString(0, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Z.getProperty("strSCORE")))).append("").append(currScore))), ScreenCanvas.width - 1, 5, 8);
                }
                if (currShapeType == 2) {
                    tmpFont = (System.currentTimeMillis() & (long)512) > (long)256 ? 0 : 1;
                    Z.drawString(tmpFont, Z.getProperty("strBonCancel"), ScreenCanvas.width - 2, ScreenCanvas.height, 40);
                    ScreenCanvas.setPointRect(1, ScreenCanvas.width - 2 - Z.stringWidth(1, Z.getProperty("strBonCancel")), ScreenCanvas.height - Z.stringHeight(1), Z.stringWidth(1, Z.getProperty("strBonCancel")), Z.stringHeight(1));
                    break;
                }
                ScreenCanvas.clearPointRect(1);
                break;
            }
            case 3: {
                Tetris.drawFields(g);
                Tetris.drawNextShape(g);
                for (int t = liquidProcessData.length - 1; t >= 0; --t) {
                    int x = liquidProcessData[t][0] * Tetris.box.width + Tetris.toInt(Tetris.div(currShapeYS * Tetris.box.height, maxShapeHeight)) * Tetris.xsDir(liquidProcessData[t][2]) + fldGameXPos;
                    int y = liquidProcessData[t][1] * Tetris.box.height + Tetris.toInt(Tetris.div(currShapeYS * Tetris.box.height, maxShapeHeight)) * Tetris.ysDir(liquidProcessData[t][2]) + fldGameYPos;
                    g.setClip(x, y, Tetris.box.width, Tetris.box.height);
                    g.drawImage(imgGirl, imgGirlXPos, imgGirlYPos, 0);
                    freeBox.draw(g, x, y);
                }
                g.setClip(0, 0, ScreenCanvas.width, ScreenCanvas.height);
                break;
            }
            case 4: {
                Tetris.drawFields(g);
                int tmpY = imgGirlYPos + (imgGirl.getHeight() >> 1) - 2 * (Z.stringHeight(0) + 2);
                int tmpX = ScreenCanvas.width >> 1;
                int tmpBonusScore = currFieldRate * currScore / 100 << (currFieldRate == 100 ? 1 : 0);
                int tmpTotalScore = allScore + currScore + currFieldRate * currScore / 100 << (currFieldRate == 100 ? 1 : 0);
                Z.drawString(1, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Z.getProperty("resultScore")))).append(" ").append(currScore))), tmpX, tmpY, 1);
                Z.drawString(1, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Z.getProperty("resultArea")))).append(" ").append(currFieldRate).append("%"))), tmpX, tmpY += Z.stringHeight(0) + 2, 1);
                Z.drawString(1, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Z.getProperty("resultBonus")))).append(" ").append(tmpBonusScore))), tmpX, tmpY += Z.stringHeight(0) + 2, 1);
                Z.drawString(1, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Z.getProperty("resultTotal")))).append(" ").append(tmpTotalScore))), tmpX, tmpY += Z.stringHeight(0) + 2, 1);
                tmpY += Z.stringHeight(0) + 2;
                int tmpFont = (System.currentTimeMillis() & (long)512) > (long)256 ? 0 : 1;
                Z.drawString(tmpFont, Z.getProperty("strNext"), ScreenCanvas.width - 2, ScreenCanvas.height, 40);
                ScreenCanvas.setPointRect(1, ScreenCanvas.width - 2 - Z.stringWidth(1, Z.getProperty("strNext")), ScreenCanvas.height - Z.stringHeight(1), Z.stringWidth(1, Z.getProperty("strNext")), Z.stringHeight(1));
                break;
            }
            case 6: {
                Tetris.drawFields(g);
                Z.drawString(0, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Z.getProperty("strAREA")))).append(" ").append(currFieldRate).append("%"))), 5, 3, 0);
                Z.drawString(0, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Z.getProperty("strSCORE")))).append(" ").append(currScore))), ScreenCanvas.width - 5, 3, 8);
                Tetris.drawNextShape(g);
                switch (bonusType) {
                    case 0: {
                        if (zigzagState == 0) break block0;
                        int jj = currShapeY * Tetris.box.height + fldGameYPos;
                        int i = 0;
                        int ii = fldGameXPos;
                        while (i < zigzagLine.length) {
                            if (zigzagLine[i]) {
                                zigzagBox.draw(g, ii, jj);
                            }
                            ++i;
                            ii += Tetris.box.width;
                        }
                        break block0;
                    }
                    case 1: {
                        if (zigzagState == 0) break block0;
                        int jj = currShapeY * Tetris.box.height + fldGameYPos;
                        int i = 0;
                        int ii = fldGameXPos;
                        while (i < zigzagLine.length) {
                            if (zigzagLine[i]) {
                                zigzagBox.draw(g, ii, jj);
                            }
                            ++i;
                            ii += Tetris.box.width;
                        }
                        break block0;
                    }
                    case 2: {
                        int xTShape = currShapeX * Tetris.box.width + fldGameXPos;
                        int yTShape = currShapeY * Tetris.box.height + fldGameYPos;
                        g.setClip(xTShape, yTShape + (Tetris.box.height << 1), Tetris.box.width << 1, Tetris.toInt(Tetris.div(currShapeYS * Tetris.box.height, maxShapeHeight)));
                        g.drawImage(imgGirl, imgGirlXPos, imgGirlYPos, 0);
                        g.setClip(0, 0, ScreenCanvas.width, ScreenCanvas.height);
                        if (aniStep >= starsEffect.length) {
                            aniStep = 0;
                        }
                        bonusBox[bonusType][0].draw(g, xTShape + ((Tetris.box.width << 1) - Tetris.bonusBox[Tetris.bonusType][0].width >> 1), yTShape + ((Tetris.box.height << 1) - Tetris.bonusBox[Tetris.bonusType][0].height));
                        starsEffect[aniStep].draw(g, xTShape + ((Tetris.box.width << 1) - Tetris.starsEffect[Tetris.aniStep].width >> 1), yTShape + ((Tetris.box.height << 1) - Tetris.starsEffect[0].height) + Tetris.toInt(Tetris.div(currShapeYS * Tetris.box.height, maxShapeHeight)));
                        break block0;
                    }
                    case 3: {
                        int yTShape;
                        int xTShape;
                        if (sprayState == 0) {
                            xTShape = currShapeX * Tetris.box.width + fldGameXPos;
                            yTShape = currShapeY * Tetris.box.height + fldGameYPos;
                            explEffect[aniSpray].draw(g, xTShape + (Tetris.box.width - Tetris.explEffect[Tetris.aniSpray].width >> 1), Tetris.box.height + yTShape + (Tetris.box.height - Tetris.explEffect[Tetris.aniSpray].height));
                        }
                        if (sprayState == 1) {
                            xTShape = currShapeX * Tetris.box.width + fldGameXPos;
                            yTShape = currShapeY * Tetris.box.height + fldGameYPos;
                            if (aniStep >= starsEffect.length) {
                                aniStep = 0;
                            }
                            starsEffect[aniStep].draw(g, xTShape + (Tetris.box.width - Tetris.starsEffect[Tetris.aniStep].width >> 1), yTShape + ((Tetris.box.height << 1) - Tetris.starsEffect[0].height) + Tetris.toInt(Tetris.div(currShapeYS * Tetris.box.height, maxShapeHeight)));
                        }
                        if (sprayState != 2) break block0;
                        int j = 0;
                        int jj = fldGameYPos;
                        while (j < fld.length) {
                            int i = 0;
                            int ii = fldGameXPos;
                            while (i < fld[0].length) {
                                if (currShape[j][i]) {
                                    explEffect[aniStep].draw(g, ii + (Tetris.box.width - Tetris.explEffect[Tetris.aniStep].width >> 1), jj + (Tetris.box.height - Tetris.explEffect[Tetris.aniStep].height >> 1));
                                }
                                ++i;
                                ii += Tetris.box.width;
                            }
                            ++j;
                            jj += Tetris.box.height;
                        }
                        break block0;
                    }
                    case 4: {
                        Tetris.drawJinKernel(g);
                        break block0;
                    }
                }
                break;
            }
        }
        Z.drawString(1, Z.getProperty("strMenu"), 2, ScreenCanvas.height, 36);
        ScreenCanvas.setPointRect(0, 4, ScreenCanvas.height - Z.stringHeight(1), Z.stringWidth(1, Z.getProperty("strMenu")), Z.stringHeight(1));
    }

    private static void drawFields(Graphics g) {
        boolean bFirst = false;
        int xFirst = 0;
        int xCount = 0;
        int j = 0;
        int jj = fldGameYPos;
        while (j < fld.length) {
            int i = 0;
            int ii = fldGameXPos;
            while (i < fld[0].length) {
                if (!bFirst) {
                    if (fld[j][i]) {
                        bFirst = true;
                        xFirst = ii;
                        xCount = Tetris.box.width;
                        if (i == fld[0].length - 1) {
                            bFirst = false;
                            g.setClip(xFirst, jj, xCount, Tetris.box.height);
                            g.drawImage(imgGirl, imgGirlXPos, imgGirlYPos, 0);
                        }
                    }
                } else {
                    if (fld[j][i]) {
                        xCount += Tetris.box.width;
                    }
                    if (!fld[j][i] || i == fld[0].length - 1) {
                        bFirst = false;
                        g.setClip(xFirst, jj, xCount, Tetris.box.height);
                        if (imgGirl != null) {
                            g.drawImage(imgGirl, imgGirlXPos, imgGirlYPos, 0);
                        }
                    }
                }
                ++i;
                ii += Tetris.box.width;
            }
            ++j;
            jj += Tetris.box.height;
        }
        g.setClip(0, 0, ScreenCanvas.width, ScreenCanvas.height);
    }

    private static void drawNextShape(Graphics g) {
        if (nextShape != null) {
            if (nextShapeType == 2) {
                int iconPosX = ScreenCanvas.width - fldGameYPos + (fldGameYPos - Tetris.bonusIcons[Tetris.bonusType].width >> 1);
                int iconPosY = fldGameYPos - Tetris.bonusIcons[Tetris.bonusType].height >> 1;
                bonusIcons[bonusType].draw(g, iconPosX, iconPosY);
            } else {
                int size = Tetris.box.width >> 1;
                int iconPosX = ScreenCanvas.width - fldGameYPos + (fldGameYPos - nextShape[0].length * size >> 1);
                int iconPosY = fldGameYPos - nextShape.length * size >> 1;
                int j = 0;
                int jj = iconPosY;
                while (j < nextShape.length) {
                    int i = 0;
                    int ii = iconPosX;
                    while (i < nextShape[0].length) {
                        if (nextShapeType == 0) {
                            g.setColor(0xFF00FF);
                        }
                        if (nextShapeType == 1) {
                            g.setColor(0xFFBB44);
                        }
                        if (nextShape[j][i]) {
                            g.fillRect(ii, jj, size, size);
                            g.setColor(0x555555);
                            g.drawRect(ii, jj, size, size);
                        }
                        ++i;
                        ii += size;
                    }
                    ++j;
                    jj += size;
                }
            }
        }
    }

    private static void processGame() {
        if (Z.KeyLeft) {
            toLeft = ++keyLeftDelay < 2 || keyLeftDelay > 4;
        } else {
            keyLeftDelay = 0;
            toLeft = false;
        }
        if (Z.KeyRight) {
            toRight = ++keyRightDelay < 2 || keyRightDelay > 4;
        } else {
            keyRightDelay = 0;
            toRight = false;
        }
        block0 : switch (currGameState) {
            case 0: 
            case 1: {
                Tetris.initGame();
                break;
            }
            case 7: {
                if (!Z.KeyFire && !Z.SoftRight) break;
                Z.clearKeys();
                currGameState = 1;
                currState = 15;
                break;
            }
            case 2: {
                int fldFill = 0;
                for (int i = 0; i < fld[0].length; ++i) {
                    if (!fld[0][i]) continue;
                    ++fldFill;
                }
                if (fldFill == fld[0].length) {
                    currGameState = 4;
                    ScreenCanvas.clearPointRect();
                    return;
                }
                if (currShape == null) {
                    if (nextShape != null) {
                        currShape = nextShape;
                        currShapeType = nextShapeType;
                    } else {
                        currShape = Tetris.getNewShape();
                        currShapeType = nextShapeType;
                    }
                    nextShape = Tetris.getNewShape();
                    currShapeX = initShapeXPos;
                    currShapeY = initShapeYPos - currShape.length;
                    currShapeYS = 0;
                }
                if (Z.KeyUp) {
                    Z.KeyUp = false;
                    boolean[][] currShapeRotate = Tetris.rotateShape(currShape, false);
                    if (Tetris.isCorrect(currShapeRotate, currShapeX, currShapeY)) {
                        currShape = currShapeRotate;
                    }
                }
                if (toLeft && (Tetris.isCorrect(currShape, currShapeX - 1, currShapeY + 1) && currShapeYS != 0 && Tetris.isCorrect(currShape, currShapeX - 1, currShapeY) || Tetris.isCorrect(currShape, currShapeX - 1, currShapeY) && currShapeYS == 0)) {
                    --currShapeX;
                }
                if (toRight && (Tetris.isCorrect(currShape, currShapeX + 1, currShapeY + 1) && currShapeYS != 0 && Tetris.isCorrect(currShape, currShapeX + 1, currShapeY) || Tetris.isCorrect(currShape, currShapeX + 1, currShapeY) && currShapeYS == 0)) {
                    ++currShapeX;
                }
                if (Z.KeyDown) {
                    Z.KeyDown = false;
                    currShapeYS = maxShapeHeight;
                    while (Tetris.isCorrect(currShape, currShapeX, currShapeY + 1)) {
                        ++currShapeY;
                    }
                    --currShapeY;
                }
                if (Z.SoftRight && currShapeType == 2) {
                    currShape = null;
                    return;
                }
                if (fGirlCanOpen) {
                    int j;
                    if (Z.KeyPound) {
                        currShape = null;
                        for (j = 0; j < fld.length; ++j) {
                            for (int i = 0; i < fld[0].length; ++i) {
                                Tetris.fld[j][i] = true;
                            }
                        }
                        Tetris.updateFieldRate();
                        return;
                    }
                    if (Z.KeyStar) {
                        currShape = null;
                        for (j = 0; j < fld.length; ++j) {
                            for (int i = 0; i < fld[0].length; ++i) {
                                Tetris.fld[j][i] = true;
                            }
                        }
                        Tetris.updateFieldRate();
                        currLevel += 4;
                        return;
                    }
                }
                if (!Tetris.isCorrect(currShape, currShapeX, currShapeY + 1)) {
                    if (currShapeType == 2) {
                        currShapeYS = 0;
                        currGameState = 6;
                        if (bonusType == 2) {
                            Tetris.playSound(sndBucket, false);
                        }
                        return;
                    }
                    currScore += Tetris.getShapeScore(currShape);
                    if (currShapeType == 1) {
                        currGameState = 3;
                        Tetris.playSound(sndDrop, false);
                        Tetris.initLiquidProcess(currShape, currShapeX, currShapeY);
                        return;
                    }
                    if (!Tetris.copyToFld(currShape, currShapeX, currShapeY)) {
                        currGameState = 4;
                        ScreenCanvas.clearPointRect();
                        Z.sleep(5L);
                    }
                    currShape = null;
                    Tetris.updateFieldRate();
                    Tetris.playSound(sndDrop, false);
                }
                if (currShape == null || (currShapeYS += currShapeYSAdd) < maxShapeHeight) break;
                ++currShapeY;
                currShapeYS -= maxShapeHeight;
                break;
            }
            case 3: {
                if ((currShapeYS += maxShapeHeight >> 2) < maxShapeHeight) break;
                currShapeYS = 0;
                for (int t = 0; t < liquidProcessData.length; ++t) {
                    int[] nArray = liquidProcessData[t];
                    nArray[0] = nArray[0] + Tetris.xsDir(liquidProcessData[t][2]);
                    int[] nArray2 = liquidProcessData[t];
                    nArray2[1] = nArray2[1] + Tetris.ysDir(liquidProcessData[t][2]);
                }
                if (!Tetris.liquidCanMove()) {
                    boolean bGameOver = false;
                    for (int t = 0; t < liquidProcessData.length; ++t) {
                        if (liquidProcessData[t][1] >= 0) {
                            Tetris.fld[Tetris.liquidProcessData[t][1]][Tetris.liquidProcessData[t][0]] = true;
                            continue;
                        }
                        bGameOver = true;
                    }
                    currShape = null;
                    Tetris.updateFieldRate();
                    if (bGameOver) {
                        currGameState = 4;
                        ScreenCanvas.clearPointRect();
                        return;
                    }
                    currGameState = 2;
                    break;
                }
                Tetris.playSound(sndLiquid, false);
                break;
            }
            case 4: {
                if (!Z.KeyFire && !Z.SoftRight) break;
                Z.clearKeys();
                if (currFieldRate <= AREA_FOR_LEVELS[currLevel % AREA_FOR_LEVELS.length]) {
                    currState = 4;
                    currGameState = 1;
                    currLevel = 0;
                    currScore = allScore + currScore + currFieldRate * currScore / 100 << (currFieldRate == 100 ? 1 : 0);
                    break;
                }
                allScore += currScore + currFieldRate * currScore / 100 << (currFieldRate == 100 ? 1 : 0);
                currGameState = 7;
                if (++currLevel % 5 != 0) break;
                SoundManager.play(sndWin, false);
                break;
            }
            case 5: {
                if (!Z.KeyFire) break;
                currState = 4;
                currGameState = 1;
                break;
            }
            case 6: {
                switch (bonusType) {
                    case 0: {
                        if (!Tetris.mainProcessZigzag(currShapeX, currShapeY, true)) break block0;
                        currGameState = 2;
                        currShape = null;
                        Tetris.updateFieldRate();
                        break block0;
                    }
                    case 1: {
                        if (!Tetris.mainProcessZigzag(currShapeX, currShapeY, false)) break block0;
                        currShape = null;
                        currGameState = 3;
                        Tetris.updateFieldRate();
                        if (currShapeY > 0) {
                            currShape = new boolean[currShapeY][fld[0].length];
                            for (int j = 0; j < currShapeY; ++j) {
                                for (int i = 0; i < fld[0].length; ++i) {
                                    Tetris.currShape[j][i] = fld[j][i];
                                    Tetris.fld[j][i] = false;
                                }
                                Tetris.initLiquidProcess(currShape, 0, 0);
                                currGameState = 3;
                            }
                            break block0;
                        }
                        currGameState = 2;
                        break block0;
                    }
                    case 2: {
                        if (currShapeYS == 0) {
                            if (currShapeY + 2 < fld.length) {
                                currShape = new boolean[fld.length - (currShapeY + 1)][2];
                                int j = 0;
                                for (int jj = currShapeY + 2; jj < fld.length; ++jj) {
                                    int i = 0;
                                    int ii = currShapeX;
                                    while (i < 2) {
                                        Tetris.currShape[j][i] = !fld[jj][ii];
                                        ++i;
                                        ++ii;
                                    }
                                    ++j;
                                }
                                currShapeYS += maxShapeHeight >> 2;
                                break block0;
                            }
                            currGameState = 2;
                            currShape = null;
                            break block0;
                        }
                        if (currShapeY + 2 + (currShapeYS += maxShapeHeight >> 2) / maxShapeHeight < fld.length) break block0;
                        int j = 0;
                        for (int jj = currShapeY + 2; jj < fld.length; ++jj) {
                            int i = 0;
                            int ii = currShapeX;
                            while (i < 2) {
                                if (currShape[j][i]) {
                                    Tetris.fld[jj][ii] = true;
                                }
                                ++i;
                                ++ii;
                            }
                            ++j;
                        }
                        currGameState = 2;
                        currShape = null;
                        break block0;
                    }
                    case 3: {
                        if (!Tetris.processBonusSpray()) break block0;
                        currGameState = 2;
                        currShape = null;
                        break block0;
                    }
                    case 4: {
                        if (!Tetris.processJin()) break block0;
                        currGameState = 2;
                        currShape = null;
                        break block0;
                    }
                }
                break;
            }
        }
    }

    private static int getShapeScore(boolean[][] b) {
        int iRet = 0;
        for (int j = 0; j < b.length; ++j) {
            for (int i = 0; i < b[0].length; ++i) {
                iRet += b[j][i] ? 1 + currDifficulty : 0;
            }
        }
        return iRet;
    }

    private static boolean[][] getNewShape() {
        Z.SoftRight = false;
        int tRnd = Math.abs(rnd.nextInt() % 100);
        boolean[][] tmp = null;
        if (tRnd < (currDifficulty == 0 ? 70 : (currDifficulty == 1 ? 80 : 90)) || currShapeType != 0) {
            tmp = new boolean[3][3];
            int tParam = Math.abs(rnd.nextInt() % (currDifficulty == 0 ? 10 : SHAPE_DATA_COMMON.length));
            int tPos = 0;
            for (int j = 0; j < 3; ++j) {
                for (int i = 0; i < 3; ++i) {
                    tmp[j][i] = SHAPE_DATA_COMMON[tParam].charAt(tPos) == '1';
                    ++tPos;
                }
            }
            nextShapeType = 0;
        } else if (tRnd < (currDifficulty < 2 ? 90 : 95)) {
            tRnd = Math.abs(rnd.nextInt() % 100);
            if ((tRnd & 3) == 0) {
                tmp = new boolean[5][5];
                int tPos = 0;
                for (int j = 0; j < 5; ++j) {
                    for (int i = 0; i < 5; ++i) {
                        tmp[j][i] = SHAPE_DATA_LIQUID[0].charAt(tPos) == '1';
                        ++tPos;
                    }
                }
            } else if ((tRnd & 3) == 1) {
                tmp = new boolean[4][4];
                int tPos = 0;
                for (int j = 0; j < 4; ++j) {
                    for (int i = 0; i < 4; ++i) {
                        tmp[j][i] = SHAPE_DATA_LIQUID[1].charAt(tPos) == '1';
                        ++tPos;
                    }
                }
            } else {
                tmp = new boolean[3][3];
                int tPos = 0;
                for (int j = 0; j < 3; ++j) {
                    for (int i = 0; i < 3; ++i) {
                        tmp[j][i] = SHAPE_DATA_LIQUID[2].charAt(tPos) == '1';
                        ++tPos;
                    }
                }
            }
            nextShapeType = 1;
        } else {
            bonusType = Math.abs(rnd.nextInt()) % (currScore < 70 * maxScore / 100 ? 4 : 5);
            if (bonusType == 2) {
                tmp = new boolean[2][2];
                tmp[0][0] = true;
                tmp[0][1] = true;
                tmp[1][0] = true;
                tmp[1][1] = true;
            } else {
                tmp = new boolean[2][1];
                tmp[0][0] = true;
                tmp[1][0] = true;
            }
            nextShapeType = 2;
        }
        return nextShapeType == 2 ? tmp : Tetris.cropShape(tmp);
    }

    private static boolean[][] rotateShape(boolean[][] b, boolean CW) {
        boolean[][] tmp = new boolean[b[0].length][b.length];
        if (!CW) {
            for (int j = 0; j < b.length; ++j) {
                for (int i = 0; i < b[0].length; ++i) {
                    tmp[b[0].length - 1 - i][j] = b[j][i];
                }
            }
        } else {
            for (int j = 0; j < b.length; ++j) {
                for (int i = 0; i < b[0].length; ++i) {
                    tmp[i][b.length - 1 - j] = b[j][i];
                }
            }
        }
        return tmp;
    }

    private static boolean[][] cropShape(boolean[][] b) {
        int minX = 1;
        int maxX = 1;
        int minY = 1;
        int maxY = 1;
        for (int j = 0; j < b.length; ++j) {
            for (int i = 0; i < b[0].length; ++i) {
                if (!b[j][i]) continue;
                if (minX > i) {
                    minX = i;
                }
                if (minY > j) {
                    minY = j;
                }
                if (maxX < i) {
                    maxX = i;
                }
                if (maxY >= j) continue;
                maxY = j;
            }
        }
        int dX = maxX - minX;
        int dY = maxY - minY;
        int dXY = Math.abs(dY - dX);
        boolean[][] tmp = null;
        if (dXY < 2) {
            tmp = new boolean[dY + 1][dX + 1];
            int j = 0;
            int jj = minX;
            while (j < tmp.length) {
                int i = 0;
                int ii = minX;
                while (i < tmp[0].length) {
                    tmp[j][i] = b[jj][ii];
                    ++i;
                    ++ii;
                }
                ++j;
                ++jj;
            }
        }
        return tmp == null ? b : tmp;
    }

    private static boolean copyToFld(boolean[][] b, int x, int y) {
        boolean bRet = true;
        for (int j = 0; j < b.length; ++j) {
            for (int i = 0; i < b[0].length; ++i) {
                if (!b[j][i]) continue;
                if (j + y < 0) {
                    bRet = false;
                    continue;
                }
                Tetris.fld[j + y][i + x] = b[j][i];
            }
        }
        return bRet;
    }

    private static boolean isCorrect(boolean[][] b, int x, int y) {
        boolean bRet = true;
        for (int j = 0; j < b.length; ++j) {
            for (int i = 0; i < b[0].length; ++i) {
                if (!Tetris.getFromField(i + x, j + y) || !Tetris.getFromMask(b, i, j)) continue;
                return false;
            }
        }
        return bRet;
    }

    private static boolean getFromMask(boolean[][] b, int x, int y) {
        if (x < 0 || x >= b[0].length || y < 0 || y >= b.length) {
            return false;
        }
        return b[y][x];
    }

    private static boolean getFromField(int x, int y) {
        if (x < 0 || x >= fld[0].length || y >= fld.length) {
            return true;
        }
        if (y < 0) {
            return false;
        }
        return fld[y][x];
    }

    private static boolean getFromField(boolean[][] b, int x, int y) {
        if (x < 0 || x >= b[0].length || y >= b.length) {
            return true;
        }
        if (y < 0) {
            return false;
        }
        return b[y][x];
    }

    private static boolean getFromShape(boolean[][] b, int x, int y) {
        if (x < 0 || x >= b[0].length || y >= b.length || y < 0) {
            return false;
        }
        return b[y][x];
    }

    private static void updateFieldRate() {
        int allBlocks = fld.length * fld[0].length;
        int busyBlocks = 0;
        for (int j = 0; j < fld.length; ++j) {
            for (int i = 0; i < fld[0].length; ++i) {
                if (!fld[j][i]) continue;
                ++busyBlocks;
            }
        }
        currFieldRate = busyBlocks * 100 / allBlocks;
    }

    private static void initLiquidProcess(boolean[][] b, int x, int y) {
        int liqDataLength = 0;
        for (int j = 0; j < b.length; ++j) {
            for (int i = 0; i < b[0].length; ++i) {
                if (!b[j][i]) continue;
                ++liqDataLength;
            }
        }
        liquidProcessData = new int[liqDataLength][3];
        int currLiq = 0;
        for (int j = 0; j < b.length; ++j) {
            for (int i = 0; i < b[0].length; ++i) {
                if (!b[j][i]) continue;
                Tetris.liquidProcessData[currLiq][0] = x + i;
                Tetris.liquidProcessData[currLiq][1] = y + j;
                Tetris.liquidProcessData[currLiq][2] = 4;
                ++currLiq;
            }
        }
        Tetris.liquidCanMove();
    }

    private static boolean liquidCanMove() {
        int t;
        boolean bRet = false;
        boolean[][] tmpFld = new boolean[fld.length][fld[0].length];
        for (int j = 0; j < fld.length; ++j) {
            for (int i = 0; i < fld[0].length; ++i) {
                tmpFld[j][i] = fld[j][i];
            }
        }
        for (t = liquidProcessData.length - 1; t >= 0; --t) {
            if (liquidProcessData[t][1] < 0) continue;
            tmpFld[Tetris.liquidProcessData[t][1]][Tetris.liquidProcessData[t][0]] = true;
        }
        for (t = liquidProcessData.length - 1; t >= 0; --t) {
            boolean tr;
            if (liquidProcessData[t][2] < 0) {
                Tetris.liquidProcessData[t][2] = 4;
            } else if (liquidProcessData[t][2] < 4) {
                int[] nArray = liquidProcessData[t];
                nArray[2] = nArray[2] + 1;
            } else if (liquidProcessData[t][2] > 4) {
                int[] nArray = liquidProcessData[t];
                nArray[2] = nArray[2] - 1;
            }
            boolean bExit = false;
            if (liquidProcessData[t][1] >= 0) {
                tmpFld[Tetris.liquidProcessData[t][1]][Tetris.liquidProcessData[t][0]] = false;
            }
            int x = liquidProcessData[t][0];
            int y = liquidProcessData[t][1];
            int d = liquidProcessData[t][2] < 0 ? 4 : liquidProcessData[t][2];
            int xs = Tetris.xsDir(d);
            int ys = Tetris.ysDir(d);
            if (!bExit && !Tetris.getFromField(tmpFld, x + xs, y + ys)) {
                if (y + ys > 0) {
                    tmpFld[y + ys][x + xs] = true;
                }
                bExit = true;
                bRet = true;
            }
            if (!bExit & liquidProcessData[t][2] == -1) {
                bExit = true;
            }
            boolean bl = tr = (rnd.nextInt() & 0x10) != 0;
            if (!bExit && !Tetris.getFromField(tmpFld, x + (xs = Tetris.xsDir(tr ? Tetris.addDir(d) : Tetris.decDir(d))), y + (ys = Tetris.ysDir(tr ? Tetris.addDir(d) : Tetris.decDir(d))))) {
                int n = Tetris.liquidProcessData[t][2] = tr ? Tetris.addDir(d) : Tetris.decDir(d);
                if (y + ys > 0) {
                    tmpFld[y + ys][x + xs] = true;
                }
                bExit = true;
                bRet = true;
            }
            if (!bExit && !Tetris.getFromField(tmpFld, x + (xs = Tetris.xsDir(!tr ? Tetris.addDir(d) : Tetris.decDir(d))), y + (ys = Tetris.ysDir(!tr ? Tetris.addDir(d) : Tetris.decDir(d))))) {
                int n = Tetris.liquidProcessData[t][2] = !tr ? Tetris.addDir(d) : Tetris.decDir(d);
                if (y + ys > 0) {
                    tmpFld[y + ys][x + xs] = true;
                }
                bExit = true;
                bRet = true;
            }
            if (bExit) continue;
            Tetris.liquidProcessData[t][2] = -1;
            if (liquidProcessData[t][1] < 0) continue;
            tmpFld[Tetris.liquidProcessData[t][1]][Tetris.liquidProcessData[t][0]] = true;
        }
        return bRet;
    }

    private static int addDir(int dir) {
        return dir + 1 > 6 ? 5 : dir + 1;
    }

    private static int decDir(int dir) {
        return dir - 1 < 2 ? 3 : dir - 1;
    }

    private static int xsDir(int dir) {
        int xRet = 0;
        switch (dir) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                xRet = 1;
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                xRet = -1;
            }
        }
        return xRet;
    }

    private static int ysDir(int dir) {
        int yRet = 0;
        switch (dir) {
            case 0: 
            case 1: 
            case 7: {
                yRet = -1;
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                yRet = 1;
                break;
            }
        }
        return yRet;
    }

    private static boolean mainProcessZigzag(int x, int y, boolean fillFld) {
        boolean bRet = false;
        switch (zigzagState) {
            case 0: {
                zigzagState = 1;
                zigzagLine = new boolean[fld[0].length];
                Tetris.playSound(sndRolLastic, false);
                break;
            }
            case 1: {
                if (!Tetris.processZigzag(x, y, fillFld, false)) break;
                zigzagState = 2;
                break;
            }
            case 2: {
                bRet = Tetris.processZigzag(x, y, fillFld, true);
                if (!bRet) break;
                zigzagState = 0;
                zigzagLine = null;
                Z.sleep(10L);
            }
        }
        return bRet;
    }

    private static boolean processZigzag(int x, int y, boolean fillFld, boolean endState) {
        boolean bRet = true;
        if (zigzagLine[x] == endState) {
            boolean bl = Tetris.zigzagLine[x] = !endState;
            if (endState) {
                if (y >= 0) {
                    Tetris.fld[y][x] = fillFld;
                }
                if (y + 1 >= 0) {
                    Tetris.fld[y + 1][x] = fillFld;
                }
            }
            bRet = false;
        } else {
            int i;
            boolean bExit = false;
            for (i = x - 1; i >= 0 && !bExit; --i) {
                if (i < 0 || zigzagLine[i] != endState || zigzagLine[i + 1] == endState) continue;
                Tetris.fillZigzagLine(x, y, fillFld, endState, i);
                bRet = false;
                bExit = true;
            }
            bExit = false;
            for (i = x; i < zigzagLine.length && !bExit; ++i) {
                if (i >= zigzagLine.length || zigzagLine[i] != endState || zigzagLine[i - 1] == endState) continue;
                Tetris.fillZigzagLine(x, y, fillFld, endState, i);
                bRet = false;
                bExit = true;
            }
        }
        return bRet;
    }

    private static void fillZigzagLine(int x, int y, boolean fillFld, boolean endState, int i) {
        boolean bl = Tetris.zigzagLine[i] = !endState;
        if (endState) {
            if (y >= 0) {
                Tetris.fld[y][i] = fillFld;
            }
            if (y + 1 >= 0) {
                Tetris.fld[y + 1][i] = fillFld;
            }
        }
    }

    private static boolean processBonusSpray() {
        switch (sprayState) {
            case 0: {
                if (++aniSpray >= explEffect.length) {
                    if (currShapeY + 2 >= fld.length) {
                        aniSpray = 0;
                        return true;
                    }
                    aniStep = -1;
                    currShapeYS = 0;
                    sprayState = 1;
                    aniSpray = 0;
                }
                Tetris.playSound(sndSpray, false);
                break;
            }
            case 1: {
                if ((currShapeYS += maxShapeHeight >> 2) <= 0) break;
                int tmpY = currShapeY + 2 + currShapeYS / maxShapeHeight;
                if (tmpY >= fld.length) {
                    currShapeYS = 0;
                    sprayState = 0;
                    return true;
                }
                if (fld[tmpY][currShapeX] || !Tetris.checkFldForBonusSpray(tmpY)) break;
                currShapeYS = 0;
                currShape = new boolean[fld.length][fld[0].length];
                Tetris.currShape[tmpY][Tetris.currShapeX] = true;
                sprayState = 2;
                aniStep = -1;
                break;
            }
            case 2: {
                if (aniStep + 1 >= explEffect.length >> 1) {
                    for (int j = 0; j < currShape.length; ++j) {
                        for (int i = 0; i < currShape[0].length; ++i) {
                            boolean[] blArray = fld[j];
                            int n = i;
                            blArray[n] = blArray[n] | currShape[j][i];
                        }
                    }
                }
                if (aniStep + 1 < explEffect.length) break;
                aniStep = -1;
                boolean[][] tmpShape = new boolean[fld.length][fld[0].length];
                boolean newShapeIsFree = true;
                for (int j = 0; j < currShape.length; ++j) {
                    for (int i = 0; i < currShape[0].length; ++i) {
                        if (fld[j][i] || !Tetris.getFromShape(currShape, i - 1, j) && !Tetris.getFromShape(currShape, i + 1, j) && !Tetris.getFromShape(currShape, i, j - 1) && !Tetris.getFromShape(currShape, i, j + 1)) continue;
                        newShapeIsFree = false;
                        tmpShape[j][i] = true;
                    }
                }
                if (newShapeIsFree) {
                    currShapeYS = 0;
                    sprayState = 0;
                    return true;
                }
                currShape = tmpShape;
                break;
            }
        }
        return false;
    }

    private static boolean checkFldForBonusSpray(int tmpY) {
        boolean[][] tmpShape = new boolean[fld.length][fld[0].length];
        tmpShape[tmpY][Tetris.currShapeX] = true;
        boolean checkExit = false;
        while (!checkExit) {
            checkExit = true;
            for (int j = 0; j < tmpShape.length; ++j) {
                for (int i = 0; i < tmpShape[0].length; ++i) {
                    if (fld[j][i] || Tetris.getFromShape(tmpShape, i, j) || !Tetris.getFromShape(tmpShape, i - 1, j) && !Tetris.getFromShape(tmpShape, i + 1, j) && !Tetris.getFromShape(tmpShape, i, j - 1) && !Tetris.getFromShape(tmpShape, i, j + 1)) continue;
                    tmpShape[j][i] = true;
                    if (i == currShapeX && j == currShapeY) {
                        return false;
                    }
                    checkExit = false;
                }
            }
        }
        for (int i = 0; i < tmpShape[0].length; ++i) {
            if (!tmpShape[0][i]) continue;
            return false;
        }
        return true;
    }

    private static boolean processJin() {
        switch (jinState) {
            case 0: {
                jinX = fldGameXPos + currShapeX * Tetris.box.width + (Tetris.box.width >> 1);
                jinY = fldGameYPos + (currShapeY + 1) * Tetris.box.height + (Tetris.box.height >> 1);
                jinStep = 0;
                int sum = 0;
                for (int i = 0; i < 25; ++i) {
                    sum += i + 1;
                }
                int h = currShapeY + 3;
                int speed = Tetris.intToFP(1);
                speedKernelFly = Tetris.div(Tetris.mul(Tetris.intToFP(25), speed) - Tetris.intToFP(h >> 1), Tetris.intToFP(sum));
                jinArrayKernel = new int[fld[0].length >> 2][5];
                int sxAdd = Tetris.div(fld[0].length, fld.length << 2) / jinArrayKernel.length;
                int sxMax = sxAdd * (jinArrayKernel.length - 1);
                int j = 0;
                int xs = -sxMax;
                while (j < jinArrayKernel.length) {
                    aniStep = 0;
                    Tetris.jinArrayKernel[j][0] = Tetris.intToFP(currShapeX) + (Tetris.intToFP(1) >> 1);
                    Tetris.jinArrayKernel[j][1] = Tetris.intToFP(currShapeY + 1) + (Tetris.intToFP(1) >> 1);
                    Tetris.jinArrayKernel[j][2] = xs;
                    Tetris.jinArrayKernel[j][3] = -speed - Math.abs(rnd.nextInt() % 8191);
                    Tetris.jinArrayKernel[j][4] = 0;
                    ++j;
                    xs += sxAdd << 1;
                }
                jinFldKernel = new int[fld[0].length][];
                jinFldKernelInit = new boolean[fld[0].length];
                jinFldKernelActiveNum = 0;
                jinState = 1;
                Tetris.playSound(sndSpray, false);
                break;
            }
            case 1: {
                ++jinStep;
                if (!Tetris.processJinKernel()) break;
                Tetris.updateFieldRate();
                jinState = 0;
                return true;
            }
        }
        return false;
    }

    private static void drawJinKernel(Graphics g) {
        int j;
        if (aniStep < explEffect.length) {
            explEffect[aniStep].draw(g, jinX - (Tetris.explEffect[Tetris.aniStep].width >> 1), jinY - (Tetris.explEffect[Tetris.aniStep].height >> 1));
        }
        if (jinArrayKernel != null) {
            for (j = 0; j < jinArrayKernel.length; ++j) {
                if (jinArrayKernel[j] == null) continue;
                explEffect[jinArrayKernel[j][4] == 0 ? 0 : jinArrayKernel[j][2]].draw(g, fldGameXPos + Tetris.toInt(jinArrayKernel[j][0] * Tetris.box.width), fldGameYPos + Tetris.toInt(jinArrayKernel[j][1] * Tetris.box.height));
            }
        }
        if (jinFldKernel != null) {
            block5: for (j = 0; j < jinFldKernel.length; ++j) {
                if (jinFldKernel[j] == null) continue;
                switch (jinFldKernel[j][4]) {
                    case 0: 
                    case 1: {
                        int explXS = jinFldKernel[j][4] == 0 ? 0 : jinFldKernel[j][5];
                        explEffect[explXS].draw(g, fldGameXPos + Tetris.toInt(jinFldKernel[j][0] * Tetris.box.width) - Tetris.explEffect[explXS].width, fldGameYPos + Tetris.toInt(jinFldKernel[j][1] * Tetris.box.height) - Tetris.explEffect[explXS].height);
                        continue block5;
                    }
                    case 2: {
                        if (jinStep >= starsEffect.length) {
                            jinStep = 0;
                        }
                        starsEffect[jinStep].draw(g, fldGameXPos + jinFldKernel[j][0] * Tetris.box.width, fldGameYPos + jinFldKernel[j][1] * Tetris.box.height + (jinFldKernel[j][5] == 0 ? 0 : Tetris.box.height >> 1) - Tetris.starsEffect[Tetris.jinStep].height);
                        continue block5;
                    }
                    default: {
                        continue block5;
                    }
                }
            }
        }
    }

    private static boolean processJinKernel() {
        int j;
        int kernelsKilled = 0;
        int fldKernelsKilled = 0;
        if (jinArrayKernel != null) {
            for (j = 0; j < jinArrayKernel.length; ++j) {
                if (jinArrayKernel == null) continue;
                if (jinArrayKernel[j] != null) {
                    if (jinArrayKernel[j][4] == 0) {
                        int i;
                        int[] nArray = jinArrayKernel[j];
                        nArray[0] = nArray[0] + jinArrayKernel[j][2];
                        if (jinArrayKernel[j][0] < 0 || Tetris.toInt(jinArrayKernel[j][0]) >= fld[0].length) {
                            int[] nArray2 = jinArrayKernel[j];
                            nArray2[0] = nArray2[0] - jinArrayKernel[j][2];
                            Tetris.jinArrayKernel[j][2] = -jinArrayKernel[j][2];
                        }
                        int[] nArray3 = jinArrayKernel[j];
                        nArray3[1] = nArray3[1] + jinArrayKernel[j][3];
                        int[] nArray4 = jinArrayKernel[j];
                        nArray4[3] = nArray4[3] + speedKernelFly;
                        if (jinArrayKernel[j][3] <= 0 || Tetris.toInt(jinArrayKernel[j][1]) <= -3) continue;
                        Tetris.jinArrayKernel[j][4] = 1;
                        Tetris.jinArrayKernel[j][2] = 0;
                        Tetris.playSound(sndSpray, false);
                        int tmpCount = 0;
                        for (i = 0; i < jinArrayKernel.length; ++i) {
                            if (jinArrayKernel[i] == null || jinArrayKernel[i][4] != 0) continue;
                            ++tmpCount;
                        }
                        tmpCount = tmpCount > 0 ? fld[0].length / (fld[0].length >> 2) : fld[0].length - jinFldKernelActiveNum;
                        for (i = 0; i < jinFldKernelInit.length; ++i) {
                        }
                        for (i = 0; i < tmpCount; ++i) {
                            int tmpPos;
                            while (jinFldKernelInit[tmpPos = Math.abs(rnd.nextInt() % fld[0].length)]) {
                            }
                            Tetris.jinFldKernel[tmpPos] = new int[6];
                            Tetris.jinFldKernel[tmpPos][0] = jinArrayKernel[j][0];
                            Tetris.jinFldKernel[tmpPos][1] = jinArrayKernel[j][1];
                            Tetris.jinFldKernel[tmpPos][2] = Tetris.intToFP(tmpPos) + (Tetris.intToFP(1) >> 1);
                            Tetris.jinFldKernel[tmpPos][3] = -(Tetris.toInt(1) >> 1);
                            int xs = (jinFldKernel[tmpPos][2] - jinFldKernel[tmpPos][0]) / 10;
                            int ys = (jinFldKernel[tmpPos][3] - jinFldKernel[tmpPos][1]) / 10;
                            Tetris.jinFldKernel[tmpPos][2] = xs;
                            Tetris.jinFldKernel[tmpPos][3] = ys;
                            Tetris.jinFldKernel[tmpPos][4] = 0;
                            Tetris.jinFldKernel[tmpPos][5] = 0;
                            Tetris.jinFldKernelInit[tmpPos] = true;
                            ++jinFldKernelActiveNum;
                        }
                        continue;
                    }
                    int[] nArray = jinArrayKernel[j];
                    nArray[2] = nArray[2] + 1;
                    if (jinArrayKernel[j][2] < explEffect.length) continue;
                    Tetris.jinArrayKernel[j] = null;
                    continue;
                }
                ++kernelsKilled;
            }
            if (kernelsKilled == jinArrayKernel.length) {
                jinArrayKernel = null;
            }
        }
        block10: for (j = 0; j < jinFldKernel.length; ++j) {
            if (jinFldKernel[j] != null) {
                switch (jinFldKernel[j][4]) {
                    case 0: {
                        int[] nArray = jinFldKernel[j];
                        nArray[5] = nArray[5] + 1;
                        if (nArray[5] < 10) {
                            int[] nArray5 = jinFldKernel[j];
                            nArray5[0] = nArray5[0] + jinFldKernel[j][2];
                            int[] nArray6 = jinFldKernel[j];
                            nArray6[1] = nArray6[1] + jinFldKernel[j][3];
                            break;
                        }
                        Tetris.jinFldKernel[j][0] = Tetris.intToFP(j) + (Tetris.intToFP(1) >> 1);
                        Tetris.jinFldKernel[j][1] = 0;
                        Tetris.jinFldKernel[j][4] = 1;
                        Tetris.jinFldKernel[j][5] = 0;
                        break;
                    }
                    case 1: {
                        int[] nArray = jinFldKernel[j];
                        nArray[5] = nArray[5] + 1;
                        if (jinFldKernel[j][5] < explEffect.length) continue block10;
                        Tetris.jinFldKernel[j][0] = j;
                        Tetris.jinFldKernel[j][1] = 0;
                        Tetris.jinFldKernel[j][4] = 2;
                        Tetris.jinFldKernel[j][5] = 0;
                        break;
                    }
                    case 2: {
                        int[] nArray = jinFldKernel[j];
                        nArray[5] = nArray[5] + 1;
                        if (jinFldKernel[j][5] < 2) continue block10;
                        Tetris.fld[Tetris.jinFldKernel[j][1]][j] = true;
                        Tetris.jinFldKernel[j][5] = 0;
                        int[] nArray7 = jinFldKernel[j];
                        nArray7[1] = nArray7[1] + 1;
                        if (jinFldKernel[j][1] < fld.length) continue block10;
                        Tetris.jinFldKernel[j] = null;
                        ++fldKernelsKilled;
                    }
                }
                continue;
            }
            ++fldKernelsKilled;
        }
        return fldKernelsKilled == fld[0].length && jinFldKernelActiveNum == fld[0].length;
    }

    public static int sinA(int a) {
        if (a >= 0 & a < 90) {
            return trigValue[a];
        }
        if (a >= 90 & a < 180) {
            return trigValue[180 - a];
        }
        if (a >= 180 & a < 270) {
            return (int)((long)(-trigValue[a - 180]));
        }
        if (a >= 270 & a < 360) {
            return (int)((long)(-trigValue[360 - a]));
        }
        return 0;
    }

    public static int cosA(int a) {
        if (a >= 0 & a < 90) {
            return trigValue[90 - a];
        }
        if (a >= 90 & a < 180) {
            return (int)((long)(-trigValue[a - 90]));
        }
        if (a >= 180 & a < 270) {
            return (int)((long)(-trigValue[270 - a]));
        }
        if (a >= 270 & a < 360) {
            return trigValue[a - 270];
        }
        return 0;
    }

    public static int mul(int x, int y) {
        long z = (long)x * (long)y;
        return (int)(z >> 16);
    }

    public static int div(int x, int y) {
        long z = (long)x << 32;
        return (int)(z / (long)y >> 16);
    }

    public static int toInt(int x) {
        return x >> 16;
    }

    public static int intToFP(int x) {
        return x << 16;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean loadOptions() {
        void var0;
        block13: {
            boolean fRet = false;
            RecordStore myStore = null;
            try {
                myStore = RecordStore.openRecordStore((String)"config", (boolean)true);
                if (myStore.getNumRecords() != 0) {
                    DataInputStream dis = new DataInputStream(new ByteArrayInputStream(myStore.getRecord(1)));
                    currDifficulty = dis.read();
                    System.out.println("currDifficulty:".concat(String.valueOf(String.valueOf(currDifficulty))));
                    boolean sndDefault = dis.readBoolean();
                    System.out.println("loadOptions: sound==".concat(String.valueOf(String.valueOf(sndDefault))));
                    SoundManager.setSound(sndDefault);
                    GameMenu.strLastName = dis.readUTF();
                    currLevel = dis.readInt();
                    fContinue = currLevel != 0;
                    allScore = dis.readInt();
                    dis.close();
                    fRet = true;
                }
                if (myStore == null) break block13;
            }
            catch (Exception rse) {
                rse.printStackTrace();
                return (boolean)var0;
            }
            try {
                myStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
            myStore = null;
            Z.sleep(10L);
        }
        return (boolean)var0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveOptions() {
        block14: {
            RecordStore myStore = null;
            try {
                myStore = RecordStore.openRecordStore((String)"config", (boolean)true);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                dos.write(currDifficulty);
                dos.writeBoolean(SoundManager.SoundIsOn());
                dos.writeUTF(GameMenu.strLastName);
                dos.writeInt(currLevel);
                dos.writeInt(allScore);
                byte[] data = baos.toByteArray();
                if (myStore.getNumRecords() != 0) {
                    myStore.setRecord(1, data, 0, data.length);
                } else {
                    myStore.addRecord(data, 0, data.length);
                }
                dos.close();
                if (myStore == null) break block14;
            }
            catch (Exception rse) {
                rse.printStackTrace();
                return;
            }
            try {
                myStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
            myStore = null;
            Z.sleep(10L);
        }
    }

    static void cheat(int i) {
    }

    static void resume(boolean b) {
        if (currState == 1) {
            // empty if block
        }
        Z.clearKeys();
    }

    static void pause(boolean b) {
        if (currState == 3) {
            currState = 1;
            SoundManager.stop();
        }
        Z.clearKeys();
    }

    static {
        STATE_NONE = 0;
        STATE_MENU = 1;
        STATE_PLAY = 3;
        STATE_RESULT = 4;
        STATE_DRAW_SCORE = 5;
        STATE_ABORT_GAME = 6;
        STATE_LEVEL_MENU = 7;
        STATE_QUESTION_ABORT_GAME = 8;
        STATE_NEW_GAME = 9;
        STATE_PROGRESS_BACK = 10;
        STATE_SHOW_SPLASH = 12;
        STATE_DRAW_INFO = 13;
        STATE_ENTER_NAME = 14;
        STATE_INIT_BRIEFING = 15;
        STATE_BRIEFING = 16;
        STATE_QUEST_SMS = 17;
        STATE_SMS_UPLOAD_RESULT = 18;
        STATE_UPLOAD = 19;
        STATE_UPLOAD_BACK = 20;
        MENU_STATE_PLAY = 0;
        MENU_STATE_SOUND = 1;
        MENU_STATE_SCORE = 2;
        MENU_STATE_HELP = 3;
        MENU_STATE_ABOUT = 4;
        MENU_STATE_WAP = 5;
        MENU_STATE_EXIT = 6;
        MENU_STATE_CONTINUE = 7;
        fContinue = false;
        currState = 0;
        lastState = 0;
        resizeGraph = false;
        messGraphResize = false;
        sndMusic = 0;
        sndDrop = 1;
        sndRolLastic = 2;
        sndSpray = 3;
        sndBucket = 4;
        sndLiquid = 5;
        sndWin = 6;
        sndLevNext = 7;
        sndOver = 8;
        fDrawProgressBar = false;
        iCurrProgress = 0;
        cheat = new int[]{7, 2, 8, 5, 6};
        fGirlCanOpen = false;
        cheatPos = 0;
        SHAPE_DATA_COMMON = new String[]{"000111000", "010110000", "110011000", "011110000", "110110000", "000111001", "001111000", "010111000", "010111010", "101111000", "001111100", "100111001", "010010111"};
        SHAPE_DATA_LIQUID = new String[]{"0010001110111110111000100", "0110111111110110", "010111010"};
        AREA_FOR_LEVELS = new int[]{65, 70, 75, 80, 85, 65, 70, 75, 80, 85, 65, 70, 75, 80, 85, 65, 70, 75, 80, 85};
        SPEED_FOR_LEVELS = new int[]{16, 15, 14, 13, 12, 12, 11, 10, 9, 8, 8, 8, 7, 7, 6, 6, 6, 5, 5, 4};
        GAME_STATE_NONE = 0;
        GAME_STATE_REINIT = 1;
        GAME_STATE_PLAY = 2;
        GAME_STATE_LIQUID = 3;
        GAME_STATE_RESULT = 4;
        GAME_STATE_BRIEFING = 5;
        GAME_STATE_BONUS_PROC = 6;
        GAME_STATE_DRAWGIRL = 7;
        SHAPE_TYPE_COMMON = 0;
        SHAPE_TYPE_LIQUID = 1;
        SHAPE_TYPE_BONUS = 2;
        BONUS_TYPE_ROLLER = 0;
        BONUS_TYPE_LASTIC = 1;
        BONUS_TYPE_BUCKET = 2;
        BONUS_TYPE_SPRAY = 3;
        BONUS_TYPE_JIN = 4;
        currGameState = 0;
        backGroundTile = null;
        imgGirl = null;
        girlsCoords = null;
        imgGirlXPos = 0;
        imgGirlYPos = 0;
        fldGameXPos = 0;
        fldGameYPos = 0;
        initShapeXPos = 0;
        initShapeYPos = 0;
        fld = null;
        currShape = null;
        nextShape = null;
        currShapeX = 0;
        currShapeY = 0;
        currShapeYS = 0;
        currShapeYSAdd = 1;
        maxShapeHeight = 16;
        currShapeType = 0;
        nextShapeType = 0;
        aniStep = 0;
        currFieldRate = 0;
        currLevel = 0;
        currScore = 0;
        maxScore = 0;
        currDifficulty = 0;
        allScore = 0;
        liquidProcessData = null;
        bonusType = 0;
        keyLeftDelay = 0;
        keyRightDelay = 0;
        toLeft = false;
        toRight = false;
        ZIGZAG_STATE_NONE = 0;
        ZIGZAG_STATE_FILL = 1;
        ZIGZAG_STATE_CLEAR = 2;
        zigzagState = 0;
        SPRAY_STATE_NONE = 0;
        SPRAY_STATE_DOWN = 1;
        SPRAY_STATE_FILL = 2;
        sprayState = 0;
        aniSpray = 0;
        JIN_STATE_NONE = 0;
        JIN_STATE_MOVE = 1;
        jinState = 0;
        jinStep = 0;
        jinX = 0;
        jinY = 0;
        speedKernelFly = Tetris.div(1, 2);
        trigValue = new int[]{0, 1143, 2287, 3429, 4571, 5711, 6850, 7986, 9120, 10252, 11380, 12504, 13625, 14742, 15854, 16961, 18064, 19160, 20251, 21336, 22414, 23485, 24550, 25606, 26655, 27696, 28729, 29752, 30767, 31772, Short.MAX_VALUE, 33753, 34728, 35693, 36647, 37589, 38521, 39440, 40347, 41243, 42125, 42995, 43852, 44695, 45525, 46340, 47142, 47929, 48702, 49460, 50203, 50931, 51643, 52339, 53019, 53683, 54331, 54963, 55577, 56175, 56755, 57319, 57864, 58392, 58903, 59395, 59870, 60326, 60763, 61183, 61583, 61965, 62328, 62672, 62997, 63302, 63589, 63856, 64103, 64331, 64540, 64729, 64898, 65047, 65176, 65286, 65376, 65446, 65496, 65526, 65536};
    }
}

