/*
 * Decompiled with CFR 0.152.
 */
package com.mogames.gui;

import com.alsigames.animations.ComplexPicture;
import com.alsigames.font.FontManagerEx;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Tabs {
    Vector contents = new Vector();
    Vector contentsWidth = new Vector();
    int hSpace = 0;
    int direction = 0;
    int ActiveTab = 0;
    int SelectedTab = 0;
    public int tabShift;
    int xLastRight = this.tabShift = 5;
    ComplexPicture backCP = null;

    public Tabs(ComplexPicture cp, int hSpace) {
        this.backCP = cp;
        this.hSpace = hSpace;
    }

    public void addTab(int id, String str) {
        this.contents.addElement(new tab(id, str));
        int w = this.tabWidth(str, false, false);
        this.contentsWidth.addElement(new Integer(w));
        this.xLastRight += w - this.tabShift;
    }

    public void addTab(int id, Image img) {
        this.contents.addElement(new tab(id, img));
        int w = this.tabWidth(img, false, false);
        this.contentsWidth.addElement(new Integer(w));
        this.xLastRight += w - this.tabShift;
    }

    public void clear() {
        this.contents.removeAllElements();
        this.contentsWidth.removeAllElements();
        this.ActiveTab = 0;
        this.SelectedTab = 0;
        this.xLastRight = this.tabShift;
    }

    public int count() {
        return this.contents.size();
    }

    public int priorTab() {
        if (this.contents.size() > 0) {
            --this.SelectedTab;
            if (this.SelectedTab < 0) {
                this.SelectedTab = this.contents.size() - 1;
            }
        }
        return this.SelectedTab;
    }

    public int nextTab() {
        if (this.contents.size() > 0) {
            ++this.SelectedTab;
            if (this.SelectedTab >= this.contents.size()) {
                this.SelectedTab = 0;
            }
        }
        return this.SelectedTab;
    }

    public boolean activateTab() {
        if (this.SelectedTab != this.ActiveTab) {
            this.ActiveTab = this.SelectedTab;
            return true;
        }
        return false;
    }

    public boolean activateTab(int id) {
        if (this.contents.size() > 0) {
            for (int i = 0; i < this.contents.size(); ++i) {
                tab t = (tab)this.contents.elementAt(i);
                if (t.id != id) continue;
                this.ActiveTab = this.SelectedTab = i;
                return true;
            }
            return false;
        }
        return false;
    }

    public int getActiveTab() {
        return this.ActiveTab;
    }

    public int getActiveTabID() {
        tab t = (tab)this.contents.elementAt(this.ActiveTab);
        return t.id;
    }

    public void draw(Graphics g, int x, int y, int width) {
        if (this.contents == null) {
            return;
        }
        if (this.contents.size() == 0) {
            return;
        }
        int widthTillSelected = 0;
        int widthTillEnd = 0;
        int w = 0;
        int selTabWidth = (Integer)this.contentsWidth.elementAt(this.SelectedTab);
        for (int i = 0; i < this.contents.size(); ++i) {
            widthTillEnd += (Integer)this.contentsWidth.elementAt(i) - this.tabShift;
            if (i > this.SelectedTab) continue;
            widthTillSelected += (Integer)this.contentsWidth.elementAt(i) - this.tabShift;
        }
        if (this.xLastRight - widthTillEnd + widthTillSelected - selTabWidth < 0) {
            this.xLastRight = widthTillEnd - widthTillSelected + selTabWidth;
        } else if (this.xLastRight - widthTillEnd + widthTillSelected > width) {
            this.xLastRight = widthTillEnd - widthTillSelected + width;
        }
        int xOff = this.xLastRight + x;
        int xActive = x;
        int xSelected = x;
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            tab t = (tab)this.contents.elementAt(i);
            if (i == this.ActiveTab) {
                xActive = xOff;
            }
            if (i == this.SelectedTab) {
                xSelected = xOff;
            }
            if (t.isText) {
                w = this.tabWidth(t.text, false, false);
                if (xOff > x && xOff - w < x + width) {
                    this.drawTab(g, t.text, xOff - w, y, x, x + width, false, false);
                }
            } else {
                w = this.tabWidth(t.img, false, false);
                if (xOff > x && xOff - w < x + width) {
                    this.drawTab(g, t.img, xOff - w, y, x, x + width, false, false);
                }
            }
            xOff -= w - this.tabShift;
        }
        if (this.ActiveTab >= 0 && this.ActiveTab < this.contents.size()) {
            tab t = (tab)this.contents.elementAt(this.ActiveTab);
            if (t.isText) {
                w = this.tabWidth(t.text, true, false);
                if (xActive > x && xActive - w < x + width) {
                    this.drawTab(g, t.text, xActive - w, y, x, x + width, true, false);
                }
            } else {
                w = this.tabWidth(t.img, true, false);
                if (xActive > x && xActive - w < x + width) {
                    this.drawTab(g, t.img, xActive - w, y, x, x + width, true, false);
                }
            }
        }
        if (this.SelectedTab >= 0 && this.SelectedTab < this.contents.size() && this.SelectedTab != this.ActiveTab) {
            tab t = (tab)this.contents.elementAt(this.SelectedTab);
            if (t.isText) {
                w = this.tabWidth(t.text, false, true);
                if (xSelected > x && xSelected - w < x + width) {
                    this.drawTab(g, t.text, xSelected - w, y, x, x + width, false, true);
                }
            } else {
                w = this.tabWidth(t.img, false, true);
                if (xSelected > x && xSelected - w < x + width) {
                    this.drawTab(g, t.img, xSelected - w, y, x, x + width, false, true);
                }
            }
        }
    }

    public int drawTab(Graphics g, Image img, int x, int y, int minX, int maxX, boolean active, boolean selected) {
        int w = 0;
        int h = 0;
        if (selected) {
            w = active ? this.backCP.GetWidth(0) : this.backCP.GetWidth(6);
            h = active ? this.backCP.GetHeight(0) : this.backCP.GetHeight(6);
        } else {
            w = active ? this.backCP.GetWidth(0) : this.backCP.GetWidth(3);
            h = active ? this.backCP.GetHeight(0) : this.backCP.GetHeight(3);
        }
        int width = img.getWidth() + 2 * w / 3;
        this.drawTabBack(g, x, y, width, minX, maxX, active, selected);
        g.drawImage(img, x + w, y + h / 2, 6);
        return width + this.hSpace;
    }

    public int drawTab(Graphics g, String str, int x, int y, int minX, int maxX, boolean active, boolean selected) {
        int w = 0;
        int h = 0;
        if (selected) {
            w = active ? this.backCP.GetWidth(0) : this.backCP.GetWidth(6);
            h = active ? this.backCP.GetHeight(0) : this.backCP.GetHeight(6);
        } else {
            w = active ? this.backCP.GetWidth(0) : this.backCP.GetWidth(3);
            h = active ? this.backCP.GetHeight(0) : this.backCP.GetHeight(3);
        }
        int width = FontManagerEx.stringWidth(str) + 2 * w;
        this.drawTabBack(g, x, y, width, minX, maxX, active, selected);
        FontManagerEx.drawString(str, x + w, y + h / 2, 6);
        return width + this.hSpace;
    }

    private void drawTabBack(Graphics g, int x, int y, int width, int minX, int maxX, boolean active, boolean selected) {
        int fillW;
        int w = 0;
        int h = 0;
        int ind = 0;
        if (selected) {
            w = active ? this.backCP.GetWidth(0) : this.backCP.GetWidth(6);
            h = active ? this.backCP.GetHeight(0) : this.backCP.GetHeight(6);
            ind = active ? 0 : 6;
        } else {
            w = active ? this.backCP.GetWidth(0) : this.backCP.GetWidth(3);
            h = active ? this.backCP.GetHeight(0) : this.backCP.GetHeight(3);
            ind = active ? 0 : 3;
        }
        this.backCP.Draw(g, ind, x, y);
        int fillX = x + w;
        int fillR = x + width - w;
        if (minX > fillX) {
            fillX = minX;
        }
        if (fillR > maxX) {
            fillR = maxX;
        }
        if ((fillW = fillR - fillX) > 0) {
            this.backCP.FillWidthByFrame(g, ind + 2, fillX, y, fillW);
        }
        this.backCP.Draw(g, ind + 1, x + width, y, 24);
    }

    public int tabWidth(String title, boolean active, boolean selected) {
        int w = 0;
        int h = 0;
        if (selected) {
            w = active ? this.backCP.GetWidth(0) : this.backCP.GetWidth(6);
            h = active ? this.backCP.GetHeight(0) : this.backCP.GetHeight(6);
        } else {
            w = active ? this.backCP.GetWidth(0) : this.backCP.GetWidth(3);
            h = active ? this.backCP.GetHeight(0) : this.backCP.GetHeight(3);
        }
        return FontManagerEx.stringWidth(title) + 2 * w + this.hSpace;
    }

    public int tabWidth(Image img, boolean active, boolean selected) {
        int w = 0;
        int h = 0;
        if (selected) {
            w = active ? this.backCP.GetWidth(0) : this.backCP.GetWidth(6);
            h = active ? this.backCP.GetHeight(0) : this.backCP.GetHeight(6);
        } else {
            w = active ? this.backCP.GetWidth(0) : this.backCP.GetWidth(3);
            h = active ? this.backCP.GetHeight(0) : this.backCP.GetHeight(3);
        }
        return img.getWidth() + 2 * w + this.hSpace;
    }

    public int getHeight() {
        if (this.backCP != null) {
            return this.backCP.GetHeight(0);
        }
        return 0;
    }

    public class tab {
        int id = 0;
        String text = null;
        Image img = null;
        boolean isText = true;

        private tab() {
        }

        public tab(int id, String text) {
            this.id = id;
            this.text = text;
            this.isText = true;
        }

        public tab(int id, Image img) {
            this.id = id;
            this.img = img;
            this.isText = false;
        }
    }
}

