/*
 * Decompiled with CFR 0.152.
 */
package com.mogames.datatype;

import com.alsigames.net.NotFoundParamIDException;
import com.mogames.dataconv.DataConverter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public class Param {
    public static final byte TYPE_BYTE = 1;
    public static final byte TYPE_SHORT = 2;
    public static final byte TYPE_INT = 3;
    public static final byte TYPE_STRING = 4;
    public static final byte TYPE_IMAGE = 5;
    public static final byte TYPE_HASHTABLE = 6;
    public static final byte TYPE_ARRAY = 7;
    public static final byte TYPE_BOOL = 8;
    public static final byte TYPE_LONG = 9;
    byte type = 0;
    byte[] descr = null;

    private int loadType(byte[] data, int off) {
        int offOld = off;
        this.type = data[off++];
        if (this.type == 6) {
            off += this.loadDescription(data, off);
        }
        if (this.type == 7) {
            short num = DataConverter.shortFromBytes(data, off);
            Param p = new Param();
            int len = p.loadType(data, off + 2) + 2;
            this.descr = new byte[len];
            System.arraycopy(data, off, this.descr, 0, len);
            off += len;
        }
        return off - offOld;
    }

    private int loadDescription(byte[] data, int off) {
        short len = DataConverter.shortFromBytes(data, off);
        this.descr = new byte[len + 2];
        System.arraycopy(data, off, this.descr, 0, this.descr.length);
        return this.descr.length;
    }

    private Object createObject(byte[] data, IntHolder offset) {
        Object[] obj;
        block27: {
            obj = null;
            try {
                switch (this.type) {
                    case 1: {
                        obj = new Byte(data[offset.value++]);
                        break;
                    }
                    case 2: {
                        obj = new Short(DataConverter.shortFromBytes(data, offset.value));
                        offset.value += 2;
                        break;
                    }
                    case 3: {
                        obj = new Integer(DataConverter.intFromBytes(data, offset.value));
                        offset.value += 4;
                        break;
                    }
                    case 9: {
                        obj = new Long(DataConverter.longFromBytes(data, offset.value));
                        offset.value += 8;
                        break;
                    }
                    case 4: {
                        short len = DataConverter.shortFromBytes(data, offset.value);
                        offset.value += 2;
                        obj = DataConverter.stringFromBytes(data, offset.value, len);
                        offset.value += len;
                        break;
                    }
                    case 5: {
                        short len = DataConverter.shortFromBytes(data, offset.value);
                        offset.value += 2;
                        obj = Image.createImage((byte[])data, (int)offset.value, (int)len);
                        offset.value += len;
                        break;
                    }
                    case 7: {
                        int off = 0;
                        int num = DataConverter.shortFromBytes(this.descr, off);
                        off += 2;
                        Param pt = new Param();
                        off += pt.loadType(this.descr, off);
                        switch (pt.type) {
                            case 1: {
                                obj = new byte[num];
                                for (int i = 0; i < num; ++i) {
                                    ((byte[])obj)[i] = (Byte)pt.createObject(data, offset);
                                }
                                break block27;
                            }
                            case 2: {
                                obj = new short[num];
                                for (int i = 0; i < num; ++i) {
                                    ((short[])obj)[i] = (Short)pt.createObject(data, offset);
                                }
                                break block27;
                            }
                            case 3: {
                                obj = new int[num];
                                for (int i = 0; i < num; ++i) {
                                    ((int[])obj)[i] = (Integer)pt.createObject(data, offset);
                                }
                                break block27;
                            }
                            case 4: {
                                obj = new String[num];
                                for (int i = 0; i < num; ++i) {
                                    ((String[])obj)[i] = (String)pt.createObject(data, offset);
                                }
                                break block27;
                            }
                            case 5: {
                                obj = new Image[num];
                                for (int i = 0; i < num; ++i) {
                                    ((Image[])obj)[i] = (Image)pt.createObject(data, offset);
                                }
                                break block27;
                            }
                            case 6: {
                                obj = new Hashtable[num];
                                for (int i = 0; i < num; ++i) {
                                    ((Hashtable[])obj)[i] = (Hashtable)pt.createObject(data, offset);
                                }
                            }
                        }
                        break;
                    }
                    case 6: {
                        obj = this.createHashtable(data, offset);
                        break;
                    }
                    case 8: {
                        obj = new Boolean(data[offset.value++] == 1);
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Param.createObject: " + e);
            }
        }
        return obj;
    }

    public static Hashtable createHashtable(byte[] data, int off) {
        Param pt = new Param();
        off += pt.loadDescription(data, off);
        return pt.createHashtable(data, new IntHolder(off));
    }

    private Hashtable createHashtable(byte[] data, IntHolder offset) {
        Hashtable<Byte, Object> hashtable = new Hashtable<Byte, Object>();
        try {
            Param pt;
            for (int dOff = 2; dOff < this.descr.length; dOff += pt.loadType(this.descr, dOff)) {
                byte id = this.descr[dOff++];
                pt = new Param();
                hashtable.put(new Byte(id), pt.createObject(data, offset));
            }
        }
        catch (Exception e) {
            System.out.println("Param.createHashtable: " + e);
        }
        return hashtable;
    }

    private static int writeDescription(Hashtable ht, byte[] data, int off) {
        int offOld = off;
        off += 2;
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            Byte id = (Byte)e.nextElement();
            data[off++] = id;
            off += Param.writeType(ht.get(id), data, off);
        }
        DataConverter.bytesFromShort(data, offOld, off - offOld - 2);
        return off - offOld;
    }

    private static int writeType(Object value, byte[] data, int off) {
        int offOld = off;
        try {
            if (value instanceof Byte) {
                data[off++] = 1;
            } else if (value instanceof Short) {
                data[off++] = 2;
            } else if (value instanceof Integer) {
                data[off++] = 3;
            } else if (value instanceof Long) {
                data[off++] = 9;
            } else if (value instanceof String) {
                data[off++] = 4;
            } else if (value instanceof Image) {
                data[off++] = 5;
            } else if (value instanceof Hashtable) {
                data[off++] = 6;
                off += Param.writeDescription((Hashtable)value, data, off);
            } else if (value instanceof Boolean) {
                data[off++] = 8;
            } else {
                data[off++] = 7;
                if (value instanceof byte[]) {
                    DataConverter.bytesFromShort(data, off, ((byte[])value).length);
                    off += 2;
                    off += Param.writeType(new Byte(0), data, off);
                }
                if (value instanceof short[]) {
                    DataConverter.bytesFromShort(data, off, ((short[])value).length);
                    off += 2;
                    off += Param.writeType(new Short(0), data, off);
                }
                if (value instanceof int[]) {
                    DataConverter.bytesFromShort(data, off, ((int[])value).length);
                    off += 2;
                    off += Param.writeType(new Integer(0), data, off);
                }
                if (value instanceof String[]) {
                    DataConverter.bytesFromShort(data, off, ((String[])value).length);
                    off += 2;
                    off += Param.writeType("", data, off);
                }
                if (value instanceof Hashtable[]) {
                    DataConverter.bytesFromShort(data, off, ((Hashtable[])value).length);
                    off += 2;
                    off += Param.writeType(((Hashtable[])value)[0], data, off);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Param.writeType: " + e);
        }
        return off - offOld;
    }

    private static int writeData(Hashtable ht, byte[] data, int off) {
        int offOld = off;
        try {
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                int i;
                int num;
                Byte id = (Byte)e.nextElement();
                Object value = ht.get(id);
                if (value instanceof Byte) {
                    data[off++] = (Byte)value;
                    continue;
                }
                if (value instanceof Short) {
                    off += DataConverter.bytesFromShort(data, off, ((Short)value).shortValue());
                    continue;
                }
                if (value instanceof Integer) {
                    off += DataConverter.bytesFromInt(data, off, (Integer)value);
                    continue;
                }
                if (value instanceof Long) {
                    off += DataConverter.bytesFromLong(data, off, (Long)value);
                    continue;
                }
                if (value instanceof String) {
                    int len = DataConverter.bytesFromString((String)value, data, off + 2);
                    off += DataConverter.bytesFromShort(data, off, len);
                    off += len;
                    continue;
                }
                if (value instanceof Image) continue;
                if (value instanceof Hashtable) {
                    off += Param.writeData((Hashtable)value, data, off);
                    continue;
                }
                if (value instanceof Boolean) {
                    data[off++] = (byte)((Boolean)value != false ? 1 : 0);
                    continue;
                }
                if (value instanceof byte[]) {
                    num = ((byte[])value).length;
                    for (i = 0; i < num; ++i) {
                        data[off++] = ((byte[])value)[i];
                    }
                } else if (value instanceof short[]) {
                    num = ((short[])value).length;
                    for (i = 0; i < num; ++i) {
                        off += DataConverter.bytesFromShort(data, off, ((short[])value)[i]);
                    }
                } else if (value instanceof int[]) {
                    num = ((int[])value).length;
                    for (i = 0; i < num; ++i) {
                        off += DataConverter.bytesFromInt(data, off, ((int[])value)[i]);
                    }
                } else if (value instanceof long[]) {
                    num = ((long[])value).length;
                    for (i = 0; i < num; ++i) {
                        off += DataConverter.bytesFromLong(data, off, ((long[])value)[i]);
                    }
                } else if (value instanceof String[]) {
                    num = ((String[])value).length;
                    for (i = 0; i < num; ++i) {
                        int len = DataConverter.bytesFromString(((String[])value)[i], data, off + 2);
                        off += DataConverter.bytesFromShort(data, off, len);
                        off += len;
                    }
                } else if (!(value instanceof Image[]) && value instanceof Hashtable[]) {
                    off += Param.writeType(((Hashtable[])value)[0], data, off);
                    num = ((Hashtable[])value).length;
                    data[off++] = (byte)num;
                    for (i = 0; i < num; ++i) {
                        off += Param.writeData(ht, data, off);
                    }
                }
                if (!(value instanceof Boolean[])) continue;
                num = ((boolean[])value).length;
                for (i = 0; i < num; ++i) {
                    data[off++] = (byte)(((boolean[])value)[i] ? 1 : 0);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Param.writeData: " + e);
        }
        return off - offOld;
    }

    public static int writeHashtable(Hashtable ht, byte[] data, int off) {
        int offOld = off;
        off += Param.writeDescription(ht, data, off);
        off += Param.writeData(ht, data, off);
        return off - offOld;
    }

    public static Object get(Hashtable p, int key) throws NotFoundParamIDException {
        Byte id = new Byte((byte)key);
        if (!p.containsKey(id)) {
            throw new NotFoundParamIDException(key);
        }
        return p.get(id);
    }

    public static long getLong(Hashtable p, int key) throws NotFoundParamIDException {
        return (Long)Param.get(p, key);
    }

    public static int getInt(Hashtable p, int key) throws NotFoundParamIDException {
        return (Integer)Param.get(p, key);
    }

    public static short getShort(Hashtable p, int key) throws NotFoundParamIDException {
        return (Short)Param.get(p, key);
    }

    public static byte getByte(Hashtable p, int key) throws NotFoundParamIDException {
        return (Byte)Param.get(p, key);
    }

    public static boolean getBoolean(Hashtable p, int key) throws NotFoundParamIDException {
        return (Boolean)Param.get(p, key);
    }

    public static String getString(Hashtable p, int key) throws NotFoundParamIDException {
        return (String)Param.get(p, key);
    }

    public static Hashtable getHashtable(Hashtable p, int key) throws NotFoundParamIDException {
        return (Hashtable)Param.get(p, key);
    }

    public static Hashtable[] getHashtableArray(Hashtable p, int key) throws NotFoundParamIDException {
        Hashtable[] array = Param.get(p, key);
        if (array instanceof byte[] && ((byte[])array).length == 0) {
            array = new Hashtable[]{};
        }
        return array;
    }

    public static long[] getLongArray(Hashtable p, int key) throws NotFoundParamIDException {
        Hashtable[] array = Param.get(p, key);
        if (array instanceof byte[] && ((byte[])array).length == 0) {
            array = new Hashtable[]{};
        }
        return (long[])array;
    }

    public static int[] getIntArray(Hashtable p, int key) throws NotFoundParamIDException {
        Hashtable[] array = Param.get(p, key);
        if (array instanceof byte[] && ((byte[])array).length == 0) {
            array = new Hashtable[]{};
        }
        return (int[])array;
    }

    public static short[] getShortArray(Hashtable p, int key) throws NotFoundParamIDException {
        Hashtable[] array = Param.get(p, key);
        if (array instanceof byte[] && ((byte[])array).length == 0) {
            array = new Hashtable[]{};
        }
        return (short[])array;
    }

    public static byte[] getByteArray(Hashtable p, int key) throws NotFoundParamIDException {
        Object array = Param.get(p, key);
        return (byte[])array;
    }

    public static boolean[] getBooleanArray(Hashtable p, int key) throws NotFoundParamIDException {
        Hashtable[] array = Param.get(p, key);
        if (array instanceof byte[] && ((byte[])array).length == 0) {
            array = new Hashtable[]{};
        }
        return (boolean[])array;
    }

    public static String[] getStringArray(Hashtable p, int key) throws NotFoundParamIDException {
        Hashtable[] array = Param.get(p, key);
        if (array instanceof String[] && ((String[])array).length == 0) {
            array = new Hashtable[]{};
        }
        return (String[])array;
    }

    private static class IntHolder {
        public int value;

        public IntHolder() {
        }

        public IntHolder(int value) {
            this.value = value;
        }
    }
}

