/*
 * Decompiled with CFR 0.152.
 */
package com.mogames.dataconv;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;

public class DataConverter {
    public static final int intFromBytes(byte[] array, int off) {
        return (0xFF & array[off]) << 24 | (0xFF & array[off + 1]) << 16 | (0xFF & array[off + 2]) << 8 | 0xFF & array[off + 3];
    }

    public static final int bytesFromInt(byte[] array, int off, int value) {
        array[off] = (byte)((value & 0xFF000000) >> 24);
        array[off + 1] = (byte)((value & 0xFF0000) >> 16);
        array[off + 2] = (byte)((value & 0xFF00) >> 8);
        array[off + 3] = (byte)(value & 0xFF);
        return 4;
    }

    public static final byte[] bytesFromInt(int value) {
        byte[] array = new byte[]{(byte)((value & 0xFF000000) >> 24), (byte)((value & 0xFF0000) >> 16), (byte)((value & 0xFF00) >> 8), (byte)(value & 0xFF)};
        return array;
    }

    public static final short shortFromBytes(byte[] array, int off) {
        return (short)((0xFF & array[off]) << 8 | 0xFF & array[off + 1]);
    }

    public static final int bytesFromShort(byte[] array, int off, int value) {
        array[off] = (byte)((value & 0xFF00) >> 8);
        array[off + 1] = (byte)(value & 0xFF);
        return 2;
    }

    public static final long longFromBytes(byte[] array, int first) {
        return (0xFFL & (long)array[first]) << 56 | (0xFFL & (long)array[first + 1]) << 48 | (0xFFL & (long)array[first + 2]) << 40 | (0xFFL & (long)array[first + 3]) << 32 | (0xFFL & (long)array[first + 4]) << 24 | (0xFFL & (long)array[first + 5]) << 16 | (0xFFL & (long)array[first + 6]) << 8 | (long)(0xFF & array[first + 7]);
    }

    public static final int bytesFromLong(byte[] array, int off, long value) {
        array[off] = (byte)((value & 0xFF00000000000000L) >> 56);
        array[off + 1] = (byte)((value & 0xFF000000000000L) >> 48);
        array[off + 2] = (byte)((value & 0xFF0000000000L) >> 40);
        array[off + 3] = (byte)((value & 0xFF00000000L) >> 32);
        array[off + 4] = (byte)((value & 0xFF000000L) >> 24);
        array[off + 5] = (byte)((value & 0xFF0000L) >> 16);
        array[off + 6] = (byte)((value & 0xFF00L) >> 8);
        array[off + 7] = (byte)(value & 0xFFL);
        return 8;
    }

    public static final byte[] bytesFromString(String str) {
        byte[] eee = null;
        ByteArrayOutputStream dis = new ByteArrayOutputStream();
        DataOutputStream st = new DataOutputStream(dis);
        try {
            st.writeUTF(str);
            eee = dis.toByteArray();
        }
        catch (Exception e) {
            // empty catch block
        }
        return eee;
    }

    public static int bytesFromString(String str, byte[] data, int offset) {
        byte[] tmp_byte = DataConverter.bytesFromString(str);
        if (tmp_byte == null) {
            return 0;
        }
        System.arraycopy(tmp_byte, 0, data, offset, tmp_byte.length);
        return tmp_byte.length;
    }

    public static String stringFromBytes(byte[] data) {
        String eee = "";
        ByteArrayInputStream dis = new ByteArrayInputStream(data);
        DataInputStream st = new DataInputStream(dis);
        try {
            eee = st.readUTF();
        }
        catch (Exception e) {
            // empty catch block
        }
        return eee;
    }

    public static String stringFromBytes(byte[] data, int offset, int length) {
        byte[] tmp_data = new byte[length];
        for (int u = 0; u < length; ++u) {
            tmp_data[u] = data[offset + u];
        }
        return DataConverter.stringFromBytes(tmp_data);
    }

    public static void dataXor(byte[] data, int off, int len, byte[] key) {
        if (key == null) {
            return;
        }
        if (key.length == 0) {
            return;
        }
        int i = off;
        int k = 0;
        while (i < off + len) {
            if (k == key.length) {
                k = 0;
            }
            int n = i++;
            data[n] = (byte)(data[n] ^ key[k]);
            ++k;
        }
    }

    public static final int intFromStream(InputStream is) {
        int res = 0;
        try {
            res |= (0xFF & (byte)is.read()) << 24;
            res |= (0xFF & (byte)is.read()) << 16;
            res |= (0xFF & (byte)is.read()) << 8;
            res |= 0xFF & (byte)is.read();
        }
        catch (Exception e) {
            System.out.println("DataConverter.intFromStream: " + e);
        }
        return res;
    }

    public static final short shortFromStream(InputStream is) {
        int res = 0;
        try {
            res |= (0xFF & (byte)is.read()) << 8;
            res |= 0xFF & (byte)is.read();
        }
        catch (Exception e) {
            System.out.println("DataConverter.shortFromStream: " + e);
        }
        return (short)res;
    }

    public static String stringFromStream(InputStream is) {
        short len = DataConverter.shortFromStream(is);
        byte[] data = new byte[len];
        try {
            is.read(data);
        }
        catch (Exception e) {
            System.out.println("DataConverter.stringFromStream: " + e);
        }
        String eee = "";
        ByteArrayInputStream dis = new ByteArrayInputStream(data);
        DataInputStream st = new DataInputStream(dis);
        try {
            eee = st.readUTF();
        }
        catch (Exception e) {
            // empty catch block
        }
        return eee;
    }
}

