/*
 * Decompiled with CFR 0.152.
 */
package com.alsigames.xml;

import com.alsigames.xml.Attribute;
import com.alsigames.xml.Element;
import java.io.DataInputStream;

public class Parser {
    public static int ENC_ANSCII = 0;
    public static int ENC_UTF8 = 1;
    private DataInputStream reader;
    private Element TopElements;
    char Buffer;
    boolean usedBuffer;
    public static final int TAG_NOTFINISHED = 0;
    public static final int TAG_FINISHEDOPENED = 1;
    public static final int TAG_FINISHEDCLOSED = 2;
    private char[] ExtraSymbolBuffer = new char[6];
    public static String _amp = "&amp;";
    public static String _lt = "&lt;";
    public static String _gt = "&gt;";
    public static String _quot = "&quot;";
    public static String _apos = "&apos;";

    public Parser(DataInputStream reader) {
        this.reader = reader;
    }

    public Element getTree(int Encoding) {
        if (this.TopElements != null) {
            this.TopElements = null;
        }
        this.TopElements = new Element("root", 2, null);
        this.ParsAll(Encoding, false);
        return this.TopElements;
    }

    public Element getTree() {
        if (this.TopElements != null) {
            this.TopElements = null;
        }
        this.TopElements = new Element("root", 2, null);
        this.ParsAll(ENC_ANSCII, true);
        return this.TopElements;
    }

    public void ClearTree() {
        this.TopElements = null;
    }

    private boolean isNonSpaceSymbol(char c) {
        return c != ' ' && c != '\r' && c != '\n' && c != '\t';
    }

    private boolean isValidSymbol(char c) {
        return c == '_' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getTagName(int Encoding) {
        int c = 32;
        StringBuffer sb = new StringBuffer();
        boolean started = false;
        boolean isFirst = true;
        boolean startedComment = false;
        int commentCount = 0;
        while (true) {
            block12: {
                block13: {
                    if (!this.usedBuffer) {
                        c = this.getNextChar(Encoding);
                        if (c == -1) return sb.toString();
                    }
                    if (this.usedBuffer) {
                        c = this.Buffer;
                        this.usedBuffer = false;
                    }
                    if (!this.isNonSpaceSymbol((char)c)) break block13;
                    if (isFirst && !started) {
                        started = true;
                    }
                    if (!started) break block12;
                    if (this.isValidSymbol((char)c) || isFirst && ((char)c == '!' || (char)c == '?')) {
                        if (startedComment) {
                            // empty if block
                        }
                        if (isFirst && (char)c == '!') {
                            startedComment = true;
                        }
                        sb.append((char)c);
                        break block12;
                    } else if ((char)c == '-' && startedComment) {
                        sb.append((char)c);
                        if (++commentCount == 2) {
                            return sb.toString();
                        }
                        break block12;
                    } else {
                        this.usedBuffer = true;
                        this.Buffer = (char)c;
                        return sb.toString();
                    }
                }
                if (started) {
                    return sb.toString();
                }
            }
            if (!isFirst) continue;
            isFirst = false;
        }
    }

    private void skipTo(char skipSymbol, int Encoding) {
        int c;
        while ((c = this.getNextChar(Encoding)) != -1 && c != skipSymbol) {
        }
    }

    private void skipTo(String skipString, int Encoding) {
        int c;
        int foundPart = 0;
        while ((c = this.getNextChar(Encoding)) != -1) {
            if (c == skipString.charAt(foundPart)) {
                if (++foundPart < skipString.length()) continue;
                break;
            }
            foundPart = 0;
        }
    }

    private final boolean isExtraSymbol(String str, int ExtraSymbolBufferUsingIndex) {
        boolean result = true;
        if (ExtraSymbolBufferUsingIndex != str.length()) {
            return false;
        }
        for (int i = 0; i < ExtraSymbolBufferUsingIndex; ++i) {
            if (str.charAt(i) == this.ExtraSymbolBuffer[i]) continue;
            return false;
        }
        return result;
    }

    private Attribute getNextAttribute(int Encoding, boolean isRootTag) {
        int c = 32;
        Attribute atr = null;
        StringBuffer sbName = new StringBuffer();
        StringBuffer sbValue = new StringBuffer();
        boolean started = false;
        boolean isFirst = true;
        boolean breakSpace = false;
        while (this.usedBuffer || (c = this.getNextChar(Encoding)) != -1) {
            if (this.usedBuffer) {
                c = this.Buffer;
                this.usedBuffer = false;
            }
            if (this.isNonSpaceSymbol((char)c)) {
                if ((char)c == '=') break;
                if (!isRootTag && ((char)c == '/' || (char)c == '>') || isRootTag && (char)c == '?') {
                    this.Buffer = (char)c;
                    this.usedBuffer = true;
                    if (sbName.length() > 0) {
                        atr = new Attribute(sbName.toString(), null);
                        break;
                    }
                    return null;
                }
                if (!started) {
                    started = true;
                }
                sbName.append((char)c);
                continue;
            }
            if (!started) continue;
            breakSpace = true;
            break;
        }
        if (breakSpace) {
            while (this.usedBuffer || (c = this.getNextChar(Encoding)) != -1) {
                if (this.usedBuffer) {
                    c = this.Buffer;
                    this.usedBuffer = false;
                }
                if (!this.isNonSpaceSymbol((char)c) || (char)c == '=') continue;
                this.usedBuffer = true;
                this.Buffer = (char)c;
                atr = new Attribute(sbName.toString(), null);
                break;
            }
        }
        started = false;
        int ExtraSymbolBufferUsingIndex = 0;
        if (atr == null) {
            int atrStartedCount = 0;
            while (this.usedBuffer || (c = this.getNextChar(Encoding)) != -1) {
                int i;
                if (this.usedBuffer) {
                    c = this.Buffer;
                    this.usedBuffer = false;
                }
                if (this.isNonSpaceSymbol((char)c) && (!isRootTag || (char)c != '?') && (isRootTag || (char)c != '/' && (char)c != '>')) {
                    if (!started) {
                        started = true;
                    }
                    if ((char)c == '\"') {
                        if (ExtraSymbolBufferUsingIndex != 0) {
                            for (i = 0; i < ExtraSymbolBufferUsingIndex; ++i) {
                                sbValue.append(this.ExtraSymbolBuffer[i]);
                            }
                            ExtraSymbolBufferUsingIndex = 0;
                        }
                        if (++atrStartedCount <= 2) continue;
                        break;
                    }
                    if ((char)c == '&') {
                        if (ExtraSymbolBufferUsingIndex == 0) {
                            this.ExtraSymbolBuffer[ExtraSymbolBufferUsingIndex++] = 38;
                            continue;
                        }
                        for (i = 0; i < ExtraSymbolBufferUsingIndex; ++i) {
                            sbValue.append(this.ExtraSymbolBuffer[i]);
                        }
                        ExtraSymbolBufferUsingIndex = 0;
                        this.ExtraSymbolBuffer[ExtraSymbolBufferUsingIndex++] = 38;
                        continue;
                    }
                    if (ExtraSymbolBufferUsingIndex == 0) {
                        if (atrStartedCount > 1) {
                            this.usedBuffer = true;
                            this.Buffer = (char)c;
                            break;
                        }
                        sbValue.append((char)c);
                        continue;
                    }
                    this.ExtraSymbolBuffer[ExtraSymbolBufferUsingIndex++] = (char)c;
                    if (this.isExtraSymbol(_lt, ExtraSymbolBufferUsingIndex)) {
                        sbValue.append('<');
                        ExtraSymbolBufferUsingIndex = 0;
                        continue;
                    }
                    if (this.isExtraSymbol(_gt, ExtraSymbolBufferUsingIndex)) {
                        sbValue.append('>');
                        ExtraSymbolBufferUsingIndex = 0;
                        continue;
                    }
                    if (this.isExtraSymbol(_amp, ExtraSymbolBufferUsingIndex)) {
                        sbValue.append('&');
                        ExtraSymbolBufferUsingIndex = 0;
                        continue;
                    }
                    if (this.isExtraSymbol(_apos, ExtraSymbolBufferUsingIndex)) {
                        sbValue.append('\'');
                        ExtraSymbolBufferUsingIndex = 0;
                        continue;
                    }
                    if (this.isExtraSymbol(_quot, ExtraSymbolBufferUsingIndex)) {
                        sbValue.append('\"');
                        ExtraSymbolBufferUsingIndex = 0;
                        continue;
                    }
                    if (ExtraSymbolBufferUsingIndex < 6) continue;
                    for (i = 0; i < ExtraSymbolBufferUsingIndex; ++i) {
                        sbValue.append(this.ExtraSymbolBuffer[i]);
                    }
                    ExtraSymbolBufferUsingIndex = 0;
                    continue;
                }
                if (!started) continue;
                if (ExtraSymbolBufferUsingIndex != 0) {
                    for (i = 0; i < ExtraSymbolBufferUsingIndex; ++i) {
                        sbValue.append(this.ExtraSymbolBuffer[i]);
                    }
                    ExtraSymbolBufferUsingIndex = 0;
                }
                if (atrStartedCount > 1) {
                    breakSpace = true;
                    atr = new Attribute(sbName.toString(), sbValue.toString());
                    if ((!isRootTag || (char)c != '?') && (isRootTag || (char)c != '/' && (char)c != '>')) break;
                    this.usedBuffer = true;
                    this.Buffer = (char)c;
                    break;
                }
                sbValue.append((char)c);
            }
        }
        return atr;
    }

    private int isClosedTag(int Encoding, boolean isRootTag) {
        int found = 0;
        int state = 0;
        if (isRootTag) {
            int c;
            boolean satrted = false;
            if (this.usedBuffer) {
                if (this.Buffer != '?') {
                    return 0;
                }
                ++found;
                this.usedBuffer = false;
                satrted = true;
            }
            while ((c = this.getNextChar(Encoding)) != -1) {
                if (!satrted && !this.isNonSpaceSymbol((char)c)) continue;
                if (found == 0) {
                    if ((char)c != '?') {
                        this.Buffer = (char)c;
                        this.usedBuffer = true;
                        return 0;
                    }
                    ++found;
                    continue;
                }
                if ((char)c != '>') {
                    return 0;
                }
                state = 2;
                break;
            }
        } else {
            int c;
            if (this.usedBuffer) {
                if (this.Buffer != '/' && this.Buffer != '>') {
                    return 0;
                }
                if (this.Buffer == '>') {
                    this.usedBuffer = false;
                    return 1;
                }
                ++found;
                this.usedBuffer = false;
            }
            while ((c = this.getNextChar(Encoding)) != -1) {
                if (found == 0) {
                    if (this.Buffer != '/' && this.Buffer != '>') {
                        this.Buffer = (char)c;
                        this.usedBuffer = true;
                        return 0;
                    }
                    if (this.Buffer == '>') {
                        this.usedBuffer = false;
                        return 1;
                    }
                    ++found;
                    continue;
                }
                if ((char)c != '>') {
                    return 0;
                }
                state = 2;
                break;
            }
        }
        return state;
    }

    private void ParsAll(int Encoding, boolean updateEncoding) {
        int c;
        boolean tagStarted = false;
        StringBuffer sb = new StringBuffer();
        Element currentElemement = this.TopElements;
        boolean isEmptyText = true;
        boolean isSpaceInBuffer = false;
        int[] beforXMLStart = new int[3];
        int curStartedSymbol = 0;
        boolean isXMLStarted = false;
        boolean isRealUTF8 = false;
        while ((c = this.getNextChar(Encoding)) != -1) {
            if (this.isNonSpaceSymbol((char)c)) {
                if (c == 60) {
                    if (!tagStarted) {
                        Attribute nextAttribute;
                        boolean closingTag = false;
                        tagStarted = true;
                        if (sb.length() > 0) {
                            if (isXMLStarted) {
                                currentElemement.addElement(sb.toString(), 3);
                            }
                            sb.delete(0, sb.length());
                        }
                        if ((c = this.getNextChar(Encoding)) == -1) break;
                        if (c != 47) {
                            this.usedBuffer = true;
                            this.Buffer = (char)c;
                        } else {
                            closingTag = true;
                        }
                        String name = this.getTagName(Encoding);
                        int state = 0;
                        if (name.startsWith("!--")) {
                            this.skipTo("-->", Encoding);
                            tagStarted = false;
                            isEmptyText = true;
                        } else if (name.startsWith("?")) {
                            isXMLStarted = true;
                            currentElemement.addElement(name.substring(1, name.length()), 5);
                            if (!closingTag) {
                                while ((nextAttribute = this.getNextAttribute(Encoding, true)) != null) {
                                    currentElemement.addAttribute(nextAttribute);
                                    if (!isRealUTF8 && updateEncoding && nextAttribute.getName().equals("encoding") && nextAttribute.getValue() != null) {
                                        String encodTable = nextAttribute.getValue().toLowerCase();
                                        if (encodTable.equals("utf-8")) {
                                            Encoding = ENC_UTF8;
                                        } else if (encodTable.equals("ascii")) {
                                            Encoding = ENC_ANSCII;
                                        }
                                    }
                                    if ((state = this.isClosedTag(Encoding, true)) == 0) continue;
                                    tagStarted = false;
                                    isEmptyText = true;
                                    break;
                                }
                            }
                            if (state == 0 && (state = this.isClosedTag(Encoding, true)) != 0) {
                                tagStarted = false;
                                isEmptyText = true;
                            }
                        } else {
                            if (!closingTag) {
                                currentElemement = currentElemement.addElement(name, 1);
                                nextAttribute = null;
                                while ((nextAttribute = this.getNextAttribute(Encoding, false)) != null) {
                                    currentElemement.addAttribute(nextAttribute);
                                    state = this.isClosedTag(Encoding, false);
                                    if (state == 0) continue;
                                    tagStarted = false;
                                    isEmptyText = true;
                                    break;
                                }
                            } else if (!name.equals(currentElemement.getName())) {
                                // empty if block
                            }
                            if (state == 0) {
                                state = this.isClosedTag(Encoding, false);
                                if (state != 0) {
                                    tagStarted = false;
                                    isEmptyText = true;
                                }
                                if (closingTag && state == 1) {
                                    state = 2;
                                }
                            }
                            if (state == 2) {
                                currentElemement = currentElemement.getParent();
                            }
                        }
                        isEmptyText = true;
                        isSpaceInBuffer = false;
                    }
                } else {
                    if (isEmptyText) {
                        isEmptyText = false;
                    }
                    if (isSpaceInBuffer) {
                        sb.append(' ');
                        isSpaceInBuffer = false;
                    }
                    sb.append((char)c);
                }
            } else if (!isEmptyText) {
                isSpaceInBuffer = true;
            }
            if (isXMLStarted || curStartedSymbol >= beforXMLStart.length) continue;
            beforXMLStart[curStartedSymbol++] = c;
            if (curStartedSymbol != 3 || Encoding != ENC_ANSCII || beforXMLStart[0] != 1087 || beforXMLStart[1] != 1035 || beforXMLStart[2] != 1039) continue;
            Encoding = ENC_UTF8;
            isRealUTF8 = true;
        }
    }

    public Element getNextTreeElemen(Element parent, Element First) {
        return this.getNextTreeElement(parent, First, false, 0);
    }

    public Element getNextTreeElemen(Element parent, Element First, int elementType) {
        return this.getNextTreeElement(parent, First, false, elementType);
    }

    private Element getNextTreeElement(Element parent, Element First, boolean fromDown, int elementType) {
        Element child = null;
        if (parent.getElementsCount() > 0) {
            int count = parent.getElementsCount();
            int start = 0;
            if (First != null) {
                for (int j = 0; j < count && First != parent.getElement(j); ++j) {
                    ++start;
                }
            }
            for (int i = start; i < count; ++i) {
                if (!(First != null && i == start ? !fromDown && (child = this.getNextTreeElement(child, null, false, elementType)) != null && (elementType == 0 || elementType == child.getType()) : (child = parent.getElement(i)) != null && (elementType == 0 || elementType == child.getType()))) continue;
                return child;
            }
            child = null;
        }
        if (child == null && parent.getParent() != null) {
            child = this.getNextTreeElement(parent.getParent(), parent, true, elementType);
        }
        return child;
    }

    public Element getNextTreeElementByName(Element parent, String name) {
        Element child = null;
        if (parent.getElementsCount() > 0) {
            int count = parent.getElementsCount();
            for (int i = 0; i < count; ++i) {
                child = parent.getElement(i);
                if (child == null) continue;
                if (child.getName().equals(name)) {
                    return child;
                }
                if ((child = this.getNextTreeElementByName(child, name)) == null) continue;
                return child;
            }
            child = null;
        }
        return null;
    }

    public Element getNextTreeElementByName(Element parent, Element First, String name) {
        return this.getNextTreeElementByName(parent, First, false, name);
    }

    private Element getNextTreeElementByName(Element parent, Element First, boolean fromDown, String name) {
        Element child = null;
        if (parent.getElementsCount() > 0) {
            int count = parent.getElementsCount();
            int start = 0;
            if (First != null) {
                for (int j = 0; j < count && First != parent.getElement(j); ++j) {
                    ++start;
                }
            }
            for (int i = start; i < count; ++i) {
                child = parent.getElement(i);
                if (child == null) continue;
                if (First != null && i == start) {
                    if (fromDown || (child = this.getNextTreeElementByName(child, name)) == null) continue;
                    return child;
                }
                if (child.getName().equals(name)) {
                    return child;
                }
                if ((child = this.getNextTreeElementByName(child, name)) == null) continue;
                return child;
            }
            child = null;
        }
        if (child == null && parent.getParent() != null && fromDown) {
            child = this.getNextTreeElementByName(parent.getParent(), parent, true, name);
        }
        return child;
    }

    public Element getNextTreeElementByAttribute(Element parent, String tagName, String name, String value) {
        if (parent.getElementsCount() > 0) {
            int count = parent.getElementsCount();
            for (int i = 0; i < count; ++i) {
                Element child = parent.getElement(i);
                if (child == null) continue;
                if (child.getName().equals(tagName) && child.getAttribute(name) != null && child.getAttribute(name).getValue().equals(value)) {
                    return child;
                }
                if ((child = this.getNextTreeElementByAttribute(child, tagName, name, value)) == null) continue;
                return child;
            }
        }
        return null;
    }

    public Element getNextTreeElementByAttribute(Element parent, Element First, String tagName, String name, String value) {
        return this.getNextTreeElementByAttribute(parent, First, false, tagName, name, value);
    }

    private Element getNextTreeElementByAttribute(Element parent, Element First, boolean fromDown, String tagName, String name, String value) {
        Element child = null;
        if (parent.getElementsCount() > 0) {
            int count = parent.getElementsCount();
            int start = 0;
            if (First != null) {
                for (int j = 0; j < count && First != parent.getElement(j); ++j) {
                    ++start;
                }
            }
            for (int i = start; i < count; ++i) {
                child = parent.getElement(i);
                if (child == null) continue;
                if (First != null && i == start) {
                    if (fromDown || (child = this.getNextTreeElementByAttribute(child, tagName, name, value)) == null) continue;
                    return child;
                }
                if (child.getName().equals(tagName) && child.getAttribute(name) != null && child.getAttribute(name).getValue().equals(value)) {
                    return child;
                }
                if ((child = this.getNextTreeElementByAttribute(child, tagName, name, value)) == null) continue;
                return child;
            }
            child = null;
        }
        if (child == null && parent.getParent() != null) {
            child = this.getNextTreeElementByAttribute(parent.getParent(), parent, true, tagName, name, value);
        }
        return child;
    }

    private final char byte2char(byte ch) {
        if (ch < 0) {
            switch (ch) {
                case -88: {
                    return (char)(ch + 9 - 64432);
                }
                case -72: {
                    return (char)(ch + 73 - 64432);
                }
                case -71: {
                    return (char)(ch + 7437 - 64432);
                }
            }
            return (char)(ch - 64432);
        }
        return (char)ch;
    }

    private int getNextChar(int Encoding) {
        int c = -1;
        if (Encoding == ENC_ANSCII) {
            try {
                c = this.reader.read();
                if (c >= 0) {
                    c = this.byte2char((byte)c);
                }
            }
            catch (Exception e) {
                c = -1;
            }
        } else if (Encoding == ENC_UTF8) {
            try {
                c = this.reader.read();
            }
            catch (Exception e) {
                c = -1;
            }
            if (c >= 0 && (0x80 & c) != 0) {
                int count = 0;
                for (int i = 1; i < 3 && (128 >> i & c) != 0; ++i) {
                    ++count;
                }
                if (count > 1) {
                    c = -1;
                } else {
                    int bufSymbol = (0x1F & c) << 6;
                    try {
                        c = this.reader.read();
                    }
                    catch (Exception e) {
                        c = -1;
                    }
                    if ((c & 0x80) != 0 && (c & 0x40) == 0) {
                        bufSymbol += 0x3F & c;
                        c = bufSymbol;
                    } else {
                        c = -1;
                    }
                }
            }
        }
        return c;
    }
}

