/*
 * Decompiled with CFR 0.152.
 */
package com.alsigames.net;

import com.alsigames.net.MobileNetReceiver;
import com.mogames.dataconv.DataConverter;
import com.mogames.datatype.Param;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Random;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;

public class MobileConnection
extends Thread {
    MobileNetReceiver parentThread = null;
    long lastNetTime;
    boolean inProcess = false;
    long lastSendTime;
    long lastRecvTime;
    static final long maxTimeOut = 60000L;
    static final int NETMSGTYPE_MEMPTY = 0;
    static final int NETMSGTYPE_CREATE = 1;
    static final int NETMSGTYPE_ILOGIN = 2;
    static final int NETMSGTYPE_LOGANS = 3;
    static final int NETMSGTYPE_GETOPD = 5;
    static final int NETMSGTYPE_OPDATA = 6;
    static final int NETMSGTYPE_OPGDDT = 7;
    static final int NETMSGTYPE_OPDGDS = 8;
    static final int NETMSGTYPE_LEVLUP = 9;
    static final int NETMSGTYPE_FNDUSR = 10;
    static final int NETMSGTYPE_GVMONY = 11;
    static final int NETMSGTYPE_CONCLS = 12;
    static final int NETMSGTYPE_PLONLN = 13;
    static final int NETMSGTYPE_MAILSN = 14;
    static final int NETMSGTYPE_MAILRC = 15;
    static final int NETMSGTYPE_MAILLS = 16;
    static final int NETMSGTYPE_MAILDT = 17;
    static final int NETMSGTYPE_MAILRD = 18;
    static final int NETMSGTYPE_MAILDL = 19;
    static final int NETMSGTYPE_CLNUPD = 20;
    static final int NETMSGTYPE_CLUPMS = 21;
    static final int NETMSGTYPE_BTLCRT = 31;
    static final int NETMSGTYPE_BTLCNS = 32;
    static final int NETMSGTYPE_BTLFND = 33;
    static final int NETMSGTYPE_BTLVIN = 34;
    static final int NETMSGTYPE_BTLCNT = 35;
    static final int NETMSGTYPE_BTSTEN = 36;
    static final int NETMSGTYPE_BTCRRS = 41;
    static final int NETMSGTYPE_BTFNRS = 42;
    static final int NETMSGTYPE_BTFNEN = 43;
    static final int NETMSGTYPE_BTFUCN = 44;
    static final int NETMSGTYPE_BTCNRS = 45;
    static final int NETMSGTYPE_BTCUOF = 46;
    static final int NETMSGTYPE_BTLSTR = 47;
    static final int NETMSGTYPE_BTLNXT = 48;
    static final int NETMSGTYPE_BTTNRS = 49;
    static final int NETMSGTYPE_BTLEND = 50;
    static final int NETMSGTYPE_BTLLOG = 51;
    static final int NETMSGTYPE_BTLLUP = 52;
    static final int NETMSGTYPE_ROLACT = 53;
    static final int NETMSGTYPE_GTGDIM = 60;
    static final int NETMSGTYPE_GDSIMG = 61;
    static final int NETMSGTYPE_GTSHIM = 62;
    static final int NETMSGTYPE_SHPIMG = 63;
    static final int NETMSGTYPE_NENFMN = 71;
    static final int NETMSGTYPE_ENFMNY = 72;
    static final int NETMSGTYPE_CRGLST = 80;
    static final int NETMSGTYPE_CRABOT = 81;
    static final int NETMSGTYPE_CRCRET = 82;
    static final int NETMSGTYPE_CRCRRS = 83;
    static final int NETMSGTYPE_CRLOGN = 84;
    static final int NETMSGTYPE_CRINMS = 85;
    static final int NETMSGTYPE_CRINRS = 86;
    static final int NETMSGTYPE_CRRSLT = 87;
    static final int NETMSGTYPE_CREXIT = 88;
    static final int NETMSGTYPE_CRUSEX = 89;
    static final int NETMSGTYPE_CRCLOS = 90;
    static final int NETMSGTYPE_CRREPR = 91;
    static final int NETMSGTYPE_CRNDEX = 92;
    static final int NETMSGTYPE_LINCHT = 100;
    static final int NETMSGTYPE_CHTCMS = 101;
    static final int NETMSGTYPE_CHTPMS = 102;
    static final int NETMSGTYPE_CHTULI = 105;
    static final int NETMSGTYPE_CHTULO = 106;
    static final int NETMSGTYPE_CHTLST = 107;
    static final int NETMSGTYPE_CHTUSR = 108;
    static final int NETMSGTYPE_CHTUMS = 109;
    static final int NETMSGTYPE_LOFCHT = 120;
    static final int NETMSGTYPE_SHPLIN = 140;
    static final int NETMSGTYPE_SHPBYE = 141;
    static final int NETMSGTYPE_INVDRS = 142;
    static final int NETMSGTYPE_INVGDD = 143;
    static final int NETMSGTYPE_SHPGCN = 145;
    static final int NETMSGTYPE_SHPGDS = 146;
    static final int NETMSGTYPE_INVGDS = 147;
    static final int NETMSGTYPE_SHPBRS = 148;
    static final int NETMSGTYPE_INVWER = 149;
    static final int NETMSGTYPE_GDSCPL = 150;
    static final int NETMSGTYPE_MONEYQ = 151;
    static final int NETMSGTYPE_MONEYU = 152;
    static final int NETMSGTYPE_GLRLST = 160;
    static final int NETMSGTYPE_GLRCNT = 162;
    static final int NETMSGTYPE_GLRIMN = 163;
    static final int NETMSGREAD_HEADER = 0;
    static final int NETMSGREAD_KEY = 1;
    static final int NETMSGREAD_DATA = 2;
    private byte[] msgHeaderRecv = new byte[4];
    private byte[] msgKeyRecv = new byte[5];
    private byte[] msgBufferRecv = new byte[2048];
    private int msgLength = 0;
    private int msgType = 0;
    private byte[] msgHeaderSend = new byte[4];
    private byte[] msgKeySend = new byte[5];
    private byte[] msgBufferSend = new byte[2048];
    private SocketConnection sc = null;
    private InputStream is = null;
    private OutputStream os = null;
    private final int sleepSize;
    boolean active = false;

    public MobileConnection(MobileNetReceiver pThread) {
        this.sleepSize = 100;
        this.parentThread = pThread;
        this.lastNetTime = this.lastRecvTime = (this.lastSendTime = System.currentTimeMillis());
    }

    public int InitConnection(String host, int port) {
        int stat = 0;
        try {
            this.sc = (SocketConnection)Connector.open((String)("socket://" + host + ":" + port));
            this.sc.setSocketOption((byte)2, 1);
            this.active = true;
            this.start();
        }
        catch (Exception e) {
            System.out.println("SocketConnection thrown exception " + e);
            this.sc = null;
            stat = 1;
        }
        if (stat == 0) {
            try {
                if (this.sc != null) {
                    this.is = this.sc.openInputStream();
                    this.os = this.sc.openOutputStream();
                }
            }
            catch (Exception e) {
                System.out.println("InputOutputStream thrown exception " + e);
                stat = 2;
            }
        }
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void CloseConnection() {
        this.active = false;
        this.inProcess = false;
        try {
            if (this.is != null) {
                this.is.close();
            }
            if (this.os != null) {
                this.os.close();
            }
            if (this.sc != null) {
                this.sc.close();
            }
        }
        catch (Exception e) {
            System.out.println("initConnection error " + e);
        }
        finally {
            this.is = null;
            this.os = null;
            this.sc = null;
        }
    }

    public void run() {
        while (this.active) {
            try {
                if (this.is != null) {
                    int ch = 0;
                    int msgStat = 0;
                    int index = 0;
                    while (ch != -1) {
                        ch = this.is.read();
                        if (ch != -1) {
                            this.lastNetTime = this.lastRecvTime = System.currentTimeMillis();
                            switch (msgStat) {
                                case 0: {
                                    this.msgHeaderRecv[index++] = (byte)ch;
                                    if (index < this.msgHeaderRecv.length) break;
                                    index = 0;
                                    ++msgStat;
                                    break;
                                }
                                case 1: {
                                    this.msgKeyRecv[index++] = (byte)ch;
                                    if (index < this.msgKeyRecv.length) break;
                                    index = 0;
                                    ++msgStat;
                                    DataConverter.dataXor(this.msgHeaderRecv, 0, this.msgHeaderRecv.length, this.msgKeyRecv);
                                    int off = 0;
                                    this.msgType = DataConverter.shortFromBytes(this.msgHeaderRecv, off);
                                    this.msgLength = DataConverter.shortFromBytes(this.msgHeaderRecv, off += 2);
                                    off += 2;
                                    if (this.msgBufferRecv.length >= this.msgLength) break;
                                    this.msgBufferRecv = null;
                                    this.msgBufferRecv = new byte[this.msgLength];
                                    break;
                                }
                                case 2: {
                                    if (this.msgLength > 0) {
                                        this.msgBufferRecv[index++] = (byte)ch;
                                    }
                                    if (index < this.msgLength) break;
                                    DataConverter.dataXor(this.msgBufferRecv, 0, this.msgLength, this.msgKeyRecv);
                                    this.inProcess = false;
                                    if (this.msgType == 17) {
                                        boolean o = false;
                                    }
                                    this.parentThread.GetNetMessage(this.msgType, Param.createHashtable(this.msgBufferRecv, 0));
                                    msgStat = 0;
                                    index = 0;
                                }
                            }
                        }
                        if (msgStat != 0 || index != 0) continue;
                    }
                }
                MobileConnection.sleep(100L);
            }
            catch (IOException eIO) {
                this.parentThread.CloseConnection();
                this.active = false;
            }
            catch (Exception e) {
                System.out.println("SocketConnection run error " + e);
                this.active = false;
            }
        }
    }

    private final void send(byte[] data, int length, int type) {
        this.lastNetTime = this.lastSendTime = System.currentTimeMillis();
        int off = 0;
        off += DataConverter.bytesFromShort(this.msgHeaderSend, off, type);
        off += DataConverter.bytesFromShort(this.msgHeaderSend, off, length + this.msgHeaderSend.length + this.msgKeySend.length);
        Random rand = new Random();
        for (int i = 0; i < this.msgKeySend.length; ++i) {
            int rnd = rand.nextInt();
            this.msgKeySend[i] = (byte)((rnd >= 0 ? rnd : -rnd) % 127);
        }
        try {
            DataConverter.dataXor(this.msgHeaderSend, 0, this.msgHeaderSend.length, this.msgKeySend);
            DataConverter.dataXor(data, 0, length, this.msgKeySend);
            this.os.write(this.msgHeaderSend, 0, this.msgHeaderSend.length);
            this.os.write(this.msgKeySend, 0, this.msgKeySend.length);
            this.os.write(data, 0, length);
            this.os.flush();
        }
        catch (IOException eIO) {
            System.out.println("send bytes java.io.IOException " + eIO);
            this.parentThread.CloseConnection();
        }
        catch (Exception e) {
            System.out.println("SocketConnection send bytes error [length]=" + length + ", " + "dada=" + data + " :" + e);
        }
    }

    public final void send(int type, Hashtable params) {
        int length = Param.writeHashtable(params, this.msgBufferSend, 0);
        this.send(this.msgBufferSend, length, type);
    }

    public final int recv() {
        int result = -1;
        return result;
    }

    public final void stop() {
        this.active = false;
    }
}

