/*
 * Decompiled with CFR 0.152.
 */
package com.alsigames.gui;

import com.alsigames.gui.ScrollListElement;

public class ScrollList {
    protected ScrollListElement[] List = null;
    protected int MaxCount = 0;
    protected int ElementsShift = 0;
    protected int ElementsUsed = 0;
    protected int PageHeight = 0;
    protected int PageWidth = 0;
    protected int PagePos = 0;
    protected int ScreenW = 0;
    protected int ScreenH = 0;
    protected int ScrollArrowTopSize = 0;
    protected int ScrollArrowBotSize = 0;
    protected int ScrollMarkerSize = 0;
    protected int ScrollPos = 0;

    public ScrollList(ScrollListElement[] list) {
        this.List = list;
        if (this.List != null) {
            this.MaxCount = this.List.length;
        }
    }

    public ScrollList(ScrollListElement[] list, boolean isFilled) {
        this.List = list;
        if (this.List != null) {
            this.MaxCount = this.List.length;
            if (isFilled) {
                this.ElementsUsed = this.MaxCount;
                this.GetTotalHeight();
            }
        }
    }

    public void initScreen(int w, int h) {
        this.ScreenW = w;
        this.ScreenH = h;
        this.PageWidth = w;
    }

    public void setElementsShift(int shift) {
        this.ElementsShift = shift;
    }

    public boolean isListFull() {
        return this.ElementsUsed >= this.MaxCount;
    }

    public ScrollListElement GetEmptyElement() {
        ScrollListElement res = null;
        if (this.List != null && this.List.length > 0) {
            if (this.ElementsUsed >= this.MaxCount) {
                for (int i = 0; i < this.MaxCount - 1; ++i) {
                    this.List[i].CopyFromAnother(this.List[i + 1]);
                }
                res = this.List[this.MaxCount - 1];
            } else {
                res = this.List[this.ElementsUsed];
                ++this.ElementsUsed;
            }
        }
        return res;
    }

    public ScrollListElement GetElement(int num) {
        ScrollListElement res = null;
        if (num >= 0 && num < this.ElementsUsed && this.List != null && this.MaxCount > 0 && num < this.MaxCount) {
            res = this.List[num];
        }
        return res;
    }

    public int GetTotalHeight() {
        if (this.List != null && this.List.length > 0 && this.ElementsUsed > 0) {
            this.PageHeight = 0;
            for (int i = 0; i < this.ElementsUsed; ++i) {
                if (i > 0) {
                    this.PageHeight += this.ElementsShift;
                }
                this.PageHeight += this.List[i].height;
            }
        }
        return this.PageHeight;
    }

    public boolean IsInBottomList() {
        if (this.PageHeight <= this.ScreenH) {
            return true;
        }
        return this.PagePos == this.ScreenH - this.PageHeight;
    }

    public void ScrollTo(int direct) {
        if (direct > 0) {
            if (this.ScreenH - this.PageHeight < 0) {
                this.PagePos = this.ScreenH - this.PageHeight;
                int scrollHeight = this.ScreenH - this.ScrollArrowTopSize - this.ScrollArrowBotSize - this.ScrollMarkerSize;
                this.ScrollPos = -this.PagePos * scrollHeight / (this.PageHeight - this.ScreenH);
            } else {
                this.PagePos = 0;
                this.ScrollPos = 0;
            }
        } else if (direct < 0) {
            this.PagePos = 0;
            this.ScrollPos = 0;
        }
    }

    public void Scroll(int val) {
        if (this.ElementsUsed > 0) {
            if (this.PageHeight > this.ScreenH) {
                this.PagePos -= val;
                if (this.PagePos > 0) {
                    this.PagePos = 0;
                }
                if (this.PageHeight + this.PagePos < this.ScreenH) {
                    this.PagePos = this.ScreenH - this.PageHeight;
                }
                int scrollHeight = this.ScreenH - this.ScrollArrowTopSize - this.ScrollArrowBotSize - this.ScrollMarkerSize;
                this.ScrollPos = -this.PagePos * scrollHeight / (this.PageHeight - this.ScreenH);
            } else if (this.PagePos != 0) {
                this.PagePos = 0;
                this.ScrollPos = 0;
            }
        }
    }

    public int GetUsedElementsCount() {
        return this.ElementsUsed;
    }

    public void SetMaxCount(int cnt) {
        if (cnt > 0) {
            if (cnt > this.List.length) {
                cnt = this.List.length;
            }
            this.MaxCount = cnt;
            if (this.ElementsUsed > this.MaxCount) {
                int shift = this.ElementsUsed - this.MaxCount;
                for (int i = 0; i < this.MaxCount; ++i) {
                    this.List[i].CopyFromAnother(this.List[i + shift]);
                }
                this.ElementsUsed = this.MaxCount;
            }
        }
    }

    public int getScreenW() {
        return this.ScreenW;
    }

    public int getScreenH() {
        return this.ScreenH;
    }

    public int getPageW() {
        return this.PageWidth;
    }

    public int getPageH() {
        return this.PageHeight;
    }

    public int getPagePos() {
        return this.PagePos;
    }
}

