/*
 * Decompiled with CFR 0.152.
 */
package com.alsigames.font;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FontManagerEx {
    static final int fontMaxNum = 4;
    static Image[] iFont = new Image[4];
    static byte[][] ShiftsAlpha = new byte[4][];
    static short[][] ShiftsCuts = new short[4][];
    static int[] SpaceW = new int[4];
    static int[] cellW = new int[4];
    static int[] cellH = new int[4];
    static String[] alph = new String[4];
    static int[] fontLength = new int[4];
    static int curFont = 0;
    public static final String NewLine = "\n";
    static int[] _xSpacing = new int[4];
    static int[] _ySpacing = new int[4];
    static int pageX = 0;
    static int pageY = 0;
    static int pageW = 0;
    static int pageH = 0;
    static int pageScrollH = 1;
    static int pageYShift = 0;
    static int pageScrollPhaseCur = 0;
    static int pageScrollPhaseNum = 1;
    static int pageScrollTextH = 0;
    static Graphics g;
    static int clipX;
    static int clipY;
    static int clipW;
    static int clipH;
    static boolean enableTextClip;
    static byte tabInSpaces;

    public static void loadFont(byte[] inifile, short[] shiftsCuts, byte[] shiftsAlpha, Image font, int id, Class getClass) {
        FontManagerEx.iFont[id] = font;
        FontManagerEx.loadIni(inifile, id);
        FontManagerEx.cellW[id] = shiftsAlpha[0] & 0xFF;
        FontManagerEx.cellH[id] = shiftsAlpha[1] & 0xFF;
        FontManagerEx.ShiftsCuts[id] = shiftsCuts;
        FontManagerEx.ShiftsAlpha[id] = shiftsAlpha;
    }

    public static void setXSpacing(int sp, int fontid) {
        FontManagerEx._xSpacing[fontid] = sp;
    }

    public static void setYSpacing(int sp, int fontid) {
        FontManagerEx._ySpacing[fontid] = sp;
    }

    public static char byte2char(byte ch) {
        if (ch < 0) {
            switch (ch) {
                case -88: {
                    return (char)(ch + 9 - 64432);
                }
                case -72: {
                    return (char)(ch + 73 - 64432);
                }
                case -71: {
                    return (char)(ch + 7437 - 64432);
                }
            }
            return (char)(ch - 64432);
        }
        return (char)ch;
    }

    static void loadIni(byte[] iniFile, int id) {
        int c = 0;
        StringBuffer tmpStrBuf = new StringBuffer();
        while (iniFile[c] != 13) {
            tmpStrBuf.append(FontManagerEx.byte2char(iniFile[c]));
            ++c;
        }
        FontManagerEx.alph[id] = new String(tmpStrBuf);
        tmpStrBuf = null;
        FontManagerEx.fontLength[id] = alph[id].length();
        ++c;
        FontManagerEx.SpaceW[id] = 0;
        ++c;
        while (iniFile[c] != 13) {
            FontManagerEx.SpaceW[id] = 10 * SpaceW[id] + (iniFile[c] - 48);
            ++c;
        }
        ++c;
        iniFile = null;
    }

    public static void setFont(int id) {
        curFont = id;
    }

    public static int getFont() {
        return curFont;
    }

    public static void setXSpacing(int newSpacing) {
        FontManagerEx._xSpacing[FontManagerEx.curFont] = newSpacing;
    }

    public static void setYSpacing(int newSpacing) {
        FontManagerEx._ySpacing[FontManagerEx.curFont] = newSpacing;
    }

    public static int getHeight() {
        return cellH[curFont] + _ySpacing[curFont];
    }

    public static int getHeight(int fID) {
        return cellH[fID];
    }

    public static void setGraphics(Graphics newg) {
        g = newg;
    }

    static void setClip_(int aX, int aY, int aWidth, int aHeight) {
        if (enableTextClip) {
            int resX = aX > clipX ? aX : clipX;
            int resW = clipX + clipW - resX < aX + aWidth - resX ? clipX + clipW - resX : aX + aWidth - resX;
            int resY = aY > clipY ? aY : clipY;
            int resH = clipY + clipH - resY < aY + aHeight - resY ? clipY + clipH - resY : aY + aHeight - resY;
            g.setClip(resX, resY, resW, resH);
        } else {
            g.setClip(aX, aY, aWidth, aHeight);
        }
    }

    public static int charWidth(char ch) {
        if (ch == ' ') {
            return SpaceW[curFont];
        }
        if (ch == '\t') {
            return tabInSpaces * SpaceW[curFont];
        }
        return ShiftsCuts[curFont][FontManagerEx.getIndex(ch) * 4 + 2];
    }

    public static int charWidth(int FID, char ch) {
        if (ch == ' ') {
            return SpaceW[FID];
        }
        if (ch == '\t') {
            return tabInSpaces * SpaceW[FID];
        }
        return ShiftsCuts[FID][FontManagerEx.getIndex(ch) * 4 + 2];
    }

    public static int stringWidth(int FID, String s) {
        int w = 0;
        for (int i = 0; i < s.length(); ++i) {
            w += FontManagerEx.charWidth(FID, s.charAt(i)) + _xSpacing[FID];
        }
        return w;
    }

    public static int stringWidth(String s) {
        int w = 0;
        for (int i = 0; i < s.length(); ++i) {
            w += FontManagerEx.charWidth(s.charAt(i)) + _xSpacing[curFont];
        }
        return w;
    }

    public static int stringWidth(String s, int fromIndex, int lastIndex) {
        int w = 0;
        int lInd = lastIndex >= fromIndex ? lastIndex : s.length();
        for (int i = fromIndex; i < lInd; ++i) {
            w += FontManagerEx.charWidth(s.charAt(i)) + _xSpacing[curFont];
        }
        if (w > 0) {
            w -= _xSpacing[curFont];
        }
        return w;
    }

    static int getIndex(int alpha) {
        int letter = alph[curFont].indexOf(alpha);
        if (letter < 0) {
            return 0;
        }
        return letter;
    }

    static int getIndex(int alpha, int fID) {
        int letter = alph[fID].indexOf(alpha);
        if (letter < 0) {
            return 0;
        }
        return letter;
    }

    public static void drawString(String s, int x, int y, int flag) {
        FontManagerEx.drawString(s, x, y, flag, curFont);
    }

    public static void drawString(String s, int x, int y, int flag, int fID) {
        int xfrom = x;
        if ((flag & 1) != 0) {
            xfrom -= FontManagerEx.stringWidth(s) / 2;
        } else if ((flag & 8) != 0) {
            xfrom -= FontManagerEx.stringWidth(s);
        }
        if ((flag & 2) != 0) {
            y -= FontManagerEx.getHeight() / 2;
        } else if ((flag & 0x20) != 0) {
            y -= FontManagerEx.getHeight();
        }
        for (int i = 0; i < s.length(); ++i) {
            char curChar = s.charAt(i);
            if (curChar != ' ' && curChar != '\t') {
                int letter = FontManagerEx.getIndex(s.charAt(i), fID);
                int ind4 = letter * 4;
                int ind2 = letter * 2;
                g.drawRegion(iFont[fID], (int)ShiftsCuts[fID][ind4], (int)ShiftsCuts[fID][ind4 + 1], (int)ShiftsCuts[fID][ind4 + 2], (int)ShiftsCuts[fID][ind4 + 3], 0, xfrom + ShiftsAlpha[fID][ind2 + 2], y + ShiftsAlpha[fID][ind2 + 3], 4 | 0x10);
                xfrom += ShiftsCuts[fID][ind4 + 2] + _xSpacing[fID];
                continue;
            }
            if (curChar == ' ') {
                xfrom += SpaceW[fID] + _xSpacing[fID];
                continue;
            }
            if (curChar != '\t') continue;
            xfrom += tabInSpaces * SpaceW[fID] + _xSpacing[fID];
        }
    }

    public static int drawStringEx(String s, int x, int y, int flag) {
        int slashNIndex;
        int xfrom = x;
        int linesNum = 0;
        int firstIndex = 0;
        do {
            int slashNIndexReal;
            ++linesNum;
            slashNIndex = s.indexOf("\\n", firstIndex);
            int tempInd = s.indexOf("\\N", firstIndex);
            if (tempInd > -1 && tempInd < slashNIndex) {
                slashNIndex = tempInd;
            }
            if ((slashNIndexReal = s.indexOf(NewLine, firstIndex)) > -1 && (slashNIndexReal < slashNIndex || slashNIndex == -1)) {
                slashNIndex = slashNIndexReal;
            }
            int slashTIndex = s.indexOf("\\t", firstIndex);
            tempInd = s.indexOf("\\T", firstIndex);
            if (tempInd > -1 && tempInd < slashTIndex) {
                slashTIndex = tempInd;
            }
            xfrom = x;
            if ((flag & 1) != 0) {
                xfrom -= FontManagerEx.stringWidth(s, firstIndex, slashNIndex) / 2;
            } else if ((flag & 8) != 0) {
                xfrom -= FontManagerEx.stringWidth(s, firstIndex, slashNIndex);
            }
            if ((flag & 2) != 0) {
                y -= FontManagerEx.getHeight() / 2;
            } else if ((flag & 0x20) != 0) {
                y -= FontManagerEx.getHeight();
            }
            int lInd = slashNIndex > -1 ? slashNIndex : s.length();
            for (int i = firstIndex; i < lInd; ++i) {
                if (slashTIndex != i) {
                    char curChar = s.charAt(i);
                    if (curChar != ' ' && curChar != '\t') {
                        int letter = FontManagerEx.getIndex(s.charAt(i));
                        int ind4 = letter * 4;
                        int ind2 = letter * 2;
                        g.drawRegion(iFont[curFont], (int)ShiftsCuts[curFont][ind4], (int)ShiftsCuts[curFont][ind4 + 1], (int)ShiftsCuts[curFont][ind4 + 2], (int)ShiftsCuts[curFont][ind4 + 3], 0, xfrom + ShiftsAlpha[curFont][ind2 + 2], y + ShiftsAlpha[curFont][ind2 + 3], 4 | 0x10);
                        xfrom += ShiftsCuts[curFont][ind4 + 2] + _xSpacing[curFont];
                        continue;
                    }
                    if (curChar == ' ') {
                        xfrom += SpaceW[curFont] + _xSpacing[curFont];
                        continue;
                    }
                    if (curChar != '\t') continue;
                    xfrom += tabInSpaces * SpaceW[curFont] + _xSpacing[curFont];
                    continue;
                }
                xfrom += tabInSpaces * SpaceW[curFont] + _xSpacing[curFont];
                slashTIndex = s.indexOf("\\t", ++i);
                tempInd = s.indexOf("\\T", i);
                if (tempInd <= -1 || tempInd >= slashTIndex) continue;
                slashTIndex = tempInd;
            }
            firstIndex = slashNIndex + 2;
            y += cellH[curFont];
        } while (slashNIndex != -1);
        return linesNum;
    }

    public static int getStringLinesCount(String s) {
        int slashNIndex;
        int linesNum = 0;
        int firstIndex = 0;
        do {
            int slashNIndexReal;
            ++linesNum;
            slashNIndex = s.indexOf("\\n", firstIndex);
            int tempInd = s.indexOf("\\N", firstIndex);
            if (tempInd > -1 && tempInd < slashNIndex) {
                slashNIndex = tempInd;
            }
            if ((slashNIndexReal = s.indexOf(NewLine, firstIndex)) > -1 && (slashNIndexReal < slashNIndex || slashNIndex == -1)) {
                slashNIndex = slashNIndexReal;
            }
            firstIndex = slashNIndex + 2;
        } while (slashNIndex != -1);
        return linesNum;
    }

    public static int lineNum(int fID, String s, int w) {
        int result = 0;
        String[] strBuf = new String[2];
        strBuf[1] = s;
        while (strBuf[1].length() != 0) {
            FontManagerEx.popLine(fID, strBuf, w);
            ++result;
        }
        return result;
    }

    public static int lineNum(String s) {
        return FontManagerEx.lineNum(curFont, s, pageW);
    }

    public static int lineNum(int fID, String s) {
        return FontManagerEx.lineNum(fID, s, pageW);
    }

    public static void popLine(int fID, String[] s, int w) {
        int curW = 0;
        int curAlpha = 0;
        int lastAlpha = 0;
        for (curAlpha = 0; curAlpha < s[1].length() && s[1].charAt(curAlpha) == ' '; ++curAlpha) {
        }
        s[1] = s[1].substring(curAlpha);
        boolean slashN = false;
        for (curAlpha = 0; curAlpha < s[1].length(); ++curAlpha) {
            char curChar = s[1].charAt(curAlpha);
            if (curChar == ' ') {
                lastAlpha = curAlpha;
            }
            if (curChar == '\n') {
                lastAlpha = curAlpha;
                slashN = true;
                break;
            }
            curW = curChar != ' ' ? (curW += ShiftsCuts[fID][FontManagerEx.getIndex(s[1].charAt(curAlpha)) * 4 + 2] + _xSpacing[fID]) : (curW += SpaceW[fID] + _xSpacing[fID]);
            if (curW > w) break;
        }
        if (curAlpha >= s[1].length()) {
            s[0] = s[1];
            s[1] = "";
        } else if (lastAlpha == 0 && !slashN) {
            s[0] = s[1].substring(0, curAlpha);
            s[1] = s[1].substring(curAlpha);
        } else {
            s[0] = s[1].substring(0, lastAlpha);
            s[1] = s[1].substring(lastAlpha + 1);
        }
    }

    public static int getPageX() {
        return pageX;
    }

    public static int getPageY() {
        return pageY;
    }

    public static int getPageWidth() {
        return pageW;
    }

    public static int getPageHeight() {
        return pageH;
    }

    public static void setPageX(int X) {
        pageX = X;
    }

    public static void setPageY(int Y) {
        pageY = Y;
    }

    public static void setPageWidth(int W) {
        pageW = W;
    }

    public static void setPageHeight(int H) {
        pageH = H;
    }

    public static void setPage(int X, int Y, int W, int H) {
        pageX = X;
        pageY = Y;
        pageW = W;
        pageH = H;
    }

    public static void drawPage(String str, int yshift, int alignment, boolean onlyWholeLine) {
        int xfrom = pageX;
        int yfrom = pageY + yshift;
        int x1 = pageX + pageW;
        int y1 = pageY + pageH;
        int tmpClX = clipX = g.getClipX();
        int tmpClY = clipY = g.getClipY();
        int tmpClW = clipW = g.getClipWidth();
        int tmpClH = clipH = g.getClipHeight();
        FontManagerEx.setClip_(pageX, pageY, pageW, pageH);
        String[] strBuf = new String[]{"", str};
        if ((alignment & 1) != 0) {
            xfrom += pageW / 2;
        } else if ((alignment & 8) != 0) {
            xfrom += pageW;
        }
        if (onlyWholeLine) {
            while (yfrom + FontManagerEx.getHeight() <= y1) {
                FontManagerEx.popLine(curFont, strBuf, pageW);
                if (yfrom >= pageY) {
                    FontManagerEx.drawString(strBuf[0], xfrom, yfrom, alignment);
                }
                yfrom += FontManagerEx.getHeight();
            }
        } else {
            while (yfrom <= y1) {
                FontManagerEx.popLine(curFont, strBuf, pageW);
                if (yfrom + FontManagerEx.getHeight() > pageY) {
                    FontManagerEx.drawString(strBuf[0], xfrom, yfrom, alignment);
                }
                yfrom += FontManagerEx.getHeight();
            }
        }
        g.setClip(tmpClX, tmpClY, tmpClW, tmpClH);
    }

    public static String bytes2String(byte[] str) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < str.length; ++i) {
            int tmpCh = FontManagerEx.byte2char(str[i]);
            if (tmpCh == 13 && (tmpCh = FontManagerEx.byte2char(str[++i])) == 110) {
                tmpCh = 10;
            }
            result.append((char)tmpCh);
        }
        return new String(result);
    }

    static {
        clipX = 0;
        clipY = 0;
        clipW = 200000;
        clipH = 200000;
        enableTextClip = false;
        tabInSpaces = (byte)4;
    }
}

