/*
 * Decompiled with CFR 0.152.
 */
package com.alsigames.animations;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ComplexPicture {
    protected Image cpImage = null;
    protected int[] cpShiftX = null;
    protected int[] cpShiftY = null;
    protected int[] cpWidth = null;
    protected int[] cpHeight = null;

    public ComplexPicture(Image img, byte[] data) {
        this.cpImage = img;
        this.loadOPR(data);
    }

    public Image GetImage() {
        return this.cpImage;
    }

    public int GetShiftX(int num) {
        if (this.cpShiftX != null && num >= 0 && num < this.cpShiftX.length) {
            return this.cpShiftX[num];
        }
        return 0;
    }

    public int GetShiftY(int num) {
        if (this.cpShiftY != null && num >= 0 && num < this.cpShiftY.length) {
            return this.cpShiftY[num];
        }
        return 0;
    }

    public int GetWidth(int num) {
        if (this.cpWidth != null && num >= 0 && num < this.cpWidth.length) {
            return this.cpWidth[num];
        }
        return 0;
    }

    public int GetHeight(int num) {
        if (this.cpHeight != null && num >= 0 && num < this.cpHeight.length) {
            return this.cpHeight[num];
        }
        return 0;
    }

    protected void loadOPR(byte[] res_byte) {
        if (res_byte != null) {
            byte type = res_byte[0];
            int size = 0xFF & res_byte[1];
            this.cpShiftX = new int[size];
            this.cpShiftY = new int[size];
            this.cpWidth = new int[size];
            this.cpHeight = new int[size];
            switch (type) {
                case 1: {
                    int total_size = size * 5;
                    for (int i = 0; i < total_size; i += 5) {
                        int t = 0xFF & res_byte[i + 2];
                        this.cpShiftX[t] = 0xFF & res_byte[i + 1 + 2];
                        this.cpShiftY[t] = 0xFF & res_byte[i + 2 + 2];
                        this.cpWidth[t] = 0xFF & res_byte[i + 3 + 2];
                        this.cpHeight[t] = 0xFF & res_byte[i + 4 + 2];
                    }
                    break;
                }
                case 2: {
                    int total_size = size * 10;
                    for (int i = 0; i < total_size; i += 10) {
                        int t = 0xFFFF & ((0xFF & res_byte[i + 2]) << 8 | 0xFF & res_byte[i + 1 + 2]);
                        this.cpShiftX[t] = 0xFFFF & ((0xFF & res_byte[i + 2 + 2]) << 8 | 0xFF & res_byte[i + 3 + 2]);
                        this.cpShiftY[t] = 0xFFFF & ((0xFF & res_byte[i + 4 + 2]) << 8 | 0xFF & res_byte[i + 5 + 2]);
                        this.cpWidth[t] = 0xFFFF & ((0xFF & res_byte[i + 6 + 2]) << 8 | 0xFF & res_byte[i + 7 + 2]);
                        this.cpHeight[t] = 0xFFFF & ((0xFF & res_byte[i + 8 + 2]) << 8 | 0xFF & res_byte[i + 9 + 2]);
                    }
                    break;
                }
            }
        }
    }

    public final void FillWidthByFrame(Graphics g, int index, int screenX, int screenY, int width) {
        int startW;
        int w = startW = this.cpWidth[index];
        int shift = 0;
        if (w > width) {
            w = width;
        }
        if (width > 0) {
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipW = g.getClipWidth();
            int clipH = g.getClipHeight();
            g.setClip(screenX, screenY, width, this.cpHeight[index]);
            while (w > 0) {
                this.Draw(g, index, screenX + shift, screenY);
                if ((shift += w) < width) continue;
            }
            g.setClip(clipX, clipY, clipW, clipH);
        }
    }

    public final void Draw(Graphics g, int index, int screenX, int screenY) {
        g.drawRegion(this.cpImage, this.cpShiftX[index], this.cpShiftY[index], this.cpWidth[index], this.cpHeight[index], 0, screenX, screenY, 20);
    }

    public final void Draw(Graphics g, int index, int screenX, int screenY, int anchor) {
        g.drawRegion(this.cpImage, this.cpShiftX[index], this.cpShiftY[index], this.cpWidth[index], this.cpHeight[index], 0, screenX, screenY, anchor);
    }

    public final void Draw(Graphics g, int index, int screenX, int screenY, int anchor, int filter) {
        g.drawRegion(this.cpImage, this.cpShiftX[index], this.cpShiftY[index], this.cpWidth[index], this.cpHeight[index], filter, screenX, screenY, anchor);
    }
}

