/*
 * Decompiled with CFR 0.152.
 */
package com.alsigames.animations;

import com.alsigames.animations.AnimationData;
import com.alsigames.animations.ComplexPicture;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AnimationComplexPicture
extends ComplexPicture {
    public int[] AnimWidth = null;
    public int[] AnimHeight = null;
    public int[] AnimShiftX = null;
    public int[] AnimShiftY = null;
    public int[][] AnimIndex = null;
    public int[][] AnimPartX = null;
    public int[][] AnimPartY = null;
    public int[][] AnimSequenceIndex = null;
    public int[][] AnimSequenceTime = null;
    public long[] AnimSequenceTotalTime = null;
    int totalWidth = 0;
    int totalHeight = 0;

    public AnimationComplexPicture(Image img, byte[] data, int ansCount) {
        super(img, data);
        this.AnimSequenceIndex = new int[ansCount][];
        this.AnimSequenceTime = new int[ansCount][];
        this.AnimSequenceTotalTime = new long[ansCount];
    }

    public void loadANM(byte[] res_byte) {
        this.loadANM(res_byte, 1);
    }

    public void loadANM(byte[] res_byte, int type) {
        if (res_byte != null) {
            int ind = 0;
            int size = 0;
            if (type == 1) {
                size = 0xFF & res_byte[0];
                ++ind;
            } else if (type == 2) {
                size = 0xFFFF & ((0xFF & res_byte[ind]) << 8 | 0xFF & res_byte[ind + 1]);
                ind += 2;
            }
            this.AnimWidth = new int[size];
            this.AnimHeight = new int[size];
            this.AnimShiftX = new int[size];
            this.AnimShiftY = new int[size];
            this.AnimIndex = new int[size][];
            this.AnimPartX = new int[size][];
            this.AnimPartY = new int[size][];
            for (int i = 0; i < size; ++i) {
                int count = 0;
                if (type == 1) {
                    count = 0xFF & res_byte[ind++];
                    this.AnimShiftX[i] = res_byte[ind++];
                    this.AnimShiftY[i] = res_byte[ind++];
                } else if (type == 2) {
                    count = 0xFFFF & ((0xFF & res_byte[ind]) << 8 | 0xFF & res_byte[ind + 1]);
                    this.AnimShiftX[i] = (short)((0xFF & res_byte[ind += 2]) << 8 | 0xFF & res_byte[ind + 1]);
                    this.AnimShiftY[i] = (short)((0xFF & res_byte[ind += 2]) << 8 | 0xFF & res_byte[ind + 1]);
                    ind += 2;
                }
                this.AnimIndex[i] = new int[count];
                this.AnimPartX[i] = new int[count];
                this.AnimPartY[i] = new int[count];
                this.AnimWidth[i] = 0;
                this.AnimHeight[i] = 0;
                for (int j = 0; j < count; ++j) {
                    if (type == 1) {
                        this.AnimIndex[i][j] = 0xFF & res_byte[ind++];
                        this.AnimPartX[i][j] = res_byte[ind++];
                        this.AnimPartY[i][j] = res_byte[ind++];
                    } else if (type == 2) {
                        this.AnimIndex[i][j] = 0xFFFF & ((0xFF & res_byte[ind]) << 8 | 0xFF & res_byte[ind + 1]);
                        this.AnimPartX[i][j] = (short)((0xFF & res_byte[ind += 2]) << 8 | 0xFF & res_byte[ind + 1]);
                        this.AnimPartY[i][j] = (short)((0xFF & res_byte[ind += 2]) << 8 | 0xFF & res_byte[ind + 1]);
                        ind += 2;
                    }
                    if (this.AnimPartX[i][j] + this.cpWidth[this.AnimIndex[i][j]] > this.AnimWidth[i]) {
                        this.AnimWidth[i] = this.AnimPartX[i][j] + this.cpWidth[this.AnimIndex[i][j]];
                    }
                    if (this.AnimPartY[i][j] + this.cpHeight[this.AnimIndex[i][j]] <= this.AnimHeight[i]) continue;
                    this.AnimHeight[i] = this.AnimPartY[i][j] + this.cpHeight[this.AnimIndex[i][j]];
                }
            }
        }
    }

    public void loadANS(int index, byte[] res_byte) {
        if (res_byte != null) {
            int size = 0xFF & res_byte[0];
            this.AnimSequenceIndex[index] = new int[size];
            this.AnimSequenceTime[index] = new int[size];
            this.AnimSequenceTotalTime[index] = 0L;
            int ind = 1;
            for (int i = 0; i < size; ++i) {
                this.AnimSequenceIndex[index][i] = (res_byte[ind] & 0xFF) + ((res_byte[ind + 1] & 0xFF) << 8);
                this.AnimSequenceTime[index][i] = (res_byte[ind += 2] & 0xFF) + ((res_byte[ind + 1] & 0xFF) << 8);
                ind += 2;
                int n = index;
                this.AnimSequenceTotalTime[n] = this.AnimSequenceTotalTime[n] + (long)this.AnimSequenceTime[index][i];
            }
        }
    }

    public int getFrame(int ansIndex, long time, boolean isCicle) {
        int frameIndex = -1;
        if (this.AnimSequenceTime[ansIndex] == null) {
            return -1;
        }
        if (time >= this.AnimSequenceTotalTime[ansIndex]) {
            if (isCicle) {
                time %= this.AnimSequenceTotalTime[ansIndex];
            } else {
                return -1;
            }
        }
        long timeTemp = 0L;
        for (int i = 0; i < this.AnimSequenceTime[ansIndex].length; ++i) {
            if (timeTemp + (long)this.AnimSequenceTime[ansIndex][i] > time) {
                frameIndex = i;
                break;
            }
            timeTemp += (long)this.AnimSequenceTime[ansIndex][i];
        }
        return frameIndex;
    }

    public int getAnimFrame(int ansIndex, int frameIndex) {
        int index = 0;
        if (ansIndex > -1 && ansIndex < this.AnimSequenceIndex.length && frameIndex > -1 && frameIndex < this.AnimSequenceIndex[ansIndex].length) {
            index = this.AnimSequenceIndex[ansIndex][frameIndex];
        }
        return index;
    }

    public final void Draw(Graphics g, int ansIndex, long time, int screenX, int screenY, int anchorType, int filter, boolean isCicle) {
        int frameIndex = this.getFrame(ansIndex, time, isCicle);
        this.Draw(g, ansIndex, frameIndex, screenX, screenY, anchorType, filter);
    }

    public final void Draw(Graphics g, int ansIndex, int frameIndex, int screenX, int screenY, int anchorType, int filter) {
        if (frameIndex > -1) {
            this.DrawFrame(g, this.AnimSequenceIndex[ansIndex][frameIndex], screenX, screenY, anchorType, filter);
        }
    }

    public final void DrawFrame(Graphics g, int anmIndex, int screenX, int screenY) {
        this.DrawFrame(g, anmIndex, screenX, screenY, 20, 0);
    }

    public final void DrawFrame(Graphics g, int anmIndex, int screenX, int screenY, int anchorType) {
        this.DrawFrame(g, anmIndex, screenX, screenY, anchorType, 0);
    }

    public final void DrawFrame(Graphics g, int anmIndex, int screenX, int screenY, int anchorType, int filter) {
        if (anmIndex >= 0 && anmIndex < this.AnimIndex.length) {
            int anmInd = anmIndex;
            int count = this.AnimIndex[anmInd].length;
            int[] animSeqInd = this.AnimIndex[anmInd];
            for (int i = 0; i < count; ++i) {
                int shiftX = 0;
                int shiftY = 0;
                if ((anchorType & 4) != 0) {
                    switch (filter) {
                        case 0: {
                            shiftX = this.AnimPartX[anmInd][i] + this.AnimShiftX[anmInd];
                            break;
                        }
                        case 2: {
                            shiftX = -this.AnimPartX[anmInd][i] - this.AnimShiftX[anmInd] - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 5: {
                            shiftY = this.AnimPartX[anmInd][i] + this.AnimShiftX[anmInd];
                            break;
                        }
                        case 3: {
                            shiftX = -(this.AnimPartX[anmInd][i] + this.AnimShiftX[anmInd]) - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 6: {
                            shiftY = -(this.AnimPartX[anmInd][i] + this.AnimShiftX[anmInd]) - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 7: {
                            shiftY = -(this.AnimPartX[anmInd][i] + this.AnimShiftX[anmInd]) - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 1: {
                            shiftX = this.AnimPartX[anmInd][i] + this.AnimShiftX[anmInd];
                            break;
                        }
                        case 4: {
                            shiftY = this.AnimPartX[anmInd][i] + this.AnimShiftX[anmInd];
                        }
                    }
                } else if ((anchorType & 8) != 0) {
                    switch (filter) {
                        case 0: {
                            shiftX = this.AnimPartX[anmInd][i] + this.AnimShiftX[anmInd] - this.AnimWidth[anmInd];
                            break;
                        }
                        case 2: {
                            shiftX = this.AnimWidth[anmInd] - this.AnimPartX[anmInd][i] - this.AnimShiftX[anmInd] - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 5: {
                            shiftY = this.AnimPartX[anmInd][i] + this.AnimShiftX[anmInd] - this.AnimWidth[anmInd];
                            break;
                        }
                        case 3: {
                            shiftX = -(this.AnimPartX[anmInd][i] + this.AnimShiftX[anmInd] - this.AnimWidth[anmInd]) - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 6: {
                            shiftY = -(this.AnimPartX[anmInd][i] + this.AnimShiftX[anmInd] - this.AnimWidth[anmInd]) - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 7: {
                            shiftY = this.AnimWidth[anmInd] - this.AnimPartX[anmInd][i] - this.AnimShiftX[anmInd] - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 1: {
                            shiftX = this.AnimPartX[anmInd][i] + this.AnimShiftX[anmInd] - this.AnimWidth[anmInd];
                            break;
                        }
                        case 4: {
                            shiftY = this.AnimPartX[anmInd][i] + this.AnimShiftX[anmInd] - this.AnimWidth[anmInd];
                        }
                    }
                } else {
                    switch (filter) {
                        case 0: {
                            shiftX = this.AnimPartX[anmInd][i] + this.AnimShiftX[anmInd] - this.AnimWidth[anmInd] / 2;
                            break;
                        }
                        case 2: {
                            shiftX = this.AnimWidth[anmInd] / 2 - this.AnimPartX[anmInd][i] - this.AnimShiftX[anmInd] - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 5: {
                            shiftY = this.AnimPartX[anmInd][i] + this.AnimShiftX[anmInd] - this.AnimWidth[anmInd] / 2;
                            break;
                        }
                        case 3: {
                            shiftX = -(this.AnimPartX[anmInd][i] + this.AnimShiftX[anmInd] - this.AnimWidth[anmInd] / 2) - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 6: {
                            shiftY = -(this.AnimPartX[anmInd][i] + this.AnimShiftX[anmInd] - this.AnimWidth[anmInd] / 2) - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 7: {
                            shiftY = this.AnimWidth[anmInd] / 2 - (this.AnimPartX[anmInd][i] + this.AnimShiftX[anmInd]) - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 1: {
                            shiftX = this.AnimPartX[anmInd][i] + this.AnimShiftX[anmInd] - this.AnimWidth[anmInd] / 2;
                            break;
                        }
                        case 4: {
                            shiftY = this.AnimPartX[anmInd][i] + this.AnimShiftX[anmInd] - this.AnimWidth[anmInd] / 2;
                        }
                    }
                }
                if ((anchorType & 0x10) != 0) {
                    switch (filter) {
                        case 0: {
                            shiftY = this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd];
                            break;
                        }
                        case 2: {
                            shiftY = this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd];
                            break;
                        }
                        case 5: {
                            shiftX = -(this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd]) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 3: {
                            shiftY = -(this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd]) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 6: {
                            shiftX = this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd];
                            break;
                        }
                        case 7: {
                            shiftX = -(this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd]) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 1: {
                            shiftY = -(this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd]) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 4: {
                            shiftX = this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd];
                        }
                    }
                } else if ((anchorType & 0x20) != 0) {
                    switch (filter) {
                        case 0: {
                            shiftY = this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd] - this.AnimHeight[anmInd];
                            break;
                        }
                        case 2: {
                            shiftY = this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd] - this.AnimHeight[anmInd];
                            break;
                        }
                        case 5: {
                            shiftX = -(this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd] - this.AnimHeight[anmInd]) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 3: {
                            shiftY = -(this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd] - this.AnimHeight[anmInd]) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 6: {
                            shiftX = this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd] - this.AnimHeight[anmInd];
                            break;
                        }
                        case 7: {
                            shiftX = this.AnimHeight[anmInd] - this.AnimPartY[anmInd][i] - this.AnimShiftY[anmInd] - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 1: {
                            shiftY = -(this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd] - this.AnimHeight[anmInd]) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 4: {
                            shiftX = this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd] - this.AnimHeight[anmInd];
                        }
                    }
                } else {
                    switch (filter) {
                        case 0: {
                            shiftY = this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd] - this.AnimHeight[anmInd] / 2;
                            break;
                        }
                        case 2: {
                            shiftY = this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd] - this.AnimHeight[anmInd] / 2;
                            break;
                        }
                        case 5: {
                            shiftX = -(this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd] - this.AnimHeight[anmInd] / 2) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 3: {
                            shiftY = -(this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd] - this.AnimHeight[anmInd] / 2) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 6: {
                            shiftX = this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd] - this.AnimHeight[anmInd] / 2;
                            break;
                        }
                        case 7: {
                            shiftX = -(this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd] - this.AnimHeight[anmInd] / 2) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 1: {
                            shiftY = -(this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd] - this.AnimHeight[anmInd] / 2) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 4: {
                            shiftX = this.AnimPartY[anmInd][i] + this.AnimShiftY[anmInd] - this.AnimHeight[anmInd] / 2;
                        }
                    }
                }
                super.Draw(g, animSeqInd[i], screenX + shiftX, screenY + shiftY, 20, filter);
            }
        }
    }

    public final void DrawFrame(Graphics g, int anmIndex, int screenX, int screenY, AnimationData ad) {
        this.DrawFrame(g, anmIndex, screenX, screenY, 20, 0, ad);
    }

    public final void DrawFrame(Graphics g, int anmIndex, int screenX, int screenY, int anchorType, AnimationData ad) {
        this.DrawFrame(g, anmIndex, screenX, screenY, anchorType, 0, ad);
    }

    public final void DrawFrame(Graphics g, int anmIndex, int screenX, int screenY, int anchorType, int filter, AnimationData ad) {
        if (anmIndex >= 0 && anmIndex < ad.AnimIndex.length) {
            int anmInd = anmIndex;
            int count = ad.AnimIndex[anmInd].length;
            int[] animSeqInd = ad.AnimIndex[anmInd];
            for (int i = 0; i < count; ++i) {
                int shiftX = 0;
                int shiftY = 0;
                if ((anchorType & 4) != 0) {
                    switch (filter) {
                        case 0: {
                            shiftX = ad.AnimPartX[anmInd][i] + ad.AnimShiftX[anmInd];
                            break;
                        }
                        case 2: {
                            shiftX = -ad.AnimPartX[anmInd][i] - ad.AnimShiftX[anmInd] - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 5: {
                            shiftY = ad.AnimPartX[anmInd][i] + ad.AnimShiftX[anmInd];
                            break;
                        }
                        case 3: {
                            shiftX = -(ad.AnimPartX[anmInd][i] + ad.AnimShiftX[anmInd]) - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 6: {
                            shiftY = -(ad.AnimPartX[anmInd][i] + ad.AnimShiftX[anmInd]) - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 7: {
                            shiftY = -(ad.AnimPartX[anmInd][i] + ad.AnimShiftX[anmInd]) - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 1: {
                            shiftX = ad.AnimPartX[anmInd][i] + ad.AnimShiftX[anmInd];
                            break;
                        }
                        case 4: {
                            shiftY = ad.AnimPartX[anmInd][i] + ad.AnimShiftX[anmInd];
                        }
                    }
                } else if ((anchorType & 8) != 0) {
                    switch (filter) {
                        case 0: {
                            shiftX = ad.AnimPartX[anmInd][i] + ad.AnimShiftX[anmInd] - ad.AnimWidth[anmInd];
                            break;
                        }
                        case 2: {
                            shiftX = ad.AnimWidth[anmInd] - ad.AnimPartX[anmInd][i] - ad.AnimShiftX[anmInd] - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 5: {
                            shiftY = ad.AnimPartX[anmInd][i] + ad.AnimShiftX[anmInd] - ad.AnimWidth[anmInd];
                            break;
                        }
                        case 3: {
                            shiftX = -(ad.AnimPartX[anmInd][i] + ad.AnimShiftX[anmInd] - ad.AnimWidth[anmInd]) - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 6: {
                            shiftY = -(ad.AnimPartX[anmInd][i] + ad.AnimShiftX[anmInd] - ad.AnimWidth[anmInd]) - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 7: {
                            shiftY = ad.AnimWidth[anmInd] - ad.AnimPartX[anmInd][i] - ad.AnimShiftX[anmInd] - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 1: {
                            shiftX = ad.AnimPartX[anmInd][i] + ad.AnimShiftX[anmInd] - ad.AnimWidth[anmInd];
                            break;
                        }
                        case 4: {
                            shiftY = ad.AnimPartX[anmInd][i] + ad.AnimShiftX[anmInd] - ad.AnimWidth[anmInd];
                        }
                    }
                } else {
                    switch (filter) {
                        case 0: {
                            shiftX = ad.AnimPartX[anmInd][i] + ad.AnimShiftX[anmInd] - ad.AnimWidth[anmInd] / 2;
                            break;
                        }
                        case 2: {
                            shiftX = ad.AnimWidth[anmInd] / 2 - ad.AnimPartX[anmInd][i] - ad.AnimShiftX[anmInd] - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 5: {
                            shiftY = ad.AnimPartX[anmInd][i] + ad.AnimShiftX[anmInd] - ad.AnimWidth[anmInd] / 2;
                            break;
                        }
                        case 3: {
                            shiftX = -(ad.AnimPartX[anmInd][i] + ad.AnimShiftX[anmInd] - ad.AnimWidth[anmInd] / 2) - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 6: {
                            shiftY = -(ad.AnimPartX[anmInd][i] + ad.AnimShiftX[anmInd] - ad.AnimWidth[anmInd] / 2) - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 7: {
                            shiftY = ad.AnimWidth[anmInd] / 2 - (ad.AnimPartX[anmInd][i] + ad.AnimShiftX[anmInd]) - this.cpWidth[animSeqInd[i]];
                            break;
                        }
                        case 1: {
                            shiftX = ad.AnimPartX[anmInd][i] + ad.AnimShiftX[anmInd] - ad.AnimWidth[anmInd] / 2;
                            break;
                        }
                        case 4: {
                            shiftY = ad.AnimPartX[anmInd][i] + ad.AnimShiftX[anmInd] - ad.AnimWidth[anmInd] / 2;
                        }
                    }
                }
                if ((anchorType & 0x10) != 0) {
                    switch (filter) {
                        case 0: {
                            shiftY = ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd];
                            break;
                        }
                        case 2: {
                            shiftY = ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd];
                            break;
                        }
                        case 5: {
                            shiftX = -(ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd]) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 3: {
                            shiftY = -(ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd]) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 6: {
                            shiftX = ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd];
                            break;
                        }
                        case 7: {
                            shiftX = -(ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd]) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 1: {
                            shiftY = -(ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd]) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 4: {
                            shiftX = ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd];
                        }
                    }
                } else if ((anchorType & 0x20) != 0) {
                    switch (filter) {
                        case 0: {
                            shiftY = ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd] - ad.AnimHeight[anmInd];
                            break;
                        }
                        case 2: {
                            shiftY = ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd] - ad.AnimHeight[anmInd];
                            break;
                        }
                        case 5: {
                            shiftX = -(ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd] - ad.AnimHeight[anmInd]) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 3: {
                            shiftY = -(ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd] - ad.AnimHeight[anmInd]) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 6: {
                            shiftX = ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd] - ad.AnimHeight[anmInd];
                            break;
                        }
                        case 7: {
                            shiftX = ad.AnimHeight[anmInd] - ad.AnimPartY[anmInd][i] - ad.AnimShiftY[anmInd] - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 1: {
                            shiftY = -(ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd] - ad.AnimHeight[anmInd]) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 4: {
                            shiftX = ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd] - ad.AnimHeight[anmInd];
                        }
                    }
                } else {
                    switch (filter) {
                        case 0: {
                            shiftY = ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd] - ad.AnimHeight[anmInd] / 2;
                            break;
                        }
                        case 2: {
                            shiftY = ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd] - ad.AnimHeight[anmInd] / 2;
                            break;
                        }
                        case 5: {
                            shiftX = -(ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd] - ad.AnimHeight[anmInd] / 2) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 3: {
                            shiftY = -(ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd] - ad.AnimHeight[anmInd] / 2) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 6: {
                            shiftX = ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd] - ad.AnimHeight[anmInd] / 2;
                            break;
                        }
                        case 7: {
                            shiftX = -(ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd] - ad.AnimHeight[anmInd] / 2) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 1: {
                            shiftY = -(ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd] - ad.AnimHeight[anmInd] / 2) - this.cpHeight[animSeqInd[i]];
                            break;
                        }
                        case 4: {
                            shiftX = ad.AnimPartY[anmInd][i] + ad.AnimShiftY[anmInd] - ad.AnimHeight[anmInd] / 2;
                        }
                    }
                }
                super.Draw(g, animSeqInd[i], screenX + shiftX, screenY + shiftY, 20, filter);
            }
        }
    }
}

