/*
 * Decompiled with CFR 0.152.
 */
package Game;

import com.mogames.dataconv.DataConverter;
import java.io.InputStream;
import javax.microedition.rms.RecordStore;

public class Pack {
    int id;
    int ver;
    String name;
    String type;
    boolean inRMS;

    public Pack() {
    }

    public Pack(int id, int ver, String name, String type) {
        this.id = id;
        this.ver = ver;
        this.name = name;
        this.type = type;
        this.inRMS = false;
    }

    public Pack(InputStream is) {
        this.id = DataConverter.intFromStream(is);
        this.ver = DataConverter.intFromStream(is);
        this.name = DataConverter.stringFromStream(is);
        this.type = DataConverter.stringFromStream(is);
        this.inRMS = false;
    }

    public void checkRmsVersion(String rmsPrefix) {
        String[] rmsNames = RecordStore.listRecordStores();
        if (rmsNames != null) {
            for (int i = 0; i < rmsNames.length; ++i) {
                if (!rmsNames[i].equals(rmsPrefix + this.name)) continue;
                try {
                    RecordStore rms = RecordStore.openRecordStore((String)rmsNames[i], (boolean)false);
                    byte[] res = rms.getRecord(1);
                    int rmsVer = DataConverter.intFromBytes(res, 0);
                    rms.closeRecordStore();
                    if (rmsVer <= this.ver) {
                        RecordStore.deleteRecordStore((String)rmsNames[i]);
                        break;
                    }
                    this.ver = rmsVer;
                    this.inRMS = true;
                }
                catch (Exception e) {
                    System.out.println("Pack.checkRms: " + e);
                }
                break;
            }
        }
    }

    public void saveInRms(String rmsPrefix, byte[] data, int off, int len) {
        try {
            RecordStore rms = RecordStore.openRecordStore((String)(rmsPrefix + this.name), (boolean)true);
            rms.addRecord(DataConverter.bytesFromInt(this.ver), 0, 4);
            rms.addRecord(data, off, len);
            rms.closeRecordStore();
            this.inRMS = true;
        }
        catch (Exception e) {
            System.out.println("Pack.checkRms: " + e);
        }
    }

    public void saveInRms(String rmsPrefix, byte[] data) {
        this.saveInRms(rmsPrefix, data, 0, data.length);
    }
}

