/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.MenuItem;
import java.util.Vector;

public class Menu {
    public Vector items = null;
    public int ItemIndex = -1;
    public boolean Active = false;
    public int visibleItemsCount = 0;

    public Menu(int count) {
        this.items = new Vector(count);
    }

    public void addItem(int id, String text) {
        this.items.addElement(new MenuItem(id, text));
        ++this.visibleItemsCount;
    }

    public void addItem(MenuItem mi) {
        this.items.addElement(mi);
        if (mi.visible) {
            ++this.visibleItemsCount;
        }
    }

    public int click() {
        if (this.items != null && this.ItemIndex >= 0 && this.ItemIndex < this.items.size()) {
            return ((MenuItem)this.items.elementAt((int)this.ItemIndex)).id;
        }
        return -1;
    }

    public String itemText(int ind) {
        if (this.items != null && ind >= 0 && ind < this.items.size()) {
            return ((MenuItem)this.items.elementAt((int)ind)).text;
        }
        return null;
    }

    public int itemsCount() {
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    public void setItemVisible(boolean visible, int ind) {
        MenuItem mi = null;
        if (this.items != null && ind >= 0 && ind < this.items.size()) {
            mi = (MenuItem)this.items.elementAt(ind);
        }
        if (mi != null && visible != mi.visible) {
            this.visibleItemsCount = visible ? this.visibleItemsCount + 1 : this.visibleItemsCount - 1;
        }
    }

    public void clear() {
        this.visibleItemsCount = 0;
        if (this.items != null) {
            this.items.removeAllElements();
        }
    }

    public void nextItem() {
        if (this.items != null && this.items.size() > 0) {
            int plus = 0;
            int oldIndex = this.ItemIndex;
            while (this.ItemIndex + plus < this.items.size()) {
                if (this.isEmptyElement(this.ItemIndex + ++plus) || !this.isVisibleElement(this.ItemIndex + plus)) continue;
                this.ItemIndex += plus;
                break;
            }
            if (this.ItemIndex == oldIndex) {
                for (plus = 0; plus < this.items.size() && plus < this.ItemIndex; ++plus) {
                    if (this.isEmptyElement(plus) || !this.isVisibleElement(plus)) continue;
                    this.ItemIndex = plus;
                    break;
                }
            }
        }
    }

    public void priorItem() {
        if (this.items != null && this.items.size() > 0) {
            int minus = 0;
            int oldIndex = this.ItemIndex;
            while (this.ItemIndex - minus >= 0) {
                if (this.isEmptyElement(this.ItemIndex - ++minus) || !this.isVisibleElement(this.ItemIndex - minus)) continue;
                this.ItemIndex -= minus;
                break;
            }
            if (this.ItemIndex == oldIndex) {
                for (minus = this.items.size() - 1; minus > this.ItemIndex; --minus) {
                    if (this.isEmptyElement(minus) || !this.isVisibleElement(minus)) continue;
                    this.ItemIndex = minus;
                    break;
                }
            }
        }
    }

    public boolean isEmptyElement(int i) {
        if (this.items != null && this.items.size() > 0 && i >= 0 && i < this.items.size()) {
            MenuItem mi = (MenuItem)this.items.elementAt(i);
            return mi.id == 0;
        }
        return true;
    }

    public boolean isVisibleElement(int i) {
        if (this.items != null && this.items.size() > 0 && i >= 0 && i < this.items.size()) {
            MenuItem mi = (MenuItem)this.items.elementAt(i);
            return mi.visible;
        }
        return false;
    }

    public void setActiveItem(int index) {
        if (this.items != null && this.items.size() > 0 && index >= 0 && index < this.items.size()) {
            this.ItemIndex = index;
        }
    }

    public void show(boolean activ) {
        if (activ) {
            if (this.items != null && this.items.size() > 0) {
                this.Active = activ;
                if (this.Active) {
                    this.ItemIndex = -1;
                    for (int i = 0; i < this.items.size(); ++i) {
                        if (this.isEmptyElement(i) || !this.isVisibleElement(i)) continue;
                        this.ItemIndex = i;
                        break;
                    }
                    if (this.ItemIndex < 0) {
                        this.Active = false;
                    }
                }
            }
        } else {
            this.Active = activ;
        }
    }
}

