/*
 * Decompiled with CFR 0.152.
 */
package Game;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class MIDIPlayer {
    Hashtable Players = new Hashtable();
    int soundLevel = 100;

    public Player AddPlayer(byte[] data, int id) {
        Player p = null;
        try {
            p = Manager.createPlayer((InputStream)new ByteArrayInputStream(data), (String)"audio/midi");
            p.realize();
            VolumeControl vc = (VolumeControl)p.getControl("javax.microedition.media.control.VolumeControl");
            if (vc != null) {
                vc.setLevel(this.soundLevel);
            }
            PlayerData pd = new PlayerData(p, vc, id);
            this.Players.put(new Integer(id), pd);
        }
        catch (Exception e) {
            p = null;
        }
        return p;
    }

    public Player AddPlayer(String f_name, int id) {
        Player p = null;
        try {
            p = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(f_name), (String)"audio/midi");
            p.realize();
            VolumeControl vc = (VolumeControl)p.getControl("javax.microedition.media.control.VolumeControl");
            if (vc != null) {
                vc.setLevel(this.soundLevel);
            }
            PlayerData pd = new PlayerData(p, vc, id);
            this.Players.put(new Integer(id), pd);
        }
        catch (Exception e) {
            p = null;
            System.out.println("Load MIDI: " + e);
        }
        return p;
    }

    public void DelPlayer(int id) {
        try {
            Integer ID = new Integer(id);
            PlayerData pd = (PlayerData)this.Players.get(ID);
            if (pd != null) {
                if (pd.player != null) {
                    pd.player.close();
                }
                pd.player = null;
                pd.volumeControl = null;
            }
            this.Players.remove(ID);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Play(int id, int times) {
        try {
            PlayerData pd;
            Integer ID = new Integer(id);
            if (times <= 0) {
                times = -1;
            }
            if ((pd = (PlayerData)this.Players.get(ID)) != null && pd.player != null) {
                pd.player.setLoopCount(times);
                pd.player.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Pause(int id) {
        try {
            Integer ID = new Integer(id);
            PlayerData pd = (PlayerData)this.Players.get(ID);
            if (pd != null && pd.player != null) {
                pd.player.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Stop(int id) {
        try {
            Integer ID = new Integer(id);
            PlayerData pd = (PlayerData)this.Players.get(ID);
            if (pd != null && pd.player != null && pd.player.getState() != 0) {
                pd.player.stop();
                pd.player.deallocate();
                pd.player.setMediaTime(0L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void StopAll(int id, boolean isMute) {
        try {
            Enumeration e = this.Players.elements();
            while (e.hasMoreElements()) {
                PlayerData pd = (PlayerData)e.nextElement();
                if (pd == null || pd.player == null || pd.player.getState() == 0) continue;
                pd.player.stop();
                pd.player.deallocate();
                pd.player.setMediaTime(0L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Close(int id) {
        try {
            Integer ID = new Integer(id);
            PlayerData pd = (PlayerData)this.Players.get(ID);
            if (pd != null && pd.player != null) {
                pd.player.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Volume(int id, int value) {
        try {
            Integer ID = new Integer(id);
            PlayerData pd = (PlayerData)this.Players.get(ID);
            if (pd != null) {
                if (value < 0) {
                    value = 0;
                } else if (value > 100) {
                    value = 100;
                }
                if (pd.volumeControl != null) {
                    pd.volumeControl.setLevel(value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void VolumeAll(int id, int value) {
        try {
            Enumeration e = this.Players.elements();
            while (e.hasMoreElements()) {
                PlayerData pd = (PlayerData)e.nextElement();
                if (pd == null) continue;
                if (value < 0) {
                    value = 0;
                } else if (value > 100) {
                    value = 100;
                }
                if (pd.volumeControl == null) continue;
                pd.volumeControl.setLevel(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Mute(int id, boolean isMute) {
        try {
            Integer ID = new Integer(id);
            PlayerData pd = (PlayerData)this.Players.get(ID);
            if (pd != null && pd.volumeControl != null) {
                pd.volumeControl.setMute(isMute);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void MuteAll(int id, boolean isMute) {
        try {
            Enumeration e = this.Players.elements();
            while (e.hasMoreElements()) {
                PlayerData pd = (PlayerData)e.nextElement();
                if (pd == null || pd.volumeControl == null) continue;
                pd.volumeControl.setMute(isMute);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class PlayerData {
        Player player;
        VolumeControl volumeControl;
        int id;

        public PlayerData(Player player, VolumeControl volumeControl, int id) {
            this.player = player;
            this.volumeControl = volumeControl;
            this.id = id;
        }
    }
}

