/*
 * Decompiled with CFR 0.152.
 */
package Game;

import java.util.Vector;

public class GameStateManager {
    static final int GST_EMPTY = 0;
    static final int GST_LOGO1 = 1;
    static final int GST_LOGO2 = 2;
    static final int GST_LOGO3 = 3;
    static final int GST_LOGIN = 4;
    static final int GST_REGISTR1 = 5;
    static final int GST_REGISTR2 = 6;
    static final int GST_INVENTAR = 7;
    static final int GST_LOCATION = 8;
    static final int GST_CHAT = 9;
    static final int GST_CHATUSERS = 10;
    static final int GST_SHOP = 11;
    static final int GST_SECONDHAND = 12;
    static final int GST_QUESTS = 13;
    static final int GST_BEASTS = 14;
    static final int GST_BATTLE = 15;
    static final int GST_LOCATELIST = 16;
    static final int GST_PERSSTATS = 17;
    static final int GST_ARENA = 18;
    static final int GST_CREATEBATTLE = 19;
    static final int GST_BATTLEWAIT = 20;
    static final int GST_SETTINGS = 21;
    static final int GST_BATTLE_LOCAL = 22;
    static final int GST_SUPER_PUNCH = 23;
    static final int GST_SMS = 24;
    static final int GST_MAILS = 25;
    static final int GST_UPDATE = 26;
    static final int GST_USERS_LIST = 27;
    private Vector StateSeq = new Vector(this.StateFreeCount);
    private static GameStateManager curStateManager = null;
    private int StateFreeCount = 5;
    private int curStateInSeq = 0;

    private GameStateManager() {
        for (int i = 0; i < this.StateFreeCount; ++i) {
            this.StateSeq.addElement(new GameState());
        }
    }

    public static GameStateManager getInstance() {
        if (curStateManager == null) {
            curStateManager = new GameStateManager();
        }
        return curStateManager;
    }

    public GameState push(int statID, boolean ShowMenu, boolean ShowDialog) {
        GameState res = null;
        if (statID != 0) {
            if (this.StateFreeCount > 0) {
                res = (GameState)this.StateSeq.elementAt(this.StateSeq.size() - this.StateFreeCount);
                res.Set(statID, ShowMenu, ShowDialog);
                --this.StateFreeCount;
            } else {
                res = new GameState(statID, ShowMenu, ShowDialog);
                this.StateSeq.addElement(res);
            }
        }
        return res;
    }

    public GameState push(int statID) {
        GameState res = null;
        if (statID != 0) {
            if (this.StateFreeCount > 0) {
                res = (GameState)this.StateSeq.elementAt(this.StateSeq.size() - this.StateFreeCount);
                res.Set(statID);
                --this.StateFreeCount;
            } else {
                res = new GameState(statID);
                this.StateSeq.addElement(res);
            }
        }
        return res;
    }

    public GameState set(int statID, boolean ShowMenu, boolean ShowDialog) {
        GameState res = null;
        if (statID != 0) {
            if (this.StateSeq.size() == 0) {
                this.StateFreeCount = 0;
                res = new GameState(statID, ShowMenu, ShowDialog);
                this.StateSeq.addElement(res);
            } else {
                res = (GameState)this.StateSeq.elementAt(0);
                res.Set(statID, ShowMenu, ShowDialog);
                this.StateFreeCount = this.StateSeq.size() - 1;
            }
        }
        return res;
    }

    public GameState set(int statID) {
        GameState res = null;
        if (statID != 0) {
            if (this.StateSeq.size() == 0) {
                this.StateFreeCount = 0;
                res = new GameState(statID);
                this.StateSeq.addElement(res);
            } else {
                res = (GameState)this.StateSeq.elementAt(0);
                res.Set(statID);
                for (int i = 1; i < this.StateSeq.size(); ++i) {
                    GameState gs = (GameState)this.StateSeq.elementAt(i);
                    gs.Set();
                }
                this.StateFreeCount = this.StateSeq.size() - 1;
            }
        }
        return res;
    }

    public GameState pop() {
        int lastUsed;
        GameState res = null;
        if (this.StateSeq.size() > 0 && (lastUsed = this.StateSeq.size() - this.StateFreeCount - 1) > 0) {
            GameState gs = (GameState)this.StateSeq.elementAt(lastUsed);
            gs.Set();
            res = (GameState)this.StateSeq.elementAt(lastUsed - 1);
            ++this.StateFreeCount;
        }
        return res;
    }

    public void close() {
        this.clear();
        curStateManager = null;
    }

    private void clear() {
        if (this.StateSeq != null) {
            this.StateSeq.removeAllElements();
        }
    }

    public GameState firstState() {
        this.curStateInSeq = 0;
        if (this.StateSeq.size() > 0) {
            GameState gs = (GameState)this.StateSeq.elementAt(0);
            return gs;
        }
        return null;
    }

    public GameState lastState() {
        this.curStateInSeq = 0;
        if (this.StateSeq.size() > 0) {
            GameState gs = null;
            int lastUsed = this.StateSeq.size() - this.StateFreeCount - 1;
            if (lastUsed >= 0) {
                gs = (GameState)this.StateSeq.elementAt(lastUsed);
                this.curStateInSeq = lastUsed;
            }
            return gs;
        }
        return null;
    }

    public GameState nextState() {
        ++this.curStateInSeq;
        if (this.curStateInSeq < this.StateSeq.size()) {
            GameState gs = (GameState)this.StateSeq.elementAt(this.curStateInSeq);
            return gs;
        }
        return null;
    }

    public GameState priorState() {
        --this.curStateInSeq;
        if (this.curStateInSeq >= 0) {
            GameState gs = (GameState)this.StateSeq.elementAt(this.curStateInSeq);
            return gs;
        }
        return null;
    }

    public class GameState {
        public int State;
        public boolean ShowMenu;
        public boolean ShowDialog;

        public GameState(int State2, boolean ShowMenu, boolean ShowDialog) {
            this.State = State2;
            this.ShowMenu = ShowMenu;
            this.ShowDialog = ShowDialog;
        }

        public GameState(int State2) {
            this.State = State2;
            this.ShowMenu = false;
            this.ShowDialog = false;
        }

        public GameState() {
            this.State = 0;
            this.ShowMenu = false;
            this.ShowDialog = false;
        }

        public void Set(int State2, boolean ShowMenu, boolean ShowDialog) {
            this.State = State2;
            this.ShowMenu = ShowMenu;
            this.ShowDialog = ShowDialog;
        }

        public void Set(int State2) {
            this.State = State2;
            this.ShowMenu = false;
            this.ShowDialog = false;
        }

        public void Set() {
            this.State = 0;
            this.ShowMenu = false;
            this.ShowDialog = false;
        }
    }
}

