/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.AnimationBuilder;
import Game.AnimationSortList;
import Game.Battle;
import Game.BattlePunch;
import Game.Beast;
import Game.Chat;
import Game.GameMidlet;
import Game.GameStateManager;
import Game.GameText;
import Game.InventoryItem;
import Game.Locate;
import Game.MIDIPlayer;
import Game.Menu;
import Game.MenuItem;
import Game.Quest;
import Game.SMS;
import Game.User;
import Game.Warrior;
import com.alsigames.animations.AnimationComplexPicture;
import com.alsigames.animations.AnimationData;
import com.alsigames.animations.ComplexPicture;
import com.alsigames.font.FontManagerEx;
import com.alsigames.gui.Filler;
import com.alsigames.gui.ScrollList;
import com.alsigames.gui.ScrollListElement;
import com.alsigames.gui.SimpleScrollElement;
import com.alsigames.net.MobileConnection;
import com.alsigames.net.MobileNetReceiver;
import com.alsigames.net.NotFoundParamIDException;
import com.alsigames.pak.Pak;
import com.alsigames.pak.Unpacker;
import com.alsigames.utils.StringUtiles;
import com.alsigames.xml.Attribute;
import com.alsigames.xml.Element;
import com.alsigames.xml.Parser;
import com.mogames.dataconv.DataConverter;
import com.mogames.datatype.Param;
import com.mogames.gui.Clipper;
import com.mogames.gui.Tabs;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class Game
extends Canvas
implements Runnable {
    GameMidlet parent;
    Thread game_thread = null;
    boolean running = false;
    boolean pauseOn = false;
    GameStateManager GSM;
    GameData GD;
    private long paintTimeCur = 0L;
    private long paintTimeLast = 0L;
    public static Random rand = new Random(System.currentTimeMillis());
    public static final int WIDTH = 176;
    public static final int HEIGHT = 220;
    public static final int SCREEN_W = 176;
    public static final int SCREEN_H = 220;
    public static final int SCREEN_X = 0;
    public static final int SCREEN_Y = 0;
    public static final String RES_PATH_PART = "176x220";
    int HEADER_HEIGHT = 36;
    final int fps;
    final long desiredTime;
    long curTime = 0L;
    long lastTime = 0L;
    long execTime = 0L;
    final int SOFTKEY_LEFT;
    final int SOFTKEY_RIGHT;
    final int SOFTKEY_MIDDLE;
    final int SOFTKEY_1;
    final int SOFTKEY_2;
    final int SOFTCANCEL;
    private int lastKey = 0;
    private boolean keyLeft = false;
    private boolean keyRight = false;
    private boolean keyUp = false;
    private boolean keyDown = false;
    private boolean keyFire = false;
    private boolean keySelectL = false;
    private boolean keySelectR = false;
    private boolean keyCancel = false;
    private boolean keyNum1 = false;
    private boolean keyNum2 = false;
    private boolean keyNum3 = false;
    private boolean keyNum4 = false;
    private boolean keyNum5 = false;
    private boolean keyNum6 = false;
    private boolean keyNum7 = false;
    private boolean keyNum8 = false;
    private boolean keyNum9 = false;
    private boolean keyNum0 = false;
    private boolean keyAny = false;

    public Game(GameMidlet parent) {
        this.fps = 16;
        this.desiredTime = 62L;
        this.SOFTKEY_LEFT = -1;
        this.SOFTKEY_RIGHT = 1;
        this.SOFTKEY_MIDDLE = 0;
        this.SOFTKEY_1 = -6;
        this.SOFTKEY_2 = -7;
        this.SOFTCANCEL = -8;
        this.parent = parent;
        this.GD = new GameData(this);
        this.GD.Init();
        this.GSM = GameStateManager.getInstance();
        this.GSM.push(3);
    }

    protected void keyPressed(int keyCode) {
        this.lastKey = keyCode;
        if (keyCode == 49) {
            this.keyNum1 = true;
        } else if (keyCode == 50) {
            this.keyNum2 = true;
        } else if (keyCode == 51) {
            this.keyNum3 = true;
        } else if (keyCode == 52) {
            this.keyNum4 = true;
        } else if (keyCode == 53) {
            this.keyNum5 = true;
        } else if (keyCode == 54) {
            this.keyNum6 = true;
        } else if (keyCode == 55) {
            this.keyNum7 = true;
        } else if (keyCode == 56) {
            this.keyNum8 = true;
        } else if (keyCode == 57) {
            this.keyNum9 = true;
        } else if (keyCode == 48) {
            this.keyNum0 = true;
        } else if (keyCode == -6 || keyCode == 42) {
            this.keySelectL = true;
        } else if (keyCode == -7 || keyCode == 35) {
            this.keySelectR = true;
        } else if (keyCode == -8) {
            this.keyCancel = true;
        } else {
            try {
                int gameAct = this.getGameAction(keyCode);
                if (gameAct == 1) {
                    this.keyUp = true;
                } else if (gameAct == 6) {
                    this.keyDown = true;
                } else if (gameAct == 2) {
                    this.keyLeft = true;
                } else if (gameAct == 5) {
                    this.keyRight = true;
                } else if (gameAct == 8) {
                    this.keyFire = true;
                }
            }
            catch (Exception e) {
                System.out.println("keyPressed error: " + e);
            }
        }
        this.keyAny = true;
    }

    protected void keyReleased(int keyCode) {
        boolean kCode = false;
        if (keyCode == 49) {
            this.keyNum1 = false;
        } else if (keyCode == 50) {
            this.keyNum2 = false;
        } else if (keyCode == 51) {
            this.keyNum3 = false;
        } else if (keyCode == 52) {
            this.keyNum4 = false;
        } else if (keyCode == 53) {
            this.keyNum5 = false;
        } else if (keyCode == 54) {
            this.keyNum6 = false;
        } else if (keyCode == 55) {
            this.keyNum7 = false;
        } else if (keyCode == 56) {
            this.keyNum8 = false;
        } else if (keyCode == 57) {
            this.keyNum9 = false;
        } else if (keyCode == 48) {
            this.keyNum0 = false;
        } else if (keyCode == -6 || keyCode == 42) {
            this.keySelectL = false;
        } else if (keyCode == -7 || keyCode == 35) {
            this.keySelectR = false;
        } else if (keyCode == -8) {
            this.keyCancel = false;
        } else {
            try {
                int gameAct = this.getGameAction(keyCode);
                if (gameAct == 1) {
                    this.keyUp = false;
                } else if (gameAct == 6) {
                    this.keyDown = false;
                } else if (gameAct == 2) {
                    this.keyLeft = false;
                } else if (gameAct == 5) {
                    this.keyRight = false;
                } else if (gameAct == 8) {
                    this.keyFire = false;
                }
            }
            catch (Exception e) {
                System.out.println("keyPressed error: " + e);
            }
        }
        this.keyAny = false;
    }

    private void keyClear() {
        this.keyLeft = false;
        this.keyRight = false;
        this.keyUp = false;
        this.keyDown = false;
        this.keyFire = false;
        this.keySelectL = false;
        this.keySelectR = false;
        this.keyCancel = false;
        this.keyNum1 = false;
        this.keyNum2 = false;
        this.keyNum3 = false;
        this.keyNum4 = false;
        this.keyNum5 = false;
        this.keyNum6 = false;
        this.keyNum7 = false;
        this.keyNum8 = false;
        this.keyNum9 = false;
        this.keyNum0 = false;
        this.keyAny = false;
    }

    public final void start() {
        this.game_thread = new Thread(this);
        this.running = true;
        this.game_thread.start();
    }

    public final void stop() {
        this.running = false;
        this.game_thread = null;
    }

    public final void pause() {
        this.pauseOn = !this.pauseOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            Thread current = Thread.currentThread();
            while (current == this.game_thread && this.running) {
                if (!this.pauseOn) {
                    this.curTime = System.currentTimeMillis();
                    if (this.curTime >= this.lastTime) {
                        this.lastTime = this.curTime + 62L;
                        try {
                            GameStateManager gameStateManager = this.GSM;
                            synchronized (gameStateManager) {
                                GameData gameData = this.GD;
                                synchronized (gameData) {
                                    GameStateManager.GameState gs = this.GSM.lastState();
                                    if (gs != null && gs.State != 0) {
                                        this.GD.ExecState(gs);
                                    }
                                }
                            }
                            if (this.running) {
                                this.Repaint();
                            }
                        }
                        catch (Exception e) {
                            System.out.println("Run game " + e);
                        }
                    }
                    this.execTime = this.lastTime - System.currentTimeMillis();
                    if (this.execTime < 1L) {
                        this.execTime = 1L;
                    } else if (this.execTime > 62L) {
                        this.execTime = 62L;
                    }
                } else {
                    this.execTime = 62L;
                }
                try {
                    Thread.sleep(this.execTime);
                }
                catch (Exception e) {
                    System.out.println("Run timing " + e);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Run error " + e);
        }
    }

    protected final void Repaint() {
        this.repaint();
        this.serviceRepaints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(Graphics g) {
        GameStateManager gameStateManager = this.GSM;
        synchronized (gameStateManager) {
            GameData gameData = this.GD;
            synchronized (gameData) {
                FontManagerEx.setGraphics(g);
                this.paintTimeLast = this.paintTimeCur;
                this.paintTimeCur = System.currentTimeMillis();
                GameStateManager.GameState gs = this.GSM.firstState();
                if (gs != null && gs.State != 0) {
                    this.GD.PaintState(g, gs);
                }
            }
        }
    }

    class GameData
    implements MobileNetReceiver,
    CommandListener {
        Canvas pCanvas = null;
        Font fontSmall;
        Font fontSmallNormal;
        Font fontMedium;
        Font fontBig;
        Font fontBigNormal;
        static final int PAINT_NOT_NEED = 0;
        static final int PAINT_REPAINT = 1;
        private int PAINT_EVENT = 0;
        private int PAINT_BONUS = 0;
        static final int NET_NOTHING = 0;
        static final int NET_CONNECT = 1;
        private int NET_EVENT = 0;
        static final int ERROR_NONE = 0;
        static final int ERROR_CONN = 1;
        static final int ERROR_LGPS = 2;
        static final int ERROR_CRMN = 3;
        static final int ERROR_BTCR = 4;
        static final int ERROR_BTFL = 5;
        static final int ERROR_BTST = 6;
        static final int ERROR_BTPE = 7;
        static final int ERROR_BTWP = 8;
        static final int ERROR_BTDL = 9;
        static final int ERROR_MNY1 = 10;
        static final int ERROR_MNY2 = 11;
        static final int ERROR_GPRS = 12;
        private int ERROR_EVENT = 0;
        private String[] errorsText = new String[12];
        private int[][] errorsMsgShift = new int[12][];
        public final int logo_wait;
        static final int logoEndTotal = 20;
        private int logoEnd = 20;
        private boolean startLogoTimer = false;
        long utimer = 0L;
        int load_percent = 0;
        private Image logoImage_1;
        private Image logoImage_2;
        private Image logoImage_3;
        private Image logoImage_4;
        private Image backImage = null;
        MobileConnection conn = null;
        private String hostName = "localhost";
        private String hostIP = "127.0.0.1";
        private int hostPort = 19900;
        private int playerId = -1;
        private int playerLevel = 1;
        private String nikname = "";
        private String login = "";
        private String password = "";
        private String passwordConf = "";
        private String passwordMask = "";
        private String passwordConfMask = "";
        private int partnerId = 1;
        private byte verBeforePoint = 0;
        private byte verAfterPoint = 1;
        private int healthBonus = 0;
        private int healthMax = 100;
        private int healthCur = 100;
        private int manaMax = 100;
        private int manaCur = 0;
        private int expCur = 0;
        private int expMin = 0;
        private int expMax = 100;
        boolean isPoisoned = false;
        private int playerDamage = 1;
        private int money;
        private int max_clothes_count;
        private int max_goods_count;
        private int dressedClothes = 0;
        private int dressedCount = 0;
        private boolean dressedAction = false;
        private InventoryItem dressedActionItem = null;
        private boolean isGhost = false;
        Form form;
        TextField textFieldLogin;
        TextField textFieldPassword;
        TextField textFieldPasswordConf;
        Chat chat = new Chat();
        AnimationComplexPicture persAnim = null;
        AnimationComplexPicture pers2Anim = null;
        AnimationComplexPicture hearAnim = null;
        AnimationComplexPicture breastplateAnim = null;
        AnimationComplexPicture helmetAnim = null;
        AnimationComplexPicture legedAnim = null;
        AnimationComplexPicture bootAnim = null;
        AnimationComplexPicture shoulderAnim = null;
        AnimationComplexPicture armedAnim = null;
        AnimationComplexPicture swordAnim = null;
        AnimationComplexPicture shieldAnim = null;
        Vector hearAnimForSelect = new Vector();
        private long lastTimeAnim;
        private int curAnim = 0;
        boolean isManPers = true;
        int typePers = 1;
        int typeHear = 0;
        int typeBreastplate = 0;
        int typeHelmet = 0;
        int typeLeged = 0;
        int typeBoot = 0;
        int typeShoulder = 0;
        int typeArmed = 0;
        int typeSword = 0;
        int typeShield = 0;
        Element hearsTopElement = null;
        int hearsCount = 0;
        AnimationSortList hearSortList = new AnimationSortList();
        Hashtable hearAnimForSelectTemp = new Hashtable();
        Vector ClothesItemsList = new Vector();
        Vector QuestsList = new Vector();
        Image[] QuestsIcones = new Image[4];
        Vector SecondClothesItemsList = new Vector();
        Vector GoodsItemsList = new Vector();
        Vector PresentsItemsList = new Vector();
        boolean isSuperPunch = false;
        AnimationComplexPicture beastAnim = null;
        AnimationComplexPicture hearAnimBeast = null;
        AnimationComplexPicture breastplateAnimBeast = null;
        AnimationComplexPicture helmetAnimBeast = null;
        AnimationComplexPicture legedAnimBeast = null;
        AnimationComplexPicture bootAnimBeast = null;
        AnimationComplexPicture shoulderAnimBeast = null;
        AnimationComplexPicture armedAnimBeast = null;
        AnimationComplexPicture swordAnimBeast = null;
        AnimationComplexPicture shieldAnimBeast = null;
        private long lastTimeAnimBeast;
        private int curAnimBeast = 0;
        boolean isBotBeast = false;
        boolean isManPersBeast = true;
        int typePersBeast = 1;
        int typeHearBeast = 0;
        int typeBreastplateBeast = 0;
        int typeHelmetBeast = 0;
        int typeLegedBeast = 0;
        int typeBootBeast = 0;
        int typeShoulderBeast = 0;
        int typeArmedBeast = 0;
        int typeSwordBeast = 0;
        int typeShieldBeast = 0;
        Vector BeastsList = new Vector();
        int withWeaponBeast = 0;
        int healthMaxBeast = 100;
        int healthCurBeast = 100;
        boolean isPoisonedBeast = false;
        boolean isSuperPunchBeast = false;
        Tabs tabs = null;
        ComplexPicture guiCP = null;
        ComplexPicture statisticsGUICP = null;
        int scrollElementsShiftY = 0;
        Image[] coins = new Image[3];
        Image newMailIcon = null;
        Image[] icones_faces = new Image[2];
        Image[] icones_races = new Image[2];
        static final int GUIPART_BORDER_LEFT = 0;
        static final int GUIPART_BORDER_RIGHT = 1;
        static final int GUIPART_BORDER_TOP = 2;
        static final int GUIPART_BORDER_BOTTOM = 3;
        static final int GUIPART_TABS_FILLER = 4;
        static final int GUIPART_MENU_FILLER = 5;
        static final int GUIPART_MENU_LEFT_NA = 6;
        static final int GUIPART_MENU_RIGHT_NA = 7;
        static final int GUIPART_MENU_MIDDL_NA = 8;
        static final int GUIPART_MENU_LEFT_A = 9;
        static final int GUIPART_MENU_RIGHT_A = 10;
        static final int GUIPART_MENU_MIDDL_A = 11;
        static final int GUIPART_DIALOG_HORIZ = 12;
        static final int GUIPART_SHADOW_LEFT = 13;
        static final int GUIPART_SHADOW_RIGHT = 14;
        static final int GUIPART_EDIT_LEFT_NA = 15;
        static final int GUIPART_EDIT_RIGHT_NA = 16;
        static final int GUIPART_EDIT_MIDDL_NA = 17;
        static final int GUIPART_EDIT_LEFT_A = 18;
        static final int GUIPART_EDIT_RIGHT_A = 19;
        static final int GUIPART_EDIT_MIDDL_A = 20;
        static final int GUIPART_DIALOG_VERT = 21;
        static final int GUIPART_ARROW_LEFT = 22;
        static final int GUIPART_ARROW_RIGHT = 23;
        static final int GUIPART_SELECTOR_L_T = 24;
        static final int GUIPART_SELECTOR_L_B = 25;
        static final int GUIPART_SELECTOR_R_T = 26;
        static final int GUIPART_SELECTOR_R_B = 27;
        static final int GUIPART_SELECTOR_VERT = 28;
        static final int GUIPART_SCROLL_TOP = 29;
        static final int GUIPART_SCROLL_BOTTOM = 30;
        static final int GUIPART_MARKER_TOP = 31;
        static final int GUIPART_MARKER_BOTTOM = 32;
        static final int GUIPART_MARKER_MIDDLE = 33;
        static final int GUIPART_MENU_LEFT_EM = 34;
        static final int GUIPART_MENU_RIGHT_EM = 35;
        static final int GUIPART_MENU_MIDDL_EM = 36;
        String locationName = "";
        int newLocationID;
        int LocationType = 0;
        Vector BuildingsList = new Vector();
        long inLocationTime = 0L;
        String packPath = "/res/176x220/";
        String rmsPrefix = "theBestMobileRpg_";
        Hashtable packs = new Hashtable();
        Hashtable serverPacksVersion = new Hashtable();
        Vector packsIdToLoadFromServer = new Vector();
        Vector paksList = new Vector();
        Hashtable paksHashMap = new Hashtable();
        String pakNamesRMS = "eldor_pak_names";
        RecordStore pakNamesRecords = null;
        String pakDataRMS = "eldor_pak_data";
        RecordStore pakDataRecords = null;
        Vector paksNotInList = new Vector();
        static final int NETMSGC_REGISTRATION = 1;
        static final int NETMSGC_LOGIN = 2;
        static final int NETMSGS_LOGIN_ANSWER = 3;
        static final int NETMSGS_ERROR = 4;
        static final int NETMSGC_LOGIN_CONTINUE = 5;
        static final int NETMSGS_LOC_USERS = 6;
        static final int NETMSGS_USER_ENT_EXT = 7;
        static final int NETMSGS_PACK_LIST = 10;
        static final int NETMSGC_GET_PAKS = 11;
        static final int NETMSGS_PAK_DATA = 12;
        static final int NETMSGS_MUST_UPDATE = 15;
        static final int NETMSGS_MAY_UPDATE = 16;
        static final int NETMSGS_PAKS_LIST = 17;
        static final int NETMSGS_SUPER_PUNCH_SEQ = 21;
        static final int NETMSGS_PLAYER_HEALTH = 22;
        static final int NETMSGS_NEW_SUPER_PUNCH = 23;
        static final int NETMSGS_USER_CHARACTERS = 24;
        static final int NETMSGS_INVENTORY = 30;
        static final int NETMSGS_ADD_INVENTORY_ITEM = 31;
        static final int NETMSGC_INVENTORY_ITEM_ON = 33;
        static final int NETMSGC_INVENTORY_ITEM_DEL = 34;
        static final int NETMSGS_INVENTORY_ITEM_DEL = 35;
        static final int NETMSGS_MONEY_COUNT = 41;
        static final int NETMSGC_GHOST_RESURACTION = 42;
        static final int NETMSGS_RESURACTION_RESULT = 43;
        static final int NETMSGS_SMS_LIST = 44;
        static final int NETMSGC_MAILS_LIST = 45;
        static final int NETMSGS_MAIL_GET = 46;
        static final int NETMSGC_MAIL_SEND = 47;
        static final int NETMSGC_MAIL_READ = 48;
        static final int NETMSGC_MAIL_NEW = 49;
        static final int NETMSGC_MAIL_DELETE = 50;
        static final int NETMSGS_MAIL_GOTNEW = 51;
        static final int NETMSGC_SHOP_ITEMS = 60;
        static final int NETMSGS_SHOP_ITEMS = 61;
        static final int NETMSGC_SHOP_BUY_ITEM = 62;
        static final int NETMSGC_SHOP_GET_TYPES = 63;
        static final int NETMSGS_SHOP_SET_TYPES = 64;
        static final int NETMSGS_LOCATION_INFO = 71;
        static final int NETMSGS_LOCATION_ENTER = 72;
        static final int NETMSGC_BUILDING_BEAST_GET = 73;
        static final int NETMSGS_BUILDING_BEAST_LIST = 74;
        static final int NETMSGS_BUILDING_BEAST_END = 75;
        static final int NETMSGC_BUILDING_BEAST_ATTACK = 76;
        static final int NETMSGC_CREATE_BATTLE_TRY = 80;
        static final int NETMSGS_CREATE_BATTLE_RESULT = 81;
        static final int NETMSGC_BATTLE_LIST_GET = 82;
        static final int NETMSGS_BATTLE_LIST_SEND = 83;
        static final int NETMSGC_BATTLE_JOIN_TRY = 84;
        static final int NETMSGS_BATTLE_JOIN_RESULT = 85;
        static final int NETMSGS_BATTLE_JOIN_PLAYER = 86;
        static final int NETMSGC_BATTLE_EXIT_TRY = 87;
        static final int NETMSGS_BATTLE_EXIT_PLAYER = 88;
        static final int NETMSGS_BATTLE_START = 89;
        static final int NETMSGS_BATTLE_ADD_USER = 90;
        static final int NETMSGS_BATTLE_DUEL_USER = 91;
        static final int NETMSGC_BATTLE_STEP_ACTION = 92;
        static final int NETMSGS_BATTLE_STEP_RESULT = 93;
        static final int NETMSGS_BATTLE_END = 94;
        static final int NETMSGS_BATTLE_PLAYER_HEALTH = 95;
        static final int NETMSGS_BEAST_ATTACK_RESULT = 96;
        static final int NETMSGS_NEW_LEVEL = 97;
        static final int NETMSGC_CHAT_ENTER = 100;
        static final int NETMSGS_CHAT_ENTER = 101;
        static final int NETMSGC_CHAT_EXIT = 102;
        static final int NETMSGS_CHAT_EXIT = 103;
        static final int NETMSGC_CHAT_SENDMSG = 104;
        static final int NETMSGS_CHAT_SENDMSG = 105;
        static final int NETMSGS_USER_CHAT_ROLE = 106;
        static final int NETMSGC_CHAT_WARN_USER = 107;
        String chatSendText = "";
        int chatReceiverID = 0;
        int chatWarnTime = 0;
        static final int DIALOG_STATE_BATTLEWIN = 1;
        static final int DIALOG_STATE_BATTLELOSE = 2;
        static final int DIALOG_STATE_SMS_QUESTION = 3;
        static final int DIALOG_STATE_SMS_RESULT = 4;
        static final int DIALOG_STATE_MAIL_DELETE = 5;
        private final int MENUID_REGISTRATION;
        private final int MENUID_ENTERGAME;
        private final int MENUID_DRESSON;
        private final int MENUID_WRITECHATMSG;
        private final int MENUID_CHATPLAYERS;
        private final int MENUID_CHATROOMS;
        private final int MENUID_CHATPRVMSG;
        private final int MENUID_CHATWRITE;
        private final int MENUID_CLOTHES;
        private final int MENUID_GOODS;
        private final int MENUID_PRESENTS;
        private final int MENUID_BYE;
        private final int MENUID_SHOPINFO;
        private final int MENUID_REPAIR;
        private final int MENUID_SELL;
        private final int MENUID_ENTERBUILD;
        private final int MENUID_BUILDINFO;
        private final int MENUID_QUESTINFO;
        private final int MENUID_AGRESSION;
        private final int MENUID_BEASTINFO;
        private final int MENUID_CHANGELOCAT;
        private final int MENUID_LOCATEINFO;
        private final int MENUID_PARAMETERS;
        private final int MENUID_REWARDS;
        private final int MENUID_PERKS;
        private final int MENUID_MAGICS;
        private final int MENUID_GIFTS;
        private final int MENUID_GOODSDELETE;
        private final int MENUID_GOODSINFO;
        private final int MENUID_BATTLECREATE;
        private final int MENUID_BATTLEENTER;
        private final int MENUID_SUPERPUNCH;
        private final int MENUID_MAILOPEN;
        private final int MENUID_MAILDELETE;
        private final int MENUID_MAILWRITE;
        private final int MENUID_CHATBAN;
        private final int MENUID_CHATWARN0001;
        private final int MENUID_CHATWARN0005;
        private final int MENUID_CHATWARN0015;
        private final int MENUID_CHATWARN0030;
        private final int MENUID_CHATWARN0060;
        private final int MENUID_CHATWARN0180;
        private final int MENUID_CHATWARN0720;
        private final int MENUID_CHATWARN1440;
        private final int MENUID_CHATWARNING;
        Menu menu = new Menu(10);
        MenuItem miEmpty = new MenuItem(0, null);
        MenuItem miLoginReg = new MenuItem(1, GameText.STR_TOOLBAR_REGISTRATION);
        MenuItem miLoginEnter = new MenuItem(2, GameText.STR_TOOLBAR_ENTER);
        MenuItem miChat1 = new MenuItem(4, GameText.STR_TOOLBAR_WRITE);
        MenuItem miChat2 = new MenuItem(5, GameText.STR_TOOLBAR_LIST);
        MenuItem miChat3 = new MenuItem(6, GameText.STR_TOOLBAR_ROOMS);
        MenuItem miChatWarning = new MenuItem(45, GameText.STR_TOOLBAR_CHATWARNING);
        MenuItem miChatWarn0005 = new MenuItem(38, StringUtiles.replaceSubString(GameText.STR_TOOLBAR_SILENS_IN_MIN, "%", "5"));
        MenuItem miChatWarn0030 = new MenuItem(40, StringUtiles.replaceSubString(GameText.STR_TOOLBAR_SILENS_IN_MIN, "%", "30"));
        MenuItem miChatWarn0060 = new MenuItem(41, StringUtiles.replaceSubString(GameText.STR_TOOLBAR_SILENS_IN_HOUR, "%", "1"));
        MenuItem miChatWarn0180 = new MenuItem(42, StringUtiles.replaceSubString(GameText.STR_TOOLBAR_SILENS_IN_HOUR, "%", "3"));
        MenuItem miChatWarn1440 = new MenuItem(44, StringUtiles.replaceSubString(GameText.STR_TOOLBAR_SILENS_IN_HOUR, "%", "24"));
        MenuItem miChatBan = new MenuItem(36, GameText.STR_TOOLBAR_CHATBAN);
        MenuItem miChatPrivate = new MenuItem(7, GameText.STR_TOOLBAR_PRIVATE);
        MenuItem miChatWriteTo = new MenuItem(8, GameText.STR_TOOLBAR_WRITE);
        MenuItem miChatMailTo = new MenuItem(35, GameText.STR_TOOLBAR_MAIL);
        MenuItem miInventar1 = new MenuItem(9, GameText.STR_TOOLBAR_CLOTHES);
        MenuItem miInventar2 = new MenuItem(10, GameText.STR_TOOLBAR_GOODS);
        MenuItem miInventar3 = new MenuItem(11, GameText.STR_TOOLBAR_PRESENTS);
        MenuItem miInventar4 = new MenuItem(3, GameText.STR_TOOLBAR_DRESSON);
        MenuItem miInventar5 = new MenuItem(28, GameText.STR_TOOLBAR_PUTOFF);
        MenuItem miInventar6 = new MenuItem(29, GameText.STR_TOOLBAR_INFO);
        MenuItem miShop1 = new MenuItem(12, GameText.STR_TOOLBAR_BYE);
        MenuItem miShop2 = new MenuItem(13, GameText.STR_TOOLBAR_INFO);
        MenuItem miSecond1 = new MenuItem(14, GameText.STR_TOOLBAR_REPAER);
        MenuItem miSecond2 = new MenuItem(15, GameText.STR_TOOLBAR_SELL);
        MenuItem miLocation1 = new MenuItem(16, GameText.STR_TOOLBAR_ENTERING);
        MenuItem miLocation2 = new MenuItem(17, GameText.STR_TOOLBAR_INFO);
        MenuItem miQuests1 = new MenuItem(18, GameText.STR_TOOLBAR_INFO);
        MenuItem miBeats1 = new MenuItem(19, GameText.STR_TOOLBAR_AGRESSION);
        MenuItem miBeats2 = new MenuItem(20, GameText.STR_TOOLBAR_INFO);
        MenuItem miLocateList1 = new MenuItem(21, GameText.STR_TOOLBAR_MOVE);
        MenuItem miLocateList2 = new MenuItem(22, GameText.STR_TOOLBAR_INFO);
        MenuItem miStatistic1 = new MenuItem(23, GameText.STR_TOOLBAR_PARAMS);
        MenuItem miStatistic2 = new MenuItem(24, GameText.STR_TOOLBAR_REWARDS);
        MenuItem miStatistic3 = new MenuItem(25, GameText.STR_TOOLBAR_PERKS);
        MenuItem miStatistic4 = new MenuItem(26, GameText.STR_TOOLBAR_WIZARDS);
        MenuItem miStatistic5 = new MenuItem(27, GameText.STR_TOOLBAR_PRESENTS);
        MenuItem miStatistic6 = new MenuItem(32, GameText.STR_TOOLBAR_SUPER);
        MenuItem miBattleCreate = new MenuItem(30, GameText.STR_TOOLBAR_CREATE);
        MenuItem miBattleEnter = new MenuItem(31, GameText.STR_TOOLBAR_ENTERING);
        MenuItem miMailOpen = new MenuItem(33, GameText.STR_TOOLBAR_OPEN);
        MenuItem miMailDelete = new MenuItem(34, GameText.STR_TOOLBAR_DELETE);
        String clientVersion;
        int clientVersionTop = 0;
        int clientVersionMid = 0;
        int clientVersionBot = 0;
        int GameStateCur = 0;
        int withWeapon = 0;
        int listActiveElement = 0;
        int fieldActiveElement = 0;
        int shopItemsType = 0;
        Vector ShopItemsList = new Vector();
        Vector RewardsItemsList = new Vector();
        Vector GiftsItemsList = new Vector();
        Vector LocatesList = new Vector();
        long lastTimeWaiting;
        boolean isWaiting;
        Window window = new Window();
        AnimationComplexPicture waitingAnim = null;
        int SelectedItem = 0;
        int ItemsShiftY = 0;
        private int label1XShift = 0;
        private int label1XShiftDirection = 1;
        private long label1Time = 0L;
        private long labelTimeFirstPause = 1000L;
        private long labelTimeLastPause = 1000L;
        static final int BATTLE_STEP_TIME = 30000;
        static final int STATE_BATTLE_ACTION = 0;
        static final int STATE_BATTLE_BAG = 1;
        static final int STATE_BATTLE_BOOK = 2;
        static final int STATE_BATTLE_ALIE = 3;
        static final int STATE_BATTLE_ENEMY = 4;
        static final int STATE_BATTLE_LOG = 5;
        int battleStepPrepearedState = 0;
        int enemyHealth = 0;
        int enemyHealthMax = 0;
        boolean isPlayeredTurn = false;
        boolean isPlayeredNextTurn = false;
        boolean playerEnd = false;
        boolean enemyEnd = false;
        AnimationComplexPicture battleSelecter = null;
        AnimationComplexPicture battleSuperPunch = null;
        AnimationData battleSuperPunchWoman = null;
        int battleSelecterIndex = 0;
        int battleState;
        boolean isBattleOver = true;
        boolean isWinner = false;
        Image battleLocation = null;
        AnimationComplexPicture battleLoc = null;
        ComplexPicture battleGUICP = null;
        Vector battleAliesList = new Vector(0);
        Vector battleEnemiesList = new Vector(0);
        int battleActionState = 0;
        int damageDraw;
        Vector BattleLogList = null;
        int EnemyID = 0;
        Warrior curEnemy;
        Image[] battleLogImages = new Image[4];
        int createBattle_MIN = 0;
        int createBattle_MAX = 0;
        int createBattle_TEAM = 0;
        int ourTEAM = 0;
        int battleLocationID = 0;
        int battleID = 0;
        int lastEnemyID = 0;
        int battleIDSelected = 0;
        Vector battlesList = null;
        int battleWaitState = 0;
        long inBattleStepTime = 0L;
        int battleBonusMoney = 0;
        int battleBonusExp = 0;
        boolean showEnemy = false;
        static final int LOCATION_STEP_TIME = 30000;
        Building curBuilding = new Building(-1, "", -1);
        static final int BATTLE_PLAYER_TURN = 1;
        static final int BATTLE_WAIT_TURN = 2;
        static final int BATTLE_RESULT_TURN = 3;
        static final int BATTLE_ENEMY_TURN = 4;
        static final int BATTLE_END_RESULT = 5;
        static final int TABID_SHOP_BREASTPLATE = -1;
        static final int TABID_SHOP_HELMET = -2;
        static final int TABID_SHOP_LEGED = -3;
        static final int TABID_SHOP_BOOT = -4;
        static final int TABID_SHOP_SHOULDER = -5;
        static final int TABID_SHOP_ARMED = -6;
        static final int TABID_SHOP_SWORD = -7;
        static final int TABID_SHOP_SHIELD = -8;
        static final int TABID_SHOP_ELIXIR = -9;
        static final int TABID_BUILDINGS = 1;
        static final int TABID_INVENTAR = 2;
        static final int TABID_CHAT = 3;
        static final int TABID_QUESTS = 4;
        static final int TABID_LOCATIONS = 5;
        static final int TABID_STATISTIC = 6;
        static final int TABID_BATTLE_ACTION = 7;
        static final int TABID_BATTLE_BAG = 9;
        static final int TABID_BATTLE_BOOK = 10;
        static final int TABID_BATTLE_ALIE = 11;
        static final int TABID_BATTLE_ENEMY = 12;
        static final int TABID_BATTLE_LOG = 13;
        static final int TABID_ARENA_LIST = 14;
        static final int TABID_ARENA_TEAM1 = 15;
        static final int TABID_ARENA_TEAM2 = 16;
        static final int TABID_SETTING = 17;
        static final int TABID_SMS = 18;
        static final int TABID_MAILS = 19;
        static final int TABID_LOC_USERS = 20;
        int inventarState;
        static final int INVENTAR_STATE_CLOTHES = 1;
        static final int INVENTAR_STATE_GOODS = 2;
        static final int INVENTAR_STATE_PRESENTS = 3;
        int statisticState;
        static final int STATISTIC_STATE_LEVELS = 1;
        static final int STATISTIC_STATE_PERKS = 2;
        static final int STATISTIC_STATE_REWARDS = 3;
        static final int STATISTIC_STATE_GIFTS = 4;
        static final int CLOTHES_BREASTPLATES = 1;
        static final int CLOTHES_HELMETS = 2;
        static final int CLOTHES_LEGEDS = 3;
        static final int CLOTHES_BOOTS = 4;
        static final int CLOTHES_SHOULDERS = 5;
        static final int CLOTHES_ARMEDS = 6;
        static final int CLOTHES_SWORDS = 7;
        static final int CLOTHES_SHIELDS = 8;
        int superPunshState;
        private Vector paksDataBreastPlatesMan = new Vector();
        private Vector paksDataHelmetsMan = new Vector();
        private Vector paksDataLegedsMan = new Vector();
        private Vector paksDataBootsMan = new Vector();
        private Vector paksDataShouldersMan = new Vector();
        private Vector paksDataArmedsMan = new Vector();
        private Vector paksDataSwordsMan = new Vector();
        private Vector paksDataShieldsMan = new Vector();
        private Vector paksDataBreastPlatesWoman = new Vector();
        private Vector paksDataHelmetsWoman = new Vector();
        private Vector paksDataLegedsWoman = new Vector();
        private Vector paksDataBootsWoman = new Vector();
        private Vector paksDataShouldersWoman = new Vector();
        private Vector paksDataArmedsWoman = new Vector();
        private Vector paksDataSwordsWoman = new Vector();
        private Vector paksDataShieldsWoman = new Vector();
        static final int LIST_TYPE_BUILDINGS = 1;
        static final int LIST_TYPE_CLOTHES_INVENTORY = 2;
        static final int LIST_TYPE_CLOTHES_SHOP = 3;
        static final int LIST_TYPE_CLOTHES_SECONDHAND = 4;
        static final int LIST_TYPE_QUESTS = 5;
        static final int LIST_TYPE_ENEMYES_IN_HUNT = 6;
        static final int LIST_TYPE_LOCATIONS = 7;
        static final int LIST_TYPE_ALIES_IN_BATTLE = 8;
        static final int LIST_TYPE_ENEMYES_IN_BATTLE = 9;
        static final int LIST_TYPE_STRIKES_IN_BATTLE = 10;
        static final int LIST_TYPE_QUILLWORTS = 11;
        static final int LIST_TYPE_PRESENTS_IN_INVENTARY = 12;
        static final int LIST_TYPE_REWARDS = 13;
        static final int LIST_TYPE_PRESENTS_IN_INFO = 14;
        static final int LIST_TYPE_BATTLES_ON_ARENA = 15;
        static final int LIST_TYPE_BATTLES_USERS1_WAIT = 16;
        static final int LIST_TYPE_BATTLES_USERS2_WAIT = 17;
        static final int LIST_TYPE_SETTINGS = 18;
        static final int LIST_TYPE_SMS = 19;
        static final int LIST_TYPE_MAILS = 20;
        static final int LIST_TYPE_USERS = 21;
        MIDIPlayer SoundPlayer = new MIDIPlayer();
        static final int SOUND_BACKGROUND = 1;
        Hashtable tracksList = new Hashtable();
        Hashtable trackLocations = new Hashtable();
        Hashtable trackLocationTypes = new Hashtable();
        private Vector SettingsList = new Vector(3);
        boolean settingSoundEnable = false;
        int settingSoundLevel = 100;
        boolean settingVibroEnable = false;
        private Timer tm = new Timer();
        private HealthTimer healthTimer = new HealthTimer();
        private Vector superPunchList = new Vector(30);
        private Vector SMSList = new Vector();
        private SMS smsCur = null;
        int smsState;
        static final int SMS_STATE_LIST = 1;
        static final int SMS_STATE_WAIT = 2;
        private Vector MailsList = new Vector();
        private boolean isNewMail = false;
        public long mailStartTime = 0L;
        public long mailPauseTime = 300L;
        private Image[] mailIcons = new Image[2];
        private int formOkID = 0;
        static final int FORMOK_LOGIN = 1;
        static final int FORMOK_NIKNAME = 2;
        static final int FORMOK_PASSWORD = 3;
        static final int FORMOK_PASSREP = 4;
        static final int FORMOK_CHATCOMN = 5;
        static final int FORMOK_CHATPRIV = 6;
        static final int FORMOK_MAILFOR = 7;
        static final int FORMOK_MAILREAD = 8;
        String[] languageNamesList = new String[]{"RUS", "UZB"};
        String[] languageTypesList = new String[]{"ru", "uz"};
        int language = 0;
        private int chatMinLevel = 2;
        private int mailMinLevel = 2;
        static final int DRAWRECT_STYLE_FULL = 1;
        static final int DRAWRECT_STYLE_WOTOPBOT = 2;
        public boolean isUpdateDialog = false;
        public boolean isMustUpdate = false;
        byte clientNewVersionTop = 0;
        byte clientNewVersionMid = 0;
        byte clientNewVersionBot = 0;
        String clientNewVersionPath = "";
        String clientNewVersionStr = "";
        ScrollList scrollList = null;
        private Vector LocUsersList = new Vector();

        public GameData(Canvas c) {
            this.logo_wait = 80;
            this.MENUID_REGISTRATION = 1;
            this.MENUID_ENTERGAME = 2;
            this.MENUID_DRESSON = 3;
            this.MENUID_WRITECHATMSG = 4;
            this.MENUID_CHATPLAYERS = 5;
            this.MENUID_CHATROOMS = 6;
            this.MENUID_CHATPRVMSG = 7;
            this.MENUID_CHATWRITE = 8;
            this.MENUID_CLOTHES = 9;
            this.MENUID_GOODS = 10;
            this.MENUID_PRESENTS = 11;
            this.MENUID_BYE = 12;
            this.MENUID_SHOPINFO = 13;
            this.MENUID_REPAIR = 14;
            this.MENUID_SELL = 15;
            this.MENUID_ENTERBUILD = 16;
            this.MENUID_BUILDINFO = 17;
            this.MENUID_QUESTINFO = 18;
            this.MENUID_AGRESSION = 19;
            this.MENUID_BEASTINFO = 20;
            this.MENUID_CHANGELOCAT = 21;
            this.MENUID_LOCATEINFO = 22;
            this.MENUID_PARAMETERS = 23;
            this.MENUID_REWARDS = 24;
            this.MENUID_PERKS = 25;
            this.MENUID_MAGICS = 26;
            this.MENUID_GIFTS = 27;
            this.MENUID_GOODSDELETE = 28;
            this.MENUID_GOODSINFO = 29;
            this.MENUID_BATTLECREATE = 30;
            this.MENUID_BATTLEENTER = 31;
            this.MENUID_SUPERPUNCH = 32;
            this.MENUID_MAILOPEN = 33;
            this.MENUID_MAILDELETE = 34;
            this.MENUID_MAILWRITE = 35;
            this.MENUID_CHATBAN = 36;
            this.MENUID_CHATWARN0001 = 37;
            this.MENUID_CHATWARN0005 = 38;
            this.MENUID_CHATWARN0015 = 39;
            this.MENUID_CHATWARN0030 = 40;
            this.MENUID_CHATWARN0060 = 41;
            this.MENUID_CHATWARN0180 = 42;
            this.MENUID_CHATWARN0720 = 43;
            this.MENUID_CHATWARN1440 = 44;
            this.MENUID_CHATWARNING = 45;
            this.pCanvas = c;
            this.fontSmall = Font.getFont((int)32, (int)1, (int)8);
            this.fontMedium = Font.getFont((int)32, (int)1, (int)0);
            this.fontBig = Font.getFont((int)32, (int)1, (int)16);
            this.fontSmallNormal = Font.getFont((int)32, (int)0, (int)8);
            this.fontBigNormal = Font.getFont((int)32, (int)0, (int)16);
            this.chat.fontSmall = this.fontSmall;
            this.chat.fontMedium = this.fontMedium;
            this.chat.fontBig = this.fontBig;
            this.chat.fontSmallNormal = this.fontSmallNormal;
            this.chat.fontBigNormal = this.fontBigNormal;
            this.chat.setElementsShift(2);
            this.getDefaultLanguage();
            this.clientVersion = this.getVersion();
            this.partnerId = this.getPartner();
            try {
                int pointIndex = this.clientVersion.indexOf(".");
                int start = 0;
                if (pointIndex > 0) {
                    this.clientVersionTop = Integer.parseInt(this.clientVersion.substring(start, pointIndex));
                    start = pointIndex + 1;
                    if ((pointIndex = this.clientVersion.indexOf(".", start)) > 0) {
                        this.clientVersionMid = Integer.parseInt(this.clientVersion.substring(start, pointIndex));
                        this.clientVersionBot = Integer.parseInt(this.clientVersion.substring(pointIndex + 1, this.clientVersion.length()));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.SettingsList.addElement(new String("false"));
            this.SettingsList.addElement(new String("100"));
            this.SettingsList.addElement(new String("false"));
        }

        private final void Init() {
            this.loadPaksList();
            this.loadClothesResData();
            this.loadResForCommon();
            this.loadOptions();
            this.loadResForLogo();
            this.loadSoundResData();
            Game.this.setFullScreenMode(true);
            this.tm.scheduleAtFixedRate((TimerTask)this.healthTimer, 0L, 1000L);
        }

        private final void ExecState(GameStateManager.GameState gs) {
            if (this.isWaiting) {
                Game.this.keyClear();
            }
            if (this.window.active) {
                if (!this.window.isExternDraw()) {
                    this.window.run();
                } else {
                    this.stepWindowExtern();
                }
                Game.this.keyClear();
            }
            this.GameStateCur = gs.State;
            switch (gs.State) {
                case 1: {
                    this.stepLogo_1();
                    break;
                }
                case 2: {
                    this.stepLogo_2();
                    break;
                }
                case 3: {
                    this.stepLogo_3();
                    break;
                }
                case 4: {
                    this.stepLogin();
                    break;
                }
                case 5: {
                    this.stepRegistration1();
                    break;
                }
                case 6: {
                    this.stepRegistration2();
                    break;
                }
                case 7: {
                    this.stepRoom();
                    break;
                }
                case 8: {
                    this.stepLocation();
                    break;
                }
                case 9: {
                    this.stepChat();
                    break;
                }
                case 10: {
                    this.stepChatUsers();
                    break;
                }
                case 11: {
                    this.stepShop();
                    break;
                }
                case 12: {
                    this.stepSecondHand();
                    break;
                }
                case 13: {
                    this.stepQuests();
                    break;
                }
                case 14: {
                    this.stepBeasts();
                    break;
                }
                case 15: {
                    this.stepBattle();
                    break;
                }
                case 22: {
                    break;
                }
                case 16: {
                    this.stepLocatesList();
                    break;
                }
                case 17: {
                    this.stepPersStats();
                    break;
                }
                case 18: {
                    this.stepArena();
                    break;
                }
                case 19: {
                    this.stepCreateBattle();
                    break;
                }
                case 20: {
                    this.stepBattleWait();
                    break;
                }
                case 21: {
                    this.stepSettings();
                    break;
                }
                case 23: {
                    this.stepSuperPunch();
                    break;
                }
                case 24: {
                    this.stepSMS();
                    break;
                }
                case 25: {
                    this.stepMails();
                    break;
                }
                case 26: {
                    this.stepUpdate();
                    break;
                }
                case 27: {
                    this.stepLocUsers();
                }
            }
        }

        private final void PaintState(Graphics g, GameStateManager.GameState gs) {
            this.GameStateCur = gs.State;
            switch (gs.State) {
                case 1: {
                    this.drawLogo_1(g);
                    break;
                }
                case 2: {
                    this.drawLogo_2(g);
                    break;
                }
                case 3: {
                    this.drawLogo_3(g);
                    break;
                }
                case 4: {
                    this.drawLogin(g);
                    break;
                }
                case 5: {
                    this.drawRegistration1(g);
                    break;
                }
                case 6: {
                    this.drawRegistration2(g);
                    break;
                }
                case 7: {
                    this.drawRoom(g);
                    break;
                }
                case 8: {
                    this.drawLocation(g);
                    break;
                }
                case 9: {
                    this.drawChat(g);
                    break;
                }
                case 10: {
                    this.drawChatUsers(g);
                    break;
                }
                case 11: {
                    this.drawShop(g);
                    break;
                }
                case 12: {
                    this.drawSecondHand(g);
                    break;
                }
                case 13: {
                    this.drawQuests(g);
                    break;
                }
                case 14: {
                    this.drawBeasts(g);
                    break;
                }
                case 15: {
                    this.drawBattle(g);
                    break;
                }
                case 22: {
                    this.drawBattle(g);
                    break;
                }
                case 16: {
                    this.drawLocatesList(g);
                    break;
                }
                case 17: {
                    this.drawPersStats(g);
                    break;
                }
                case 18: {
                    this.drawArena(g);
                    break;
                }
                case 19: {
                    this.drawCreateBattle(g);
                    break;
                }
                case 20: {
                    this.drawBattleWait(g);
                    break;
                }
                case 21: {
                    this.drawSettings(g);
                    break;
                }
                case 23: {
                    this.drawSuperPunch(g);
                    break;
                }
                case 24: {
                    this.drawSMS(g);
                    break;
                }
                case 25: {
                    this.drawMails(g);
                    break;
                }
                case 26: {
                    this.drawUpdate(g);
                    break;
                }
                case 27: {
                    this.drawLocUsers(g);
                }
            }
            if (this.window.active) {
                int clipX = g.getClipX();
                int clipY = g.getClipY();
                int clipW = g.getClipWidth();
                int clipH = g.getClipHeight();
                if (!this.window.isExternDraw()) {
                    this.window.draw(g);
                } else {
                    this.window.drawFrame(g);
                    this.drawWindowExtern(g);
                }
                g.setClip(clipX, clipY, clipW, clipH);
            }
            if (this.isNewMail && this.mailStartTime != 0L && Game.this.paintTimeCur > this.mailStartTime && (Game.this.paintTimeCur - this.mailStartTime) / this.mailPauseTime % 3L != 0L) {
                int top = 220 - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(5) + this.guiCP.GetHeight(2);
                g.drawImage(this.newMailIcon, 88, top + this.guiCP.GetHeight(5) / 2, 3);
            }
            if (this.isWaiting) {
                this.drawWaiting(g);
            }
        }

        public void OpenConnection() {
            this.conn = new MobileConnection(this);
            try {
                int stat = this.conn.InitConnection(this.hostName, this.hostPort);
                if (stat != 0 && (stat = this.conn.InitConnection(this.hostIP, this.hostPort)) != 0) {
                    this.conn = null;
                }
            }
            catch (Exception e) {
                this.conn = null;
            }
        }

        public void CloseConnection() {
            this.window.init(GameText.STR_LOGIN_ERROR1);
            Game.this.keyClear();
            this.initFirstData();
            this.setState(4);
            this.isWaiting = false;
            this.conn.CloseConnection();
            this.conn = null;
        }

        public void GetNetMessage(int msgType, Hashtable p) {
            block178: {
                try {
                    Hashtable[] hArr = null;
                    block1 : switch (msgType) {
                        case 3: {
                            this.playerId = Param.getInt(p, 0);
                            if (this.playerId <= 0) break;
                            this.chat.userID = this.playerId;
                            this.isManPers = (Byte)p.get(new Byte(1)) == 0;
                            this.typePers = ((Byte)p.get(new Byte(2))).byteValue();
                            this.persAnim = this.loadResForPers(this.typePers, this.isManPers);
                            this.typeHear = ((Byte)p.get(new Byte(3))).byteValue();
                            this.hearAnim = this.loadHearData(this.isManPers, this.typeHear);
                            this.typeBreastplate = 1;
                            this.typeHelmet = 1;
                            this.typeLeged = 1;
                            this.typeBoot = 1;
                            this.typeShoulder = 1;
                            this.typeArmed = 1;
                            this.typeSword = 1;
                            this.typeShield = 1;
                            this.expCur = (Integer)p.get(new Byte(5));
                            this.expMin = (Integer)p.get(new Byte(6));
                            this.expMax = (Integer)p.get(new Byte(7));
                            this.nikname = (String)p.get(new Byte(8));
                            this.money = (Integer)p.get(new Byte(9));
                            this.playerLevel = ((Short)p.get(new Byte(10))).shortValue();
                            this.max_clothes_count = (Integer)p.get(new Byte(12));
                            this.max_goods_count = (Integer)p.get(new Byte(13));
                            this.isGhost = (Boolean)p.get(new Byte(14));
                            this.healthCur = (Integer)p.get(new Byte(15));
                            this.healthMax = (Integer)p.get(new Byte(16));
                            this.isPoisoned = Param.getBoolean(p, 17);
                            this.chatMinLevel = Param.getInt(p, 18);
                            this.mailMinLevel = Param.getInt(p, 19);
                            if (this.healthCur < this.healthMax + this.healthBonus && !this.isGhost) {
                                this.healthTimer.pause = false;
                            }
                            this.QuestsList.removeAllElements();
                            Quest q = new Quest(1, 0, "\u0423\u0431\u0438\u0439\u0446\u0430 \u0441\u043a\u0435\u043b\u0435\u0442\u043e\u0432", "\u0423\u0431\u0438\u0442\u044c 10 \u0441\u043a\u0435\u043b\u043e\u0432", "\u041d\u0435 \u043f\u0440\u0438\u043d\u044f\u0442");
                            this.QuestsList.addElement(q);
                            q = new Quest(2, 1, "\u0418\u0441\u0442\u0440\u0435\u0431\u0438\u0442\u0435\u043b\u044c \u0441\u043a\u0435\u043b\u0435\u0442\u043e\u0432", "\u0423\u0431\u0438\u0442\u044c 30 \u0441\u043a\u0435\u043b\u043e\u0432", "2008.09.10 21:00:10");
                            this.QuestsList.addElement(q);
                            q = new Quest(3, 2, "\u0423\u0431\u0438\u0439\u0446\u0430 \u043c\u0435\u0440\u0442\u0432\u044f\u043a\u043e\u0432", "\u0423\u0431\u0438\u0442\u044c 10 \u043c\u0435\u0440\u0442\u0432\u044f\u043a\u043e\u0432", "\u041d\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e");
                            this.QuestsList.addElement(q);
                            q = new Quest(4, 3, "\u0423\u0431\u0438\u0439\u0446\u0430 \u043c\u0435\u0440\u0442\u0432\u044f\u043a\u043e\u0432 2", "\u0423\u0431\u0438\u0442\u044c 20 \u043c\u0435\u0440\u0442\u0432\u044f\u043a\u043e\u0432", "\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e 2008.09.10 21:00:10");
                            this.QuestsList.addElement(q);
                            this.hearAnimForSelect.removeAllElements();
                            if (!this.isUpdateDialog) {
                                this.initTabs();
                                this.setState(8);
                                break;
                            }
                            this.isWaiting = false;
                            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
                            int left = 0 + this.guiCP.GetWidth(0) + 2;
                            FontManagerEx.setPage(left, tabsBottom, this.chat.getScreenW() - 2, this.chat.getScreenH());
                            int count = FontManagerEx.lineNum(0, this.clientNewVersionStr);
                            int h = count * FontManagerEx.getHeight(0);
                            this.scrollList = new ScrollList(new ScrollListElement[]{new SimpleScrollElement(this.clientNewVersionStr, this.chat.getScreenW() - 2, h)}, true);
                            this.scrollList.initScreen(this.chat.getScreenW() - 2, this.chat.getScreenH());
                            this.setState(26);
                            break;
                        }
                        case 16: {
                            this.clientNewVersionTop = Param.getByte(p, 0);
                            this.clientNewVersionMid = Param.getByte(p, 1);
                            this.clientNewVersionBot = Param.getByte(p, 2);
                            this.clientNewVersionPath = Param.getString(p, 3);
                            this.clientNewVersionStr = Param.getString(p, 4);
                            this.isMustUpdate = false;
                            this.isUpdateDialog = true;
                            break;
                        }
                        case 12: {
                            int _id = Param.getInt(p, 0);
                            byte[] _data = Param.getByteArray(p, 1);
                            for (int i = 0; i < this.paksNotInList.size(); ++i) {
                                Pak pak = (Pak)this.paksNotInList.elementAt(i);
                                if (pak.id != _id) continue;
                                this.paksNotInList.removeElementAt(i);
                                this.savePakInRMS(pak, _data);
                                this.paksHashMap.put(pak.name, pak);
                                break;
                            }
                            if (this.paksNotInList.size() == 0) {
                                this.SendNetMessage(5);
                            }
                            break;
                        }
                        case 17: {
                            this.paksNotInList.removeAllElements();
                            int[] versions = Param.getIntArray(p, 0);
                            String[] names = Param.getStringArray(p, 1);
                            int[] ids = Param.getIntArray(p, 2);
                            if (versions.length == names.length && names.length > 0) {
                                for (int i = 0; i < names.length; ++i) {
                                    Pak pak;
                                    if (!this.paksHashMap.containsKey(names[i])) {
                                        pak = new Pak(ids[i], versions[i], names[i], 0);
                                        pak.rmsid = 0;
                                        this.paksNotInList.addElement(pak);
                                        continue;
                                    }
                                    pak = (Pak)this.paksHashMap.get(names[i]);
                                    if (pak != null && pak.ver >= versions[i]) continue;
                                    Pak pak2 = new Pak(ids[i], versions[i], names[i], 0);
                                    pak2.rmsid = pak.rmsid;
                                    this.paksNotInList.addElement(pak2);
                                }
                            }
                            if (!this.isUpdateDialog) {
                                if (this.paksNotInList.size() == 0) {
                                    this.SendNetMessage(5);
                                    break;
                                }
                                this.SendNetMessage(11);
                            }
                            break;
                        }
                        case 30: {
                            this.typeBreastplate = 0;
                            this.typeHelmet = 0;
                            this.typeLeged = 0;
                            this.typeBoot = 0;
                            this.typeShoulder = 0;
                            this.typeArmed = 0;
                            this.typeSword = 0;
                            this.typeShield = 0;
                            hArr = Param.getHashtableArray(p, 0);
                            this.dressedClothes = 0;
                            this.ClothesItemsList.removeAllElements();
                            this.GoodsItemsList.removeAllElements();
                            this.PresentsItemsList.removeAllElements();
                            this.RewardsItemsList.removeAllElements();
                            this.GiftsItemsList.removeAllElements();
                            for (int i = 0; i < hArr.length; ++i) {
                                InventoryItem ci = new InventoryItem(hArr[i]);
                                if (ci.isDressable()) {
                                    if (ci.isDressed) {
                                        ++this.dressedClothes;
                                        switch (ci.type) {
                                            case 1: {
                                                this.typeBreastplate = ci.idInType;
                                                break;
                                            }
                                            case 2: {
                                                this.typeHelmet = ci.idInType;
                                                break;
                                            }
                                            case 3: {
                                                this.typeLeged = ci.idInType;
                                                break;
                                            }
                                            case 4: {
                                                this.typeBoot = ci.idInType;
                                                break;
                                            }
                                            case 5: {
                                                this.typeShoulder = ci.idInType;
                                                break;
                                            }
                                            case 6: {
                                                this.typeArmed = ci.idInType;
                                                break;
                                            }
                                            case 7: {
                                                this.typeSword = ci.idInType;
                                                break;
                                            }
                                            case 8: {
                                                this.typeShield = ci.idInType;
                                            }
                                        }
                                    }
                                    ci.image = this.loadIconForItem(ci.type, ci.idInType - 1);
                                    this.ClothesItemsList.addElement(ci);
                                    continue;
                                }
                                switch (ci.type) {
                                    case 9: {
                                        ci.image = this.loadIconForItem(ci.type, ci.idInType - 1);
                                        this.GoodsItemsList.addElement(ci);
                                    }
                                }
                            }
                            this.isWaiting = false;
                            break;
                        }
                        case 31: {
                            InventoryItem ii = new InventoryItem(p);
                            if (ii.isDressable()) {
                                ii.image = this.loadIconForItem(ii.type, ii.idInType - 1);
                                this.ClothesItemsList.addElement(ii);
                            }
                            break;
                        }
                        case 41: {
                            this.money = (Integer)Param.get(p, 0);
                            break;
                        }
                        case 21: {
                            int _level = Param.getInt(p, 0);
                            boolean _opened = Param.getBoolean(p, 1);
                            int[] _seq = Param.getIntArray(p, 2);
                            SuperPunch sp = new SuperPunch(_level, _opened, _seq);
                            this.superPunchList.addElement(sp);
                            break;
                        }
                        case 22: {
                            this.healthCur = Param.getInt(p, 0);
                            this.healthMax = Param.getInt(p, 1);
                            this.isPoisoned = Param.getBoolean(p, 2);
                            if (this.isGhost || !this.isBattleOver) break;
                            this.healthTimer.pause = false;
                            break;
                        }
                        case 23: {
                            int _level = Param.getInt(p, 0);
                            boolean _opened = Param.getBoolean(p, 1);
                            int[] _seq = Param.getIntArray(p, 2);
                            SuperPunch sp = (SuperPunch)this.superPunchList.elementAt(_level - 1);
                            sp.Level = _level;
                            sp.Opened = _opened;
                            sp.Seq = _seq;
                            break;
                        }
                        case 71: {
                            long _inLocationTime = (Long)Param.get(p, 0);
                            this.inLocationTime = System.currentTimeMillis() - _inLocationTime;
                            int _LocationType = Param.getInt(p, 1);
                            this.LocUsersList.removeAllElements();
                            if (this.LocationType != _LocationType) {
                                String str;
                                this.SoundPlayer.DelPlayer(1);
                                Integer trackID = (Integer)this.trackLocationTypes.get(new Integer(_LocationType));
                                if (trackID != null && (str = (String)this.tracksList.get(trackID)) != null) {
                                    this.SoundPlayer.AddPlayer("/res/sounds/" + str, 1);
                                    if (this.settingSoundEnable) {
                                        this.SoundPlayer.Play(1, 0);
                                    }
                                }
                                this.LocationType = _LocationType;
                            }
                            this.locationName = (String)Param.get(p, 2);
                            this.initLocation((Hashtable[])Param.get(p, 3));
                            this.LocatesList.removeAllElements();
                            hArr = (Hashtable[])Param.get(p, 4);
                            for (int i = 0; i < hArr.length; ++i) {
                                Locate loc = new Locate(hArr[i]);
                                loc.Image = this.loadIconForLocate(loc.Type - 1);
                                this.LocatesList.addElement(loc);
                            }
                            if (this.isWaiting && this.GameStateCur == 16) {
                                this.isWaiting = false;
                            }
                            break;
                        }
                        case 101: {
                            int chaterId = (Integer)p.get(new Byte(0));
                            String chaterNik = (String)p.get(new Byte(1));
                            byte chaterLevel = (Byte)p.get(new Byte(2));
                            String chaterCountry = (String)p.get(new Byte(3));
                            int chaterRoom = (Integer)p.get(new Byte(4));
                            this.chat.addUser(chaterId, chaterNik, chaterLevel);
                            break;
                        }
                        case 103: {
                            int chaterId = (Integer)p.get(new Byte(0));
                            this.chat.delUser(chaterId);
                            break;
                        }
                        case 105: {
                            int chaterId = (Integer)p.get(new Byte(0));
                            int receiverId = (Integer)p.get(new Byte(1));
                            byte msgTypeId = (Byte)p.get(new Byte(2));
                            String text = (String)p.get(new Byte(3));
                            this.chat.addMessage(chaterId, receiverId, msgTypeId, text);
                            break;
                        }
                        case 106: {
                            byte role = Param.getByte(p, 0);
                            int rommId = Param.getInt(p, 1);
                            if (role > 0) {
                                this.miChatWarning.visible = true;
                                this.miChatWarn0005.visible = true;
                                this.miChatWarn0030.visible = true;
                                this.miChatWarn0060.visible = true;
                                this.miChatWarn0180.visible = true;
                                this.miChatWarn1440.visible = true;
                                this.miChatBan.visible = true;
                                this.miEmpty.visible = true;
                                break;
                            }
                            this.miChatWarning.visible = false;
                            this.miChatWarn0005.visible = false;
                            this.miChatWarn0030.visible = false;
                            this.miChatWarn0060.visible = false;
                            this.miChatWarn0180.visible = false;
                            this.miChatWarn1440.visible = false;
                            this.miChatBan.visible = false;
                            this.miEmpty.visible = false;
                            break;
                        }
                        case 61: {
                            hArr = (Hashtable[])Param.get(p, 0);
                            this.ShopItemsList.removeAllElements();
                            for (int i = 0; i < hArr.length; ++i) {
                                InventoryItem ci = new InventoryItem(hArr[i]);
                                ci.idInShop = (Integer)Param.get(hArr[i], 7);
                                ci.price = (Integer)Param.get(hArr[i], 8);
                                ci.image = this.loadIconForItem(ci.type, ci.idInType - 1);
                                this.ShopItemsList.addElement(ci);
                                if (i != 0) continue;
                                this.SelectedItem = 1;
                            }
                            this.isWaiting = false;
                            break;
                        }
                        case 64: {
                            byte[] types = Param.getByteArray(p, 0);
                            block99: for (int i = 0; i < types.length; ++i) {
                                switch (types[i]) {
                                    case 1: {
                                        this.tabs.addTab(-1, " " + GameText.STR_GOODS_BREASTPLATE + " ");
                                        continue block99;
                                    }
                                    case 2: {
                                        this.tabs.addTab(-2, " " + GameText.STR_GOODS_HELMET + " ");
                                        continue block99;
                                    }
                                    case 3: {
                                        this.tabs.addTab(-3, " " + GameText.STR_GOODS_LEGED + " ");
                                        continue block99;
                                    }
                                    case 4: {
                                        this.tabs.addTab(-4, " " + GameText.STR_GOODS_BOOT + " ");
                                        continue block99;
                                    }
                                    case 5: {
                                        this.tabs.addTab(-5, " " + GameText.STR_GOODS_SHOULDER + " ");
                                        continue block99;
                                    }
                                    case 6: {
                                        this.tabs.addTab(-6, " " + GameText.STR_GOODS_ARMED + " ");
                                        continue block99;
                                    }
                                    case 7: {
                                        this.tabs.addTab(-7, " " + GameText.STR_GOODS_SWORD + " ");
                                        continue block99;
                                    }
                                    case 8: {
                                        this.tabs.addTab(-8, " " + GameText.STR_GOODS_SHIELD + " ");
                                        continue block99;
                                    }
                                    case 9: {
                                        this.tabs.addTab(-9, " " + GameText.STR_GOODS_ELIXIR + " ");
                                    }
                                }
                            }
                            this.isWaiting = false;
                            this.getGoods(types[0]);
                            break;
                        }
                        case 4: {
                            String str = (String)Param.get(p, 0);
                            this.window.init(str);
                            this.isWaiting = false;
                            break;
                        }
                        case 35: {
                            int _inventoryID = Param.getInt(p, 0);
                            int _countID = Param.getInt(p, 1);
                            boolean _result = Param.getBoolean(p, 2);
                            if (_result) {
                                this.dropClothesItem(_inventoryID);
                            }
                            this.isWaiting = false;
                            break;
                        }
                        case 81: {
                            this.battleID = Param.getInt(p, 0);
                            this.isWaiting = false;
                            if (this.battleID <= 0) break;
                            this.battleWaitState = 0;
                            this.setState(20);
                            break;
                        }
                        case 96: {
                            this.battleID = Param.getInt(p, 0);
                            if (this.battleID != 0) break;
                            this.isWaiting = false;
                            break;
                        }
                        case 83: {
                            if (this.battlesList == null) break;
                            int _battleID = Param.getInt(p, 0);
                            int _levelMin = Param.getInt(p, 1);
                            int _levelMax = Param.getInt(p, 2);
                            int _teamCount = Param.getInt(p, 3);
                            int _team1Count = Param.getInt(p, 4);
                            int _team2Count = Param.getInt(p, 5);
                            this.battlesList.addElement(new Battle(_battleID, _levelMin, _levelMax, _teamCount, _team1Count, _team2Count));
                            if (this.battlesList.size() == 1) {
                                this.SelectedItem = 1;
                            }
                            break;
                        }
                        case 85: {
                            this.isWaiting = false;
                            int _battleID = Param.getInt(p, 0);
                            int _teamID = Param.getInt(p, 1);
                            int result = Param.getInt(p, 2);
                            int _createBattle_TEAM = Param.getInt(p, 3);
                            if (result == 0) {
                                this.createBattle_TEAM = _createBattle_TEAM;
                                if (this.battleID > 0) {
                                    if (_battleID == this.battleID) {
                                        if (_teamID == 0) {
                                            Warrior w = new Warrior(this.playerId, this.nikname, this.playerLevel, false, false, this.isManPers, this.typePers, this.typeHear, this.healthCur, this.healthMax);
                                            this.battleAliesList.addElement(w);
                                            if (this.battleWaitState == 0 && this.SelectedItem == 0) {
                                                this.SelectedItem = 1;
                                            }
                                        } else if (_teamID == 1) {
                                            Warrior w = new Warrior(this.playerId, this.nikname, this.playerLevel, false, false, this.isManPers, this.typePers, this.typeHear, this.healthCur, this.healthMax);
                                            this.battleEnemiesList.addElement(w);
                                            if (this.battleWaitState == 1 && this.SelectedItem == 0) {
                                                this.SelectedItem = 1;
                                            }
                                        }
                                    }
                                } else if (_battleID == this.battleIDSelected) {
                                    this.ourTEAM = _teamID;
                                    if (_teamID == 0) {
                                        Warrior w = new Warrior(this.playerId, this.nikname, this.playerLevel, false, false, this.isManPers, this.typePers, this.typeHear, this.healthCur, this.healthMax);
                                        this.battleAliesList.addElement(w);
                                        this.battleID = _battleID;
                                        this.battleWaitState = 0;
                                        this.setState(20);
                                        break;
                                    }
                                    if (_teamID == 1) {
                                        Warrior w = new Warrior(this.playerId, this.nikname, this.playerLevel, false, false, this.isManPers, this.typePers, this.typeHear, this.healthCur, this.healthMax);
                                        this.battleEnemiesList.addElement(w);
                                        this.battleID = _battleID;
                                        this.battleWaitState = 0;
                                        this.setState(20);
                                    }
                                }
                                break;
                            }
                            switch (result) {
                                case 2: {
                                    this.window.init(GameText.STR_BATTLE_JOIN_ERR2);
                                    break;
                                }
                                case 3: {
                                    this.window.init(GameText.STR_BATTLE_JOIN_ERR3);
                                    break;
                                }
                                case 5: {
                                    this.window.init(GameText.STR_BATTLE_JOIN_ERR5);
                                    break;
                                }
                                default: {
                                    this.window.init(GameText.STR_BATTLE_JOIN_ERR1);
                                }
                            }
                            for (int i = 0; i < this.battlesList.size(); ++i) {
                                Battle b = (Battle)this.battlesList.elementAt(i);
                                if (b.id != _battleID) continue;
                                this.battlesList.removeElementAt(i);
                                if (this.battlesList.size() == 0) {
                                    this.SelectedItem = 0;
                                    break block1;
                                }
                                break block178;
                            }
                            break;
                        }
                        case 86: {
                            int _battleID = Param.getInt(p, 0);
                            int _teamID = Param.getInt(p, 1);
                            int result = Param.getInt(p, 2);
                            int pID = Param.getInt(p, 3);
                            int pLevel = Param.getInt(p, 4);
                            String pNik = Param.getString(p, 5);
                            boolean pMan = Param.getBoolean(p, 6);
                            if (result == 0 && _battleID == this.battleID) {
                                if (_teamID == 0) {
                                    Warrior w = new Warrior(pID, pNik, pLevel, false, false, pMan, 0, 0, 0, 0);
                                    this.battleAliesList.addElement(w);
                                    if (this.battleWaitState == 0 && this.SelectedItem == 0) {
                                        this.SelectedItem = 1;
                                    }
                                } else if (_teamID == 1) {
                                    Warrior w = new Warrior(pID, pNik, pLevel, false, false, pMan, 0, 0, 0, 0);
                                    this.battleEnemiesList.addElement(w);
                                    if (this.battleWaitState == 1 && this.SelectedItem == 0) {
                                        this.SelectedItem = 1;
                                    }
                                }
                            }
                            break;
                        }
                        case 88: {
                            Warrior w;
                            int i;
                            int _battleID = Param.getInt(p, 0);
                            int _pID = Param.getInt(p, 1);
                            if (_battleID != this.battleID) break;
                            boolean found = false;
                            for (i = 0; i < this.battleAliesList.size(); ++i) {
                                w = (Warrior)this.battleAliesList.elementAt(i);
                                if (w.id != _pID) continue;
                                found = true;
                                this.battleAliesList.removeElementAt(i);
                                System.out.println("Exit Alie");
                                break;
                            }
                            if (found) break;
                            for (i = 0; i < this.battleEnemiesList.size(); ++i) {
                                w = (Warrior)this.battleEnemiesList.elementAt(i);
                                if (w.id != _pID) continue;
                                found = true;
                                this.battleEnemiesList.removeElementAt(i);
                                System.out.println("Exit Enemy");
                                if (this.EnemyID == _pID) {
                                    this.showEnemy = false;
                                    this.battleState = 2;
                                    System.out.println("Exit Dueler");
                                    break block1;
                                }
                                break block178;
                            }
                            break;
                        }
                        case 89: {
                            int _battleID = Param.getInt(p, 0);
                            if (_battleID == this.battleID) {
                                this.battleLocationID = Param.getInt(p, 1);
                                this.battleAliesList.removeAllElements();
                                this.battleEnemiesList.removeAllElements();
                                this.healthTimer.pause = true;
                                this.setState(15);
                            }
                            break;
                        }
                        case 90: {
                            int _battleID = Param.getInt(p, 0);
                            if (_battleID == this.battleID) {
                                int _teamID = Param.getInt(p, 1);
                                int _pID = Param.getInt(p, 2);
                                String nik = Param.getString(p, 3);
                                int _level = Param.getInt(p, 4);
                                boolean _isMan = Param.getBoolean(p, 5);
                                int _race = Param.getInt(p, 6);
                                int _hear = Param.getInt(p, 7);
                                int _BREASTPLATE = Param.getInt(p, 8);
                                int _HELMET = Param.getInt(p, 9);
                                int _LEGED = Param.getInt(p, 10);
                                int _SHOES = Param.getInt(p, 11);
                                int _SHOULDER = Param.getInt(p, 12);
                                int _ARMED = Param.getInt(p, 13);
                                int _SWORD = Param.getInt(p, 14);
                                int _SHIELD = Param.getInt(p, 15);
                                int _healthCur = Param.getInt(p, 16);
                                int _healthMax = Param.getInt(p, 17);
                                boolean _isBot = Param.getBoolean(p, 18);
                                boolean _isBeast = Param.getBoolean(p, 19);
                                int _beastType = 0;
                                if (_isBeast) {
                                    _beastType = Param.getInt(p, 20);
                                }
                                Warrior w = new Warrior(_pID, nik, _level, false, false, _isMan, _race, _hear, _BREASTPLATE, _HELMET, _LEGED, _SHOES, _SHOULDER, _ARMED, _SWORD, _SHIELD, _healthCur, _healthMax);
                                if (_isBeast) {
                                    w.isBeast = true;
                                    w.beastType = _beastType;
                                }
                                if (!_isBeast) {
                                    w.image = this.icones_faces[_isMan ? 0 : 1];
                                } else {
                                    Warrior _w;
                                    int i;
                                    boolean found = false;
                                    for (i = 0; i < this.battleAliesList.size(); ++i) {
                                        _w = (Warrior)this.battleAliesList.elementAt(i);
                                        if (!_w.isBeast || _w.beastType != w.beastType || _w.image == null) continue;
                                        w.image = _w.image;
                                        found = true;
                                        break;
                                    }
                                    if (!found) {
                                        for (i = 0; i < this.battleEnemiesList.size(); ++i) {
                                            _w = (Warrior)this.battleEnemiesList.elementAt(i);
                                            if (!_w.isBeast || _w.beastType != w.beastType || _w.image == null) continue;
                                            w.image = _w.image;
                                            found = true;
                                            break;
                                        }
                                    }
                                    if (!found) {
                                        w.image = this.loadIconForBeast(_beastType - 1);
                                    }
                                }
                                if (_teamID == 0) {
                                    this.battleAliesList.addElement(w);
                                    break;
                                }
                                this.battleEnemiesList.addElement(w);
                            }
                            break;
                        }
                        case 91: {
                            int _battleID = Param.getInt(p, 0);
                            if (_battleID == this.battleID) {
                                int _pID = Param.getInt(p, 1);
                                boolean _active = Param.getBoolean(p, 2);
                                int _health = Param.getInt(p, 3);
                                int _healthMax = Param.getInt(p, 4);
                                if (_pID == this.playerId) {
                                    this.isPlayeredNextTurn = _active;
                                    ++this.battleStepPrepearedState;
                                } else {
                                    this.EnemyID = _pID;
                                    ++this.battleStepPrepearedState;
                                    this.enemyHealth = _health;
                                    this.enemyHealthMax = _healthMax;
                                }
                                if (this.battleStepPrepearedState >= 2 && this.battleState != 3) {
                                    this.initBattleStep();
                                    this.battleStepPrepearedState = 0;
                                }
                            }
                            break;
                        }
                        case 93: {
                            int _battleID = Param.getInt(p, 0);
                            if (_battleID == this.battleID) {
                                this.battleStepPrepearedState = 0;
                                int _pAtackID = Param.getInt(p, 1);
                                int _pDefenID = Param.getInt(p, 2);
                                int _actionAtack = Param.getInt(p, 3);
                                int _actionDefen = Param.getInt(p, 4);
                                int _damage = Param.getInt(p, 5);
                                boolean _isSuperPunch = Param.getBoolean(p, 6);
                                if (_pAtackID == this.playerId) {
                                    if (_actionAtack > 0) {
                                        this.isSuperPunch = _isSuperPunch;
                                        switch (_actionAtack) {
                                            case 1: {
                                                this.curAnim = 1 + this.withWeapon * 8;
                                                this.lastTimeAnim = 0L;
                                                break;
                                            }
                                            case 2: {
                                                this.curAnim = 2 + this.withWeapon * 8;
                                                this.lastTimeAnim = 0L;
                                                break;
                                            }
                                            case 3: {
                                                this.curAnim = 3 + this.withWeapon * 8;
                                                this.lastTimeAnim = 0L;
                                            }
                                        }
                                        BattlePunch bp = new BattlePunch((byte)(_actionAtack - 1), _pAtackID, false, _isSuperPunch, this.getAliyByID(_pAtackID));
                                        this.BattleLogList.addElement(bp);
                                        this.damageDraw = _damage;
                                        switch (_actionDefen) {
                                            case 1: {
                                                this.curAnimBeast = 4 + this.withWeaponBeast * 8;
                                                this.lastTimeAnimBeast = 0L;
                                                break;
                                            }
                                            case 2: {
                                                this.curAnimBeast = 5 + this.withWeaponBeast * 8;
                                                this.lastTimeAnimBeast = 0L;
                                                break;
                                            }
                                            case 0: {
                                                Warrior w;
                                                this.curAnimBeast = 6 + this.withWeaponBeast * 8;
                                                this.lastTimeAnimBeast = 0L;
                                                this.healthCurBeast -= _damage;
                                                this.damageDraw = _damage;
                                                if (this.healthCurBeast <= 0) {
                                                    this.healthCurBeast = 0;
                                                }
                                                if ((w = this.getEnemyByID(_pDefenID)) == null) break;
                                                w.healthCur -= _damage;
                                            }
                                        }
                                        this.battleState = 3;
                                    }
                                } else if (_actionAtack > 0) {
                                    this.isSuperPunchBeast = _isSuperPunch;
                                    switch (_actionAtack) {
                                        case 1: {
                                            this.curAnimBeast = 1 + this.withWeaponBeast * 8;
                                            this.lastTimeAnimBeast = 0L;
                                            break;
                                        }
                                        case 2: {
                                            this.curAnimBeast = 2 + this.withWeaponBeast * 8;
                                            this.lastTimeAnimBeast = 0L;
                                            break;
                                        }
                                        case 3: {
                                            this.curAnimBeast = 3 + this.withWeaponBeast * 8;
                                            this.lastTimeAnimBeast = 0L;
                                        }
                                    }
                                    BattlePunch bp = new BattlePunch((byte)(_actionAtack - 1), _pAtackID, true, _isSuperPunch, this.getEnemyByID(_pAtackID));
                                    this.BattleLogList.addElement(bp);
                                    this.damageDraw = _damage;
                                    switch (_actionDefen) {
                                        case 1: {
                                            this.curAnim = 4 + this.withWeapon * 8;
                                            this.lastTimeAnim = 0L;
                                            break;
                                        }
                                        case 2: {
                                            this.curAnim = 5 + this.withWeapon * 8;
                                            this.lastTimeAnim = 0L;
                                            break;
                                        }
                                        case 0: {
                                            Warrior w;
                                            this.curAnim = 6 + this.withWeapon * 8;
                                            this.lastTimeAnim = 0L;
                                            this.healthCur -= _damage;
                                            this.damageDraw = _damage;
                                            if (this.healthCur <= 0) {
                                                this.healthCur = 0;
                                            }
                                            if ((w = this.getAliyByID(_pDefenID)) == null) break;
                                            w.healthCur -= _damage;
                                        }
                                    }
                                    this.battleState = 3;
                                }
                            }
                            break;
                        }
                        case 94: {
                            int _battleID = Param.getInt(p, 0);
                            if (_battleID == this.battleID) {
                                this.isWinner = Param.getBoolean(p, 1);
                                if (this.isWinner) {
                                    this.battleBonusMoney = Param.getInt(p, 2);
                                    this.battleBonusExp = Param.getInt(p, 3);
                                    this.expCur += this.battleBonusExp;
                                    this.money += this.battleBonusMoney;
                                }
                                this.isBattleOver = true;
                                if (this.battleState != 3) {
                                    this.initBattleEnd();
                                }
                            }
                            break;
                        }
                        case 95: {
                            int pID = Param.getInt(p, 0);
                            int pHealthCur = Param.getInt(p, 1);
                            int pHealthMax = Param.getInt(p, 2);
                            boolean pIsPoisoned = Param.getBoolean(p, 3);
                            Warrior w = this.getEnemyByID(pID);
                            if (w == null) {
                                w = this.getAliyByID(pID);
                            }
                            if (w != null) {
                                w.healthCur = pHealthCur;
                                w.healthMax = pHealthMax;
                                w.isPoisoned = pIsPoisoned;
                            }
                            break;
                        }
                        case 97: {
                            int _level = Param.getInt(p, 0);
                            int _HealthMax = Param.getInt(p, 1);
                            int _ExpMin = Param.getInt(p, 2);
                            int _ExpMax = Param.getInt(p, 3);
                            this.playerLevel = _level;
                            this.healthMax = _HealthMax;
                            this.expMin = _ExpMin;
                            this.expMax = _ExpMax;
                            break;
                        }
                        case 43: {
                            boolean _isGhost = Param.getBoolean(p, 0);
                            this.isWaiting = false;
                            if (!_isGhost && this.isGhost) {
                                this.window.init(GameText.STR_GHOST_RESURECTION);
                            }
                            this.isGhost = _isGhost;
                            break;
                        }
                        case 74: {
                            int bID = Param.getInt(p, 0);
                            String bName = Param.getString(p, 1);
                            int bLevel = Param.getInt(p, 2);
                            Beast beast = new Beast(bID, bName, bID, bLevel);
                            beast.Image = this.loadIconForBeast(beast.Type - 1);
                            this.BeastsList.addElement(beast);
                            if (this.SelectedItem == 0) {
                                this.SelectedItem = 1;
                            }
                            break;
                        }
                        case 75: {
                            this.isWaiting = false;
                            break;
                        }
                        case 44: {
                            int _GameMoney = Param.getInt(p, 0);
                            String _RealMoney = Param.getString(p, 1);
                            String _Number = Param.getString(p, 2);
                            String _Key = Param.getString(p, 3);
                            String _Text = Param.getString(p, 4);
                            this.SMSList.addElement(new SMS(_GameMoney, _RealMoney, _Number, _Key, _Text));
                            break;
                        }
                        case 46: {
                            boolean isEnd = Param.getBoolean(p, 0);
                            if (isEnd) {
                                this.isWaiting = false;
                                break;
                            }
                            int _id = Param.getInt(p, 1);
                            String _Sender = Param.getString(p, 2);
                            int _SenderID = Param.getInt(p, 3);
                            long _Time = Param.getLong(p, 4);
                            boolean _Readed = Param.getBoolean(p, 5);
                            this.MailsList.addElement(new Mail(_id, _Readed, _Sender, _Time));
                            if (this.SelectedItem == 0) {
                                this.SelectedItem = 1;
                            }
                            break;
                        }
                        case 49: {
                            String _text = Param.getString(p, 0);
                            this.isWaiting = false;
                            if (!_text.equals("")) {
                                System.out.println(_text);
                                this.showFormSimpleText(8, "", _text, null, GameText.STR_TOOLBAR_BACK, 200);
                            }
                            break;
                        }
                        case 51: {
                            boolean _hasNew = Param.getBoolean(p, 0);
                            if (_hasNew && !this.isNewMail) {
                                this.mailStartTime = System.currentTimeMillis();
                            }
                            this.isNewMail = _hasNew;
                            break;
                        }
                        case 24: {
                            int _damage = Param.getInt(p, 0);
                            int _newHealthBonus = Param.getInt(p, 1);
                            int _healthCur = Param.getInt(p, 2);
                            this.playerDamage = _damage;
                            this.healthBonus = _newHealthBonus;
                            this.healthCur = _healthCur;
                            if (!this.isGhost && this.healthCur < this.healthMax + this.healthBonus) {
                                this.healthTimer.pause = false;
                            }
                            break;
                        }
                        case 7: {
                            int _id = Param.getInt(p, 0);
                            String _nik = Param.getString(p, 1);
                            short _level = Param.getShort(p, 2);
                            boolean _enter = Param.getBoolean(p, 3);
                            if (_enter) {
                                boolean found = false;
                                for (int i = 0; i < this.LocUsersList.size(); ++i) {
                                    User user = (User)this.LocUsersList.elementAt(i);
                                    if (user.id != _id) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    User user = new User();
                                    user.id = _id;
                                    user.nik = _nik;
                                    user.level = _level;
                                    this.LocUsersList.addElement(user);
                                }
                                break;
                            }
                            for (int i = 0; i < this.LocUsersList.size(); ++i) {
                                User user = (User)this.LocUsersList.elementAt(i);
                                if (user.id != _id) continue;
                                this.LocUsersList.removeElementAt(i);
                                break block1;
                            }
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("GetNetMessage: msgType=" + msgType + "\n" + e);
                }
            }
        }

        public void SendNetMessage(int msgType) {
            Hashtable<Byte, Object> params = new Hashtable<Byte, Object>();
            switch (msgType) {
                case 2: {
                    params.put(new Byte(0), new Integer(this.partnerId));
                    params.put(new Byte(1), this.login);
                    params.put(new Byte(2), this.password);
                    params.put(new Byte(3), new Byte((byte)this.clientVersionTop));
                    params.put(new Byte(4), new Byte((byte)this.clientVersionMid));
                    params.put(new Byte(5), new Byte((byte)this.clientVersionBot));
                    params.put(new Byte(6), this.languageTypesList[this.language]);
                    params.put(new Byte(7), Game.RES_PATH_PART);
                    break;
                }
                case 1: {
                    params.put(new Byte(0), new Integer(this.partnerId));
                    params.put(new Byte(1), this.login);
                    String nick = this.nikname;
                    params.put(new Byte(2), nick);
                    params.put(new Byte(3), this.password);
                    params.put(new Byte(4), System.getProperty("microedition.platform"));
                    params.put(new Byte(5), System.getProperty("microedition.configuration"));
                    params.put(new Byte(6), System.getProperty("microedition.profiles"));
                    params.put(new Byte(7), new Integer((int)Runtime.getRuntime().totalMemory()));
                    params.put(new Byte(8), new Integer(Game.this.getWidth()));
                    params.put(new Byte(9), new Integer(Game.this.getHeight()));
                    params.put(new Byte(10), new Byte((byte)this.clientVersionTop));
                    params.put(new Byte(11), new Byte((byte)this.clientVersionMid));
                    params.put(new Byte(12), new Byte((byte)this.clientVersionBot));
                    params.put(new Byte(13), new Byte((byte)(!this.isManPers ? 1 : 0)));
                    params.put(new Byte(14), new Byte((byte)this.typePers));
                    this.typeHear = this.listActiveElement;
                    params.put(new Byte(15), new Byte((byte)this.typeHear));
                    params.put(new Byte(16), this.languageTypesList[this.language]);
                    params.put(new Byte(17), Game.RES_PATH_PART);
                    break;
                }
                case 11: {
                    int[] pids = new int[this.paksNotInList.size()];
                    for (int i = 0; i < pids.length; ++i) {
                        Pak pak = (Pak)this.paksNotInList.elementAt(i);
                        pids[i] = pak.id;
                    }
                    params.put(new Byte(0), pids);
                    break;
                }
                case 33: {
                    params.put(new Byte(0), new Integer(this.dressedActionItem.idInInventar));
                    params.put(new Byte(1), new Boolean(this.dressedAction));
                    break;
                }
                case 60: {
                    params.put(new Byte(0), new Integer(this.curBuilding.id));
                    params.put(new Byte(1), new Byte((byte)this.shopItemsType));
                    break;
                }
                case 63: {
                    params.put(new Byte(0), new Integer(this.curBuilding.id));
                    break;
                }
                case 62: {
                    int id = -1;
                    if (this.SelectedItem > 0) {
                        id = ((InventoryItem)this.ShopItemsList.elementAt((int)(this.SelectedItem - 1))).idInShop;
                    }
                    params.put(new Byte(0), new Integer(id));
                    params.put(new Byte(1), new Integer(this.curBuilding.id));
                    break;
                }
                case 100: {
                    break;
                }
                case 102: {
                    break;
                }
                case 104: {
                    params.put(new Byte(0), new Integer(this.chatReceiverID));
                    params.put(new Byte(1), this.chatSendText);
                    break;
                }
                case 107: {
                    params.put(new Byte(0), new Integer(0));
                    params.put(new Byte(1), new Integer(this.chatReceiverID));
                    params.put(new Byte(2), new Integer(this.chatWarnTime));
                    break;
                }
                case 72: {
                    params.put(new Byte(0), new Integer(this.newLocationID));
                    break;
                }
                case 73: {
                    params.put(new Byte(0), new Integer(this.curBuilding.id));
                    break;
                }
                case 34: {
                    params.put(new Byte(0), new Integer(this.dressedActionItem.idInInventar));
                    params.put(new Byte(1), new Integer(this.dressedCount));
                    break;
                }
                case 80: {
                    this.battleAliesList.removeAllElements();
                    this.battleEnemiesList.removeAllElements();
                    params.put(new Byte(0), new Integer(this.createBattle_MIN));
                    params.put(new Byte(1), new Integer(this.createBattle_MAX));
                    params.put(new Byte(2), new Integer(this.createBattle_TEAM));
                    params.put(new Byte(3), new Integer(this.curBuilding.id));
                    break;
                }
                case 84: {
                    this.battleAliesList.removeAllElements();
                    this.battleEnemiesList.removeAllElements();
                    params.put(new Byte(0), new Integer(this.battleIDSelected));
                    params.put(new Byte(1), new Integer(2));
                    break;
                }
                case 87: {
                    params.put(new Byte(0), new Integer(this.battleID));
                    this.battleID = 0;
                    break;
                }
                case 92: {
                    params.put(new Byte(0), new Integer(this.battleID));
                    params.put(new Byte(1), new Integer(this.battleSelecterIndex + 1));
                    break;
                }
                case 42: {
                    params.put(new Byte(0), new Integer(this.curBuilding.id));
                    break;
                }
                case 76: {
                    if (this.SelectedItem <= 0 || this.SelectedItem > this.BeastsList.size()) break;
                    Beast beast = (Beast)this.BeastsList.elementAt(this.SelectedItem - 1);
                    params.put(new Byte(0), new Integer(0));
                    params.put(new Byte(1), new Integer(beast.Type));
                    params.put(new Byte(2), new Integer(this.curBuilding.id));
                    this.startWaiting();
                    break;
                }
                case 47: {
                    params.put(new Byte(0), new Integer(this.chatReceiverID));
                    params.put(new Byte(1), this.chatSendText);
                    break;
                }
                case 48: {
                    params.put(new Byte(0), new Integer(this.chatReceiverID));
                    break;
                }
                case 50: {
                    params.put(new Byte(0), new Integer(this.chatReceiverID));
                }
            }
            this.conn.send(msgType, params);
        }

        public void commandAction(Command com, Displayable d) {
            switch (com.getCommandType()) {
                case 4: {
                    boolean doExit = true;
                    switch (this.formOkID) {
                        case 2: {
                            if (!this.textFieldLogin.getString().trim().equals("")) {
                                this.nikname = this.textFieldLogin.getString();
                                break;
                            }
                            doExit = false;
                            break;
                        }
                        case 1: {
                            if (!this.textFieldLogin.getString().trim().equals("")) {
                                this.login = this.textFieldLogin.getString();
                                break;
                            }
                            doExit = false;
                            break;
                        }
                        case 3: {
                            this.password = this.textFieldLogin.getString();
                            StringBuffer sbuf = new StringBuffer(this.password.length());
                            for (int i = 0; i < this.password.length(); ++i) {
                                sbuf.append("*");
                            }
                            this.passwordMask = sbuf.toString();
                            break;
                        }
                        case 4: {
                            this.passwordConf = this.textFieldLogin.getString();
                            StringBuffer sbuf = new StringBuffer(this.passwordConf.length());
                            for (int i = 0; i < this.passwordConf.length(); ++i) {
                                sbuf.append("*");
                            }
                            this.passwordConfMask = sbuf.toString();
                            break;
                        }
                        case 5: {
                            this.chatSendText = StringUtiles.replaceSubString(this.textFieldLogin.getString(), "\n", " ").trim();
                            if (this.chatSendText.equals("")) {
                                doExit = false;
                                break;
                            }
                            this.SendNetMessage(104);
                            break;
                        }
                        case 6: {
                            this.chatSendText = StringUtiles.replaceSubString(this.textFieldLogin.getString(), "\n", " ").trim();
                            if (this.chatSendText.equals("")) {
                                doExit = false;
                                break;
                            }
                            this.SendNetMessage(104);
                            break;
                        }
                        case 7: {
                            this.chatSendText = StringUtiles.replaceSubString(this.textFieldLogin.getString(), "\n", " ").trim();
                            if (this.chatSendText.equals("")) {
                                doExit = false;
                                break;
                            }
                            this.SendNetMessage(47);
                        }
                    }
                    if (!doExit) break;
                    Display display = Display.getDisplay((MIDlet)Game.this.parent);
                    this.pCanvas.setFullScreenMode(true);
                    display.setCurrent((Displayable)this.pCanvas);
                    break;
                }
                case 7: {
                    switch (this.formOkID) {
                        case 8: {
                            if (this.MailsList.size() > 0 && this.SelectedItem > 0 && this.SelectedItem <= this.MailsList.size()) {
                                Mail mail = (Mail)this.MailsList.elementAt(this.SelectedItem - 1);
                                if (mail.ID == this.chatReceiverID) {
                                    mail.Readed = true;
                                }
                            }
                            boolean found = false;
                            for (int i = 0; i < this.MailsList.size(); ++i) {
                                Mail mail = (Mail)this.MailsList.elementAt(i);
                                if (mail.Readed) continue;
                                found = true;
                                break;
                            }
                            this.isNewMail = found;
                        }
                    }
                    Display display = Display.getDisplay((MIDlet)Game.this.parent);
                    this.pCanvas.setFullScreenMode(true);
                    display.setCurrent((Displayable)this.pCanvas);
                }
            }
        }

        public void showFormSimpleText(int okID, String formName, String simpleText, String okButton, String exiButton, int countMax) {
            this.formOkID = okID;
            Display display = Display.getDisplay((MIDlet)Game.this.parent);
            this.form = new Form(formName);
            int maxCharCount = countMax;
            int TextFieldType = 0;
            this.textFieldLogin = new TextField("", simpleText, maxCharCount, TextFieldType);
            this.form.append((Item)this.textFieldLogin);
            if (okButton != null) {
                this.form.addCommand(new Command(okButton, 4, 0));
            }
            if (exiButton != null) {
                this.form.addCommand(new Command(exiButton, 7, 0));
            }
            this.form.setCommandListener((CommandListener)this);
            display.setCurrent((Displayable)this.form);
        }

        public void showFormPasswordText(int okID, String formName, String simpleText, String okButton, String exiButton, int countMax) {
            this.formOkID = okID;
            Display display = Display.getDisplay((MIDlet)Game.this.parent);
            this.form = new Form(formName);
            int maxCharCount = countMax;
            int TextFieldType = 65536;
            this.textFieldLogin = new TextField("", simpleText, maxCharCount, TextFieldType);
            this.form.append((Item)this.textFieldLogin);
            this.form.addCommand(new Command(okButton, 4, 0));
            this.form.addCommand(new Command(exiButton, 7, 0));
            this.form.setCommandListener((CommandListener)this);
            display.setCurrent((Displayable)this.form);
        }

        private void openPak(String pakName) {
            Pak pak = (Pak)this.paksHashMap.get(pakName);
            if (pak != null) {
                if (pak.location == 1) {
                    Unpacker.openPack(this.packPath + pak.name, (byte)21, this.getClass());
                } else {
                    byte[] data = this.loadPakFromRMS(pak.rmsid);
                    Unpacker.openPack(data, (byte)21);
                }
            }
        }

        private DataInputStream openXML(String xmlName) {
            Pak pak = (Pak)this.paksHashMap.get(xmlName);
            DataInputStream _Xml = null;
            if (pak != null) {
                if (pak.location == 1) {
                    _Xml = new DataInputStream(this.getClass().getResourceAsStream(this.packPath + xmlName));
                } else {
                    byte[] data = this.loadPakFromRMS(pak.rmsid);
                    _Xml = new DataInputStream(new ByteArrayInputStream(data));
                }
            }
            return _Xml;
        }

        private void createMenuItems() {
            this.miLoginReg = new MenuItem(1, GameText.STR_TOOLBAR_REGISTRATION);
            this.miLoginEnter = new MenuItem(2, GameText.STR_TOOLBAR_ENTER);
            this.miChat1 = new MenuItem(4, GameText.STR_TOOLBAR_WRITE);
            this.miChat2 = new MenuItem(5, GameText.STR_TOOLBAR_LIST);
            this.miChat3 = new MenuItem(6, GameText.STR_TOOLBAR_ROOMS);
            this.miChatWarning = new MenuItem(45, GameText.STR_TOOLBAR_CHATWARNING);
            this.miChatWarn0005 = new MenuItem(38, StringUtiles.replaceSubString(GameText.STR_TOOLBAR_SILENS_IN_MIN, "%", "5"));
            this.miChatWarn0030 = new MenuItem(40, StringUtiles.replaceSubString(GameText.STR_TOOLBAR_SILENS_IN_MIN, "%", "30"));
            this.miChatWarn0060 = new MenuItem(41, StringUtiles.replaceSubString(GameText.STR_TOOLBAR_SILENS_IN_HOUR, "%", "1"));
            this.miChatWarn0180 = new MenuItem(42, StringUtiles.replaceSubString(GameText.STR_TOOLBAR_SILENS_IN_HOUR, "%", "3"));
            this.miChatWarn1440 = new MenuItem(44, StringUtiles.replaceSubString(GameText.STR_TOOLBAR_SILENS_IN_HOUR, "%", "24"));
            this.miChatBan = new MenuItem(36, GameText.STR_TOOLBAR_CHATBAN);
            this.miChatPrivate = new MenuItem(7, GameText.STR_TOOLBAR_PRIVATE);
            this.miChatWriteTo = new MenuItem(8, GameText.STR_TOOLBAR_WRITE);
            this.miChatMailTo = new MenuItem(35, GameText.STR_TOOLBAR_MAIL);
            this.miInventar1 = new MenuItem(9, GameText.STR_TOOLBAR_CLOTHES);
            this.miInventar2 = new MenuItem(10, GameText.STR_TOOLBAR_GOODS);
            this.miInventar3 = new MenuItem(11, GameText.STR_TOOLBAR_PRESENTS);
            this.miInventar4 = new MenuItem(3, GameText.STR_TOOLBAR_DRESSON);
            this.miInventar5 = new MenuItem(28, GameText.STR_TOOLBAR_PUTOFF);
            this.miInventar6 = new MenuItem(29, GameText.STR_TOOLBAR_INFO);
            this.miShop1 = new MenuItem(12, GameText.STR_TOOLBAR_BYE);
            this.miShop2 = new MenuItem(13, GameText.STR_TOOLBAR_INFO);
            this.miSecond1 = new MenuItem(14, GameText.STR_TOOLBAR_REPAER);
            this.miSecond2 = new MenuItem(15, GameText.STR_TOOLBAR_SELL);
            this.miLocation1 = new MenuItem(16, GameText.STR_TOOLBAR_ENTERING);
            this.miLocation2 = new MenuItem(17, GameText.STR_TOOLBAR_INFO);
            this.miQuests1 = new MenuItem(18, GameText.STR_TOOLBAR_INFO);
            this.miBeats1 = new MenuItem(19, GameText.STR_TOOLBAR_AGRESSION);
            this.miBeats2 = new MenuItem(20, GameText.STR_TOOLBAR_INFO);
            this.miLocateList1 = new MenuItem(21, GameText.STR_TOOLBAR_MOVE);
            this.miLocateList2 = new MenuItem(22, GameText.STR_TOOLBAR_INFO);
            this.miStatistic1 = new MenuItem(23, GameText.STR_TOOLBAR_PARAMS);
            this.miStatistic2 = new MenuItem(24, GameText.STR_TOOLBAR_REWARDS);
            this.miStatistic3 = new MenuItem(25, GameText.STR_TOOLBAR_PERKS);
            this.miStatistic4 = new MenuItem(26, GameText.STR_TOOLBAR_WIZARDS);
            this.miStatistic5 = new MenuItem(27, GameText.STR_TOOLBAR_PRESENTS);
            this.miStatistic6 = new MenuItem(32, GameText.STR_TOOLBAR_SUPER);
            this.miBattleCreate = new MenuItem(30, GameText.STR_TOOLBAR_CREATE);
            this.miBattleEnter = new MenuItem(31, GameText.STR_TOOLBAR_ENTERING);
            this.miMailOpen = new MenuItem(33, GameText.STR_TOOLBAR_OPEN);
            this.miMailDelete = new MenuItem(34, GameText.STR_TOOLBAR_DELETE);
        }

        private void loadLanguage(String _lang) {
            DataInputStream _Xml = new DataInputStream(this.getClass().getResourceAsStream("/" + _lang + ".xml"));
            Parser prser = new Parser(_Xml);
            Element topElement = prser.getTree();
            Element elemXML = null;
            if ((topElement = prser.getNextTreeElementByName(topElement, null, "strings")) != null) {
                while ((elemXML = prser.getNextTreeElementByName(topElement, elemXML, "rec")) != null) {
                    Attribute attrKey = elemXML.getAttribute("key");
                    Attribute attrVal = elemXML.getAttribute("val");
                    if (attrKey.getValue().equals("STR_INVENTARY_FULL")) {
                        GameText.STR_INVENTARY_FULL = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_CREATE_BATTLE")) {
                        GameText.STR_CREATE_BATTLE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_PLAYERS_LEVEL")) {
                        GameText.STR_PLAYERS_LEVEL = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_FROM")) {
                        GameText.STR_FROM = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TO")) {
                        GameText.STR_TO = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TEAM_COUNT")) {
                        GameText.STR_TEAM_COUNT = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_BATTLE_JOIN_ERR1")) {
                        GameText.STR_BATTLE_JOIN_ERR1 = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_BATTLE_JOIN_ERR2")) {
                        GameText.STR_BATTLE_JOIN_ERR2 = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_BATTLE_JOIN_ERR3")) {
                        GameText.STR_BATTLE_JOIN_ERR3 = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_BATTLE_JOIN_ERR5")) {
                        GameText.STR_BATTLE_JOIN_ERR5 = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_BATTLE_WIN")) {
                        GameText.STR_BATTLE_WIN = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_BATTLE_LOSE")) {
                        GameText.STR_BATTLE_LOSE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_EXP")) {
                        GameText.STR_EXP = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_LOCATION_CHANGE_ERROR")) {
                        GameText.STR_LOCATION_CHANGE_ERROR = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_GHOST_ENTER_ERROR")) {
                        GameText.STR_GHOST_ENTER_ERROR = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_GHOST_RESURECTION")) {
                        GameText.STR_GHOST_RESURECTION = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_CHAT_ONLINE")) {
                        GameText.STR_CHAT_ONLINE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_OK")) {
                        GameText.STR_TOOLBAR_OK = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_CANCEL")) {
                        GameText.STR_TOOLBAR_CANCEL = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_EXIT")) {
                        GameText.STR_TOOLBAR_EXIT = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_MENU")) {
                        GameText.STR_TOOLBAR_MENU = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_BACK")) {
                        GameText.STR_TOOLBAR_BACK = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_GOON")) {
                        GameText.STR_TOOLBAR_GOON = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_WRITE")) {
                        GameText.STR_TOOLBAR_WRITE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_ACTION")) {
                        GameText.STR_TOOLBAR_ACTION = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_CREATE")) {
                        GameText.STR_TOOLBAR_CREATE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_REGISTRATION")) {
                        GameText.STR_TOOLBAR_REGISTRATION = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_ENTER")) {
                        GameText.STR_TOOLBAR_ENTER = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_LIST")) {
                        GameText.STR_TOOLBAR_LIST = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_ROOMS")) {
                        GameText.STR_TOOLBAR_ROOMS = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_PRIVATE")) {
                        GameText.STR_TOOLBAR_PRIVATE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_CLOTHES")) {
                        GameText.STR_TOOLBAR_CLOTHES = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_GOODS")) {
                        GameText.STR_TOOLBAR_GOODS = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_PRESENTS")) {
                        GameText.STR_TOOLBAR_PRESENTS = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_DRESSON")) {
                        GameText.STR_TOOLBAR_DRESSON = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_DRESSOFF")) {
                        GameText.STR_TOOLBAR_DRESSOFF = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_PUTOFF")) {
                        GameText.STR_TOOLBAR_PUTOFF = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_INFO")) {
                        GameText.STR_TOOLBAR_INFO = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_BYE")) {
                        GameText.STR_TOOLBAR_BYE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_REPAER")) {
                        GameText.STR_TOOLBAR_REPAER = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_SELL")) {
                        GameText.STR_TOOLBAR_SELL = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_ENTERING")) {
                        GameText.STR_TOOLBAR_ENTERING = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_AGRESSION")) {
                        GameText.STR_TOOLBAR_AGRESSION = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_MOVE")) {
                        GameText.STR_TOOLBAR_MOVE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_PARAMS")) {
                        GameText.STR_TOOLBAR_PARAMS = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_REWARDS")) {
                        GameText.STR_TOOLBAR_REWARDS = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_PERKS")) {
                        GameText.STR_TOOLBAR_PERKS = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_WIZARDS")) {
                        GameText.STR_TOOLBAR_WIZARDS = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_AUTHORISATION")) {
                        GameText.STR_TOOLBAR_AUTHORISATION = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_LOGIN")) {
                        GameText.STR_TOOLBAR_LOGIN = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_NAME")) {
                        GameText.STR_TOOLBAR_NAME = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_PASSWORD")) {
                        GameText.STR_TOOLBAR_PASSWORD = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_PASSWORDREP")) {
                        GameText.STR_TOOLBAR_PASSWORDREP = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_REPEAT")) {
                        GameText.STR_TOOLBAR_REPEAT = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_TEAM")) {
                        GameText.STR_TOOLBAR_TEAM = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_MESSAGE")) {
                        GameText.STR_TOOLBAR_MESSAGE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_MESSAGEFOR")) {
                        GameText.STR_TOOLBAR_MESSAGEFOR = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_BATTLES")) {
                        GameText.STR_TOOLBAR_BATTLES = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_BUILDINGS")) {
                        GameText.STR_TOOLBAR_BUILDINGS = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_INVENTAR")) {
                        GameText.STR_TOOLBAR_INVENTAR = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_CHAT")) {
                        GameText.STR_TOOLBAR_CHAT = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_QUESTS")) {
                        GameText.STR_TOOLBAR_QUESTS = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_LOCATIONS")) {
                        GameText.STR_TOOLBAR_LOCATIONS = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_STATISTIC")) {
                        GameText.STR_TOOLBAR_STATISTIC = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_RACE")) {
                        GameText.STR_TOOLBAR_RACE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_SEX")) {
                        GameText.STR_TOOLBAR_SEX = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_HEAR")) {
                        GameText.STR_TOOLBAR_HEAR = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_COUNT")) {
                        GameText.STR_TOOLBAR_COUNT = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_LEVEL")) {
                        GameText.STR_TOOLBAR_LEVEL = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_DAMAGE")) {
                        GameText.STR_TOOLBAR_DAMAGE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_DEFENDS")) {
                        GameText.STR_TOOLBAR_DEFENDS = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_MAGIC")) {
                        GameText.STR_TOOLBAR_MAGIC = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_SETTINGS")) {
                        GameText.STR_TOOLBAR_SETTINGS = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_ENABLE")) {
                        GameText.STR_TOOLBAR_ENABLE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_DISABLE")) {
                        GameText.STR_TOOLBAR_DISABLE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_SUPER")) {
                        GameText.STR_TOOLBAR_SUPER = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_SMS")) {
                        GameText.STR_TOOLBAR_SMS = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_SEND")) {
                        GameText.STR_TOOLBAR_SEND = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_PASSWORDREP_ERR")) {
                        GameText.STR_TOOLBAR_PASSWORDREP_ERR = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_MAILS")) {
                        GameText.STR_TOOLBAR_MAILS = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_DELETE")) {
                        GameText.STR_TOOLBAR_DELETE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_OPEN")) {
                        GameText.STR_TOOLBAR_OPEN = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_MAIL")) {
                        GameText.STR_TOOLBAR_MAIL = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_MAILFOR")) {
                        GameText.STR_TOOLBAR_MAILFOR = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_LANGUAGE")) {
                        GameText.STR_TOOLBAR_LANGUAGE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_UPDATE")) {
                        GameText.STR_TOOLBAR_UPDATE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_SILENS_IN_MIN")) {
                        GameText.STR_TOOLBAR_SILENS_IN_MIN = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_SILENS_IN_HOUR")) {
                        GameText.STR_TOOLBAR_SILENS_IN_HOUR = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_CHATBAN")) {
                        GameText.STR_TOOLBAR_CHATBAN = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_CHATWARNING")) {
                        GameText.STR_TOOLBAR_CHATWARNING = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_REG_LOGIN")) {
                        GameText.STR_TOOLBAR_REG_LOGIN = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_REG_NIK")) {
                        GameText.STR_TOOLBAR_REG_NIK = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_TOOLBAR_USERS")) {
                        GameText.STR_TOOLBAR_USERS = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_SETTINGS_SOUNDENABLE")) {
                        GameText.STR_SETTINGS_SOUNDENABLE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_SETTINGS_SOUNDLEVEL")) {
                        GameText.STR_SETTINGS_SOUNDLEVEL = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_SETTINGS_VIBROENABLE")) {
                        GameText.STR_SETTINGS_VIBROENABLE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_SETTINGS_ENABLE")) {
                        GameText.STR_SETTINGS_ENABLE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_SETTINGS_DISABLE")) {
                        GameText.STR_SETTINGS_DISABLE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_GOODS_BREASTPLATE")) {
                        GameText.STR_GOODS_BREASTPLATE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_GOODS_HELMET")) {
                        GameText.STR_GOODS_HELMET = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_GOODS_LEGED")) {
                        GameText.STR_GOODS_LEGED = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_GOODS_BOOT")) {
                        GameText.STR_GOODS_BOOT = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_GOODS_SHOULDER")) {
                        GameText.STR_GOODS_SHOULDER = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_GOODS_ARMED")) {
                        GameText.STR_GOODS_ARMED = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_GOODS_SWORD")) {
                        GameText.STR_GOODS_SWORD = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_GOODS_SHIELD")) {
                        GameText.STR_GOODS_SHIELD = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_GOODS_ELIXIR")) {
                        GameText.STR_GOODS_ELIXIR = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_BATTLE_ACTION")) {
                        GameText.STR_BATTLE_ACTION = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_BATTLE_BAG")) {
                        GameText.STR_BATTLE_BAG = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_BATTLE_BOOK")) {
                        GameText.STR_BATTLE_BOOK = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_BATTLE_ALIE")) {
                        GameText.STR_BATTLE_ALIE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_BATTLE_ENEMY")) {
                        GameText.STR_BATTLE_ENEMY = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_BATTLE_SUPER")) {
                        GameText.STR_BATTLE_SUPER = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_BATTLE_LOG")) {
                        GameText.STR_BATTLE_LOG = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_SMS_QUEST")) {
                        GameText.STR_SMS_QUEST = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_SMS_OK")) {
                        GameText.STR_SMS_OK = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_SMS_ERROR")) {
                        GameText.STR_SMS_ERROR = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_MAIL_DELETE")) {
                        GameText.STR_MAIL_DELETE = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_MAIL_ERROR")) {
                        GameText.STR_MAIL_ERROR = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_CHAT_ERROR")) {
                        GameText.STR_CHAT_ERROR = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_REGISTR_MAN_NORTH")) {
                        GameText.STR_REGISTR_MAN_NORTH = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_REGISTR_WOMAN_NORTH")) {
                        GameText.STR_REGISTR_WOMAN_NORTH = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_REGISTR_MAN_SOUTH")) {
                        GameText.STR_REGISTR_MAN_SOUTH = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_REGISTR_WOMAN_SOUTH")) {
                        GameText.STR_REGISTR_WOMAN_SOUTH = attrVal.getValue();
                        continue;
                    }
                    if (attrKey.getValue().equals("STR_LOGIN_ERROR1")) {
                        GameText.STR_LOGIN_ERROR1 = attrVal.getValue();
                        continue;
                    }
                    if (!attrKey.getValue().equals("STR_LOGIN_ERROR2")) continue;
                    GameText.STR_LOGIN_ERROR2 = attrVal.getValue();
                }
            }
            prser.ClearTree();
            try {
                _Xml.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        private void loadClothesResData(String packName, boolean isMan, Vector resDataList) {
            DataInputStream _Xml = this.openXML(packName + ".xml");
            Parser prser = new Parser(_Xml);
            Element topElement = prser.getTree();
            Element elemXML = null;
            String topName = "man";
            if (!isMan) {
                topName = "woman";
            }
            if ((topElement = prser.getNextTreeElementByName(topElement, null, topName)) != null) {
                while ((elemXML = prser.getNextTreeElementByName(topElement, elemXML, "clothes")) != null) {
                    int id;
                    ObjectFromResData rData = new ObjectFromResData();
                    Attribute Attr = elemXML.getAttribute("id");
                    try {
                        id = Integer.parseInt(Attr.getValue());
                    }
                    catch (Exception e) {
                        id = 0;
                    }
                    rData.id = id;
                    Attr = elemXML.getAttribute("main");
                    try {
                        rData.mainPakNum = Integer.valueOf(Attr.getValue());
                    }
                    catch (Exception e) {
                        rData.mainPakNum = null;
                    }
                    Attr = elemXML.getAttribute("pal");
                    try {
                        rData.pallPakNum = Integer.valueOf(Attr.getValue());
                    }
                    catch (Exception e) {
                        rData.pallPakNum = null;
                    }
                    Attr = elemXML.getAttribute("item");
                    try {
                        rData.mainPakIndex = Integer.valueOf(Attr.getValue());
                    }
                    catch (Exception e) {
                        rData.mainPakIndex = null;
                    }
                    Attr = elemXML.getAttribute("palind");
                    try {
                        rData.pallPakIndex = Integer.valueOf(Attr.getValue());
                    }
                    catch (Exception e) {
                        rData.pallPakIndex = null;
                    }
                    resDataList.addElement(rData);
                }
            }
            prser.ClearTree();
            try {
                _Xml.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        private void loadClothesResData() {
            this.loadClothesResData("breastplates", true, this.paksDataBreastPlatesMan);
            this.loadClothesResData("breastplates", false, this.paksDataBreastPlatesWoman);
            this.loadClothesResData("helmets", true, this.paksDataHelmetsMan);
            this.loadClothesResData("helmets", false, this.paksDataHelmetsWoman);
            this.loadClothesResData("legeds", true, this.paksDataLegedsMan);
            this.loadClothesResData("legeds", false, this.paksDataLegedsWoman);
            this.loadClothesResData("boots", true, this.paksDataBootsMan);
            this.loadClothesResData("boots", false, this.paksDataBootsWoman);
            this.loadClothesResData("shoulders", true, this.paksDataShouldersMan);
            this.loadClothesResData("shoulders", false, this.paksDataShouldersWoman);
            this.loadClothesResData("armeds", true, this.paksDataArmedsMan);
            this.loadClothesResData("armeds", false, this.paksDataArmedsWoman);
            this.loadClothesResData("swords", true, this.paksDataSwordsMan);
            this.loadClothesResData("swords", false, this.paksDataSwordsWoman);
            this.loadClothesResData("shields", true, this.paksDataShieldsMan);
            this.loadClothesResData("shields", false, this.paksDataShieldsWoman);
        }

        private void loadFontFromOpenedPak(int fontID) {
            byte[] res_byte = Unpacker.getNextItem();
            Image tmpImg = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
            byte[] iniBytes = Unpacker.getNextItem();
            res_byte = Unpacker.getNextItem();
            int type = res_byte[0] & 0xFF;
            int size = res_byte[1] & 0xFF;
            short[] cutsShift = new short[4 * size];
            for (int i = 0; i < size * 5; i += 5) {
                short t = (short)(0xFF & res_byte[i + 2]);
                cutsShift[t * 4] = (short)(0xFF & res_byte[i + 1 + 2]);
                cutsShift[t * 4 + 1] = (short)(0xFF & res_byte[i + 2 + 2]);
                cutsShift[t * 4 + 2] = (short)(0xFF & res_byte[i + 3 + 2]);
                cutsShift[t * 4 + 3] = (short)(0xFF & res_byte[i + 4 + 2]);
            }
            byte[] alphaShift = Unpacker.getNextItem();
            FontManagerEx.loadFont(iniBytes, cutsShift, alphaShift, tmpImg, fontID, this.getClass());
        }

        private byte[] loadPNGPalette(String pak, int num) {
            byte[] res_byte = null;
            try {
                this.openPak(pak);
                int hdrLength = Unpacker.getItemSize(num * 2);
                int palLength = Unpacker.getItemSize(num * 2 + 1);
                res_byte = new byte[palLength + hdrLength];
                Unpacker.skipNextItems(num * 2);
                Unpacker.getNextItem(res_byte, 0);
                Unpacker.getNextItem(res_byte, hdrLength);
                Unpacker.closePack();
                System.gc();
            }
            catch (Exception e) {
                // empty catch block
            }
            return res_byte;
        }

        private void loadPunchIcons() {
            byte[] res_byte = null;
            try {
                this.openPak("punch.pak");
                for (int i = 0; i < this.battleLogImages.length; ++i) {
                    res_byte = Unpacker.getNextItem();
                    this.battleLogImages[i] = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                }
                Unpacker.closePack();
                System.gc();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void loadBattleGUI() {
            byte[] res_byte = null;
            try {
                this.openPak("battle_gui.pak");
                this.battleGUICP = null;
                res_byte = Unpacker.getNextItem();
                Image tmpImg = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                res_byte = Unpacker.getNextItem();
                this.battleGUICP = new ComplexPicture(tmpImg, res_byte);
                this.loadFontFromOpenedPak(2);
                FontManagerEx.setXSpacing(2, 2);
                this.loadFontFromOpenedPak(3);
                FontManagerEx.setXSpacing(2, 3);
                Unpacker.closePack();
                System.gc();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void loadBattleSelecter() {
            byte[] res_byte = null;
            try {
                this.openPak("selecter_battle.pak");
                this.battleSelecter = null;
                res_byte = Unpacker.getNextItem();
                Image tmpImg = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                res_byte = Unpacker.getNextItem();
                this.battleSelecter = new AnimationComplexPicture(tmpImg, res_byte, 0);
                res_byte = Unpacker.getNextItem();
                this.battleSelecter.loadANM(res_byte);
                Unpacker.closePack();
                System.gc();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void loadBattleBack(int num) {
            byte[] res_byte = null;
            try {
                this.openPak("battle_back" + num + ".pak");
                res_byte = Unpacker.getNextItem();
                this.battleLocation = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                Unpacker.closePack();
                System.gc();
            }
            catch (Exception e) {
                System.out.println("loadBattleLocation: " + e);
            }
        }

        private void loadSuperPunch() {
            byte[] res_byte = null;
            try {
                this.openPak("super_punch.pak");
                this.battleSuperPunch = null;
                this.battleSuperPunchWoman = null;
                res_byte = Unpacker.getNextItem();
                Image tmpImg = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                res_byte = Unpacker.getNextItem();
                this.battleSuperPunch = new AnimationComplexPicture(tmpImg, res_byte, 0);
                res_byte = Unpacker.getNextItem();
                this.battleSuperPunch.loadANM(res_byte);
                this.battleSuperPunchWoman = new AnimationData();
                res_byte = Unpacker.getNextItem();
                this.battleSuperPunchWoman.loadANM(res_byte, this.battleSuperPunch);
                Unpacker.closePack();
                System.gc();
            }
            catch (Exception e) {
                System.out.println("loadSuperPunch: " + e);
            }
        }

        private byte[] loadPakFromRMS(int dataid) {
            byte[] data = null;
            try {
                data = this.pakDataRecords.getRecord(dataid);
            }
            catch (Exception e) {
                data = null;
            }
            return data;
        }

        private void savePakInRMS(Pak pak, byte[] data) {
            if (pak.rmsid > 0) {
                try {
                    this.pakDataRecords.setRecord(pak.rmsid, data, 0, data.length);
                    byte[] rec = this.pakNamesRecords.getRecord(pak.rmsHeaderid);
                    if (rec != null) {
                        DataConverter.bytesFromInt(rec, 4, pak.ver);
                        this.pakNamesRecords.setRecord(pak.rmsHeaderid, rec, 0, rec.length);
                    }
                }
                catch (Exception e) {
                    try {
                        this.pakNamesRecords.deleteRecord(pak.rmsHeaderid);
                        this.pakDataRecords.deleteRecord(pak.rmsid);
                    }
                    catch (Exception ex) {}
                }
            } else {
                try {
                    pak.rmsid = this.pakDataRecords.addRecord(data, 0, data.length);
                    ByteArrayOutputStream rec = new ByteArrayOutputStream();
                    rec.write(DataConverter.bytesFromInt(pak.id));
                    rec.write(DataConverter.bytesFromInt(pak.ver));
                    rec.write(DataConverter.bytesFromInt(pak.rmsid));
                    rec.write(DataConverter.bytesFromString(pak.name));
                    byte[] d = rec.toByteArray();
                    pak.rmsHeaderid = this.pakNamesRecords.addRecord(d, 0, d.length);
                }
                catch (Exception e) {
                    pak.rmsid = 0;
                    pak.rmsHeaderid = 0;
                }
            }
        }

        private void loadPaksList() {
            DataInputStream _Xml = new DataInputStream(this.getClass().getResourceAsStream("/paks.xml"));
            Parser prser = new Parser(_Xml);
            Element topElement = prser.getTree();
            Element elemXML = null;
            if ((topElement = prser.getNextTreeElementByName(topElement, null, "paks")) != null) {
                while ((elemXML = prser.getNextTreeElementByName(topElement, elemXML, "pak")) != null) {
                    Attribute attrVersion = elemXML.getAttribute("v");
                    Attribute attrName = elemXML.getAttribute("n");
                    int ver = 0;
                    try {
                        ver = Integer.parseInt(attrVersion.getValue());
                    }
                    catch (Exception ex) {
                        ver = 0;
                    }
                    Pak pak = new Pak(0, ver, attrName.getValue(), 1);
                    this.paksHashMap.put(attrName.getValue(), pak);
                    this.paksList.addElement(pak);
                }
            }
            prser.ClearTree();
            try {
                _Xml.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            Hashtable<String, String> paksInRMS = new Hashtable<String, String>();
            try {
                this.pakDataRecords = RecordStore.openRecordStore((String)this.pakDataRMS, (boolean)true);
                this.pakNamesRecords = RecordStore.openRecordStore((String)this.pakNamesRMS, (boolean)true);
                RecordEnumeration re = this.pakNamesRecords.enumerateRecords(null, null, true);
                if (re != null) {
                    while (re.hasNextElement()) {
                        int curRecID = re.nextRecordId();
                        byte[] rec = this.pakNamesRecords.getRecord(curRecID);
                        if (rec == null) continue;
                        try {
                            int ind = 0;
                            int id = DataConverter.intFromBytes(rec, ind);
                            int ver = DataConverter.intFromBytes(rec, ind += 4);
                            int dataid = DataConverter.intFromBytes(rec, ind += 4);
                            String name = DataConverter.stringFromBytes(rec, ind += 4, rec.length - ind);
                            paksInRMS.put(name, name);
                            Pak pak = (Pak)this.paksHashMap.get(name);
                            if (pak != null) {
                                if (pak.ver < ver) {
                                    pak.ver = ver;
                                    pak.location = 2;
                                    pak.rmsid = dataid;
                                    pak.rmsHeaderid = curRecID;
                                    continue;
                                }
                                if (pak.ver <= ver) continue;
                                try {
                                    DataInputStream resData = new DataInputStream(this.getClass().getResourceAsStream(this.packPath + pak.name));
                                    byte[] _data = new byte[resData.available()];
                                    resData.readFully(_data);
                                    pak.rmsid = dataid;
                                    pak.rmsHeaderid = curRecID;
                                    this.savePakInRMS(pak, _data);
                                }
                                catch (Exception e) {
                                    System.out.println("saveInRMS " + e);
                                }
                                continue;
                            }
                            pak = new Pak(id, ver, name, 2);
                            pak.rmsid = dataid;
                            pak.rmsHeaderid = curRecID;
                            this.paksHashMap.put(name, pak);
                        }
                        catch (Exception e) {}
                    }
                }
            }
            catch (Exception e) {
                this.pakNamesRecords = null;
                System.out.println("openRecordStore thrown exception " + e);
            }
            Enumeration paks = this.paksHashMap.elements();
            while (paks.hasMoreElements()) {
                Pak pak = (Pak)paks.nextElement();
                if (paksInRMS.containsKey(pak.name)) continue;
                try {
                    DataInputStream resData = new DataInputStream(this.getClass().getResourceAsStream(this.packPath + pak.name));
                    byte[] _data = new byte[resData.available()];
                    resData.readFully(_data);
                    pak.rmsid = 0;
                    pak.rmsHeaderid = 0;
                    this.savePakInRMS(pak, _data);
                }
                catch (Exception e) {
                    System.out.println("saveInRMS " + e);
                }
            }
        }

        private void loadOptions() {
            Element topElement;
            DataInputStream _Xml = new DataInputStream(this.getClass().getResourceAsStream("/options.xml"));
            Parser prser = new Parser(_Xml);
            Element ttt = topElement = prser.getTree();
            if ((ttt = prser.getNextTreeElementByName(ttt, null, "host")) != null) {
                Element elemXML = ttt;
                Attribute attrName = elemXML.getAttribute("name");
                Attribute attrIP = elemXML.getAttribute("ip");
                Attribute attrVer = elemXML.getAttribute("port");
                if (attrName != null) {
                    this.hostName = attrName.getValue();
                }
                if (attrIP != null) {
                    this.hostIP = attrIP.getValue();
                }
                if (attrVer != null) {
                    this.hostPort = Integer.parseInt(attrVer.getValue());
                }
            }
            prser.ClearTree();
            try {
                _Xml.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        private void loadHearData(boolean isMan) {
            this.hearSortList.removeAllElements();
            DataInputStream _Xml = this.openXML("options.xml");
            Parser prser = new Parser(_Xml);
            Element topElement = prser.getTree();
            Element elemXML = null;
            String topName = "man";
            if (!isMan) {
                topName = "woman";
            }
            if ((this.hearsTopElement = prser.getNextTreeElementByName(topElement, null, topName)) != null && (this.hearsTopElement = prser.getNextTreeElementByName(this.hearsTopElement, null, "hears")) != null) {
                Attribute hearsCountAttr = this.hearsTopElement.getAttribute("count");
                try {
                    this.hearsCount = Integer.parseInt(hearsCountAttr.getValue());
                }
                catch (Exception e) {
                    this.hearsCount = 0;
                }
            }
            while ((elemXML = prser.getNextTreeElementByName(this.hearsTopElement, elemXML, "hear")) != null) {
                int palNum;
                int mainNum;
                int id;
                Attribute Attr = elemXML.getAttribute("id");
                try {
                    id = Integer.parseInt(Attr.getValue());
                }
                catch (Exception e) {
                    id = 0;
                }
                Attr = elemXML.getAttribute("main");
                String mainPak = Attr.getValue();
                Attr = elemXML.getAttribute("pal");
                String palPak = Attr.getValue();
                Attr = elemXML.getAttribute("item");
                try {
                    mainNum = Integer.parseInt(Attr.getValue());
                }
                catch (Exception e) {
                    mainNum = 0;
                }
                Attr = elemXML.getAttribute("palind");
                try {
                    palNum = Integer.parseInt(Attr.getValue());
                }
                catch (Exception e) {
                    palNum = 0;
                }
                this.hearSortList.addSortedElement(new AnimationBuilder(id, mainPak, palPak, mainNum, palNum));
            }
            prser.ClearTree();
            try {
                _Xml.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        private AnimationComplexPicture loadHearData(boolean isMan, int num) {
            AnimationComplexPicture hAnim = null;
            DataInputStream _Xml = this.openXML("options.xml");
            Parser prser = new Parser(_Xml);
            Element topElement = prser.getTree();
            Element elemXML = null;
            String topName = "man";
            if (!isMan) {
                topName = "woman";
            }
            if ((this.hearsTopElement = prser.getNextTreeElementByName(topElement, null, topName)) != null && (this.hearsTopElement = prser.getNextTreeElementByName(this.hearsTopElement, null, "hears")) != null) {
                Attribute hearsCountAttr = this.hearsTopElement.getAttribute("count");
                try {
                    this.hearsCount = Integer.parseInt(hearsCountAttr.getValue());
                }
                catch (Exception e) {
                    this.hearsCount = 0;
                }
            }
            String mainPak = null;
            String palPak = null;
            int mainNum = 0;
            int palNum = 0;
            while ((elemXML = prser.getNextTreeElementByName(this.hearsTopElement, elemXML, "hear")) != null) {
                int id;
                Attribute Attr = elemXML.getAttribute("id");
                try {
                    id = Integer.parseInt(Attr.getValue());
                }
                catch (Exception e) {
                    id = 0;
                }
                if (id != num) continue;
                Attr = elemXML.getAttribute("main");
                mainPak = Attr.getValue();
                Attr = elemXML.getAttribute("pal");
                palPak = Attr.getValue();
                Attr = elemXML.getAttribute("item");
                try {
                    mainNum = Integer.parseInt(Attr.getValue());
                }
                catch (Exception e) {
                    mainNum = 0;
                }
                Attr = elemXML.getAttribute("palind");
                try {
                    palNum = Integer.parseInt(Attr.getValue());
                }
                catch (Exception e) {
                    palNum = 0;
                }
                break;
            }
            prser.ClearTree();
            try {
                _Xml.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (mainPak != null) {
                byte[] pal = null;
                if (palPak != null) {
                    pal = isMan ? this.loadPNGPalette("hear" + palPak + ".pak", palNum - 1) : this.loadPNGPalette("hear_w" + palPak + ".pak", palNum - 1);
                }
                hAnim = isMan ? this.loadHear("hear" + mainPak + ".pak", mainNum - 1, pal) : this.loadHear("hear_w" + mainPak + ".pak", mainNum - 1, pal);
            }
            return hAnim;
        }

        private Image loadIconForItem(int type, int num) {
            String ClothesPath = "";
            switch (type) {
                case 1: {
                    ClothesPath = "icons_breastplate";
                    break;
                }
                case 2: {
                    ClothesPath = "icons_helmet";
                    break;
                }
                case 3: {
                    ClothesPath = "icons_leged";
                    break;
                }
                case 4: {
                    ClothesPath = "icons_boot";
                    break;
                }
                case 5: {
                    ClothesPath = "icons_shoulder";
                    break;
                }
                case 6: {
                    ClothesPath = "icons_armed";
                    break;
                }
                case 7: {
                    ClothesPath = "icons_sword";
                    break;
                }
                case 8: {
                    ClothesPath = "icons_shield";
                    break;
                }
                case 9: {
                    ClothesPath = "icons_goods";
                    break;
                }
                case 10: {
                    ClothesPath = "icons_presents";
                    break;
                }
                case 11: {
                    ClothesPath = "icons_reward";
                }
            }
            return this.loadIconForItem(ClothesPath, num);
        }

        private Image loadIconForItem(String pakName, int num) {
            String ClothesPath = pakName;
            Image tmpImg = null;
            try {
                this.openPak(ClothesPath + ".pak");
                Unpacker.skipNextItems(num);
                byte[] res_byte = Unpacker.getNextItem();
                tmpImg = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                res_byte = null;
                Unpacker.closePack();
                System.gc();
            }
            catch (Exception e) {
                System.out.println("loadIconForItem ex: " + e);
            }
            return tmpImg;
        }

        private Image loadIconForBuilding(int num) {
            return this.loadIconForItem("icons_buildings", num);
        }

        private Image loadIconForBeast(int num) {
            return this.loadIconForItem("icons_beasts", num);
        }

        private Image loadIconForLocate(int num) {
            return this.loadIconForItem("icons_locates", num);
        }

        private void loadClothesData(int type, boolean isMan, int num, boolean isBot, boolean isEnemy, int animInd) {
            Object clothesAnim = null;
            Vector list = null;
            String ClothesPath = "";
            switch (type) {
                case 1: {
                    ClothesPath = "breastplates";
                    list = isMan ? this.paksDataBreastPlatesMan : this.paksDataBreastPlatesWoman;
                    break;
                }
                case 2: {
                    ClothesPath = "helmets";
                    list = isMan ? this.paksDataHelmetsMan : this.paksDataHelmetsWoman;
                    break;
                }
                case 3: {
                    ClothesPath = "legeds";
                    list = isMan ? this.paksDataLegedsMan : this.paksDataLegedsWoman;
                    break;
                }
                case 4: {
                    ClothesPath = "boots";
                    list = isMan ? this.paksDataBootsMan : this.paksDataBootsWoman;
                    break;
                }
                case 5: {
                    ClothesPath = "shoulders";
                    list = isMan ? this.paksDataShouldersMan : this.paksDataShouldersWoman;
                    break;
                }
                case 6: {
                    ClothesPath = "armeds";
                    list = isMan ? this.paksDataArmedsMan : this.paksDataArmedsWoman;
                    break;
                }
                case 7: {
                    ClothesPath = "swords";
                    list = isMan ? this.paksDataSwordsMan : this.paksDataSwordsWoman;
                    break;
                }
                case 8: {
                    ClothesPath = "shields";
                    list = isMan ? this.paksDataShieldsMan : this.paksDataShieldsWoman;
                }
            }
            String mainPak = null;
            String palPak = null;
            int mainNum = 0;
            int palNum = 0;
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    ObjectFromResData rData = (ObjectFromResData)list.elementAt(i);
                    if (rData.id != num) continue;
                    if (rData.mainPakNum != null) {
                        mainPak = rData.mainPakNum.toString();
                    }
                    if (rData.pallPakNum != null) {
                        palPak = rData.pallPakNum.toString();
                    }
                    if (rData.mainPakIndex != null) {
                        mainNum = rData.mainPakIndex;
                    }
                    if (rData.pallPakIndex == null) break;
                    palNum = rData.pallPakIndex;
                    break;
                }
            }
            if (mainPak != null) {
                byte[] pal = null;
                if (palPak != null) {
                    pal = isMan ? this.loadPNGPalette(ClothesPath + palPak + ".pak", palNum - 1) : this.loadPNGPalette(ClothesPath + "_w" + palPak + ".pak", palNum - 1);
                }
                switch (type) {
                    case 1: {
                        if (!isEnemy) {
                            if (isMan) {
                                this.breastplateAnim = this.loadClothes(ClothesPath + mainPak + ".pak", mainNum - 1, pal);
                                break;
                            }
                            this.breastplateAnim = this.loadClothes(ClothesPath + "_w" + mainPak + ".pak", mainNum - 1, pal);
                            break;
                        }
                        if (isMan) {
                            this.breastplateAnimBeast = this.loadClothes(ClothesPath + mainPak + ".pak", mainNum - 1, pal);
                            break;
                        }
                        this.breastplateAnimBeast = this.loadClothes(ClothesPath + "_w" + mainPak + ".pak", mainNum - 1, pal);
                        break;
                    }
                    case 2: {
                        if (!isEnemy) {
                            if (isMan) {
                                this.helmetAnim = this.loadClothes(ClothesPath + mainPak + ".pak", mainNum - 1, pal);
                                break;
                            }
                            this.helmetAnim = this.loadClothes(ClothesPath + "_w" + mainPak + ".pak", mainNum - 1, pal);
                            break;
                        }
                        if (isMan) {
                            this.helmetAnimBeast = this.loadClothes(ClothesPath + mainPak + ".pak", mainNum - 1, pal);
                            break;
                        }
                        this.helmetAnimBeast = this.loadClothes(ClothesPath + "_w" + mainPak + ".pak", mainNum - 1, pal);
                        break;
                    }
                    case 3: {
                        if (!isEnemy) {
                            if (isMan) {
                                this.legedAnim = this.loadClothes(ClothesPath + mainPak + ".pak", mainNum - 1, pal);
                                break;
                            }
                            this.legedAnim = this.loadClothes(ClothesPath + "_w" + mainPak + ".pak", mainNum - 1, pal);
                            break;
                        }
                        if (isMan) {
                            this.legedAnimBeast = this.loadClothes(ClothesPath + mainPak + ".pak", mainNum - 1, pal);
                            break;
                        }
                        this.legedAnimBeast = this.loadClothes(ClothesPath + "_w" + mainPak + ".pak", mainNum - 1, pal);
                        break;
                    }
                    case 4: {
                        if (!isEnemy) {
                            if (isMan) {
                                this.bootAnim = this.loadClothes(ClothesPath + mainPak + ".pak", mainNum - 1, pal);
                                break;
                            }
                            this.bootAnim = this.loadClothes(ClothesPath + "_w" + mainPak + ".pak", mainNum - 1, pal);
                            break;
                        }
                        if (isMan) {
                            this.bootAnimBeast = this.loadClothes(ClothesPath + mainPak + ".pak", mainNum - 1, pal);
                            break;
                        }
                        this.bootAnimBeast = this.loadClothes(ClothesPath + "_w" + mainPak + ".pak", mainNum - 1, pal);
                        break;
                    }
                    case 5: {
                        if (!isEnemy) {
                            if (isMan) {
                                this.shoulderAnim = this.loadClothes(ClothesPath + mainPak + ".pak", mainNum - 1, pal);
                                break;
                            }
                            this.shoulderAnim = this.loadClothes(ClothesPath + "_w" + mainPak + ".pak", mainNum - 1, pal);
                            break;
                        }
                        if (isMan) {
                            this.shoulderAnimBeast = this.loadClothes(ClothesPath + mainPak + ".pak", mainNum - 1, pal);
                            break;
                        }
                        this.shoulderAnimBeast = this.loadClothes(ClothesPath + "_w" + mainPak + ".pak", mainNum - 1, pal);
                        break;
                    }
                    case 6: {
                        if (!isEnemy) {
                            if (isMan) {
                                this.armedAnim = this.loadClothes(ClothesPath + mainPak + ".pak", mainNum - 1, pal);
                                break;
                            }
                            this.armedAnim = this.loadClothes(ClothesPath + "_w" + mainPak + ".pak", mainNum - 1, pal);
                            break;
                        }
                        if (isMan) {
                            this.armedAnimBeast = this.loadClothes(ClothesPath + mainPak + ".pak", mainNum - 1, pal);
                            break;
                        }
                        this.armedAnimBeast = this.loadClothes(ClothesPath + "_w" + mainPak + ".pak", mainNum - 1, pal);
                        break;
                    }
                    case 7: {
                        if (!isEnemy) {
                            this.swordAnim = this.loadWeaponAndArmor(ClothesPath + mainPak, mainNum - 1, pal, isMan);
                            break;
                        }
                        if (!isBot) {
                            this.swordAnimBeast = this.loadWeaponAndArmor(ClothesPath + mainPak, mainNum - 1, pal, isMan);
                            break;
                        }
                        this.swordAnimBeast = this.loadWeaponAndArmor(ClothesPath + mainPak, mainNum - 1, pal, isMan, true, animInd);
                        break;
                    }
                    case 8: {
                        if (!isEnemy) {
                            this.shieldAnim = this.loadWeaponAndArmor(ClothesPath + mainPak, mainNum - 1, pal, isMan);
                            break;
                        }
                        this.shieldAnimBeast = !isBot ? this.loadWeaponAndArmor(ClothesPath + mainPak, mainNum - 1, pal, isMan) : this.loadWeaponAndArmor(ClothesPath + mainPak, mainNum - 1, pal, isMan, true, animInd);
                    }
                }
            }
        }

        private void loadResForCommon() {
            try {
                this.openPak("icons_wait.pak");
                byte[] res_byte = Unpacker.getNextItem();
                Image tmpImg = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                res_byte = Unpacker.getNextItem();
                this.waitingAnim = new AnimationComplexPicture(tmpImg, res_byte, 1);
                res_byte = Unpacker.getNextItem();
                this.waitingAnim.loadANM(res_byte);
                res_byte = Unpacker.getNextItem();
                this.waitingAnim.loadANS(0, res_byte);
                res_byte = null;
                Unpacker.closePack();
                System.gc();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void loadResForLogo() {
            try {
                Unpacker.openPack(this.packPath + "logo.pak", (byte)21, this.getClass());
                Unpacker.skipToItem(0);
                byte[] res_byte = Unpacker.getNextItem();
                this.logoImage_4 = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                res_byte = null;
                Unpacker.closePack();
                System.gc();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private AnimationComplexPicture loadResForPers(int num, boolean isMan) {
            AnimationComplexPicture persAnim = null;
            try {
                byte[] pal = null;
                if (num > 1) {
                    pal = isMan ? this.loadPNGPalette("pers" + num + ".pak", 0) : this.loadPNGPalette("woman" + num + ".pak", 0);
                }
                if (isMan) {
                    this.openPak("pers1.pak");
                } else {
                    this.openPak("woman1.pak");
                }
                byte[] res_byte = Unpacker.getNextItem();
                if (pal != null) {
                    System.arraycopy(pal, 0, res_byte, 8, pal.length);
                }
                Image tmpImg = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                res_byte = Unpacker.getNextItem();
                persAnim = null;
                persAnim = new AnimationComplexPicture(tmpImg, res_byte, 16);
                res_byte = Unpacker.getNextItem();
                persAnim.loadANM(res_byte);
                for (int i = 0; i < 16; ++i) {
                    res_byte = Unpacker.getNextItem();
                    persAnim.loadANS(i, res_byte);
                }
                res_byte = null;
                Unpacker.closePack();
                System.gc();
            }
            catch (Exception e) {
                System.out.println("loadResForPers: " + e);
            }
            return persAnim;
        }

        private void loadResForBeasts(int num) {
            DataInputStream _Xml = this.openXML("beasts.xml");
            Parser prser = new Parser(_Xml);
            Element topElement = prser.getTree();
            Element elemXML = null;
            String topName = "beasts";
            topElement = prser.getNextTreeElementByName(topElement, null, topName);
            String mainPak = null;
            String palPak = null;
            int mainNum = 0;
            int palNum = 0;
            if (topElement != null) {
                while ((elemXML = prser.getNextTreeElementByName(topElement, elemXML, "beast")) != null) {
                    int id;
                    Attribute Attr = elemXML.getAttribute("id");
                    try {
                        id = Integer.parseInt(Attr.getValue());
                    }
                    catch (Exception e) {
                        id = 0;
                    }
                    if (id != num) continue;
                    Attr = elemXML.getAttribute("main");
                    mainPak = Attr.getValue();
                    Attr = elemXML.getAttribute("pal");
                    palPak = Attr.getValue();
                    if (palPak != null && palPak.equals("")) {
                        palPak = null;
                    }
                    Attr = elemXML.getAttribute("item");
                    try {
                        mainNum = Integer.parseInt(Attr.getValue());
                    }
                    catch (Exception e) {
                        mainNum = 0;
                    }
                    Attr = elemXML.getAttribute("palind");
                    try {
                        palNum = Integer.parseInt(Attr.getValue());
                    }
                    catch (Exception e) {
                        palNum = 0;
                    }
                    break;
                }
            }
            prser.ClearTree();
            try {
                _Xml.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (mainPak != null) {
                try {
                    byte[] pal = null;
                    if (num > 1) {
                        pal = this.loadPNGPalette("beast" + palPak + ".pak", palNum - 1);
                    }
                    this.openPak("beast" + mainPak + ".pak");
                    byte[] res_byte = Unpacker.getNextItem();
                    if (pal != null) {
                        System.arraycopy(pal, 0, res_byte, 8, pal.length);
                    }
                    Image tmpImg = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                    res_byte = Unpacker.getNextItem();
                    this.beastAnim = null;
                    this.beastAnim = new AnimationComplexPicture(tmpImg, res_byte, 16);
                    res_byte = Unpacker.getNextItem();
                    this.beastAnim.loadANM(res_byte);
                    for (int i = 0; i < 16; ++i) {
                        res_byte = Unpacker.getNextItem();
                        this.beastAnim.loadANS(i, res_byte);
                    }
                    res_byte = null;
                    Unpacker.closePack();
                    System.gc();
                }
                catch (Exception e) {
                    System.out.println("loadResForPers: " + e);
                }
            }
        }

        private void loadHearForPers2(boolean isMan) {
            this.hearAnimForSelect.removeAllElements();
            this.hearAnimForSelectTemp.clear();
            for (int i = 0; i < this.hearSortList.size(); ++i) {
                AnimationBuilder ab = (AnimationBuilder)this.hearSortList.elementAt(i);
                if (ab.palPak == null || ab.palPak.equals("")) continue;
                ab.pal = isMan ? this.loadPNGPalette("hear" + ab.palPak + ".pak", ab.palNum - 1) : this.loadPNGPalette("hear_w" + ab.palPak + ".pak", ab.palNum - 1);
            }
            String pak = "";
            byte[] img_byte = null;
            byte[] opr_byte = null;
            byte[] dst_byte = null;
            byte[] anm_byte = null;
            int lastInd = -1;
            for (int i = 0; i < this.hearSortList.size(); ++i) {
                AnimationBuilder ab = (AnimationBuilder)this.hearSortList.elementAt(i);
                if (!ab.mainPak.equals(pak)) {
                    try {
                        Unpacker.closePack();
                        lastInd = -1;
                        pak = ab.mainPak;
                        if (isMan) {
                            this.openPak("hear" + pak + ".pak");
                        } else {
                            this.openPak("hear_w" + pak + ".pak");
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (lastInd != ab.mainNum - 1) {
                    lastInd = ab.mainNum - 1;
                    Unpacker.skipToItem(lastInd * 3);
                    img_byte = Unpacker.getNextItem();
                    opr_byte = Unpacker.getNextItem();
                    anm_byte = Unpacker.getNextItem();
                }
                dst_byte = null;
                if (ab.pal != null) {
                    dst_byte = new byte[img_byte.length];
                    System.arraycopy(img_byte, 0, dst_byte, 0, img_byte.length);
                    System.arraycopy(ab.pal, 0, dst_byte, 8, ab.pal.length);
                }
                Image tmpImg = null;
                tmpImg = dst_byte != null ? Image.createImage((byte[])dst_byte, (int)0, (int)dst_byte.length) : Image.createImage((byte[])img_byte, (int)0, (int)img_byte.length);
                AnimationComplexPicture _hearAnim = new AnimationComplexPicture(tmpImg, opr_byte, 16);
                _hearAnim.loadANM(anm_byte);
                this.hearAnimForSelectTemp.put(new Integer(ab.id), _hearAnim);
            }
            Unpacker.closePack();
            Enumeration hears = this.hearAnimForSelectTemp.elements();
            while (hears.hasMoreElements()) {
                this.hearAnimForSelect.insertElementAt(hears.nextElement(), 0);
            }
        }

        private AnimationComplexPicture loadHear(String pakName, int num, byte[] pal) {
            AnimationComplexPicture _hearAnim = null;
            try {
                this.openPak(pakName);
                Unpacker.skipNextItems(num * 3);
                byte[] res_byte = Unpacker.getNextItem();
                if (pal != null) {
                    System.arraycopy(pal, 0, res_byte, 8, pal.length);
                }
                Image tmpImg = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                res_byte = Unpacker.getNextItem();
                _hearAnim = new AnimationComplexPicture(tmpImg, res_byte, 16);
                res_byte = Unpacker.getNextItem();
                _hearAnim.loadANM(res_byte);
                res_byte = null;
                Unpacker.closePack();
                System.gc();
            }
            catch (Exception e) {
                // empty catch block
            }
            return _hearAnim;
        }

        private AnimationComplexPicture loadClothes(String pakName, int num, byte[] pal) {
            AnimationComplexPicture ClothesAnim = null;
            try {
                this.openPak(pakName);
                Unpacker.skipNextItems(num * 3);
                byte[] res_byte = Unpacker.getNextItem();
                if (pal != null) {
                    System.arraycopy(pal, 0, res_byte, 8, pal.length);
                }
                Image tmpImg = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                res_byte = Unpacker.getNextItem();
                ClothesAnim = new AnimationComplexPicture(tmpImg, res_byte, 16);
                res_byte = Unpacker.getNextItem();
                ClothesAnim.loadANM(res_byte);
                res_byte = null;
                Unpacker.closePack();
                System.gc();
            }
            catch (Exception e) {
                System.out.println("loadClothes ex: " + e);
            }
            return ClothesAnim;
        }

        private AnimationComplexPicture loadWeaponAndArmor(String pakName, int num, byte[] pal, boolean isMan) {
            return this.loadWeaponAndArmor(pakName, num, pal, isMan, false, 0);
        }

        private AnimationComplexPicture loadWeaponAndArmor(String pakName, int num, byte[] pal, boolean isMan, boolean isBot, int anmInd) {
            AnimationComplexPicture ClothesAnim = null;
            try {
                this.openPak(pakName + ".pak");
                Unpacker.skipNextItems(num * 4);
                byte[] res_byte = Unpacker.getNextItem();
                if (pal != null) {
                    System.arraycopy(pal, 0, res_byte, 8, pal.length);
                }
                Image tmpImg = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                res_byte = Unpacker.getNextItem();
                ClothesAnim = new AnimationComplexPicture(tmpImg, res_byte, 16);
                if (!isBot) {
                    if (!isMan) {
                        Unpacker.skipNextItems(1);
                    }
                    res_byte = Unpacker.getNextItem();
                    ClothesAnim.loadANM(res_byte);
                }
                res_byte = null;
                Unpacker.closePack();
                System.gc();
            }
            catch (Exception e) {
                System.out.println("loadClothes ex: " + e);
            }
            if (isBot) {
                try {
                    byte[] res_byte;
                    this.openPak(pakName + "_anim.pak");
                    if (ClothesAnim != null) {
                        Unpacker.skipNextItems(anmInd);
                        res_byte = Unpacker.getNextItem();
                        ClothesAnim.loadANM(res_byte);
                    }
                    res_byte = null;
                    Unpacker.closePack();
                    System.gc();
                }
                catch (Exception e) {
                    System.out.println("loadClothes anim pak ex: " + e);
                }
            }
            return ClothesAnim;
        }

        private void loadResForGUI() {
            try {
                int i;
                this.openPak("gui.pak");
                this.loadFontFromOpenedPak(0);
                FontManagerEx.setXSpacing(2, 0);
                this.loadFontFromOpenedPak(1);
                FontManagerEx.setXSpacing(2, 1);
                byte[] res_byte = Unpacker.getNextItem();
                Image tmpImg = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                res_byte = Unpacker.getNextItem();
                ComplexPicture cp = new ComplexPicture(tmpImg, res_byte);
                this.tabs = new Tabs(cp, 0);
                res_byte = Unpacker.getNextItem();
                tmpImg = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                res_byte = Unpacker.getNextItem();
                this.guiCP = new ComplexPicture(tmpImg, res_byte);
                for (i = 0; i < this.icones_faces.length; ++i) {
                    res_byte = Unpacker.getNextItem();
                    this.icones_faces[i] = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                }
                res_byte = Unpacker.getNextItem();
                this.newMailIcon = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                for (i = 0; i < this.icones_races.length; ++i) {
                    res_byte = Unpacker.getNextItem();
                    this.icones_races[i] = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                }
                res_byte = null;
                Unpacker.closePack();
                System.gc();
                this.openPak("icons_shop.pak");
                for (i = 0; i < this.coins.length; ++i) {
                    res_byte = Unpacker.getNextItem();
                    this.coins[i] = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                }
                res_byte = null;
                Unpacker.closePack();
                System.gc();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void loadResForStatisticsGUI() {
            try {
                this.openPak("statistics.pak");
                byte[] res_byte = Unpacker.getNextItem();
                Image tmpImg = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                res_byte = Unpacker.getNextItem();
                this.statisticsGUICP = new ComplexPicture(tmpImg, res_byte);
                res_byte = null;
                Unpacker.closePack();
                System.gc();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void loadResForQuest() {
            try {
                byte[] res_byte;
                this.openPak("icons_quest.pak");
                for (int i = 0; i < this.QuestsIcones.length; ++i) {
                    res_byte = Unpacker.getNextItem();
                    this.QuestsIcones[i] = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                }
                res_byte = null;
                Unpacker.closePack();
                System.gc();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void loadResForChat() {
            try {
                Unpacker.openPack("/res/smiles.pak", (byte)21, this.getClass());
                int count = Unpacker.getItemsCount() / 2;
                block2: for (int i = 0; i < count; ++i) {
                    byte[] res_byte = Unpacker.getNextItem();
                    Image tmpImg = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                    String txt = null;
                    int begin = 0;
                    res_byte = Unpacker.getNextItem();
                    String str = FontManagerEx.bytes2String(res_byte);
                    while (true) {
                        int end = str.indexOf("\n");
                        if (str.equals("")) continue block2;
                        String tmp = str.substring(begin, end);
                        if (txt == null) {
                            txt = tmp;
                        }
                        this.chat.smilesList.AddWord(tmp, 0, tmpImg);
                        str = str.substring(end + 1, str.length());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void loadSoundResData() {
            int id;
            DataInputStream _Xml = new DataInputStream(this.getClass().getResourceAsStream("/res/sounds/sounds.xml"));
            Parser prser = new Parser(_Xml);
            Element topElement = prser.getTree();
            Element elemXML = null;
            Element upperElement = topElement;
            String topName = "tracks";
            if ((topElement = prser.getNextTreeElementByName(upperElement, null, topName)) != null) {
                while ((elemXML = prser.getNextTreeElementByName(topElement, elemXML, "track")) != null) {
                    Attribute Attr = elemXML.getAttribute("id");
                    try {
                        id = Integer.parseInt(Attr.getValue());
                    }
                    catch (Exception e) {
                        id = 0;
                    }
                    if (id <= 0) continue;
                    Attr = elemXML.getAttribute("name");
                    this.tracksList.put(new Integer(id), Attr.getValue());
                }
            }
            if ((topElement = prser.getNextTreeElementByName(upperElement, null, topName = "locationtypes")) != null) {
                while ((elemXML = prser.getNextTreeElementByName(topElement, elemXML, "type")) != null) {
                    int track = 0;
                    Attribute Attr = elemXML.getAttribute("id");
                    try {
                        id = Integer.parseInt(Attr.getValue());
                    }
                    catch (Exception e) {
                        id = 0;
                    }
                    Attr = elemXML.getAttribute("track");
                    try {
                        track = Integer.parseInt(Attr.getValue());
                    }
                    catch (Exception e) {
                        track = 0;
                    }
                    if (id <= 0 || track <= 0) continue;
                    this.trackLocationTypes.put(new Integer(id), new Integer(track));
                }
            }
            prser.ClearTree();
            try {
                _Xml.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        private void loadMailIcons() {
            try {
                this.openPak("icons_mail.pak");
                for (int i = 0; i < this.mailIcons.length; ++i) {
                    byte[] res_byte = Unpacker.getNextItem();
                    this.mailIcons[i] = Image.createImage((byte[])res_byte, (int)0, (int)res_byte.length);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void clearMailIcons() {
            for (int i = 0; i < this.mailIcons.length; ++i) {
                this.mailIcons[i] = null;
            }
        }

        private void initMenuItems() {
            this.miLoginReg.text = GameText.STR_TOOLBAR_REGISTRATION;
            this.miLoginEnter.text = GameText.STR_TOOLBAR_ENTER;
            this.miChat1.text = GameText.STR_TOOLBAR_WRITE;
            this.miChat2.text = GameText.STR_TOOLBAR_LIST;
            this.miChat3.text = GameText.STR_TOOLBAR_ROOMS;
            this.miChatWarning.text = GameText.STR_TOOLBAR_CHATWARNING;
            this.miChatWarn0005.text = StringUtiles.replaceSubString(GameText.STR_TOOLBAR_SILENS_IN_MIN, "%", "5");
            this.miChatWarn0030.text = StringUtiles.replaceSubString(GameText.STR_TOOLBAR_SILENS_IN_MIN, "%", "30");
            this.miChatWarn0060.text = StringUtiles.replaceSubString(GameText.STR_TOOLBAR_SILENS_IN_HOUR, "%", "1");
            this.miChatWarn0180.text = StringUtiles.replaceSubString(GameText.STR_TOOLBAR_SILENS_IN_HOUR, "%", "3");
            this.miChatWarn1440.text = StringUtiles.replaceSubString(GameText.STR_TOOLBAR_SILENS_IN_HOUR, "%", "24");
            this.miChatBan.text = GameText.STR_TOOLBAR_CHATBAN;
            this.miChatPrivate.text = GameText.STR_TOOLBAR_PRIVATE;
            this.miChatWriteTo.text = GameText.STR_TOOLBAR_WRITE;
            this.miChatMailTo.text = GameText.STR_TOOLBAR_MAIL;
            this.miInventar1.text = GameText.STR_TOOLBAR_CLOTHES;
            this.miInventar2.text = GameText.STR_TOOLBAR_GOODS;
            this.miInventar3.text = GameText.STR_TOOLBAR_PRESENTS;
            this.miInventar4.text = GameText.STR_TOOLBAR_DRESSON;
            this.miInventar5.text = GameText.STR_TOOLBAR_PUTOFF;
            this.miInventar6.text = GameText.STR_TOOLBAR_INFO;
            this.miShop1.text = GameText.STR_TOOLBAR_BYE;
            this.miShop2.text = GameText.STR_TOOLBAR_INFO;
            this.miSecond1.text = GameText.STR_TOOLBAR_REPAER;
            this.miSecond2.text = GameText.STR_TOOLBAR_SELL;
            this.miLocation1.text = GameText.STR_TOOLBAR_ENTERING;
            this.miLocation2.text = GameText.STR_TOOLBAR_INFO;
            this.miQuests1.text = GameText.STR_TOOLBAR_INFO;
            this.miBeats1.text = GameText.STR_TOOLBAR_AGRESSION;
            this.miBeats2.text = GameText.STR_TOOLBAR_INFO;
            this.miLocateList1.text = GameText.STR_TOOLBAR_MOVE;
            this.miLocateList2.text = GameText.STR_TOOLBAR_INFO;
            this.miStatistic1.text = GameText.STR_TOOLBAR_PARAMS;
            this.miStatistic2.text = GameText.STR_TOOLBAR_REWARDS;
            this.miStatistic3.text = GameText.STR_TOOLBAR_PERKS;
            this.miStatistic4.text = GameText.STR_TOOLBAR_WIZARDS;
            this.miStatistic5.text = GameText.STR_TOOLBAR_PRESENTS;
            this.miStatistic6.text = GameText.STR_TOOLBAR_SUPER;
            this.miBattleCreate.text = GameText.STR_TOOLBAR_CREATE;
            this.miBattleEnter.text = GameText.STR_TOOLBAR_ENTERING;
            this.miMailOpen.text = GameText.STR_TOOLBAR_OPEN;
            this.miMailDelete.text = GameText.STR_TOOLBAR_DELETE;
        }

        private String getVersion() {
            String res = null;
            try {
                res = Game.this.parent.getAppProperty("Client_Version");
            }
            catch (Exception e) {
                res = null;
            }
            return res;
        }

        private void getDefaultLanguage() {
            block3: {
                try {
                    String res = Game.this.parent.getAppProperty("Language");
                    if (res == null) break block3;
                    res = res.toLowerCase();
                    for (int i = 0; i < this.languageTypesList.length; ++i) {
                        if (!res.equals(this.languageTypesList[i])) continue;
                        this.language = i;
                        break;
                    }
                }
                catch (Exception e) {
                    this.language = 0;
                }
            }
            this.initMenuItems();
        }

        private int getPartner() {
            int id = 1;
            try {
                String res = Game.this.parent.getAppProperty("Partner");
                id = Integer.parseInt(res);
            }
            catch (Exception e) {
                id = 1;
            }
            return id;
        }

        private int getMoney1(int money) {
            return money / 10000;
        }

        private int getMoney2(int money) {
            return money % 10000 / 100;
        }

        private int getMoney3(int money) {
            return money % 100;
        }

        public final void initFirstData() {
            this.healthTimer.pause = true;
            this.SMSList.removeAllElements();
            this.chat.clear(true);
        }

        public final void stepAddHealth() {
            if (this.healthCur < this.healthMax + this.healthBonus) {
                ++this.healthCur;
                if (this.healthCur >= this.healthMax + this.healthBonus) {
                    this.healthCur = this.healthMax + this.healthBonus;
                    this.healthTimer.pause = true;
                }
            }
        }

        public String getSettingName(int index) {
            String name = "";
            switch (index) {
                case 0: {
                    name = GameText.STR_SETTINGS_SOUNDENABLE;
                    break;
                }
                case 1: {
                    name = GameText.STR_SETTINGS_SOUNDLEVEL;
                    break;
                }
                case 2: {
                    name = GameText.STR_SETTINGS_VIBROENABLE;
                }
            }
            return name;
        }

        public String getSettingValue(int index) {
            String value = "";
            switch (index) {
                case 0: {
                    value = this.settingSoundEnable ? GameText.STR_SETTINGS_ENABLE : GameText.STR_SETTINGS_DISABLE;
                    break;
                }
                case 1: {
                    value = "" + this.settingSoundLevel + "/100";
                    break;
                }
                case 2: {
                    value = this.settingVibroEnable ? GameText.STR_SETTINGS_ENABLE : GameText.STR_SETTINGS_DISABLE;
                }
            }
            return value;
        }

        public String getSettingLeftSoftKey(int index) {
            String value = "";
            switch (index) {
                case 0: {
                    value = this.settingSoundEnable ? GameText.STR_TOOLBAR_DISABLE : GameText.STR_TOOLBAR_ENABLE;
                    break;
                }
                case 1: {
                    value = this.settingSoundLevel > 0 ? "-" : "";
                    break;
                }
                case 2: {
                    value = this.settingVibroEnable ? GameText.STR_TOOLBAR_DISABLE : GameText.STR_TOOLBAR_ENABLE;
                }
            }
            return value;
        }

        public String getSettingRightSoftKey(int index) {
            String value = "";
            switch (index) {
                case 0: {
                    value = "";
                    break;
                }
                case 1: {
                    value = this.settingSoundLevel < 100 ? "+" : "";
                    break;
                }
                case 2: {
                    value = "";
                }
            }
            return value;
        }

        public void getSettingLeftClick(int index) {
            switch (index) {
                case 0: {
                    boolean bl = this.settingSoundEnable = !this.settingSoundEnable;
                    if (this.settingSoundEnable) {
                        this.SoundPlayer.Volume(1, this.settingSoundLevel);
                        this.SoundPlayer.Play(1, 0);
                        break;
                    }
                    this.SoundPlayer.Stop(1);
                    break;
                }
                case 1: {
                    if (this.settingSoundLevel <= 0) break;
                    this.settingSoundLevel -= 10;
                    this.SoundPlayer.soundLevel = this.settingSoundLevel;
                    this.SoundPlayer.Volume(1, this.settingSoundLevel);
                    break;
                }
                case 2: {
                    this.settingVibroEnable = !this.settingVibroEnable;
                }
            }
        }

        public void getSettingRightClick(int index) {
            switch (index) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.settingSoundLevel >= 100) break;
                    this.settingSoundLevel += 10;
                    this.SoundPlayer.soundLevel = this.settingSoundLevel;
                    this.SoundPlayer.Volume(1, this.settingSoundLevel);
                    break;
                }
            }
        }

        private void setState(int state) {
            this.clearState(Game.this.GSM.lastState().State);
            this.initState(state);
            Game.this.GSM.set(state);
        }

        private void pushState(int state) {
            this.clearState(Game.this.GSM.lastState().State);
            this.initState(state);
            Game.this.GSM.push(state);
        }

        private void popState() {
            this.clearState(Game.this.GSM.lastState().State);
            this.initState(Game.this.GSM.priorState().State);
            Game.this.GSM.pop();
        }

        private void clearState(int state) {
            switch (state) {
                case 7: {
                    this.breastplateAnim = null;
                    this.helmetAnim = null;
                    this.legedAnim = null;
                    this.bootAnim = null;
                    this.shoulderAnim = null;
                    this.armedAnim = null;
                    this.swordAnim = null;
                    this.curAnim = 0;
                    this.withWeapon = 0;
                    this.shieldAnim = null;
                    break;
                }
                case 15: {
                    this.breastplateAnim = null;
                    this.helmetAnim = null;
                    this.legedAnim = null;
                    this.bootAnim = null;
                    this.shoulderAnim = null;
                    this.armedAnim = null;
                    this.swordAnim = null;
                    this.curAnim = 0;
                    this.withWeapon = 0;
                    this.shieldAnim = null;
                    for (int i = 0; i < this.battleLogImages.length; ++i) {
                        this.battleLogImages[i] = null;
                    }
                    break;
                }
                case 17: {
                    this.breastplateAnim = null;
                    this.helmetAnim = null;
                    this.legedAnim = null;
                    this.bootAnim = null;
                    this.shoulderAnim = null;
                    this.armedAnim = null;
                    this.swordAnim = null;
                    this.curAnim = 0;
                    this.withWeapon = 0;
                    this.shieldAnim = null;
                    break;
                }
                case 23: {
                    for (int i = 0; i < this.battleLogImages.length; ++i) {
                        this.battleLogImages[i] = null;
                    }
                    break;
                }
                case 25: {
                    this.MailsList.removeAllElements();
                    this.clearMailIcons();
                }
            }
        }

        private void initState(int state) {
            switch (state) {
                case 4: {
                    this.listActiveElement = 0;
                    this.menu.clear();
                    this.menu.addItem(this.miLoginEnter);
                    this.menu.addItem(this.miLoginReg);
                    this.menu.setActiveItem(0);
                    break;
                }
                case 5: {
                    this.listActiveElement = 0;
                    break;
                }
                case 7: {
                    this.menu.clear();
                    this.menu.addItem(this.miInventar4);
                    this.menu.addItem(this.miInventar5);
                    this.menu.addItem(this.miInventar6);
                    this.menu.addItem(this.miEmpty);
                    this.menu.addItem(this.miInventar1);
                    this.menu.addItem(this.miInventar2);
                    this.menu.addItem(this.miInventar3);
                    this.menu.setActiveItem(0);
                    this.SelectedItem = this.ClothesItemsList.size() > 0 ? 1 : 0;
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    this.withWeapon = 0;
                    this.curAnim = 0;
                    this.dressedClothes = 0;
                    for (int i = 0; i < this.ClothesItemsList.size(); ++i) {
                        InventoryItem ci = (InventoryItem)this.ClothesItemsList.elementAt(i);
                        if (!ci.isDressed) continue;
                        this.dressedClothes -= this.dressOffClothesType(ci.type) - 1;
                        this.loadClothesData(ci.type, this.isManPers, ci.idInType, false, false, 0);
                        ci.isDressed = true;
                        ++this.dressedClothes;
                        if (ci.type == 7) {
                            if (this.withWeapon == 0) {
                                if (ci.isDressed) {
                                    this.curAnim += 8;
                                    this.withWeapon = 1;
                                }
                            } else if (!ci.isDressed) {
                                this.curAnim -= 8;
                                this.withWeapon = 0;
                            }
                            this.withWeapon = ci.isDressed ? 1 : 0;
                        }
                        this.lastTimeAnim = 0L;
                    }
                    break;
                }
                case 8: {
                    this.menu.clear();
                    this.menu.addItem(this.miLocation1);
                    this.menu.addItem(this.miLocation2);
                    this.menu.setActiveItem(0);
                    this.SelectedItem = this.BuildingsList.size() > 0 ? 1 : 0;
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    break;
                }
                case 9: {
                    this.menu.clear();
                    this.menu.addItem(this.miChat1);
                    this.menu.addItem(this.miChat2);
                    this.menu.setActiveItem(0);
                    break;
                }
                case 10: {
                    this.menu.clear();
                    this.menu.addItem(this.miChatWarning);
                    this.menu.addItem(this.miChatWarn0005);
                    this.menu.addItem(this.miChatWarn0030);
                    this.menu.addItem(this.miChatWarn0060);
                    this.menu.addItem(this.miChatWarn0180);
                    this.menu.addItem(this.miChatWarn1440);
                    this.menu.addItem(this.miChatBan);
                    this.menu.addItem(this.miEmpty);
                    this.menu.addItem(this.miChatPrivate);
                    this.menu.addItem(this.miChatWriteTo);
                    this.menu.addItem(this.miChatMailTo);
                    this.menu.setActiveItem(0);
                    break;
                }
                case 11: {
                    if (this.GameStateCur != 11) {
                        this.startWaiting();
                        this.SendNetMessage(63);
                        this.tabs.clear();
                    }
                    this.menu.clear();
                    this.menu.addItem(this.miShop1);
                    this.menu.addItem(this.miShop2);
                    this.menu.setActiveItem(0);
                    this.SelectedItem = this.ShopItemsList.size() > 0 ? 1 : 0;
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    break;
                }
                case 12: {
                    this.menu.clear();
                    this.menu.addItem(this.miSecond1);
                    this.menu.addItem(this.miSecond2);
                    this.menu.setActiveItem(0);
                    this.SecondClothesItemsList.removeAllElements();
                    for (int i = 0; i < this.ClothesItemsList.size(); ++i) {
                        InventoryItem ci = (InventoryItem)this.ClothesItemsList.elementAt(i);
                        if (ci.isDressed) continue;
                        this.SecondClothesItemsList.addElement(ci);
                    }
                    this.SelectedItem = this.SecondClothesItemsList.size() > 0 ? 1 : 0;
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    break;
                }
                case 13: {
                    this.menu.clear();
                    this.menu.addItem(this.miQuests1);
                    this.menu.setActiveItem(0);
                    this.SelectedItem = this.QuestsList.size() > 0 ? 1 : 0;
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    break;
                }
                case 14: {
                    this.menu.clear();
                    this.menu.addItem(this.miBeats1);
                    this.menu.addItem(this.miBeats2);
                    this.menu.setActiveItem(0);
                    this.SelectedItem = this.BeastsList.size() > 0 ? 1 : 0;
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    break;
                }
                case 15: {
                    this.isBattleOver = false;
                    this.loadBattleGUI();
                    this.loadBattleSelecter();
                    this.loadBattleBack(this.battleLocationID);
                    this.loadSuperPunch();
                    this.loadPunchIcons();
                    this.menu.clear();
                    this.battleBonusMoney = 0;
                    this.battleBonusExp = 0;
                    for (int i = 0; i < this.ClothesItemsList.size(); ++i) {
                        InventoryItem ci = (InventoryItem)this.ClothesItemsList.elementAt(i);
                        if (!ci.isDressed) continue;
                        this.loadClothesData(ci.type, this.isManPers, ci.idInType, false, false, 0);
                        if (ci.type == 7) {
                            if (this.withWeapon == 0) {
                                if (ci.isDressed) {
                                    this.curAnim += 8;
                                    this.withWeapon = 1;
                                }
                            } else if (!ci.isDressed) {
                                this.curAnim -= 8;
                                this.withWeapon = 0;
                            }
                            this.withWeapon = ci.isDressed ? 1 : 0;
                        }
                        this.lastTimeAnim = 0L;
                    }
                    this.menu.setActiveItem(0);
                    this.damageDraw = 0;
                    this.tabs.clear();
                    this.tabs.addTab(7, " " + GameText.STR_BATTLE_ACTION + " ");
                    this.tabs.addTab(9, " " + GameText.STR_BATTLE_BAG + " ");
                    this.tabs.addTab(10, " " + GameText.STR_BATTLE_BOOK + " ");
                    this.tabs.addTab(11, " " + GameText.STR_BATTLE_ALIE + " ");
                    this.tabs.addTab(12, " " + GameText.STR_BATTLE_ENEMY + " ");
                    this.tabs.addTab(13, " " + GameText.STR_BATTLE_LOG + " ");
                    this.BattleLogList = new Vector();
                    this.SelectedItem = 0;
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    this.lastTimeAnimBeast = 0L;
                    this.battleState = 2;
                    break;
                }
                case 16: {
                    this.menu.clear();
                    this.menu.addItem(this.miLocateList1);
                    this.menu.addItem(this.miLocateList2);
                    this.menu.setActiveItem(0);
                    this.SelectedItem = this.LocatesList.size() > 0 ? 1 : 0;
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    break;
                }
                case 17: {
                    this.menu.clear();
                    this.menu.addItem(this.miStatistic1);
                    this.menu.addItem(this.miStatistic2);
                    this.menu.addItem(this.miStatistic3);
                    this.menu.addItem(this.miStatistic4);
                    this.menu.addItem(this.miStatistic5);
                    this.menu.addItem(this.miStatistic6);
                    this.menu.setActiveItem(0);
                    for (int i = 0; i < this.ClothesItemsList.size(); ++i) {
                        InventoryItem ci = (InventoryItem)this.ClothesItemsList.elementAt(i);
                        if (!ci.isDressed) continue;
                        this.loadClothesData(ci.type, this.isManPers, ci.idInType, false, false, 0);
                        if (ci.type == 7) {
                            if (this.withWeapon == 0) {
                                if (ci.isDressed) {
                                    this.curAnim += 8;
                                    this.withWeapon = 1;
                                }
                            } else if (!ci.isDressed) {
                                this.curAnim -= 8;
                                this.withWeapon = 0;
                            }
                            this.withWeapon = ci.isDressed ? 1 : 0;
                        }
                        this.lastTimeAnim = 0L;
                    }
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    this.statisticState = 1;
                    break;
                }
                case 18: {
                    this.menu.clear();
                    this.menu.addItem(this.miBattleCreate);
                    this.menu.addItem(this.miBattleEnter);
                    this.menu.setActiveItem(0);
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    if (this.battlesList != null) {
                        this.battlesList.removeAllElements();
                    } else {
                        this.battlesList = new Vector();
                    }
                    this.SelectedItem = 0;
                    this.SendNetMessage(82);
                    break;
                }
                case 19: {
                    this.menu.clear();
                    this.fieldActiveElement = 0;
                    this.createBattle_MIN = this.playerLevel;
                    this.createBattle_MAX = this.playerLevel;
                    this.createBattle_TEAM = 1;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    break;
                }
                case 20: {
                    this.menu.clear();
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    this.SelectedItem = 0;
                    this.tabs.clear();
                    this.tabs.addTab(15, " " + GameText.STR_TOOLBAR_TEAM + " 1 ");
                    this.tabs.addTab(16, " " + GameText.STR_TOOLBAR_TEAM + " 2 ");
                    if (this.ourTEAM <= 0) break;
                    this.tabs.nextTab();
                    if (!this.tabs.activateTab()) break;
                    this.tabAction(this.tabs.getActiveTabID());
                    break;
                }
                case 21: {
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    this.SelectedItem = 1;
                    break;
                }
                case 23: {
                    this.loadPunchIcons();
                    this.tabs.clear();
                    for (int i = 0; i < this.playerLevel; ++i) {
                        this.tabs.addTab(-(i + 1), " " + GameText.STR_TOOLBAR_LEVEL + " " + (i + 1) + " ");
                    }
                    break;
                }
                case 24: {
                    this.menu.clear();
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    this.smsState = 1;
                    this.SelectedItem = this.SMSList.size() == 0 ? 0 : 1;
                    break;
                }
                case 25: {
                    this.menu.clear();
                    this.menu.addItem(this.miMailOpen);
                    this.menu.addItem(this.miMailDelete);
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    this.SelectedItem = this.MailsList.size() == 0 ? 0 : 1;
                    this.loadMailIcons();
                    this.startWaiting();
                    this.SendNetMessage(45);
                    break;
                }
                case 27: {
                    this.menu.clear();
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    this.SelectedItem = this.LocUsersList.size() == 0 ? 0 : 1;
                }
            }
        }

        private void processMenu() {
            if (Game.this.keyNum8 || Game.this.keyDown) {
                Game.this.keyClear();
                this.menu.nextItem();
            }
            if (Game.this.keyNum2 || Game.this.keyUp) {
                Game.this.keyClear();
                this.menu.priorItem();
            }
            if (Game.this.keyNum5 || Game.this.keyFire || Game.this.keySelectL) {
                Game.this.keyClear();
                this.menuAction(this.menu.click());
                this.menu.show(false);
            }
            if (Game.this.keySelectR) {
                Game.this.keyClear();
                this.menu.show(false);
            }
        }

        private void processTabs() {
            if (Game.this.keyLeft || Game.this.keyNum4) {
                Game.this.keyClear();
                this.tabs.priorTab();
            }
            if (Game.this.keyRight || Game.this.keyNum6) {
                Game.this.keyClear();
                this.tabs.nextTab();
            }
            if (Game.this.keyFire || Game.this.keyNum5) {
                Game.this.keyClear();
                if (this.tabs.activateTab()) {
                    this.tabAction(this.tabs.getActiveTabID());
                }
            }
        }

        private void tabAction(int tabID) {
            block0 : switch (tabID) {
                case 1: {
                    this.setState(8);
                    break;
                }
                case 2: {
                    this.inventarState = 1;
                    this.setState(7);
                    break;
                }
                case 3: {
                    this.setState(9);
                    this.SendNetMessage(100);
                    break;
                }
                case 4: {
                    this.setState(13);
                    break;
                }
                case 5: {
                    this.setState(16);
                    break;
                }
                case 6: {
                    this.setState(17);
                    break;
                }
                case 7: {
                    this.battleActionState = 0;
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    break;
                }
                case 11: {
                    this.SelectedItem = 0;
                    this.SelectedItem = this.battleAliesList.size() > 0 ? 1 : 0;
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    this.lastTimeAnimBeast = 0L;
                    this.battleActionState = 3;
                    break;
                }
                case 12: {
                    this.SelectedItem = 0;
                    this.SelectedItem = this.battleEnemiesList.size() > 0 ? 1 : 0;
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    this.lastTimeAnimBeast = 0L;
                    this.battleActionState = 4;
                    break;
                }
                case 13: {
                    this.SelectedItem = 0;
                    this.SelectedItem = this.BattleLogList.size() > 0 ? this.BattleLogList.size() : 0;
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    this.battleActionState = 5;
                    break;
                }
                case 14: {
                    this.setState(18);
                    break;
                }
                case 15: {
                    if (this.battleWaitState == 0) break;
                    this.battleWaitState = 0;
                    this.SelectedItem = this.battleAliesList.size() > 0 ? 1 : 0;
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    break;
                }
                case 16: {
                    if (this.battleWaitState != 0) break;
                    this.battleWaitState = 1;
                    this.SelectedItem = this.battleEnemiesList.size() > 0 ? 1 : 0;
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    break;
                }
                case 17: {
                    this.setState(21);
                    break;
                }
                case 18: {
                    this.setState(24);
                    break;
                }
                case 19: {
                    this.setState(25);
                    break;
                }
                case 20: {
                    this.setState(27);
                    break;
                }
                default: {
                    if (this.GameStateCur == 23) {
                        this.superPunshState = -tabID;
                        break;
                    }
                    if (this.GameStateCur != 11) break;
                    switch (tabID) {
                        case -1: {
                            this.startWaiting();
                            this.getGoods(1);
                            this.setState(11);
                            break block0;
                        }
                        case -2: {
                            this.startWaiting();
                            this.getGoods(2);
                            this.setState(11);
                            break block0;
                        }
                        case -3: {
                            this.startWaiting();
                            this.getGoods(3);
                            this.setState(11);
                            break block0;
                        }
                        case -4: {
                            this.startWaiting();
                            this.getGoods(4);
                            this.setState(11);
                            break block0;
                        }
                        case -5: {
                            this.startWaiting();
                            this.getGoods(5);
                            this.setState(11);
                            break block0;
                        }
                        case -6: {
                            this.startWaiting();
                            this.getGoods(6);
                            this.setState(11);
                            break block0;
                        }
                        case -7: {
                            this.startWaiting();
                            this.getGoods(7);
                            this.setState(11);
                            break block0;
                        }
                        case -8: {
                            this.startWaiting();
                            this.getGoods(8);
                            this.setState(11);
                            break block0;
                        }
                        case -9: {
                            this.startWaiting();
                            this.getGoods(9);
                            this.setState(11);
                        }
                    }
                }
            }
        }

        private void menuAction(int miID) {
            switch (miID) {
                case 1: {
                    this.setState(5);
                    break;
                }
                case 2: {
                    if (this.login.equals("")) {
                        this.window.init(GameText.STR_TOOLBAR_REG_LOGIN);
                        break;
                    }
                    this.startWaiting();
                    Thread t = new Thread(new Runnable(){

                        public void run() {
                            GameData.this.OpenConnection();
                            if (GameData.this.conn != null) {
                                Game.this.keyClear();
                                GameData.this.superPunchList.removeAllElements();
                                GameData.this.isUpdateDialog = false;
                                GameData.this.isMustUpdate = false;
                                GameData.this.SendNetMessage(2);
                            } else {
                                GameData.this.isWaiting = false;
                                GameData.this.window.init(GameText.STR_LOGIN_ERROR1 + " " + GameText.STR_LOGIN_ERROR2);
                            }
                        }
                    });
                    t.start();
                    break;
                }
                case 3: {
                    this.dressItemAction();
                    break;
                }
                case 4: {
                    if (this.playerLevel >= this.chatMinLevel) {
                        this.chatReceiverID = 0;
                        this.chatSendText = "";
                        this.showFormSimpleText(5, GameText.STR_TOOLBAR_MESSAGE, this.chatSendText, GameText.STR_TOOLBAR_OK, GameText.STR_TOOLBAR_CANCEL, 200);
                        break;
                    }
                    this.window.init(StringUtiles.replaceSubString(GameText.STR_CHAT_ERROR, "%N%", "" + this.chatMinLevel));
                    break;
                }
                case 5: {
                    this.chat.SelectedUserNum = this.chat.chatUsersList.size() > 0 ? 1 : 0;
                    this.chat.chatUsersShiftY = 0;
                    this.setState(10);
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    if (this.chat.SelectedUserData == null) break;
                    if (this.playerLevel >= this.chatMinLevel) {
                        this.chatReceiverID = this.chat.SelectedUserData.id;
                        this.chatSendText = "";
                        this.showFormSimpleText(6, GameText.STR_TOOLBAR_MESSAGEFOR + " " + this.chat.SelectedUserData.Name, this.chatSendText, GameText.STR_TOOLBAR_OK, GameText.STR_TOOLBAR_CANCEL, 200);
                        break;
                    }
                    this.window.init(StringUtiles.replaceSubString(GameText.STR_CHAT_ERROR, "%N%", "" + this.chatMinLevel));
                    break;
                }
                case 8: {
                    if (this.chat.SelectedUserData == null) break;
                    if (this.playerLevel >= this.chatMinLevel) {
                        this.chatReceiverID = 0;
                        this.chatSendText = this.chat.SelectedUserData.Name + " ";
                        this.showFormSimpleText(5, GameText.STR_TOOLBAR_MESSAGE, this.chatSendText, GameText.STR_TOOLBAR_OK, GameText.STR_TOOLBAR_CANCEL, 200);
                        break;
                    }
                    this.window.init(StringUtiles.replaceSubString(GameText.STR_CHAT_ERROR, "%N%", "" + this.chatMinLevel));
                    break;
                }
                case 9: {
                    if (this.inventarState == 1) break;
                    this.menu.clear();
                    this.menu.addItem(this.miInventar4);
                    this.menu.addItem(this.miInventar5);
                    this.menu.addItem(this.miInventar6);
                    this.menu.addItem(this.miEmpty);
                    this.menu.addItem(this.miInventar1);
                    this.menu.addItem(this.miInventar2);
                    this.menu.addItem(this.miInventar3);
                    this.menu.setActiveItem(0);
                    this.SelectedItem = this.ClothesItemsList.size() > 0 ? 1 : 0;
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    this.inventarState = 1;
                    break;
                }
                case 10: {
                    if (this.inventarState == 2) break;
                    this.menu.clear();
                    this.menu.addItem(this.miInventar5);
                    this.menu.addItem(this.miInventar6);
                    this.menu.addItem(this.miEmpty);
                    this.menu.addItem(this.miInventar1);
                    this.menu.addItem(this.miInventar2);
                    this.menu.addItem(this.miInventar3);
                    this.menu.setActiveItem(0);
                    this.SelectedItem = this.GoodsItemsList.size() > 0 ? 1 : 0;
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    this.inventarState = 2;
                    break;
                }
                case 11: {
                    if (this.inventarState == 3) break;
                    this.menu.clear();
                    this.menu.addItem(this.miInventar5);
                    this.menu.addItem(this.miInventar6);
                    this.menu.addItem(this.miEmpty);
                    this.menu.addItem(this.miInventar1);
                    this.menu.addItem(this.miInventar2);
                    this.menu.addItem(this.miInventar3);
                    this.menu.setActiveItem(0);
                    this.SelectedItem = this.PresentsItemsList.size() > 0 ? 1 : 0;
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    this.inventarState = 3;
                    break;
                }
                case 12: {
                    if (InventoryItem.isDressable(this.shopItemsType)) {
                        if (this.ClothesItemsList.size() - this.dressedClothes < this.max_clothes_count) {
                            this.SendNetMessage(62);
                            break;
                        }
                        this.window.init(GameText.STR_INVENTARY_FULL);
                        break;
                    }
                    this.SendNetMessage(62);
                    break;
                }
                case 13: {
                    if (this.SelectedItem <= 0) break;
                    InventoryItem ci = (InventoryItem)this.ShopItemsList.elementAt(this.SelectedItem - 1);
                    this.window.init(ci.name + "\n" + ci.description);
                    break;
                }
                case 14: {
                    break;
                }
                case 15: {
                    break;
                }
                case 16: {
                    if (this.BuildingsList.size() <= 0 || this.SelectedItem <= 0) break;
                    this.curBuilding = (Building)this.BuildingsList.elementAt(this.SelectedItem - 1);
                    if (!this.isGhost) {
                        if (this.curBuilding.Type == 3) {
                            this.setState(11);
                            break;
                        }
                        if (this.curBuilding.Type == 4) {
                            this.setState(12);
                            break;
                        }
                        if (this.curBuilding.Type == 6) {
                            this.BeastsList.removeAllElements();
                            this.startWaiting();
                            this.setState(14);
                            this.SendNetMessage(73);
                            break;
                        }
                        if (this.curBuilding.Type == 2) {
                            this.tabs.clear();
                            this.tabs.addTab(14, " " + GameText.STR_TOOLBAR_BATTLES + " ");
                            this.setState(18);
                            break;
                        }
                        if (this.curBuilding.Type != 8) break;
                        this.tabs.clear();
                        this.tabs.addTab(14, " " + GameText.STR_TOOLBAR_BATTLES + " ");
                        this.setState(18);
                        break;
                    }
                    if (this.curBuilding.Type != 5) {
                        this.window.init(GameText.STR_GHOST_ENTER_ERROR);
                        break;
                    }
                    this.startWaiting();
                    this.SendNetMessage(42);
                    break;
                }
                case 17: {
                    break;
                }
                case 18: {
                    break;
                }
                case 19: {
                    this.SendNetMessage(76);
                    break;
                }
                case 20: {
                    break;
                }
                case 21: {
                    long dif = System.currentTimeMillis() - this.inLocationTime;
                    if (this.isGhost || dif > 30000L) {
                        this.startWaiting();
                        this.newLocationID = ((Locate)this.LocatesList.elementAt((int)(this.SelectedItem - 1))).id;
                        this.SendNetMessage(72);
                        break;
                    }
                    this.window.init(StringUtiles.replaceSubString(GameText.STR_LOCATION_CHANGE_ERROR, "%TIME%", "" + (30000L - dif + 999L) / 1000L));
                    break;
                }
                case 22: {
                    break;
                }
                case 23: {
                    if (this.statisticState == 1) break;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    this.statisticState = 1;
                    break;
                }
                case 24: {
                    if (this.statisticState == 3) break;
                    this.SelectedItem = this.RewardsItemsList.size() > 0 ? 1 : 0;
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    this.statisticState = 3;
                    break;
                }
                case 25: {
                    break;
                }
                case 26: {
                    break;
                }
                case 27: {
                    if (this.statisticState == 4) break;
                    this.SelectedItem = this.GiftsItemsList.size() > 0 ? 1 : 0;
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    this.statisticState = 4;
                    break;
                }
                case 28: {
                    InventoryItem ci;
                    if (this.SelectedItem <= 0 || this.inventarState != 1) break;
                    this.dressedActionItem = ci = (InventoryItem)this.ClothesItemsList.elementAt(this.SelectedItem - 1);
                    this.dressedCount = 1;
                    this.startWaiting();
                    this.SendNetMessage(34);
                    break;
                }
                case 29: {
                    if (this.SelectedItem <= 0) break;
                    InventoryItem ci = (InventoryItem)this.ClothesItemsList.elementAt(this.SelectedItem - 1);
                    this.window.init(ci.name + "\n" + ci.description);
                    break;
                }
                case 30: {
                    this.setState(19);
                    break;
                }
                case 31: {
                    if (this.battlesList.size() <= 0 || this.SelectedItem <= 0 || this.SelectedItem > this.battlesList.size()) break;
                    this.startWaiting();
                    Battle b = (Battle)this.battlesList.elementAt(this.SelectedItem - 1);
                    this.battleIDSelected = b.id;
                    this.SendNetMessage(84);
                    break;
                }
                case 32: {
                    this.superPunshState = 1;
                    this.SelectedItem = this.GiftsItemsList.size() > 0 ? 1 : 0;
                    this.ItemsShiftY = 0;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                    this.setState(23);
                    break;
                }
                case 35: {
                    if (this.chat.SelectedUserData == null) break;
                    if (this.playerLevel >= this.mailMinLevel) {
                        this.chatReceiverID = this.chat.SelectedUserData.id;
                        this.chatSendText = "";
                        this.showFormSimpleText(7, GameText.STR_TOOLBAR_MAILFOR + " " + this.chat.SelectedUserData.Name, this.chatSendText, GameText.STR_TOOLBAR_OK, GameText.STR_TOOLBAR_CANCEL, 200);
                        break;
                    }
                    this.window.init(StringUtiles.replaceSubString(GameText.STR_MAIL_ERROR, "%N%", "" + this.mailMinLevel));
                    break;
                }
                case 33: {
                    if (this.MailsList.size() <= 0 || this.SelectedItem <= 0 || this.SelectedItem > this.MailsList.size()) break;
                    this.startWaiting();
                    Mail mail = (Mail)this.MailsList.elementAt(this.SelectedItem - 1);
                    this.chatReceiverID = mail.ID;
                    this.SendNetMessage(48);
                    break;
                }
                case 34: {
                    if (this.MailsList.size() <= 0 || this.SelectedItem <= 0 || this.SelectedItem > this.MailsList.size()) break;
                    Mail mail = (Mail)this.MailsList.elementAt(this.SelectedItem - 1);
                    this.chatReceiverID = mail.ID;
                    this.window.init(GameText.STR_MAIL_DELETE, 5);
                    break;
                }
                case 37: {
                    if (this.chat.SelectedUserData == null) break;
                    this.chatReceiverID = this.chat.SelectedUserData.id;
                    this.chatWarnTime = 1;
                    this.SendNetMessage(107);
                    break;
                }
                case 38: {
                    if (this.chat.SelectedUserData == null) break;
                    this.chatReceiverID = this.chat.SelectedUserData.id;
                    this.chatWarnTime = 5;
                    this.SendNetMessage(107);
                    break;
                }
                case 39: {
                    if (this.chat.SelectedUserData == null) break;
                    this.chatReceiverID = this.chat.SelectedUserData.id;
                    this.chatWarnTime = 15;
                    this.SendNetMessage(107);
                    break;
                }
                case 40: {
                    if (this.chat.SelectedUserData == null) break;
                    this.chatReceiverID = this.chat.SelectedUserData.id;
                    this.chatWarnTime = 30;
                    this.SendNetMessage(107);
                    break;
                }
                case 41: {
                    if (this.chat.SelectedUserData == null) break;
                    this.chatReceiverID = this.chat.SelectedUserData.id;
                    this.chatWarnTime = 60;
                    this.SendNetMessage(107);
                    break;
                }
                case 42: {
                    if (this.chat.SelectedUserData == null) break;
                    this.chatReceiverID = this.chat.SelectedUserData.id;
                    this.chatWarnTime = 180;
                    this.SendNetMessage(107);
                    break;
                }
                case 43: {
                    if (this.chat.SelectedUserData == null) break;
                    this.chatReceiverID = this.chat.SelectedUserData.id;
                    this.chatWarnTime = 720;
                    this.SendNetMessage(107);
                    break;
                }
                case 44: {
                    if (this.chat.SelectedUserData == null) break;
                    this.chatReceiverID = this.chat.SelectedUserData.id;
                    this.chatWarnTime = 1440;
                    this.SendNetMessage(107);
                    break;
                }
                case 36: {
                    if (this.chat.SelectedUserData == null) break;
                    this.chatReceiverID = this.chat.SelectedUserData.id;
                    this.chatWarnTime = 0;
                    this.SendNetMessage(107);
                    break;
                }
                case 45: {
                    if (this.chat.SelectedUserData == null) break;
                    this.chatReceiverID = this.chat.SelectedUserData.id;
                    this.chatWarnTime = -1;
                    this.SendNetMessage(107);
                }
            }
        }

        private void getGoods(int type) {
            this.ShopItemsList.removeAllElements();
            this.shopItemsType = type;
            this.SendNetMessage(60);
        }

        private void scrollTextListUp(Vector v) {
            if (v.size() > 0 && this.SelectedItem > 1) {
                --this.SelectedItem;
                this.label1Time = System.currentTimeMillis();
                this.label1XShift = 0;
                this.label1XShiftDirection = 1;
            }
        }

        private void scrollTextListDown(Vector v) {
            if (v.size() > 0 && this.SelectedItem < v.size()) {
                ++this.SelectedItem;
                this.label1Time = System.currentTimeMillis();
                this.label1XShift = 0;
                this.label1XShiftDirection = 1;
            }
        }

        private void startWaiting() {
            this.lastTimeWaiting = 0L;
            this.isWaiting = true;
        }

        private void stepLogo_1() {
            if (this.utimer >= 80L || !Game.this.keyAny) {
                // empty if block
            }
            this.startLogoTimer = true;
            if (this.startLogoTimer) {
                this.PAINT_EVENT = 1;
                --this.logoEnd;
            }
            if (this.logoEnd <= 0) {
                this.PAINT_EVENT = 1;
                this.utimer = 0L;
                this.logoEnd = 20;
                this.startLogoTimer = false;
                Game.this.keyClear();
                this.setState(2);
                this.logoImage_3 = null;
                System.gc();
            } else {
                ++this.utimer;
            }
        }

        private void stepLogo_2() {
            if (this.utimer >= 80L || !Game.this.keyAny) {
                // empty if block
            }
            this.startLogoTimer = true;
            if (this.startLogoTimer) {
                this.PAINT_EVENT = 1;
                --this.logoEnd;
            }
            if (this.logoEnd <= 0) {
                this.PAINT_EVENT = 1;
                this.utimer = 0L;
                this.logoEnd = 20;
                this.startLogoTimer = false;
                Game.this.keyClear();
                this.setState(3);
                this.logoImage_1 = null;
                this.logoImage_2 = null;
                System.gc();
            } else {
                ++this.utimer;
            }
        }

        private void stepLogo_3() {
            if (this.utimer >= 80L || Game.this.keyAny) {
                this.PAINT_EVENT = 1;
                this.utimer = 0L;
                Game.this.keyClear();
                this.loadLanguage(this.languageTypesList[this.language]);
                this.createMenuItems();
                this.loadResForGUI();
                this.loadResForStatisticsGUI();
                this.persAnim = this.loadResForPers(this.typePers, this.isManPers);
                this.loadResForQuest();
                this.loadHearData(this.isManPers);
                this.loadHearForPers2(this.isManPers);
                this.loadResForChat();
                int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7;
                int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
                this.chat.initScreen(w, h);
                this.lastTimeAnim = 0L;
                this.setState(4);
                this.logoImage_4 = null;
                System.gc();
            } else {
                ++this.utimer;
            }
        }

        private void stepLogin() {
            if (!this.menu.Active) {
                if (Game.this.keyUp || Game.this.keyNum2) {
                    Game.this.keyClear();
                    --this.listActiveElement;
                    if (this.listActiveElement < 0) {
                        this.listActiveElement = 2;
                    }
                }
                if (Game.this.keyDown || Game.this.keyNum8) {
                    Game.this.keyClear();
                    ++this.listActiveElement;
                    if (this.listActiveElement > 2) {
                        this.listActiveElement = 0;
                    }
                }
                if (Game.this.keyFire || Game.this.keyNum5) {
                    Game.this.keyClear();
                    String head = "";
                    String text = "";
                    switch (this.listActiveElement) {
                        case 0: {
                            head = GameText.STR_TOOLBAR_LOGIN;
                            text = this.login;
                            this.showFormSimpleText(1, head, text, GameText.STR_TOOLBAR_OK, GameText.STR_TOOLBAR_CANCEL, 15);
                            break;
                        }
                        case 1: {
                            head = GameText.STR_TOOLBAR_PASSWORD;
                            text = this.password;
                            this.showFormPasswordText(3, head, text, GameText.STR_TOOLBAR_OK, GameText.STR_TOOLBAR_CANCEL, 15);
                        }
                    }
                }
                if (Game.this.keyLeft || Game.this.keyNum4) {
                    Game.this.keyClear();
                    if (this.listActiveElement == 2 && this.language > 0) {
                        --this.language;
                        this.loadLanguage(this.languageTypesList[this.language]);
                        this.initMenuItems();
                    }
                }
                if (Game.this.keyRight || Game.this.keyNum6) {
                    Game.this.keyClear();
                    if (this.listActiveElement == 2 && this.language < this.languageNamesList.length - 1) {
                        ++this.language;
                        this.loadLanguage(this.languageTypesList[this.language]);
                        this.initMenuItems();
                    }
                }
                if (Game.this.keySelectL) {
                    Game.this.keyClear();
                    Game.this.parent.quit();
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    this.menu.show(true);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepRegistration1() {
            if (Game.this.keyUp || Game.this.keyNum2) {
                Game.this.keyClear();
                --this.listActiveElement;
                if (this.listActiveElement < 0) {
                    this.listActiveElement = 3;
                }
            }
            if (Game.this.keyDown || Game.this.keyNum8) {
                Game.this.keyClear();
                ++this.listActiveElement;
                if (this.listActiveElement > 3) {
                    this.listActiveElement = 0;
                }
            }
            if (Game.this.keyFire || Game.this.keyNum5) {
                Game.this.keyClear();
                String head = "";
                String text = "";
                switch (this.listActiveElement) {
                    case 0: {
                        head = GameText.STR_TOOLBAR_NAME;
                        text = this.nikname;
                        this.showFormSimpleText(2, head, text, GameText.STR_TOOLBAR_OK, GameText.STR_TOOLBAR_CANCEL, 15);
                        break;
                    }
                    case 1: {
                        head = GameText.STR_TOOLBAR_LOGIN;
                        text = this.login;
                        this.showFormSimpleText(1, head, text, GameText.STR_TOOLBAR_OK, GameText.STR_TOOLBAR_CANCEL, 15);
                        break;
                    }
                    case 2: {
                        head = GameText.STR_TOOLBAR_PASSWORD;
                        text = this.password;
                        this.showFormPasswordText(3, head, text, GameText.STR_TOOLBAR_OK, GameText.STR_TOOLBAR_CANCEL, 15);
                        break;
                    }
                    case 3: {
                        head = GameText.STR_TOOLBAR_REPEAT;
                        text = this.passwordConf;
                        this.showFormPasswordText(4, head, text, GameText.STR_TOOLBAR_OK, GameText.STR_TOOLBAR_CANCEL, 15);
                    }
                }
            }
            if (Game.this.keySelectL) {
                Game.this.keyClear();
                this.setState(4);
            }
            if (Game.this.keySelectR) {
                Game.this.keyClear();
                if (!this.password.equals(this.passwordConf)) {
                    this.window.init(GameText.STR_TOOLBAR_PASSWORDREP_ERR);
                } else if (this.nikname.equals("")) {
                    this.window.init(GameText.STR_TOOLBAR_REG_NIK);
                } else if (this.login.equals("")) {
                    this.window.init(GameText.STR_TOOLBAR_REG_LOGIN);
                } else {
                    this.lastTimeAnim = 0L;
                    this.listActiveElement = 0;
                    this.fieldActiveElement = 0;
                    this.setState(6);
                }
            }
        }

        private void stepRegistration2() {
            if (Game.this.keyUp || Game.this.keyNum2) {
                Game.this.keyClear();
                --this.fieldActiveElement;
                if (this.fieldActiveElement < 0) {
                    this.fieldActiveElement = 2;
                }
            }
            if (Game.this.keyDown || Game.this.keyNum8) {
                Game.this.keyClear();
                ++this.fieldActiveElement;
                if (this.fieldActiveElement > 2) {
                    this.fieldActiveElement = 0;
                }
            }
            if (Game.this.keyLeft || Game.this.keyNum4) {
                Game.this.keyClear();
                switch (this.fieldActiveElement) {
                    case 0: {
                        this.typePers = this.typePers == 1 ? 2 : 1;
                        this.persAnim = this.loadResForPers(this.typePers, this.isManPers);
                        break;
                    }
                    case 1: {
                        this.isManPers = !this.isManPers;
                        this.listActiveElement = 0;
                        this.loadHearData(this.isManPers);
                        this.loadHearForPers2(this.isManPers);
                        this.persAnim = this.loadResForPers(this.typePers, this.isManPers);
                        break;
                    }
                    case 2: {
                        --this.listActiveElement;
                        if (this.listActiveElement >= 0) break;
                        this.listActiveElement = this.hearAnimForSelect.size();
                    }
                }
            }
            if (Game.this.keyRight || Game.this.keyNum6) {
                Game.this.keyClear();
                switch (this.fieldActiveElement) {
                    case 0: {
                        this.typePers = this.typePers == 1 ? 2 : 1;
                        this.persAnim = this.loadResForPers(this.typePers, this.isManPers);
                        break;
                    }
                    case 1: {
                        this.isManPers = !this.isManPers;
                        this.listActiveElement = 0;
                        this.loadHearData(this.isManPers);
                        this.loadHearForPers2(this.isManPers);
                        this.persAnim = this.loadResForPers(this.typePers, this.isManPers);
                        break;
                    }
                    case 2: {
                        ++this.listActiveElement;
                        if (this.listActiveElement <= this.hearAnimForSelect.size()) break;
                        this.listActiveElement = 0;
                    }
                }
            }
            if (Game.this.keySelectL) {
                Game.this.keyClear();
                this.setState(5);
            }
            if (Game.this.keySelectR) {
                this.startWaiting();
                Game.this.keyClear();
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        GameData.this.OpenConnection();
                        if (GameData.this.conn != null) {
                            Game.this.keyClear();
                            GameData.this.superPunchList.removeAllElements();
                            GameData.this.isUpdateDialog = false;
                            GameData.this.isMustUpdate = false;
                            GameData.this.SendNetMessage(1);
                        } else {
                            GameData.this.isWaiting = false;
                            GameData.this.window.init(GameText.STR_LOGIN_ERROR1 + " " + GameText.STR_LOGIN_ERROR2);
                        }
                    }
                });
                t.start();
            }
        }

        private void initTabs() {
            this.tabs.clear();
            this.tabs.addTab(1, " " + GameText.STR_TOOLBAR_BUILDINGS + " ");
            this.tabs.addTab(2, " " + GameText.STR_TOOLBAR_INVENTAR + " ");
            this.tabs.addTab(3, " " + GameText.STR_TOOLBAR_CHAT + " ");
            this.tabs.addTab(5, " " + GameText.STR_TOOLBAR_LOCATIONS + " ");
            this.tabs.addTab(6, " " + GameText.STR_TOOLBAR_STATISTIC + " ");
            this.tabs.addTab(17, " " + GameText.STR_TOOLBAR_SETTINGS + " ");
            this.tabs.addTab(18, " " + GameText.STR_TOOLBAR_SMS + " ");
            this.tabs.addTab(19, " " + GameText.STR_TOOLBAR_MAILS + " ");
            this.tabs.addTab(20, " " + GameText.STR_TOOLBAR_USERS + " ");
        }

        private void initLocation(Hashtable[] hArr) {
            this.BuildingsList.removeAllElements();
            for (int i = 0; i < hArr.length; ++i) {
                Building b = new Building(hArr[i]);
                b.Image = this.loadIconForBuilding(b.Type - 1);
                this.BuildingsList.addElement(b);
            }
            this.SelectedItem = this.BuildingsList.size() > 0 ? 1 : 0;
        }

        private void stepLocation() {
            this.PAINT_EVENT = 1;
            if (!this.menu.Active) {
                this.processTabs();
                if (Game.this.keyNum2 || Game.this.keyUp) {
                    Game.this.keyClear();
                    if (this.BuildingsList.size() > 0 && this.SelectedItem > 1) {
                        --this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keyNum8 || Game.this.keyDown) {
                    Game.this.keyClear();
                    if (this.BuildingsList.size() > 0 && this.SelectedItem < this.BuildingsList.size()) {
                        ++this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keySelectL) {
                    Game.this.keyClear();
                    this.initFirstData();
                    this.setState(4);
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    this.menu.show(true);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepChat() {
            this.PAINT_EVENT = 1;
            if (!this.menu.Active) {
                if (Game.this.keyLeft) {
                    Game.this.keyClear();
                    this.tabs.priorTab();
                }
                if (Game.this.keyRight) {
                    Game.this.keyClear();
                    this.tabs.nextTab();
                }
                if (Game.this.keyFire) {
                    Game.this.keyClear();
                    if (this.tabs.activateTab()) {
                        this.tabAction(this.tabs.getActiveTabID());
                        this.SendNetMessage(102);
                        this.chat.clear(false);
                    }
                }
                if (Game.this.keyUp || Game.this.keyNum2) {
                    this.chat.Scroll(-this.fontSmall.getHeight());
                }
                if (Game.this.keyDown || Game.this.keyNum8) {
                    this.chat.Scroll(this.fontSmall.getHeight());
                }
                if (Game.this.keySelectL) {
                    Game.this.keyClear();
                    this.chatReceiverID = 0;
                    this.chatSendText = "";
                    this.showFormSimpleText(5, GameText.STR_TOOLBAR_MESSAGE, this.chatSendText, GameText.STR_TOOLBAR_OK, GameText.STR_TOOLBAR_CANCEL, 200);
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    this.menu.show(true);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepChatUsers() {
            this.PAINT_EVENT = 1;
            if (!this.menu.Active) {
                if (Game.this.keyLeft) {
                    Game.this.keyClear();
                    this.tabs.priorTab();
                }
                if (Game.this.keyRight) {
                    Game.this.keyClear();
                    this.tabs.nextTab();
                }
                if (Game.this.keyFire) {
                    Game.this.keyClear();
                    if (this.tabs.activateTab()) {
                        this.tabAction(this.tabs.getActiveTabID());
                        this.SendNetMessage(102);
                        this.chat.clear(false);
                    }
                }
                if ((Game.this.keyUp || Game.this.keyNum2) && this.chat.chatUsersList.size() > 0 && this.chat.SelectedUserNum > 1) {
                    --this.chat.SelectedUserNum;
                }
                if ((Game.this.keyDown || Game.this.keyNum8) && this.chat.chatUsersList.size() > 0 && this.chat.SelectedUserNum < this.chat.chatUsersList.size()) {
                    ++this.chat.SelectedUserNum;
                }
                if (Game.this.keySelectL) {
                    Game.this.keyClear();
                    this.setState(9);
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    if (this.chat.chatUsersList.size() > 0) {
                        this.chat.lockUser();
                        this.menu.show(true);
                    }
                }
            } else {
                this.processMenu();
            }
        }

        private void dropClothesItem(int id) {
            if (this.ClothesItemsList.size() > 0) {
                for (int i = 0; i < this.ClothesItemsList.size(); ++i) {
                    InventoryItem ci = (InventoryItem)this.ClothesItemsList.elementAt(i);
                    if (ci.idInInventar != id) continue;
                    this.ClothesItemsList.removeElementAt(i);
                    if (!ci.isDressed) break;
                    --this.dressedClothes;
                    switch (ci.type) {
                        case 1: {
                            this.breastplateAnim = null;
                            break;
                        }
                        case 2: {
                            this.helmetAnim = null;
                            break;
                        }
                        case 3: {
                            this.legedAnim = null;
                            break;
                        }
                        case 4: {
                            this.bootAnim = null;
                            break;
                        }
                        case 5: {
                            this.shoulderAnim = null;
                            break;
                        }
                        case 6: {
                            this.armedAnim = null;
                            break;
                        }
                        case 7: {
                            this.swordAnim = null;
                            this.curAnim -= 8;
                            this.withWeapon = 0;
                            break;
                        }
                        case 8: {
                            this.shieldAnim = null;
                        }
                    }
                    break;
                }
            }
        }

        private boolean dressOffClothes(InventoryItem ci) {
            boolean wasDreesed = false;
            if (ci.isDressed) {
                wasDreesed = true;
                switch (ci.type) {
                    case 1: {
                        this.breastplateAnim = null;
                        break;
                    }
                    case 2: {
                        this.helmetAnim = null;
                        break;
                    }
                    case 3: {
                        this.legedAnim = null;
                        break;
                    }
                    case 4: {
                        this.bootAnim = null;
                        break;
                    }
                    case 5: {
                        this.shoulderAnim = null;
                        break;
                    }
                    case 6: {
                        this.armedAnim = null;
                        break;
                    }
                    case 7: {
                        this.swordAnim = null;
                        break;
                    }
                    case 8: {
                        this.shieldAnim = null;
                    }
                }
                ci.isDressed = false;
            }
            return wasDreesed;
        }

        private int dressOffClothesType(int type) {
            int count = 0;
            if (this.ClothesItemsList.size() > 0) {
                for (int i = 0; i < this.ClothesItemsList.size(); ++i) {
                    InventoryItem ci = (InventoryItem)this.ClothesItemsList.elementAt(i);
                    if (ci.type != type || !this.dressOffClothes(ci)) continue;
                    ++count;
                }
            }
            return count;
        }

        private void dressItemAction() {
            if (this.SelectedItem > 0) {
                InventoryItem ci;
                this.dressedActionItem = ci = (InventoryItem)this.ClothesItemsList.elementAt(this.SelectedItem - 1);
                if (ci.isDressed && this.ClothesItemsList.size() - this.dressedClothes >= this.max_clothes_count) {
                    this.window.init(GameText.STR_INVENTARY_FULL);
                } else {
                    boolean complite = true;
                    if (!this.dressOffClothes(ci)) {
                        if (ci.level <= this.playerLevel) {
                            int dressedOff = this.dressOffClothesType(ci.type);
                            this.dressedClothes -= dressedOff;
                            this.loadClothesData(ci.type, this.isManPers, ci.idInType, false, false, 0);
                            ci.isDressed = true;
                            ++this.dressedClothes;
                            this.dressedAction = true;
                        } else {
                            complite = false;
                        }
                    } else {
                        this.dressedAction = false;
                        --this.dressedClothes;
                    }
                    if (complite) {
                        this.SendNetMessage(33);
                        if (ci.type == 7) {
                            if (this.withWeapon == 0) {
                                if (ci.isDressed) {
                                    this.curAnim += 8;
                                    this.withWeapon = 1;
                                }
                            } else if (!ci.isDressed) {
                                this.curAnim -= 8;
                                this.withWeapon = 0;
                            }
                            this.withWeapon = ci.isDressed ? 1 : 0;
                        }
                        this.lastTimeAnim = 0L;
                    }
                }
                switch (ci.type) {
                    case 1: {
                        this.typeBreastplate = ci.isDressed ? ci.idInType : 0;
                        break;
                    }
                    case 2: {
                        this.typeHelmet = ci.isDressed ? ci.idInType : 0;
                        break;
                    }
                    case 3: {
                        this.typeLeged = ci.isDressed ? ci.idInType : 0;
                        break;
                    }
                    case 4: {
                        this.typeBoot = ci.isDressed ? ci.idInType : 0;
                        break;
                    }
                    case 5: {
                        this.typeShoulder = ci.isDressed ? ci.idInType : 0;
                        break;
                    }
                    case 6: {
                        this.typeArmed = ci.isDressed ? ci.idInType : 0;
                        break;
                    }
                    case 7: {
                        this.typeSword = ci.isDressed ? ci.idInType : 0;
                        break;
                    }
                    case 8: {
                        this.typeShield = ci.isDressed ? ci.idInType : 0;
                    }
                }
            }
        }

        private void stepInventarClothes() {
            this.PAINT_EVENT = 1;
            if (!this.menu.Active) {
                this.processTabs();
                if (Game.this.keyNum2 || Game.this.keyUp) {
                    Game.this.keyClear();
                    if (this.ClothesItemsList.size() > 0 && this.SelectedItem > 1) {
                        --this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keyNum8 || Game.this.keyDown) {
                    Game.this.keyClear();
                    if (this.ClothesItemsList.size() > 0 && this.SelectedItem < this.ClothesItemsList.size()) {
                        ++this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keySelectL) {
                    Game.this.keyClear();
                    this.dressItemAction();
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    if (this.SelectedItem > 0) {
                        InventoryItem ci = (InventoryItem)this.ClothesItemsList.elementAt(this.SelectedItem - 1);
                        this.miInventar6.visible = true;
                        this.miInventar5.visible = true;
                        this.miInventar4.visible = ci.isDressed || ci.level <= this.playerLevel;
                        this.miInventar4.text = ci.isDressed ? GameText.STR_TOOLBAR_DRESSOFF : GameText.STR_TOOLBAR_DRESSON;
                        this.miEmpty.visible = true;
                    } else {
                        this.miInventar4.visible = false;
                        this.miInventar5.visible = false;
                        this.miInventar6.visible = false;
                        this.miEmpty.visible = false;
                    }
                    this.menu.show(true);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepInventarGoods() {
            if (!this.menu.Active) {
                this.processTabs();
                if (Game.this.keyNum2 || Game.this.keyUp) {
                    Game.this.keyClear();
                    if (this.GoodsItemsList.size() > 0 && this.SelectedItem > 1) {
                        --this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keyNum8 || Game.this.keyDown) {
                    Game.this.keyClear();
                    if (this.GoodsItemsList.size() > 0 && this.SelectedItem < this.GoodsItemsList.size()) {
                        ++this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    this.menu.show(true);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepInventarPresents() {
            if (!this.menu.Active) {
                this.processTabs();
                if (Game.this.keyNum2 || Game.this.keyUp) {
                    Game.this.keyClear();
                    if (this.PresentsItemsList.size() > 0 && this.SelectedItem > 1) {
                        --this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keyNum8 || Game.this.keyDown) {
                    Game.this.keyClear();
                    if (this.PresentsItemsList.size() > 0 && this.SelectedItem < this.PresentsItemsList.size()) {
                        ++this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    this.menu.show(true);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepRoom() {
            switch (this.inventarState) {
                case 1: {
                    this.stepInventarClothes();
                    break;
                }
                case 2: {
                    this.stepInventarGoods();
                    break;
                }
                case 3: {
                    this.stepInventarPresents();
                }
            }
        }

        private void stepShop() {
            if (!this.menu.Active) {
                this.processTabs();
                if (Game.this.keyNum2 || Game.this.keyUp) {
                    Game.this.keyClear();
                    if (this.ShopItemsList.size() > 0 && this.SelectedItem > 1) {
                        --this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keyNum8 || Game.this.keyDown) {
                    Game.this.keyClear();
                    if (this.ShopItemsList.size() > 0 && this.SelectedItem < this.ShopItemsList.size()) {
                        ++this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keySelectL) {
                    Game.this.keyClear();
                    this.ShopItemsList.removeAllElements();
                    this.initTabs();
                    this.setState(8);
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    this.menu.show(true);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepSecondHand() {
            if (!this.menu.Active) {
                if (Game.this.keyNum2 || Game.this.keyUp) {
                    Game.this.keyClear();
                    if (this.SecondClothesItemsList.size() > 0 && this.SelectedItem > 1) {
                        --this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keyNum8 || Game.this.keyDown) {
                    Game.this.keyClear();
                    if (this.SecondClothesItemsList.size() > 0 && this.SelectedItem < this.SecondClothesItemsList.size()) {
                        ++this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keySelectL) {
                    Game.this.keyClear();
                    this.ShopItemsList.removeAllElements();
                    this.initTabs();
                    this.setState(8);
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    this.menu.show(true);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepQuests() {
            if (!this.menu.Active) {
                this.processTabs();
                if (Game.this.keyNum2 || Game.this.keyUp) {
                    Game.this.keyClear();
                    if (this.QuestsList.size() > 0 && this.SelectedItem > 1) {
                        --this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keyNum8 || Game.this.keyDown) {
                    Game.this.keyClear();
                    if (this.QuestsList.size() > 0 && this.SelectedItem < this.QuestsList.size()) {
                        ++this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
            } else {
                this.processMenu();
            }
        }

        private void stepBeasts() {
            if (!this.menu.Active) {
                if (Game.this.keyNum2 || Game.this.keyUp) {
                    Game.this.keyClear();
                    if (this.BeastsList.size() > 0 && this.SelectedItem > 1) {
                        --this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keyNum8 || Game.this.keyDown) {
                    Game.this.keyClear();
                    if (this.BeastsList.size() > 0 && this.SelectedItem < this.BeastsList.size()) {
                        ++this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keySelectL) {
                    Game.this.keyClear();
                    this.setState(8);
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    this.menu.show(true);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepCloseBattle() {
            this.initTabs();
            this.curAnim = this.withWeapon * 8;
            this.lastTimeAnim = 0L;
            this.BattleLogList.removeAllElements();
            this.BattleLogList = null;
            this.battleID = 0;
            for (int i = 0; i < this.battleLogImages.length; ++i) {
                this.battleLogImages[i] = null;
            }
            this.setState(8);
        }

        private Warrior getAliyByID(int id) {
            Warrior aliy = null;
            for (int i = 0; i < this.battleAliesList.size(); ++i) {
                Warrior w = (Warrior)this.battleAliesList.elementAt(i);
                if (w.id != id) continue;
                aliy = w;
                break;
            }
            return aliy;
        }

        private Warrior getEnemyByID(int id) {
            Warrior enemy = null;
            for (int i = 0; i < this.battleEnemiesList.size(); ++i) {
                Warrior w = (Warrior)this.battleEnemiesList.elementAt(i);
                if (w.id != id) continue;
                enemy = w;
                break;
            }
            return enemy;
        }

        private void initBattleEnd() {
            this.battleState = 5;
            this.hearAnimBeast = null;
            this.breastplateAnimBeast = null;
            this.helmetAnimBeast = null;
            this.legedAnimBeast = null;
            this.bootAnimBeast = null;
            this.shoulderAnimBeast = null;
            this.armedAnimBeast = null;
            this.swordAnimBeast = null;
            this.shieldAnimBeast = null;
            this.beastAnim = null;
            this.lastEnemyID = 0;
            if (this.isWinner) {
                this.window.init(GameText.STR_BATTLE_WIN, true, false, 1, 3);
            } else {
                this.window.init(GameText.STR_BATTLE_LOSE, true, false, 2, 1);
            }
            Game.this.keyClear();
        }

        private void initBattleStep() {
            this.playerEnd = false;
            this.enemyEnd = false;
            this.isPlayeredTurn = this.isPlayeredNextTurn;
            this.battleSelecterIndex = 0;
            if (this.EnemyID != 0) {
                this.healthCurBeast = this.enemyHealth;
                this.healthMaxBeast = this.enemyHealthMax;
                this.curAnimBeast = 0;
                if (this.lastEnemyID != this.EnemyID) {
                    this.curEnemy = null;
                    for (int i = 0; i < this.battleEnemiesList.size(); ++i) {
                        Warrior w = (Warrior)this.battleEnemiesList.elementAt(i);
                        if (w.id != this.EnemyID) continue;
                        this.curEnemy = w;
                        break;
                    }
                    if (this.curEnemy != null) {
                        if (!this.curEnemy.isBeast) {
                            if (this.curEnemy.typeHear > 0) {
                                if (this.curEnemy.typeHear == this.typeHear && this.isManPers == this.curEnemy.isMan) {
                                    this.hearAnimBeast = this.hearAnim;
                                } else if (this.hearAnimBeast == null || this.typeHearBeast != this.curEnemy.typeHear || this.curEnemy.isMan != this.isManPersBeast) {
                                    this.hearAnimBeast = this.loadHearData(this.curEnemy.isMan, this.curEnemy.typeHear);
                                }
                            } else {
                                this.hearAnimBeast = null;
                            }
                            this.typeHearBeast = this.curEnemy.typeHear;
                            if (this.curEnemy.typeBreastplate > 0) {
                                if (this.curEnemy.typeBreastplate == this.typeBreastplate && this.isManPers == this.curEnemy.isMan) {
                                    this.breastplateAnimBeast = this.breastplateAnim;
                                } else if (this.breastplateAnimBeast == null || this.typeBreastplateBeast != this.curEnemy.typeBreastplate || this.curEnemy.isMan != this.isManPersBeast) {
                                    this.loadClothesData(1, this.curEnemy.isMan, this.curEnemy.typeBreastplate, false, true, 0);
                                }
                            } else {
                                this.breastplateAnimBeast = null;
                            }
                            this.typeBreastplateBeast = this.curEnemy.typeBreastplate;
                            if (this.curEnemy.typeHelmet > 0) {
                                if (this.curEnemy.typeHelmet == this.typeHelmet && this.isManPers == this.curEnemy.isMan) {
                                    this.helmetAnimBeast = this.helmetAnim;
                                } else if (this.helmetAnimBeast == null || this.typeHelmetBeast != this.curEnemy.typeHelmet || this.curEnemy.isMan != this.isManPersBeast) {
                                    this.loadClothesData(2, this.curEnemy.isMan, this.curEnemy.typeHelmet, false, true, 0);
                                }
                            } else {
                                this.helmetAnimBeast = null;
                            }
                            this.typeHelmetBeast = this.curEnemy.typeHelmet;
                            if (this.curEnemy.typeLeged > 0) {
                                if (this.curEnemy.typeLeged == this.typeLeged && this.isManPers == this.curEnemy.isMan) {
                                    this.legedAnimBeast = this.legedAnim;
                                } else if (this.legedAnimBeast == null || this.typeLegedBeast != this.curEnemy.typeLeged || this.curEnemy.isMan != this.isManPersBeast) {
                                    this.loadClothesData(3, this.curEnemy.isMan, this.curEnemy.typeLeged, false, true, 0);
                                }
                            } else {
                                this.legedAnimBeast = null;
                            }
                            this.typeLegedBeast = this.curEnemy.typeLeged;
                            if (this.curEnemy.typeBoot > 0) {
                                if (this.curEnemy.typeBoot == this.typeBoot && this.isManPers == this.curEnemy.isMan) {
                                    this.bootAnimBeast = this.bootAnim;
                                } else if (this.bootAnimBeast == null || this.typeBootBeast != this.curEnemy.typeBoot || this.curEnemy.isMan != this.isManPersBeast) {
                                    this.loadClothesData(4, this.curEnemy.isMan, this.curEnemy.typeBoot, false, true, 0);
                                }
                            } else {
                                this.bootAnimBeast = null;
                            }
                            this.typeBootBeast = this.curEnemy.typeBoot;
                            if (this.curEnemy.typeShoulder > 0) {
                                if (this.curEnemy.typeShoulder == this.typeShoulder && this.isManPers == this.curEnemy.isMan) {
                                    this.shoulderAnimBeast = this.shoulderAnim;
                                } else if (this.shoulderAnimBeast == null || this.typeShoulderBeast != this.curEnemy.typeShoulder || this.curEnemy.isMan != this.isManPersBeast) {
                                    this.loadClothesData(5, this.curEnemy.isMan, this.curEnemy.typeShoulder, false, true, 0);
                                }
                            } else {
                                this.shoulderAnimBeast = null;
                            }
                            this.typeShoulderBeast = this.curEnemy.typeShoulder;
                            if (this.curEnemy.typeArmed > 0) {
                                if (this.curEnemy.typeArmed == this.typeArmed && this.isManPers == this.curEnemy.isMan) {
                                    this.armedAnimBeast = this.armedAnim;
                                } else if (this.armedAnimBeast == null || this.typeArmedBeast != this.curEnemy.typeArmed || this.curEnemy.isMan != this.isManPersBeast) {
                                    this.loadClothesData(6, this.curEnemy.isMan, this.curEnemy.typeArmed, false, true, 0);
                                }
                            } else {
                                this.armedAnimBeast = null;
                            }
                            this.typeArmedBeast = this.curEnemy.typeArmed;
                            this.withWeaponBeast = 0;
                            this.curAnimBeast = 0;
                            if (this.curEnemy.typeSword > 0) {
                                this.withWeaponBeast = 1;
                                this.curAnimBeast += this.withWeaponBeast * 8;
                                if (this.curEnemy.typeSword == this.typeSword && this.isManPers == this.curEnemy.isMan) {
                                    this.swordAnimBeast = this.swordAnim;
                                } else if (this.swordAnimBeast == null || this.typeSwordBeast != this.curEnemy.typeSword || this.curEnemy.isMan != this.isManPersBeast) {
                                    this.loadClothesData(7, this.curEnemy.isMan, this.curEnemy.typeSword, false, true, 0);
                                }
                            } else {
                                this.swordAnimBeast = null;
                            }
                            this.typeSwordBeast = this.curEnemy.typeSword;
                            if (this.curEnemy.typeShield > 0) {
                                if (this.curEnemy.typeShield == this.typeShield && this.isManPers == this.curEnemy.isMan) {
                                    this.shieldAnimBeast = this.shieldAnim;
                                } else if (this.shieldAnimBeast == null || this.typeShieldBeast != this.curEnemy.typeShield || this.curEnemy.isMan != this.isManPersBeast) {
                                    this.loadClothesData(8, this.curEnemy.isMan, this.curEnemy.typeShield, false, true, 0);
                                }
                            } else {
                                this.shieldAnimBeast = null;
                            }
                            this.typeShieldBeast = this.curEnemy.typeShield;
                            if (this.curEnemy.isMan == this.isManPers && this.curEnemy.typePers == this.typePers) {
                                this.beastAnim = this.persAnim;
                            } else if (this.beastAnim == null || this.typePersBeast != this.curEnemy.typePers || this.curEnemy.isMan != this.isManPersBeast) {
                                this.beastAnim = this.loadResForPers(this.curEnemy.typePers, this.curEnemy.isMan);
                            }
                            this.isManPersBeast = this.curEnemy.isMan;
                            this.typePersBeast = this.curEnemy.typePers;
                        } else {
                            this.loadResForBeasts(this.curEnemy.beastType);
                            if (this.curEnemy.beastType == 1) {
                                this.loadClothesData(7, true, 1, true, true, 0);
                                this.loadClothesData(8, true, 1, true, true, 0);
                            } else if (this.curEnemy.beastType == 2) {
                                this.loadClothesData(7, true, 2, true, true, 0);
                                this.loadClothesData(8, true, 2, true, true, 0);
                            }
                        }
                    }
                }
            } else {
                this.curEnemy = null;
                this.beastAnim = null;
                this.hearAnimBeast = null;
                this.breastplateAnimBeast = null;
                this.helmetAnimBeast = null;
                this.legedAnimBeast = null;
                this.bootAnimBeast = null;
                this.shoulderAnimBeast = null;
                this.armedAnimBeast = null;
                this.swordAnimBeast = null;
                this.shieldAnimBeast = null;
            }
            this.lastEnemyID = this.EnemyID;
            int n = this.battleState = this.isPlayeredTurn ? 1 : 4;
            if (this.isPlayeredTurn) {
                this.inBattleStepTime = System.currentTimeMillis();
            }
            this.showEnemy = true;
            Game.this.keyClear();
        }

        private void stepBattleAction() {
            if (!this.menu.Active) {
                this.processTabs();
                if (!this.isBattleOver && this.battleState == 1) {
                    if (Game.this.keyNum2 || Game.this.keyUp) {
                        Game.this.keyClear();
                        if (this.battleSelecterIndex > 0) {
                            --this.battleSelecterIndex;
                        }
                    }
                    if (Game.this.keyNum8 || Game.this.keyDown) {
                        Game.this.keyClear();
                        if (this.battleSelecterIndex < 2) {
                            ++this.battleSelecterIndex;
                        }
                    }
                    if (Game.this.keySelectR) {
                        Game.this.keyClear();
                        this.battleState = 2;
                        this.SendNetMessage(92);
                    }
                }
            } else {
                this.processMenu();
            }
        }

        private void stepBattleAlies() {
            if (!this.menu.Active) {
                this.processTabs();
                if (Game.this.keyNum2 || Game.this.keyUp) {
                    Game.this.keyClear();
                    if (this.battleAliesList.size() > 0 && this.SelectedItem > 1) {
                        --this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keyNum8 || Game.this.keyDown) {
                    Game.this.keyClear();
                    if (this.battleAliesList.size() > 0 && this.SelectedItem < this.battleAliesList.size()) {
                        ++this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    this.menu.show(true);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepBattleEnemies() {
            if (!this.menu.Active) {
                this.processTabs();
                if (Game.this.keyNum2 || Game.this.keyUp) {
                    Game.this.keyClear();
                    if (this.battleEnemiesList.size() > 0 && this.SelectedItem > 1) {
                        --this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keyNum8 || Game.this.keyDown) {
                    Game.this.keyClear();
                    if (this.battleEnemiesList.size() > 0 && this.SelectedItem < this.battleEnemiesList.size()) {
                        ++this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    this.menu.show(true);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepBattleLog() {
            if (!this.menu.Active) {
                this.processTabs();
                if ((Game.this.keyNum2 || Game.this.keyUp) && this.BattleLogList.size() > 0 && this.SelectedItem > 1) {
                    --this.SelectedItem;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                }
                if ((Game.this.keyNum8 || Game.this.keyDown) && this.BattleLogList.size() > 0 && this.SelectedItem < this.BattleLogList.size()) {
                    ++this.SelectedItem;
                    this.label1Time = System.currentTimeMillis();
                    this.label1XShift = 0;
                    this.label1XShiftDirection = 1;
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    this.menu.show(true);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepBattle() {
            long cTime;
            if (this.battleState == 1 && (cTime = System.currentTimeMillis()) - this.inBattleStepTime > 30000L) {
                this.battleSelecterIndex = -1;
                this.battleState = 2;
                this.SendNetMessage(92);
            }
            switch (this.battleActionState) {
                case 0: {
                    this.stepBattleAction();
                    break;
                }
                case 3: {
                    this.stepBattleAlies();
                    break;
                }
                case 4: {
                    this.stepBattleEnemies();
                    break;
                }
                case 5: {
                    this.stepBattleLog();
                }
            }
        }

        private void stepLocatesList() {
            if (!this.menu.Active) {
                this.processTabs();
                if (Game.this.keyNum2 || Game.this.keyUp) {
                    Game.this.keyClear();
                    if (this.LocatesList.size() > 0 && this.SelectedItem > 1) {
                        --this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keyNum8 || Game.this.keyDown) {
                    Game.this.keyClear();
                    if (this.LocatesList.size() > 0 && this.SelectedItem < this.LocatesList.size()) {
                        ++this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    this.menu.show(true);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepPersStatsParameters() {
            if (!this.menu.Active) {
                this.processTabs();
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    this.menu.show(true);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepPersStatsRewards() {
            if (!this.menu.Active) {
                this.processTabs();
                if (Game.this.keyNum2 || Game.this.keyUp) {
                    Game.this.keyClear();
                    this.scrollTextListUp(this.RewardsItemsList);
                }
                if (Game.this.keyNum8 || Game.this.keyDown) {
                    Game.this.keyClear();
                    this.scrollTextListDown(this.RewardsItemsList);
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    this.menu.show(true);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepPersStatsGifts() {
            if (!this.menu.Active) {
                this.processTabs();
                if (Game.this.keyNum2 || Game.this.keyUp) {
                    Game.this.keyClear();
                    this.scrollTextListUp(this.GiftsItemsList);
                }
                if (Game.this.keyNum8 || Game.this.keyDown) {
                    Game.this.keyClear();
                    this.scrollTextListDown(this.GiftsItemsList);
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    this.menu.show(true);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepPersStats() {
            switch (this.statisticState) {
                case 1: {
                    this.stepPersStatsParameters();
                    break;
                }
                case 3: {
                    this.stepPersStatsRewards();
                    break;
                }
                case 4: {
                    this.stepPersStatsGifts();
                }
            }
        }

        private void stepArena() {
            if (!this.menu.Active) {
                this.processTabs();
                if (Game.this.keyNum2 || Game.this.keyUp) {
                    Game.this.keyClear();
                    if (this.battlesList.size() > 0 && this.SelectedItem > 1) {
                        --this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keyNum8 || Game.this.keyDown) {
                    Game.this.keyClear();
                    if (this.battlesList.size() > 0 && this.SelectedItem < this.battlesList.size()) {
                        ++this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    this.menu.show(true);
                }
                if (Game.this.keySelectL) {
                    Game.this.keyClear();
                    this.initTabs();
                    this.setState(8);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepCreateBattle() {
            if (!this.menu.Active) {
                if (Game.this.keyUp || Game.this.keyNum2) {
                    Game.this.keyClear();
                    --this.fieldActiveElement;
                    if (this.fieldActiveElement < 0) {
                        this.fieldActiveElement = 2;
                    }
                }
                if (Game.this.keyDown || Game.this.keyNum8) {
                    Game.this.keyClear();
                    ++this.fieldActiveElement;
                    if (this.fieldActiveElement > 2) {
                        this.fieldActiveElement = 0;
                    }
                }
                if (Game.this.keyLeft || Game.this.keyNum4) {
                    Game.this.keyClear();
                    switch (this.fieldActiveElement) {
                        case 0: {
                            if (this.createBattle_MIN <= 1 || this.playerLevel - this.createBattle_MIN >= 2) break;
                            --this.createBattle_MIN;
                            break;
                        }
                        case 1: {
                            if (this.createBattle_MAX <= this.playerLevel) break;
                            --this.createBattle_MAX;
                            break;
                        }
                        case 2: {
                            if (this.createBattle_TEAM <= 1) break;
                            --this.createBattle_TEAM;
                        }
                    }
                }
                if (Game.this.keyRight || Game.this.keyNum6) {
                    Game.this.keyClear();
                    switch (this.fieldActiveElement) {
                        case 0: {
                            if (this.createBattle_MIN >= this.playerLevel) break;
                            ++this.createBattle_MIN;
                            break;
                        }
                        case 1: {
                            if (this.createBattle_MAX - this.playerLevel >= 2) break;
                            ++this.createBattle_MAX;
                            break;
                        }
                        case 2: {
                            if (this.createBattle_TEAM >= 5) break;
                            ++this.createBattle_TEAM;
                        }
                    }
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    this.startWaiting();
                    this.SendNetMessage(80);
                }
                if (Game.this.keySelectL) {
                    Game.this.keyClear();
                    this.setState(18);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepBattleWait() {
            if (!this.menu.Active) {
                Vector v;
                this.processTabs();
                if (Game.this.keyNum2 || Game.this.keyUp) {
                    Game.this.keyClear();
                    Vector vector = v = this.battleWaitState == 0 ? this.battleAliesList : this.battleEnemiesList;
                    if (v.size() > 0 && this.SelectedItem > 1) {
                        --this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keyNum8 || Game.this.keyDown) {
                    Game.this.keyClear();
                    Vector vector = v = this.battleWaitState == 0 ? this.battleAliesList : this.battleEnemiesList;
                    if (v.size() > 0 && this.SelectedItem < v.size()) {
                        ++this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keySelectL) {
                    Game.this.keyClear();
                    this.SendNetMessage(87);
                    this.ShopItemsList.removeAllElements();
                    this.initTabs();
                    this.setState(8);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepSettings() {
            if (!this.menu.Active) {
                this.processTabs();
                if (Game.this.keyNum2 || Game.this.keyUp) {
                    Game.this.keyClear();
                    if (this.SettingsList.size() > 0 && this.SelectedItem > 1) {
                        --this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keyNum8 || Game.this.keyDown) {
                    Game.this.keyClear();
                    if (this.SettingsList.size() > 0 && this.SelectedItem < this.SettingsList.size()) {
                        ++this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keySelectL) {
                    Game.this.keyClear();
                    this.getSettingLeftClick(this.SelectedItem - 1);
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    this.getSettingRightClick(this.SelectedItem - 1);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepSuperPunch() {
            if (!this.menu.Active) {
                this.processTabs();
                if (Game.this.keySelectL) {
                    Game.this.keyClear();
                    this.initTabs();
                    this.tabs.activateTab(6);
                    this.setState(17);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepSMS() {
            if (this.smsState != 2) {
                if (!this.menu.Active) {
                    this.processTabs();
                    if (Game.this.keyNum2 || Game.this.keyUp) {
                        Game.this.keyClear();
                        if (this.SMSList.size() > 0 && this.SelectedItem > 1) {
                            --this.SelectedItem;
                            this.label1Time = System.currentTimeMillis();
                            this.label1XShift = 0;
                            this.label1XShiftDirection = 1;
                        }
                    }
                    if (Game.this.keyNum8 || Game.this.keyDown) {
                        Game.this.keyClear();
                        if (this.SMSList.size() > 0 && this.SelectedItem < this.SMSList.size()) {
                            ++this.SelectedItem;
                            this.label1Time = System.currentTimeMillis();
                            this.label1XShift = 0;
                            this.label1XShiftDirection = 1;
                        }
                    }
                    if (Game.this.keySelectL) {
                        Game.this.keyClear();
                    }
                    if (Game.this.keySelectR) {
                        Game.this.keyClear();
                        if (this.SMSList.size() > 0 && this.SelectedItem > 0 && this.SelectedItem <= this.SMSList.size()) {
                            this.smsCur = (SMS)this.SMSList.elementAt(this.SelectedItem - 1);
                            this.window.init(StringUtiles.replaceSubString(GameText.STR_SMS_QUEST, "%N%", this.smsCur.Number) + "\n" + "\"" + this.smsCur.Key + " " + this.smsCur.Text + "\"?", 3);
                        }
                    }
                } else {
                    this.processMenu();
                }
            } else if (this.smsCur.ResultSend >= 0) {
                this.isWaiting = false;
                this.smsState = 1;
                if (this.smsCur.ResultSend == 0) {
                    this.window.init(GameText.STR_SMS_OK, 4);
                } else {
                    this.window.init(StringUtiles.replaceSubString(GameText.STR_SMS_ERROR, "%N%", this.smsCur.Number) + "\n" + "\"" + this.smsCur.Key + " " + this.smsCur.Text + "\"", 4);
                }
            }
        }

        private void stepMails() {
            if (!this.menu.Active) {
                this.processTabs();
                if (Game.this.keyNum2 || Game.this.keyUp) {
                    Game.this.keyClear();
                    if (this.MailsList.size() > 0 && this.SelectedItem > 1) {
                        --this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keyNum8 || Game.this.keyDown) {
                    Game.this.keyClear();
                    if (this.MailsList.size() > 0 && this.SelectedItem < this.MailsList.size()) {
                        ++this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keySelectL) {
                    Game.this.keyClear();
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    this.menu.show(true);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepUpdate() {
            if (Game.this.keyUp || Game.this.keyNum2) {
                this.scrollList.Scroll(-FontManagerEx.getHeight(0));
            }
            if (Game.this.keyDown || Game.this.keyNum8) {
                this.scrollList.Scroll(FontManagerEx.getHeight(0));
            }
            if (Game.this.keySelectL) {
                Game.this.keyClear();
                try {
                    Game.this.parent.platformRequest(this.clientNewVersionPath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Game.this.parent.quit();
            }
            if (Game.this.keySelectR) {
                Game.this.keyClear();
                if (!this.isMustUpdate) {
                    this.initTabs();
                    this.setState(8);
                    this.startWaiting();
                    if (this.paksNotInList.size() == 0) {
                        this.SendNetMessage(5);
                    } else {
                        this.SendNetMessage(11);
                    }
                } else {
                    Game.this.parent.quit();
                }
            }
        }

        private void stepLocUsers() {
            if (!this.menu.Active) {
                this.processTabs();
                if (Game.this.keyNum2 || Game.this.keyUp) {
                    Game.this.keyClear();
                    if (this.LocUsersList.size() > 0 && this.SelectedItem > 1) {
                        --this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keyNum8 || Game.this.keyDown) {
                    Game.this.keyClear();
                    if (this.LocUsersList.size() > 0 && this.SelectedItem < this.LocUsersList.size()) {
                        ++this.SelectedItem;
                        this.label1Time = System.currentTimeMillis();
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                    }
                }
                if (Game.this.keySelectL) {
                    Game.this.keyClear();
                }
                if (Game.this.keySelectR) {
                    Game.this.keyClear();
                    this.menu.show(true);
                }
            } else {
                this.processMenu();
            }
        }

        private void stepWindowExtern() {
            switch (this.window.WindowExternState) {
                case 1: {
                    this.stepBattleEndText(true);
                    break;
                }
                case 2: {
                    this.stepBattleEndText(false);
                    break;
                }
                case 3: {
                    this.stepSMSQuestion();
                    break;
                }
                case 4: {
                    this.window.run();
                    break;
                }
                case 5: {
                    this.stepMailQuestion();
                }
            }
        }

        private void stepBattleEndText(boolean win) {
            if (Game.this.keyFire) {
                Game.this.keyClear();
                this.stepCloseBattle();
                this.window.active = false;
            }
        }

        private void stepSMSQuestion() {
            if (Game.this.keySelectL) {
                Game.this.keyClear();
                this.window.active = false;
                this.smsState = 2;
                this.startWaiting();
                this.smsCur.Send();
            }
            if (Game.this.keySelectR) {
                Game.this.keyClear();
                this.window.active = false;
            }
        }

        private void stepMailQuestion() {
            if (Game.this.keySelectL) {
                Game.this.keyClear();
                this.window.active = false;
                this.SendNetMessage(50);
                if (this.MailsList.size() > 0 && this.SelectedItem > 0 && this.SelectedItem <= this.MailsList.size()) {
                    Mail mail = (Mail)this.MailsList.elementAt(this.SelectedItem - 1);
                    if (mail.ID == this.chatReceiverID) {
                        this.MailsList.removeElementAt(this.SelectedItem - 1);
                        if (this.SelectedItem >= this.MailsList.size()) {
                            this.SelectedItem = this.MailsList.size();
                        }
                    }
                }
                boolean found = false;
                for (int i = 0; i < this.MailsList.size(); ++i) {
                    Mail mail = (Mail)this.MailsList.elementAt(i);
                    if (mail.Readed) continue;
                    found = true;
                    break;
                }
                this.isNewMail = found;
            }
            if (Game.this.keySelectR) {
                Game.this.keyClear();
                this.window.active = false;
            }
        }

        final void setClipFullSize(Graphics g) {
            g.setClip(0, 0, 176, 220);
        }

        final void drawWaiting(Graphics g) {
            if (this.lastTimeWaiting == 0L) {
                this.lastTimeWaiting = Game.this.paintTimeCur;
            }
            int frameID = this.waitingAnim.getFrame(0, Game.this.paintTimeCur - this.lastTimeWaiting, true);
            int anmFrame = this.waitingAnim.getAnimFrame(0, frameID);
            this.waitingAnim.DrawFrame(g, anmFrame, 88, 110, 3);
        }

        void longTextMoveSolve1(String str, int width, int fID) {
            int lngh = FontManagerEx.stringWidth(fID, str);
            if (lngh > width) {
                if (this.label1XShiftDirection > 0) {
                    if (this.label1Time + this.labelTimeFirstPause < Game.this.paintTimeCur) {
                        this.label1XShift = -((int)(Game.this.paintTimeCur - this.label1Time - this.labelTimeFirstPause)) * 20 / 1000;
                    }
                    if (lngh + this.label1XShift <= width) {
                        this.label1XShift = width - lngh;
                        this.label1XShiftDirection = -1;
                        this.label1Time = Game.this.paintTimeCur;
                    }
                } else {
                    if (this.label1Time + this.labelTimeLastPause < Game.this.paintTimeCur) {
                        this.label1XShift = width - lngh + (int)(Game.this.paintTimeCur - this.label1Time - this.labelTimeFirstPause) * 20 / 1000;
                    }
                    if (this.label1XShift >= 0) {
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                        this.label1Time = Game.this.paintTimeCur;
                    }
                }
            }
        }

        void longTextMoveSolve1(String str, int width, Font font) {
            int lngh = font.stringWidth(str);
            if (lngh > width) {
                if (this.label1XShiftDirection > 0) {
                    if (this.label1Time + this.labelTimeFirstPause < Game.this.paintTimeCur) {
                        this.label1XShift = -((int)(Game.this.paintTimeCur - this.label1Time - this.labelTimeFirstPause)) * 20 / 1000;
                    }
                    if (lngh + this.label1XShift <= width) {
                        this.label1XShift = width - lngh;
                        this.label1XShiftDirection = -1;
                        this.label1Time = Game.this.paintTimeCur;
                    }
                } else {
                    if (this.label1Time + this.labelTimeLastPause < Game.this.paintTimeCur) {
                        this.label1XShift = width - lngh + (int)(Game.this.paintTimeCur - this.label1Time - this.labelTimeFirstPause) * 20 / 1000;
                    }
                    if (this.label1XShift >= 0) {
                        this.label1XShift = 0;
                        this.label1XShiftDirection = 1;
                        this.label1Time = Game.this.paintTimeCur;
                    }
                }
            }
        }

        final void drawRect(Graphics g, int style, int x, int y, int w, int h, int color) {
            switch (style) {
                case 1: {
                    g.setColor(color);
                    g.fillRect(x, y, w, h);
                    Filler.fillWidthByImage(g, x, y, x + w, this.guiCP, 12);
                    Filler.fillWidthByImage(g, x, y + h - this.guiCP.GetHeight(12), x + w, this.guiCP, 12);
                    Filler.fillHeightByImage(g, x, y + this.guiCP.GetHeight(12), y + h - this.guiCP.GetHeight(12), this.guiCP, 21);
                    Filler.fillHeightByImage(g, x + w - this.guiCP.GetWidth(21), y + this.guiCP.GetHeight(12), y + h - this.guiCP.GetHeight(12), this.guiCP, 21);
                    break;
                }
                case 2: {
                    g.setColor(color);
                    g.fillRect(x, y, w, h);
                    Filler.fillHeightByImage(g, x, y, y + h, this.guiCP, 21);
                    Filler.fillHeightByImage(g, x + w - this.guiCP.GetWidth(21), y, y + h, this.guiCP, 21);
                }
            }
        }

        final void drawMenu(Graphics g, int right, int bot) {
            int width = 110;
            int Left = right - width;
            int Top = bot;
            for (int i = 0; i < this.menu.itemsCount(); ++i) {
                MenuItem mi = (MenuItem)this.menu.items.elementAt(i);
                if (!mi.visible) continue;
                if (mi.id != 0) {
                    Top -= this.guiCP.GetHeight(6);
                    continue;
                }
                Top -= this.guiCP.GetHeight(34);
            }
            int mLeft = Left + this.guiCP.GetWidth(6);
            int mWidth = width - this.guiCP.GetWidth(6) - this.guiCP.GetWidth(7);
            int itemHeight = this.guiCP.GetHeight(6);
            for (int i = 0; i < this.menu.itemsCount(); ++i) {
                MenuItem mi = (MenuItem)this.menu.items.elementAt(i);
                if (!mi.visible) continue;
                if (i != this.menu.ItemIndex) {
                    if (mi.id != 0) {
                        this.guiCP.Draw(g, 6, Left, Top);
                        this.guiCP.Draw(g, 7, Left + width - this.guiCP.GetWidth(7), Top);
                        Filler.fillWidthByImage(g, mLeft, Top, mLeft + mWidth, this.guiCP, 8);
                    } else {
                        this.guiCP.Draw(g, 34, Left, Top);
                        this.guiCP.Draw(g, 35, Left + width - this.guiCP.GetWidth(35), Top);
                        Filler.fillWidthByImage(g, mLeft, Top, mLeft + mWidth, this.guiCP, 36);
                    }
                } else {
                    this.guiCP.Draw(g, 9, Left, Top);
                    this.guiCP.Draw(g, 10, Left + width - this.guiCP.GetWidth(10), Top);
                    Filler.fillWidthByImage(g, mLeft, Top, mLeft + mWidth, this.guiCP, 11);
                }
                Top = mi.id != 0 ? (Top += itemHeight) : (Top += this.guiCP.GetHeight(34));
                if (mi.id == 0 || mi.text == null) continue;
                FontManagerEx.drawString(mi.text, right - width / 2, Top, 33, i == this.menu.ItemIndex ? 0 : 1);
            }
        }

        final void drawLogo_1(Graphics g) {
            g.setClip(0, 0, 176, 220);
            g.setColor(0);
            g.fillRect(0, 0, 176, 220);
            if (!this.startLogoTimer) {
                g.drawImage(this.logoImage_3, 88, 110, 3);
            } else {
                int[] shift = new int[2];
                shift[0] = (20 - this.logoEnd) * 10;
                shift[1] = -shift[0];
                int curShift = 0;
                int width = this.logoImage_3.getWidth();
                int height = this.logoImage_3.getHeight();
                for (int t = 0; t < height; ++t) {
                    curShift = shift[(t + 1) % 2];
                    g.setClip(0, 110 - height / 2 + t, 176, 1);
                    g.drawImage(this.logoImage_3, 88 - curShift, 110 - height / 2, 17);
                }
            }
        }

        final void drawLogo_2(Graphics g) {
            g.setClip(0, 0, 176, 220);
            g.setColor(0);
            g.fillRect(0, 0, 176, 220);
            int top1 = 110 - (this.logoImage_1.getHeight() + this.logoImage_2.getHeight() + 10) / 2;
            int top2 = top1 + this.logoImage_1.getHeight() + 10;
            if (!this.startLogoTimer) {
                g.drawImage(this.logoImage_1, 88, top1, 17);
                g.drawImage(this.logoImage_2, 88, top2, 17);
            } else {
                int t;
                int[] shift = new int[2];
                shift[0] = (20 - this.logoEnd) * 10;
                shift[1] = -shift[0];
                int curShift = 0;
                int width = this.logoImage_1.getWidth();
                int height = this.logoImage_1.getHeight();
                for (t = 0; t < height; ++t) {
                    curShift = shift[t % 2];
                    g.setClip(0, top1 + t, 176, 1);
                    g.drawImage(this.logoImage_1, 88 - curShift, top1, 17);
                }
                width = this.logoImage_2.getWidth();
                height = this.logoImage_2.getHeight();
                for (t = 0; t < height; ++t) {
                    curShift = shift[(t + 1) % 2];
                    g.setClip(0, top2 + t, 176, 1);
                    g.drawImage(this.logoImage_2, 88 - curShift, top2, 17);
                }
            }
        }

        final void drawLogo_3(Graphics g) {
            g.setClip(0, 0, 176, 220);
            g.setColor(0);
            g.fillRect(0, 0, 176, 220);
            g.drawImage(this.logoImage_4, 88, 110, 3);
        }

        final void drawLogin(Graphics g) {
            int menuTop;
            g.setClip(0, 0, 176, 220);
            g.setColor(2499093);
            g.fillRect(0, 0, 176, 220);
            int top = menuTop = 220 - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(5);
            int editWidth = 110;
            int w1 = 46;
            int shift = 25;
            Filler.fillWidthByImage(g, 0, top, 176, this.guiCP, 2);
            Filler.fillWidthByImage(g, 0, top += this.guiCP.GetHeight(2), 176, this.guiCP, 5);
            FontManagerEx.drawString(this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_EXIT, 5, top + this.guiCP.GetHeight(5) / 2 - FontManagerEx.getHeight(0) / 2, 20, 0);
            FontManagerEx.drawString(this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, 171, top + this.guiCP.GetHeight(5) / 2 - FontManagerEx.getHeight(0) / 2, 24, 0);
            Filler.fillWidthByImage(g, 0, top += this.guiCP.GetHeight(5), 176, this.guiCP, 3);
            int tabsBottom = 0;
            Filler.fillHeightByImage(g, 0, tabsBottom, menuTop, this.guiCP, 0);
            Filler.fillHeightByImage(g, 176 - this.guiCP.GetWidth(1), tabsBottom, menuTop, this.guiCP, 1);
            int left = 0 + this.guiCP.GetWidth(0);
            int right = 176 - this.guiCP.GetWidth(1);
            Filler.fillWidthByImage(g, left, 0, right, this.guiCP, 12);
            Filler.fillWidthByImage(g, left, menuTop - this.guiCP.GetHeight(12), right, this.guiCP, 12);
            top = 0 + shift;
            FontManagerEx.drawString(GameText.STR_TOOLBAR_LOGIN, 88, top, 17, 1);
            Filler.fillWidthByImage(g, left, top += 1 + FontManagerEx.getHeight(1), right, this.guiCP, 2);
            this.guiCP.Draw(g, 13, left, top += this.guiCP.GetHeight(2));
            this.guiCP.Draw(g, 14, right - this.guiCP.GetWidth(14), top);
            Filler.fillWidthByImage(g, left + this.guiCP.GetWidth(13), top, right - this.guiCP.GetWidth(14), this.guiCP, 5);
            this.drawEditBox(g, 88 - editWidth / 2, top, editWidth, this.listActiveElement == 0, this.login);
            Filler.fillWidthByImage(g, left, top += this.guiCP.GetHeight(13), right, this.guiCP, 3);
            FontManagerEx.drawString(GameText.STR_TOOLBAR_PASSWORD, 88, top += 5 + this.guiCP.GetHeight(3), 17, 1);
            Filler.fillWidthByImage(g, left, top += 1 + FontManagerEx.getHeight(1), right, this.guiCP, 2);
            this.guiCP.Draw(g, 13, left, top += this.guiCP.GetHeight(2));
            this.guiCP.Draw(g, 14, right - this.guiCP.GetWidth(14), top);
            Filler.fillWidthByImage(g, left + this.guiCP.GetWidth(13), top, right - this.guiCP.GetWidth(14), this.guiCP, 5);
            this.drawEditBox(g, 88 - editWidth / 2, top, editWidth, this.listActiveElement == 1, this.passwordMask);
            Filler.fillWidthByImage(g, left, top += this.guiCP.GetHeight(13), right, this.guiCP, 3);
            FontManagerEx.drawString(GameText.STR_TOOLBAR_LANGUAGE, 88, top += 5 + this.guiCP.GetHeight(3), 17, 1);
            int l1 = 88 - w1 / 2;
            int r1 = 88 + w1 / 2;
            this.guiCP.Draw(g, 22, l1 - 2 - this.guiCP.GetWidth(22) - this.guiCP.GetWidth(21), top += 1 + FontManagerEx.getHeight(1));
            this.guiCP.Draw(g, 23, r1 + 2 + this.guiCP.GetWidth(21), top);
            Filler.fillHeightByImage(g, l1 - this.guiCP.GetWidth(21), top, top + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(5), this.guiCP, 21);
            Filler.fillHeightByImage(g, r1, top, top + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(5), this.guiCP, 21);
            Filler.fillWidthByImage(g, l1, top, r1, this.guiCP, 2);
            Filler.fillWidthByImage(g, l1, top += this.guiCP.GetHeight(2), r1, this.guiCP, this.listActiveElement == 2 ? 5 : 4);
            FontManagerEx.drawString(this.languageNamesList[this.language], (l1 + r1) / 2, top + this.guiCP.GetHeight(5) / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            Filler.fillWidthByImage(g, l1, top += this.guiCP.GetHeight(5), r1, this.guiCP, 3);
            top += this.guiCP.GetHeight(3);
            FontManagerEx.drawString("v" + this.clientVersion, right - 5, menuTop - this.guiCP.GetHeight(12) - 5, 40);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawEditBox(Graphics g, int left, int top, int width, boolean active, String text) {
            int ind = active ? 18 : 15;
            this.guiCP.Draw(g, ind, left, top);
            int right = left + width - this.guiCP.GetWidth(ind + 1);
            this.guiCP.Draw(g, ind + 1, right, top);
            Filler.fillWidthByImage(g, left + this.guiCP.GetWidth(ind), top, right, this.guiCP, ind + 2);
            if (text != null) {
                Clipper.pushClip(g);
                g.setClip(left + this.guiCP.GetWidth(ind), top, width - this.guiCP.GetWidth(ind) - this.guiCP.GetWidth(ind + 1), this.guiCP.GetHeight(ind + 2));
                FontManagerEx.drawString(text, left + width / 2, top + this.guiCP.GetHeight(ind) / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
                Clipper.popClip(g);
            }
        }

        final void drawFilledBox(Graphics g, int left, int top, int width, String text, int color, int cur, int max) {
            int indact = color * 6;
            int ind = color * 6 + 3;
            this.statisticsGUICP.Draw(g, ind, left, top);
            int right = left + width - this.statisticsGUICP.GetWidth(ind + 2);
            this.statisticsGUICP.Draw(g, ind + 2, right, top);
            Filler.fillWidthByImage(g, left + this.statisticsGUICP.GetWidth(ind), top, right, this.statisticsGUICP, ind + 1);
            int fillerWidth = width * cur / max;
            int endFill = left + width - this.statisticsGUICP.GetWidth(indact + 2);
            if (fillerWidth > 0) {
                Clipper.pushClip(g);
                g.setClip(left, top, fillerWidth, this.statisticsGUICP.GetHeight(indact + 2));
                this.statisticsGUICP.Draw(g, indact, left, top);
                if (fillerWidth > this.statisticsGUICP.GetWidth(indact)) {
                    if (endFill < left + fillerWidth) {
                        Filler.fillWidthByImage(g, left + this.statisticsGUICP.GetWidth(indact), top, endFill, this.statisticsGUICP, indact + 1);
                        this.statisticsGUICP.Draw(g, indact + 2, endFill, top);
                    } else {
                        Filler.fillWidthByImage(g, left + this.statisticsGUICP.GetWidth(indact), top, left + fillerWidth, this.statisticsGUICP, indact + 1);
                    }
                }
                Clipper.popClip(g);
            }
            Clipper.pushClip(g);
            g.setClip(left + this.statisticsGUICP.GetWidth(ind), top, width - this.statisticsGUICP.GetWidth(ind) - this.statisticsGUICP.GetWidth(ind + 2), this.statisticsGUICP.GetHeight(ind + 1));
            FontManagerEx.drawString(text, left + width / 2, top + this.statisticsGUICP.GetHeight(ind) / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            Clipper.popClip(g);
        }

        final void drawRegistration1(Graphics g) {
            int menuTop;
            g.setClip(0, 0, 176, 220);
            g.setColor(2499093);
            g.fillRect(0, 0, 176, 220);
            int top = menuTop = 220 - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(5);
            int editWidth = 110;
            Filler.fillWidthByImage(g, 0, top, 176, this.guiCP, 2);
            Filler.fillWidthByImage(g, 0, top += this.guiCP.GetHeight(2), 176, this.guiCP, 5);
            FontManagerEx.drawString(GameText.STR_TOOLBAR_BACK, 5, top + this.guiCP.GetHeight(5) / 2 - FontManagerEx.getHeight(0) / 2, 20, 0);
            FontManagerEx.drawString(GameText.STR_TOOLBAR_GOON, 171, top + this.guiCP.GetHeight(5) / 2 - FontManagerEx.getHeight(0) / 2, 24, 0);
            Filler.fillWidthByImage(g, 0, top += this.guiCP.GetHeight(5), 176, this.guiCP, 3);
            int tabsBottom = 0;
            Filler.fillHeightByImage(g, 0, tabsBottom, menuTop, this.guiCP, 0);
            Filler.fillHeightByImage(g, 176 - this.guiCP.GetWidth(1), tabsBottom, menuTop, this.guiCP, 1);
            int left = 0 + this.guiCP.GetWidth(0);
            int right = 176 - this.guiCP.GetWidth(1);
            Filler.fillWidthByImage(g, left, 0, right, this.guiCP, 12);
            Filler.fillWidthByImage(g, left, menuTop - this.guiCP.GetHeight(12), right, this.guiCP, 12);
            top = 12;
            FontManagerEx.drawString(GameText.STR_TOOLBAR_NAME, 88, top, 17, 1);
            Filler.fillWidthByImage(g, left, top += 1 + FontManagerEx.getHeight(1), right, this.guiCP, 2);
            this.guiCP.Draw(g, 13, left, top += this.guiCP.GetHeight(2));
            this.guiCP.Draw(g, 14, right - this.guiCP.GetWidth(14), top);
            Filler.fillWidthByImage(g, left + this.guiCP.GetWidth(13), top, right - this.guiCP.GetWidth(14), this.guiCP, 5);
            this.drawEditBox(g, 88 - editWidth / 2, top, editWidth, this.listActiveElement == 0, this.nikname);
            Filler.fillWidthByImage(g, left, top += this.guiCP.GetHeight(13), right, this.guiCP, 3);
            FontManagerEx.drawString(GameText.STR_TOOLBAR_LOGIN, 88, top += 5 + this.guiCP.GetHeight(3), 17, 1);
            Filler.fillWidthByImage(g, left, top += 1 + FontManagerEx.getHeight(1), right, this.guiCP, 2);
            this.guiCP.Draw(g, 13, left, top += this.guiCP.GetHeight(2));
            this.guiCP.Draw(g, 14, right - this.guiCP.GetWidth(14), top);
            Filler.fillWidthByImage(g, left + this.guiCP.GetWidth(13), top, right - this.guiCP.GetWidth(14), this.guiCP, 5);
            this.drawEditBox(g, 88 - editWidth / 2, top, editWidth, this.listActiveElement == 1, this.login);
            Filler.fillWidthByImage(g, left, top += this.guiCP.GetHeight(13), right, this.guiCP, 3);
            FontManagerEx.drawString(GameText.STR_TOOLBAR_PASSWORD, 88, top += 5 + this.guiCP.GetHeight(3), 17, 1);
            Filler.fillWidthByImage(g, left, top += 1 + FontManagerEx.getHeight(1), right, this.guiCP, 2);
            this.guiCP.Draw(g, 13, left, top += this.guiCP.GetHeight(2));
            this.guiCP.Draw(g, 14, right - this.guiCP.GetWidth(14), top);
            Filler.fillWidthByImage(g, left + this.guiCP.GetWidth(13), top, right - this.guiCP.GetWidth(14), this.guiCP, 5);
            this.drawEditBox(g, 88 - editWidth / 2, top, editWidth, this.listActiveElement == 2, this.passwordMask);
            Filler.fillWidthByImage(g, left, top += this.guiCP.GetHeight(13), right, this.guiCP, 3);
            FontManagerEx.drawString(GameText.STR_TOOLBAR_PASSWORDREP, 88, top += 5 + this.guiCP.GetHeight(3), 17, 1);
            Filler.fillWidthByImage(g, left, top += 1 + FontManagerEx.getHeight(1), right, this.guiCP, 2);
            this.guiCP.Draw(g, 13, left, top += this.guiCP.GetHeight(2));
            this.guiCP.Draw(g, 14, right - this.guiCP.GetWidth(14), top);
            Filler.fillWidthByImage(g, left + this.guiCP.GetWidth(13), top, right - this.guiCP.GetWidth(14), this.guiCP, 5);
            this.drawEditBox(g, 88 - editWidth / 2, top, editWidth, this.listActiveElement == 3, this.passwordConfMask);
            Filler.fillWidthByImage(g, left, top += this.guiCP.GetHeight(13), right, this.guiCP, 3);
        }

        final void drawRegistration2(Graphics g) {
            int menuTop;
            g.setClip(0, 0, 176, 220);
            g.setColor(2499093);
            g.fillRect(0, 0, 176, 220);
            int top = menuTop = 220 - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(5);
            Filler.fillWidthByImage(g, 0, top, 176, this.guiCP, 2);
            Filler.fillWidthByImage(g, 0, top += this.guiCP.GetHeight(2), 176, this.guiCP, 5);
            FontManagerEx.drawString(GameText.STR_TOOLBAR_BACK, 5, top + this.guiCP.GetHeight(5) / 2 - FontManagerEx.getHeight(0) / 2, 20, 0);
            FontManagerEx.drawString(GameText.STR_TOOLBAR_GOON, 171, top + this.guiCP.GetHeight(5) / 2 - FontManagerEx.getHeight(0) / 2, 24, 0);
            Filler.fillWidthByImage(g, 0, top += this.guiCP.GetHeight(5), 176, this.guiCP, 3);
            int tabsBottom = 0;
            Filler.fillHeightByImage(g, 0, tabsBottom, menuTop, this.guiCP, 0);
            Filler.fillHeightByImage(g, 176 - this.guiCP.GetWidth(1), tabsBottom, menuTop, this.guiCP, 1);
            int left = 0 + this.guiCP.GetWidth(0);
            int right = 176 - this.guiCP.GetWidth(1);
            Filler.fillWidthByImage(g, left, 0, right, this.guiCP, 12);
            Filler.fillWidthByImage(g, left, menuTop - this.guiCP.GetHeight(12), right, this.guiCP, 12);
            top = 15;
            int l1 = left + 74;
            int r1 = l1 + 46;
            int shift = 5;
            if (this.fieldActiveElement == 0) {
                this.guiCP.Draw(g, 22, l1 - 2 - this.guiCP.GetWidth(22) - this.guiCP.GetWidth(21), top);
                this.guiCP.Draw(g, 23, r1 + 2 + this.guiCP.GetWidth(21), top);
            }
            Filler.fillHeightByImage(g, l1 - this.guiCP.GetWidth(21), top, top + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(5), this.guiCP, 21);
            Filler.fillHeightByImage(g, r1, top, top + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(5), this.guiCP, 21);
            Filler.fillWidthByImage(g, l1, top, r1, this.guiCP, 2);
            Filler.fillWidthByImage(g, l1, top += this.guiCP.GetHeight(2), r1, this.guiCP, this.fieldActiveElement == 0 ? 5 : 4);
            FontManagerEx.drawString(GameText.STR_TOOLBAR_RACE, (l1 + r1) / 2, top + this.guiCP.GetHeight(5) / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            Filler.fillWidthByImage(g, l1, top += this.guiCP.GetHeight(5), r1, this.guiCP, 3);
            top += this.guiCP.GetHeight(3);
            top += shift;
            if (this.fieldActiveElement == 1) {
                this.guiCP.Draw(g, 22, l1 - 2 - this.guiCP.GetWidth(22) - this.guiCP.GetWidth(21), top);
                this.guiCP.Draw(g, 23, r1 + 2 + this.guiCP.GetWidth(21), top);
            }
            Filler.fillHeightByImage(g, l1 - this.guiCP.GetWidth(21), top, top + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(5), this.guiCP, 21);
            Filler.fillHeightByImage(g, r1, top, top + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(5), this.guiCP, 21);
            Filler.fillWidthByImage(g, l1, top, r1, this.guiCP, 2);
            Filler.fillWidthByImage(g, l1, top += this.guiCP.GetHeight(2), r1, this.guiCP, this.fieldActiveElement == 1 ? 5 : 4);
            FontManagerEx.drawString(GameText.STR_TOOLBAR_SEX, (l1 + r1) / 2, top + this.guiCP.GetHeight(5) / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            Filler.fillWidthByImage(g, l1, top += this.guiCP.GetHeight(5), r1, this.guiCP, 3);
            top += this.guiCP.GetHeight(3);
            top += shift;
            if (this.fieldActiveElement == 2) {
                this.guiCP.Draw(g, 22, l1 - 2 - this.guiCP.GetWidth(22) - this.guiCP.GetWidth(21), top);
                this.guiCP.Draw(g, 23, r1 + 2 + this.guiCP.GetWidth(21), top);
            }
            Filler.fillHeightByImage(g, l1 - this.guiCP.GetWidth(21), top, top + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(5), this.guiCP, 21);
            Filler.fillHeightByImage(g, r1, top, top + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(5), this.guiCP, 21);
            Filler.fillWidthByImage(g, l1, top, r1, this.guiCP, 2);
            Filler.fillWidthByImage(g, l1, top += this.guiCP.GetHeight(2), r1, this.guiCP, this.fieldActiveElement == 2 ? 5 : 4);
            FontManagerEx.drawString(GameText.STR_TOOLBAR_HEAR, (l1 + r1) / 2, top + this.guiCP.GetHeight(5) / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            Filler.fillWidthByImage(g, l1, top += this.guiCP.GetHeight(5), r1, this.guiCP, 3);
            top += this.guiCP.GetHeight(3);
            top = 15;
            int persBot = top + 85;
            this.drawRect(g, 1, left + 5, top, 44, 88, 5987403);
            this.setClipFullSize(g);
            if (this.lastTimeAnim == 0L) {
                this.lastTimeAnim = Game.this.paintTimeCur;
            }
            int animInd = 0;
            int frameID = this.persAnim.getFrame(animInd, Game.this.paintTimeCur - this.lastTimeAnim, true);
            int anmFrame = this.persAnim.getAnimFrame(animInd, frameID);
            for (int i = 0; i < 4; ++i) {
                this.persAnim.DrawFrame(g, anmFrame + i, left - 10, persBot, 36);
                if (i != 1 || this.listActiveElement <= 0) continue;
                int anfFrm = anmFrame / 4;
                ((AnimationComplexPicture)this.hearAnimForSelect.elementAt(this.listActiveElement - 1)).DrawFrame(g, anfFrm, left - 10, persBot, 36);
            }
            g.drawImage(this.icones_races[this.typePers - 1], left + 10, persBot + 10, 20);
            FontManagerEx.setPage(left += 15 + this.icones_races[this.typePers - 1].getWidth(), persBot + 10, right - left - 10, 100);
            String str = "";
            str = this.typePers == 1 ? (this.isManPers ? GameText.STR_REGISTR_MAN_NORTH : GameText.STR_REGISTR_WOMAN_NORTH) : (this.isManPers ? GameText.STR_REGISTR_MAN_SOUTH : GameText.STR_REGISTR_WOMAN_SOUTH);
            FontManagerEx.drawPage(str, 0, 20, true);
        }

        final void drawGUIBorders(Graphics g, String leftLabel, String rightLabel) {
            this.drawGUIBorders(g, leftLabel, rightLabel, true);
        }

        final void drawGUIBorders(Graphics g, String leftLabel, String rightLabel, boolean showTowm) {
            this.drawGUIBorders(g, leftLabel, rightLabel, showTowm, true);
        }

        final void drawGUIBorders(Graphics g, String leftLabel, String rightLabel, boolean showTowm, boolean showTabs) {
            int menuTop;
            this.setClipFullSize(g);
            g.setColor(2499093);
            g.fillRect(0, 0, 176, 220);
            int top = menuTop = 220 - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(5);
            Filler.fillWidthByImage(g, 0, top, 176, this.guiCP, 2);
            Filler.fillWidthByImage(g, 0, top += this.guiCP.GetHeight(2), 176, this.guiCP, 5);
            if (leftLabel != null) {
                FontManagerEx.drawString(leftLabel, 5, top + this.guiCP.GetHeight(5) / 2 - FontManagerEx.getHeight(0) / 2, 20, 0);
            }
            if (rightLabel != null) {
                FontManagerEx.drawString(rightLabel, 171, top + this.guiCP.GetHeight(5) / 2 - FontManagerEx.getHeight(0) / 2, 24, 0);
            }
            Filler.fillWidthByImage(g, 0, top += this.guiCP.GetHeight(5), 176, this.guiCP, 3);
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT;
            Filler.fillWidthByImage(g, 0, tabsBottom, 176, this.guiCP, 2);
            Filler.fillWidthByImage(g, 0, tabsBottom += this.guiCP.GetHeight(2), 176, this.guiCP, 4);
            tabsBottom += this.guiCP.GetHeight(4);
            if (showTabs) {
                this.tabs.draw(g, 0, tabsBottom - this.tabs.getHeight(), 176);
            }
            Filler.fillWidthByImage(g, 0, tabsBottom, 176, this.guiCP, 3);
            Filler.fillHeightByImage(g, 0, tabsBottom += this.guiCP.GetHeight(3), menuTop, this.guiCP, 0);
            Filler.fillHeightByImage(g, 176 - this.guiCP.GetWidth(1), tabsBottom, menuTop, this.guiCP, 1);
        }

        final int getMoneyWidth(int money) {
            int price1 = this.getMoney1(money);
            int price2 = this.getMoney2(money);
            int price3 = this.getMoney3(money);
            int w = 0;
            int prc = price1;
            if (prc > 0) {
                w += 2 + FontManagerEx.stringWidth(0, "" + prc);
                w += 2 + this.coins[0].getWidth();
            }
            if ((prc = price2) > 0) {
                w += 2 + FontManagerEx.stringWidth(0, "" + prc);
                w += 2 + this.coins[1].getWidth();
            }
            if ((prc = price3) > 0) {
                w += 2 + FontManagerEx.stringWidth(0, "" + prc);
                w += this.coins[2].getWidth();
            }
            return w;
        }

        final void drawMoney(Graphics g, int money, int left, int top) {
            int price1 = this.getMoney1(money);
            int price2 = this.getMoney2(money);
            int price3 = this.getMoney3(money);
            int prc = price1;
            if (prc > 0) {
                FontManagerEx.drawString("" + price1, left, top, 20, 0);
                g.drawImage(this.coins[0], left += 2 + FontManagerEx.stringWidth(0, "" + prc), top + FontManagerEx.getHeight(0) / 2, 6);
                left += 2 + this.coins[0].getWidth();
            }
            if ((prc = price2) > 0) {
                FontManagerEx.drawString("" + price2, left, top, 20, 0);
                g.drawImage(this.coins[1], left += 2 + FontManagerEx.stringWidth(0, "" + prc), top + FontManagerEx.getHeight(0) / 2, 6);
                left += 2 + this.coins[1].getWidth();
            }
            if ((prc = price3) > 0) {
                FontManagerEx.drawString("" + price3, left, top, 20, 0);
                g.drawImage(this.coins[2], left += 2 + FontManagerEx.stringWidth(0, "" + prc), top + FontManagerEx.getHeight(0) / 2, 6);
            }
        }

        final void drawVectorScrollList(Graphics g, int Left, int Top, int Width, int Height, int Type2, int fontHeight, int textShift) {
            g.setClip(Left, Top, Width, Height);
            int top = Top + 2;
            g.setFont(this.fontSmall);
            if (this.SelectedItem > 0) {
                if (this.SelectedItem * fontHeight + this.ItemsShiftY > Height) {
                    this.ItemsShiftY = Height - this.SelectedItem * fontHeight;
                } else if ((this.SelectedItem - 1) * fontHeight + this.ItemsShiftY < 0) {
                    this.ItemsShiftY = -(this.SelectedItem - 1) * fontHeight;
                }
            }
            top += this.ItemsShiftY;
            int left = Left + this.guiCP.GetWidth(28) + 5;
            int width = Width - this.guiCP.GetWidth(28) * 2 - 10;
            int count = 0;
            switch (Type2) {
                case 1: {
                    count = this.BuildingsList.size();
                    break;
                }
                case 2: {
                    count = this.ClothesItemsList.size();
                    break;
                }
                case 3: {
                    count = this.ShopItemsList.size();
                    break;
                }
                case 4: {
                    count = this.SecondClothesItemsList.size();
                    break;
                }
                case 5: {
                    count = this.QuestsList.size();
                    break;
                }
                case 6: {
                    count = this.BeastsList.size();
                    break;
                }
                case 7: {
                    count = this.LocatesList.size();
                    break;
                }
                case 8: {
                    count = this.battleAliesList.size();
                    break;
                }
                case 9: {
                    count = this.battleEnemiesList.size();
                    break;
                }
                case 10: {
                    count = this.BattleLogList.size();
                    break;
                }
                case 11: {
                    count = this.GoodsItemsList.size();
                    break;
                }
                case 12: {
                    count = this.PresentsItemsList.size();
                    break;
                }
                case 13: {
                    count = this.RewardsItemsList.size();
                    break;
                }
                case 14: {
                    count = this.GiftsItemsList.size();
                    break;
                }
                case 15: {
                    count = this.battlesList.size();
                    break;
                }
                case 16: {
                    count = this.battleAliesList.size();
                    break;
                }
                case 17: {
                    count = this.battleEnemiesList.size();
                    break;
                }
                case 18: {
                    count = this.SettingsList.size();
                    break;
                }
                case 19: {
                    count = this.SMSList.size();
                    break;
                }
                case 20: {
                    count = this.MailsList.size();
                    break;
                }
                case 21: {
                    count = this.LocUsersList.size();
                }
            }
            for (int i = 0; i < count; ++i) {
                if (top + (i + 1) * fontHeight < Top) continue;
                if (top + i * fontHeight > Top + Height) break;
                int textLeftShift = 0;
                if (i + 1 == this.SelectedItem) {
                    this.guiCP.Draw(g, 24, left - this.guiCP.GetWidth(28) - 4, top + i * fontHeight - 2);
                    this.guiCP.Draw(g, 25, left - this.guiCP.GetWidth(28) - 4, top + (i + 1) * fontHeight - 2 - this.guiCP.GetHeight(25));
                    this.guiCP.Draw(g, 26, left + width, top + i * fontHeight - 2);
                    this.guiCP.Draw(g, 27, left + width, top + (i + 1) * fontHeight - 2 - this.guiCP.GetHeight(27));
                    Filler.fillHeightByImage(g, left - this.guiCP.GetWidth(28) - 4 + 1, top + i * fontHeight - 2 + this.guiCP.GetHeight(24), top + (i + 1) * fontHeight - 2 - this.guiCP.GetHeight(25), this.guiCP, 28);
                    Filler.fillHeightByImage(g, left + width + 2, top + i * fontHeight - 2 + this.guiCP.GetHeight(24), top + (i + 1) * fontHeight - 2 - this.guiCP.GetHeight(25), this.guiCP, 28);
                    int c = g.getColor();
                    g.setColor(8085556);
                    g.fillRect(left, top + i * fontHeight, width, fontHeight - 4);
                    g.setColor(c);
                }
                switch (Type2) {
                    case 1: {
                        Building building = (Building)this.BuildingsList.elementAt(i);
                        if (building.Image != null) {
                            g.drawImage(building.Image, left, top + i * fontHeight + fontHeight / 2 - 2, 6);
                        }
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            int x = building.Image != null ? building.Image.getWidth() + 2 : 0;
                            g.setClip(left + x, top + i * fontHeight, width - x, fontHeight - 4);
                            this.longTextMoveSolve1(building.Name, width - x, 0);
                            textLeftShift = this.label1XShift;
                        }
                        FontManagerEx.drawString(building.Name, (building.Image != null ? left + building.Image.getWidth() + 2 : left) + textLeftShift, top + i * fontHeight + textShift, 20, 0);
                        break;
                    }
                    case 2: {
                        InventoryItem ci = (InventoryItem)this.ClothesItemsList.elementAt(i);
                        if (ci.image != null) {
                            g.drawImage(ci.image, left, top + i * fontHeight + fontHeight / 2 - 2, 6);
                        }
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            int x = ci.image != null ? ci.image.getWidth() + 2 : 0;
                            g.setClip(left + x, top + i * fontHeight, width - x, fontHeight - 4);
                            this.longTextMoveSolve1(ci.name, width - x, 0);
                            textLeftShift = this.label1XShift;
                        }
                        FontManagerEx.drawString(ci.name, (ci.image != null ? left + ci.image.getWidth() + 2 : left) + textLeftShift, top + i * fontHeight + textShift, 20, ci.isDressed ? 1 : 0);
                        FontManagerEx.drawString("" + ci.curHealth + "/" + ci.maxHealth, ci.image != null ? left + ci.image.getWidth() + 2 : left, top + i * fontHeight + textShift + FontManagerEx.getHeight(0), 20, ci.isDressed ? 1 : 0);
                        break;
                    }
                    case 3: {
                        InventoryItem ci = (InventoryItem)this.ShopItemsList.elementAt(i);
                        if (ci.image != null) {
                            g.drawImage(ci.image, left, top + i * fontHeight + fontHeight / 2 - 2, 6);
                        }
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            int x = ci.image != null ? ci.image.getWidth() + 2 : 0;
                            g.setClip(left + x, top + i * fontHeight, width - x, fontHeight - 4);
                            this.longTextMoveSolve1(ci.name, width - x, 0);
                            textLeftShift = this.label1XShift;
                        }
                        int _left_ = ci.image != null ? left + ci.image.getWidth() + 2 : left;
                        FontManagerEx.drawString(ci.name, _left_ + textLeftShift, top + i * fontHeight + textShift, 20, 0);
                        int _top_ = top + i * fontHeight + textShift + FontManagerEx.getHeight(0);
                        this.drawMoney(g, ci.price, _left_, _top_);
                        break;
                    }
                    case 4: {
                        InventoryItem ci = (InventoryItem)this.SecondClothesItemsList.elementAt(i);
                        if (ci.image != null) {
                            g.drawImage(ci.image, left, top + i * fontHeight + fontHeight / 2 - 2, 6);
                        }
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            int x = ci.image != null ? ci.image.getWidth() + 2 : 0;
                            g.setClip(left + x, top + i * fontHeight, width - x, fontHeight - 4);
                            this.longTextMoveSolve1(ci.name, width - x, 0);
                            textLeftShift = this.label1XShift;
                        }
                        FontManagerEx.drawString(ci.name, (ci.image != null ? left + ci.image.getWidth() + 2 : left) + textLeftShift, top + i * fontHeight + textShift, 20, 0);
                        int _top_ = top + i * fontHeight + textShift + FontManagerEx.getHeight(0);
                        int _left_ = ci.image != null ? left + ci.image.getWidth() + 2 : left;
                        String str = "" + ci.curHealth + "/" + ci.maxHealth;
                        FontManagerEx.drawString(str, _left_, _top_, 20, 0);
                        int right = Left + Width - this.guiCP.GetWidth(28) * 2 - 10;
                        _left_ = right - 10 - this.coins[0].getWidth() - this.coins[1].getWidth() - this.coins[2].getWidth() - FontManagerEx.stringWidth(0, "" + this.getMoney1(ci.getSecondPrice())) - FontManagerEx.stringWidth(0, "" + this.getMoney2(ci.getSecondPrice())) - FontManagerEx.stringWidth(0, "" + this.getMoney3(ci.getSecondPrice()));
                        int prc = this.getMoney1(ci.getSecondPrice());
                        if (prc > 0) {
                            FontManagerEx.drawString("" + prc, _left_, _top_, 20, 0);
                            g.drawImage(this.coins[0], _left_ += 2 + FontManagerEx.stringWidth(0, "" + prc), _top_ + FontManagerEx.getHeight(0) / 2, 6);
                            _left_ += 2 + this.coins[0].getWidth();
                        }
                        if ((prc = this.getMoney2(ci.getSecondPrice())) > 0) {
                            FontManagerEx.drawString("" + prc, _left_, _top_, 20, 0);
                            g.drawImage(this.coins[1], _left_ += 2 + FontManagerEx.stringWidth(0, "" + prc), _top_ + FontManagerEx.getHeight(0) / 2, 6);
                            _left_ += 2 + this.coins[0].getWidth();
                        }
                        if ((prc = this.getMoney3(ci.getSecondPrice())) <= 0) break;
                        FontManagerEx.drawString("" + prc, _left_, _top_, 20, 0);
                        g.drawImage(this.coins[2], _left_ += 2 + FontManagerEx.stringWidth(0, "" + prc), _top_ + FontManagerEx.getHeight(0) / 2, 6);
                        break;
                    }
                    case 5: {
                        Quest q = (Quest)this.QuestsList.elementAt(i);
                        if (q.Type < this.QuestsIcones.length && this.QuestsIcones[q.Type] != null) {
                            g.drawImage(this.QuestsIcones[q.Type], left, top + i * fontHeight + fontHeight / 2 - 2, 6);
                        }
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            int x = q.Type < this.QuestsIcones.length && this.QuestsIcones[q.Type] != null ? this.QuestsIcones[q.Type].getWidth() + 2 : 0;
                            g.setClip(left + x, top + i * fontHeight, width - x, fontHeight - 4);
                            this.longTextMoveSolve1(q.Name, width - x, 0);
                            textLeftShift = this.label1XShift;
                        }
                        FontManagerEx.drawString(q.Name, (q.Type < this.QuestsIcones.length && this.QuestsIcones[q.Type] != null ? left + this.QuestsIcones[q.Type].getWidth() + 2 : left) + textLeftShift, top + i * fontHeight + textShift, 20, 0);
                        break;
                    }
                    case 6: {
                        Beast beast = (Beast)this.BeastsList.elementAt(i);
                        if (beast.Image != null) {
                            g.drawImage(beast.Image, left, top + i * fontHeight + fontHeight / 2 - 2, 6);
                        }
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            int x = beast.Image != null ? beast.Image.getWidth() + 2 : 0;
                            g.setClip(left + x, top + i * fontHeight, width - x, fontHeight - 4);
                            this.longTextMoveSolve1(beast.Name, width - x, 0);
                            textLeftShift = this.label1XShift;
                        }
                        FontManagerEx.drawString(beast.Name, (beast.Image != null ? left + beast.Image.getWidth() + 2 : left) + textLeftShift, top + i * fontHeight + textShift, 20, 0);
                        break;
                    }
                    case 7: {
                        Locate loc = (Locate)this.LocatesList.elementAt(i);
                        if (loc.Image != null) {
                            g.drawImage(loc.Image, left, top + i * fontHeight + fontHeight / 2 - 2, 6);
                        }
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            int x = loc.Image != null ? loc.Image.getWidth() + 2 : 0;
                            g.setClip(left + x, top + i * fontHeight, width - x, fontHeight - 4);
                            this.longTextMoveSolve1(loc.Name, width - x, 0);
                            textLeftShift = this.label1XShift;
                        }
                        FontManagerEx.drawString(loc.Name, (loc.Image != null ? left + loc.Image.getWidth() + 2 : left) + textLeftShift, top + i * fontHeight + textShift, 20, 0);
                        break;
                    }
                    case 8: {
                        int wdth;
                        Warrior warrior = (Warrior)this.battleAliesList.elementAt(i);
                        Image img = warrior.image;
                        if (img != null) {
                            g.drawImage(img, left, top + i * fontHeight + fontHeight / 2 - 2, 6);
                        }
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            int x = img != null ? img.getWidth() + 2 : 0;
                            g.setClip(left + x, top + i * fontHeight, width - x, fontHeight - 4);
                            this.longTextMoveSolve1(warrior.nik, width - x, 0);
                            textLeftShift = this.label1XShift;
                        }
                        int _left_ = (img != null ? left + img.getWidth() + 2 : left) + textLeftShift;
                        FontManagerEx.drawString(warrior.nik, _left_, top + i * fontHeight + textShift, 20, 0);
                        int healthWidth = (this.battleLocation.getWidth() - 6 - this.battleGUICP.GetWidth(4)) / 2 - this.battleGUICP.GetWidth(1) - this.battleGUICP.GetWidth(0);
                        int _top = top + i * fontHeight + textShift + FontManagerEx.getHeight(0);
                        int fillerTop = _top + FontManagerEx.getHeight(0) / 2 - this.battleGUICP.GetHeight(11) / 2;
                        Filler.fillWidthByImage(g, _left_, fillerTop, _left_ + healthWidth, this.battleGUICP, warrior.isPoisoned ? 11 : 7);
                        if (warrior.healthMax > 0 && warrior.healthCur > 0) {
                            wdth = healthWidth * warrior.healthCur / warrior.healthMax;
                            Filler.fillWidthByImage(g, _left_, fillerTop, _left_ + wdth, this.battleGUICP, warrior.isPoisoned ? 10 : 6);
                        }
                        FontManagerEx.drawString("" + warrior.healthCur + "/" + warrior.healthMax, _left_ + healthWidth / 2, _top, 17, 0);
                        break;
                    }
                    case 9: {
                        int wdth;
                        Warrior warrior = (Warrior)this.battleEnemiesList.elementAt(i);
                        Image img = warrior.image;
                        if (img != null) {
                            g.drawImage(img, left, top + i * fontHeight + fontHeight / 2 - 2, 6);
                        }
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            int x = img != null ? img.getWidth() + 2 : 0;
                            g.setClip(left + x, top + i * fontHeight, width - x, fontHeight - 4);
                            this.longTextMoveSolve1(warrior.nik, width - x, 0);
                            textLeftShift = this.label1XShift;
                        }
                        int _left_ = (img != null ? left + img.getWidth() + 2 : left) + textLeftShift;
                        FontManagerEx.drawString(warrior.nik, _left_, top + i * fontHeight + textShift, 20, 0);
                        int healthWidth = (this.battleLocation.getWidth() - 6 - this.battleGUICP.GetWidth(4)) / 2 - this.battleGUICP.GetWidth(1) - this.battleGUICP.GetWidth(0);
                        int _top = top + i * fontHeight + textShift + FontManagerEx.getHeight(0);
                        int fillerTop = _top + FontManagerEx.getHeight(0) / 2 - this.battleGUICP.GetHeight(11) / 2;
                        Filler.fillWidthByImage(g, _left_, fillerTop, _left_ + healthWidth, this.battleGUICP, warrior.isPoisoned ? 11 : 7);
                        if (warrior.healthMax > 0 && warrior.healthCur > 0) {
                            wdth = healthWidth * warrior.healthCur / warrior.healthMax;
                            Filler.fillWidthByImage(g, _left_, fillerTop, _left_ + wdth, this.battleGUICP, warrior.isPoisoned ? 10 : 6);
                        }
                        FontManagerEx.drawString("" + warrior.healthCur + "/" + warrior.healthMax, _left_ + healthWidth / 2, _top, 17, 0);
                        break;
                    }
                    case 10: {
                        BattlePunch bp = (BattlePunch)this.BattleLogList.elementAt(i);
                        Image img = null;
                        if (bp.punchType < this.battleLogImages.length && this.battleLogImages[bp.punchType] != null) {
                            img = this.battleLogImages[bp.punchType];
                            g.drawImage(img, left, top + i * fontHeight + fontHeight / 2 - 2, 6);
                        }
                        Warrior w = bp.player;
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            int x = img != null ? img.getWidth() + 2 : 0;
                            g.setClip(left + x, top + i * fontHeight, width - x, fontHeight - 4);
                            this.longTextMoveSolve1(w.nik, width - x, bp.isEnemy || w.id != this.playerId ? 1 : 0);
                            textLeftShift = this.label1XShift;
                        }
                        FontManagerEx.drawString(w.nik, (img != null ? left + img.getWidth() + 2 : left) + textLeftShift, top + i * fontHeight, 20, bp.isEnemy || w.id != this.playerId ? 1 : 0);
                        if (!bp.isSuperPunch) break;
                        int _left_ = img != null ? left + img.getWidth() + 2 : left;
                        int _top_ = top + i * fontHeight + FontManagerEx.getHeight(0);
                        FontManagerEx.drawString(GameText.STR_BATTLE_SUPER, _left_, _top_, 20, 0);
                        break;
                    }
                    case 11: {
                        InventoryItem item = (InventoryItem)this.GoodsItemsList.elementAt(i);
                        if (item.image != null) {
                            g.drawImage(item.image, left, top + i * fontHeight + fontHeight / 2 - 2, 6);
                        }
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            int x = item.image != null ? item.image.getWidth() + 2 : 0;
                            g.setClip(left + x, top + i * fontHeight, width - x, fontHeight - 4);
                            this.longTextMoveSolve1(item.name, width - x, 0);
                            textLeftShift = this.label1XShift;
                        }
                        FontManagerEx.drawString(item.name, (item.image != null ? left + item.image.getWidth() + 2 : left) + textLeftShift, top + i * fontHeight + textShift, 20, 0);
                        FontManagerEx.drawString("" + item.count + GameText.STR_TOOLBAR_COUNT, item.image != null ? left + item.image.getWidth() + 2 : left, top + i * fontHeight + textShift + FontManagerEx.getHeight(0), 20, 0);
                        break;
                    }
                    case 12: {
                        InventoryItem item = (InventoryItem)this.PresentsItemsList.elementAt(i);
                        if (item.image != null) {
                            g.drawImage(item.image, left, top + i * fontHeight + fontHeight / 2 - 2, 6);
                        }
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            int x = item.image != null ? item.image.getWidth() + 2 : 0;
                            g.setClip(left + x, top + i * fontHeight, width - x, fontHeight - 4);
                            this.longTextMoveSolve1(item.name, width - x, 0);
                            textLeftShift = this.label1XShift;
                        }
                        FontManagerEx.drawString(item.name, (item.image != null ? left + item.image.getWidth() + 2 : left) + textLeftShift, top + i * fontHeight + textShift, 20, 0);
                        break;
                    }
                    case 13: {
                        InventoryItem item = (InventoryItem)this.RewardsItemsList.elementAt(i);
                        if (item.image != null) {
                            g.drawImage(item.image, left, top + i * fontHeight + fontHeight / 2 - 2, 6);
                        }
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            int x = item.image != null ? item.image.getWidth() + 2 : 0;
                            g.setClip(left + x, top + i * fontHeight, width - x, fontHeight - 4);
                            this.longTextMoveSolve1(item.name, width - x, 0);
                            textLeftShift = this.label1XShift;
                        }
                        FontManagerEx.drawString(item.name, (item.image != null ? left + item.image.getWidth() + 2 : left) + textLeftShift, top + i * fontHeight + textShift, 20, 0);
                        break;
                    }
                    case 14: {
                        InventoryItem item = (InventoryItem)this.GiftsItemsList.elementAt(i);
                        if (item.image != null) {
                            g.drawImage(item.image, left, top + i * fontHeight + fontHeight / 2 - 2, 6);
                        }
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            int x = item.image != null ? item.image.getWidth() + 2 : 0;
                            g.setClip(left + x, top + i * fontHeight, width - x, fontHeight - 4);
                            this.longTextMoveSolve1(item.name, width - x, 0);
                            textLeftShift = this.label1XShift;
                        }
                        FontManagerEx.drawString(item.name, (item.image != null ? left + item.image.getWidth() + 2 : left) + textLeftShift, top + i * fontHeight + textShift, 20, 0);
                        break;
                    }
                    case 15: {
                        Battle battle = (Battle)this.battlesList.elementAt(i);
                        if (battle.image != null) {
                            g.drawImage(battle.image, left, top + i * fontHeight + fontHeight / 2 - 2, 6);
                        }
                        String str1 = GameText.STR_FROM + " " + battle.levelMin + " " + GameText.STR_TO + " " + battle.levelMax + " " + battle.teamCount + "x" + battle.teamCount;
                        String str2 = "" + battle.team1Count + " / " + battle.team2Count;
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            int x = battle.image != null ? battle.image.getWidth() + 2 : 0;
                            g.setClip(left + x, top + i * fontHeight, width - x, fontHeight - 4);
                            this.longTextMoveSolve1(str1, width - x, 0);
                            textLeftShift = this.label1XShift;
                        }
                        FontManagerEx.drawString(str1, (battle.image != null ? left + battle.image.getWidth() + 2 : left) + textLeftShift, top + i * fontHeight + textShift, 20, 0);
                        FontManagerEx.drawString(str2, battle.image != null ? left + battle.image.getWidth() + 2 : left, top + i * fontHeight + textShift + FontManagerEx.getHeight(0), 20, 0);
                        break;
                    }
                    case 16: {
                        Warrior warrior = (Warrior)this.battleAliesList.elementAt(i);
                        Image img = warrior.image;
                        if (img != null) {
                            g.drawImage(img, left, top + i * fontHeight + fontHeight / 2 - 2, 6);
                        }
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            int x = img != null ? img.getWidth() + 2 : 0;
                            g.setClip(left + x, top + i * fontHeight, width - x, fontHeight - 4);
                            this.longTextMoveSolve1(warrior.nik, width - x, 0);
                            textLeftShift = this.label1XShift;
                        }
                        int _left_ = (img != null ? left + img.getWidth() + 2 : left) + textLeftShift;
                        FontManagerEx.drawString(warrior.nik, _left_, top + i * fontHeight + textShift, 20, 0);
                        break;
                    }
                    case 17: {
                        Warrior warrior = (Warrior)this.battleEnemiesList.elementAt(i);
                        Image img = warrior.image;
                        if (img != null) {
                            g.drawImage(img, left, top + i * fontHeight + fontHeight / 2 - 2, 6);
                        }
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            int x = img != null ? img.getWidth() + 2 : 0;
                            g.setClip(left + x, top + i * fontHeight, width - x, fontHeight - 4);
                            this.longTextMoveSolve1(warrior.nik, width - x, 0);
                            textLeftShift = this.label1XShift;
                        }
                        int _left_ = (img != null ? left + img.getWidth() + 2 : left) + textLeftShift;
                        FontManagerEx.drawString(warrior.nik, _left_, top + i * fontHeight + textShift, 20, 0);
                        break;
                    }
                    case 18: {
                        String settingName = this.getSettingName(i);
                        String settingValue = this.getSettingValue(i);
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            int x = 0;
                            g.setClip(left + x, top + i * fontHeight, width - x, fontHeight - 4);
                            this.longTextMoveSolve1(settingName, width - x, 0);
                            textLeftShift = this.label1XShift;
                        }
                        int _left_ = left + textLeftShift;
                        FontManagerEx.drawString(settingName, _left_, top + i * fontHeight + textShift, 20, 0);
                        FontManagerEx.drawString(settingValue, _left_, top + i * fontHeight + textShift + FontManagerEx.getHeight(0), 20, 0);
                        break;
                    }
                    case 19: {
                        SMS sms = (SMS)this.SMSList.elementAt(i);
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            g.setClip(left, top + i * fontHeight, width, fontHeight - 4);
                            this.longTextMoveSolve1(sms.RealMoney, width, 0);
                            textLeftShift = this.label1XShift;
                        }
                        this.drawMoney(g, sms.GameMoney, left, top + i * fontHeight);
                        int _left_ = left + textLeftShift;
                        int _top_ = top + i * fontHeight + textShift + FontManagerEx.getHeight(0);
                        FontManagerEx.drawString(sms.RealMoney, _left_, _top_, 20, 0);
                        break;
                    }
                    case 20: {
                        Image img;
                        Mail mail = (Mail)this.MailsList.elementAt(i);
                        Image image = img = mail.Readed ? this.mailIcons[1] : this.mailIcons[0];
                        if (img != null) {
                            g.drawImage(img, left, top + i * fontHeight + fontHeight / 2 - 2, 6);
                        }
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            int x = img != null ? img.getWidth() + 2 : 0;
                            g.setClip(left + x, top + i * fontHeight, width - x, fontHeight - 4);
                            this.longTextMoveSolve1(mail.Sender, width - x, 0);
                            textLeftShift = this.label1XShift;
                        }
                        g.setColor(0xFFFFFF);
                        Font font = g.getFont();
                        int _left_ = (img != null ? left + img.getWidth() + 2 : left) + textLeftShift;
                        g.drawString(mail.Sender, _left_, top + i * fontHeight, 20);
                        g.drawString(mail.TimeStr, _left_, top + (i + 1) * fontHeight - font.getHeight() - 3, 20);
                        break;
                    }
                    case 21: {
                        User user = (User)this.LocUsersList.elementAt(i);
                        Object img = null;
                        String text = user.nik + "[" + user.level + "]";
                        if (i + 1 == this.SelectedItem) {
                            Clipper.pushClip(g);
                            int x = img != null ? img.getWidth() + 2 : 0;
                            g.setClip(left + x, top + i * fontHeight, width - x, fontHeight - 4);
                            this.longTextMoveSolve1(text, width - x, 0);
                            textLeftShift = this.label1XShift;
                        }
                        g.setColor(0xFFFFFF);
                        Font font = g.getFont();
                        int _left_ = (img != null ? left + img.getWidth() + 2 : left) + textLeftShift;
                        g.drawString(text, _left_, top + i * fontHeight, 20);
                    }
                }
                if (i + 1 != this.SelectedItem) continue;
                Clipper.popClip(g);
            }
            this.setClipFullSize(g);
            this.drawScroll(g, Top, 176 - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 3, Height, this.ItemsShiftY, Height, fontHeight * count);
        }

        final void drawLocation(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_EXIT, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            FontManagerEx.drawString(this.locationName, 88, 0 + Game.this.HEADER_HEIGHT / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            int persWidth = 0;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7 - persWidth;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = FontManagerEx.getHeight(0) * 2 + 4;
            int textShift = (fontHeight - 4) / 2 - FontManagerEx.getHeight(0) / 2;
            this.drawVectorScrollList(g, left, tabsBottom, w, h, 1, fontHeight, textShift);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawScroll(Graphics g, int top, int left, int height, int PagePos, int PageHeight, int TotalHeight) {
            this.guiCP.Draw(g, 29, left, top);
            Filler.fillHeightByImage(g, left + 1, top + this.guiCP.GetHeight(29), top + height - this.guiCP.GetHeight(30), this.guiCP, 28);
            this.guiCP.Draw(g, 30, left, top + height - this.guiCP.GetHeight(30));
            int scrollHeight = height - this.guiCP.GetHeight(29) - this.guiCP.GetHeight(30) - this.guiCP.GetHeight(31) - this.guiCP.GetHeight(32) - this.guiCP.GetHeight(33);
            int ScrollPos = 0;
            if (TotalHeight != PageHeight) {
                ScrollPos = -PagePos * scrollHeight / (TotalHeight - PageHeight);
            }
            this.guiCP.Draw(g, 31, left - 1, top += this.guiCP.GetHeight(29) + ScrollPos);
            this.guiCP.Draw(g, 33, left - 1, top += this.guiCP.GetHeight(31));
            this.guiCP.Draw(g, 32, left - 1, top += this.guiCP.GetHeight(33));
        }

        final void drawChat(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_WRITE, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            FontManagerEx.drawString(GameText.STR_CHAT_ONLINE + this.chat.usersCount(), 88, 0 + Game.this.HEADER_HEIGHT / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            g.setColor(0xAAAAAA);
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1;
            this.chat.draw(g, left, tabsBottom, this.fontSmall, this.fontSmallNormal);
            this.setClipFullSize(g);
            this.drawScroll(g, tabsBottom, 176 - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 3, this.chat.getScreenH(), this.chat.getPagePos(), this.chat.getScreenH(), this.chat.getPageH());
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawChatUsers(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_BACK, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            FontManagerEx.drawString(GameText.STR_CHAT_ONLINE + this.chat.usersCount(), 88, 0 + Game.this.HEADER_HEIGHT / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            g.setColor(0xFFFFFF);
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1;
            g.setClip(left, tabsBottom, this.chat.getScreenW(), this.chat.getScreenH());
            int top = tabsBottom + 2;
            g.setFont(this.fontSmall);
            int fontHeight = this.fontSmall.getHeight() + 4;
            if (this.chat.SelectedUserNum * fontHeight + this.chat.chatUsersShiftY > this.chat.getScreenH()) {
                this.chat.chatUsersShiftY = this.chat.getScreenH() - this.chat.SelectedUserNum * fontHeight;
            } else if ((this.chat.SelectedUserNum - 1) * fontHeight + this.chat.chatUsersShiftY < 0) {
                this.chat.chatUsersShiftY = -(this.chat.SelectedUserNum - 1) * fontHeight;
            }
            top += this.chat.chatUsersShiftY;
            left += this.guiCP.GetWidth(28) + 5;
            int width = this.chat.getScreenW() - this.guiCP.GetWidth(28) * 2 - 10;
            for (int i = 0; i < this.chat.chatUsersList.size(); ++i) {
                if (top + (i + 1) * fontHeight < tabsBottom) continue;
                if (top + i * fontHeight > tabsBottom + this.chat.getScreenH()) break;
                Chat.ChatUser cu = (Chat.ChatUser)this.chat.chatUsersList.elementAt(i);
                if (i + 1 == this.chat.SelectedUserNum) {
                    this.guiCP.Draw(g, 24, left - this.guiCP.GetWidth(28) - 4, top + i * fontHeight - 2);
                    this.guiCP.Draw(g, 25, left - this.guiCP.GetWidth(28) - 4, top + (i + 1) * fontHeight - 2 - this.guiCP.GetHeight(25));
                    this.guiCP.Draw(g, 26, left + width, top + i * fontHeight - 2);
                    this.guiCP.Draw(g, 27, left + width, top + (i + 1) * fontHeight - 2 - this.guiCP.GetHeight(27));
                    Filler.fillHeightByImage(g, left - this.guiCP.GetWidth(28) - 4 + 1, top + i * fontHeight - 2 + this.guiCP.GetHeight(24), top + (i + 1) * fontHeight - 2 - this.guiCP.GetHeight(25), this.guiCP, 28);
                    Filler.fillHeightByImage(g, left + width + 2, top + i * fontHeight - 2 + this.guiCP.GetHeight(24), top + (i + 1) * fontHeight - 2 - this.guiCP.GetHeight(25), this.guiCP, 28);
                    int c = g.getColor();
                    g.setColor(8085556);
                    g.fillRect(left, top + i * fontHeight, width, fontHeight - 4);
                    g.setColor(c);
                }
                g.drawString(cu.Name + '[' + cu.level + ']', left, top + i * fontHeight, 20);
            }
            this.setClipFullSize(g);
            this.drawScroll(g, tabsBottom, 176 - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 3, this.chat.getScreenH(), this.chat.chatUsersShiftY, this.chat.getScreenH(), fontHeight * this.chat.chatUsersList.size());
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawInventarClothes(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_OK, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            FontManagerEx.drawString("" + (this.ClothesItemsList.size() - this.dressedClothes) + "/" + this.max_clothes_count, 88, 0 + Game.this.HEADER_HEIGHT / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 64;
            int menuTop = 220 - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(5);
            Filler.fillHeightByImage(g, 70, tabsBottom, menuTop, this.guiCP, 21);
            if (this.lastTimeAnim == 0L) {
                this.lastTimeAnim = Game.this.paintTimeCur;
            }
            int animInd = this.curAnim;
            int frameID = -1;
            frameID = this.curAnim == 0 || this.curAnim == 7 || this.curAnim == 8 || this.curAnim == 15 ? this.persAnim.getFrame(animInd, Game.this.paintTimeCur - this.lastTimeAnim, true) : this.persAnim.getFrame(animInd, Game.this.paintTimeCur - this.lastTimeAnim, false);
            if (frameID < 0) {
                this.curAnim = this.withWeapon * 8;
                this.lastTimeAnim = Game.this.paintTimeCur;
                animInd = this.curAnim;
                frameID = this.persAnim.getFrame(animInd, Game.this.paintTimeCur - this.lastTimeAnim, true);
            }
            int anmFrame = this.persAnim.getAnimFrame(animInd, frameID);
            left = 0 + this.guiCP.GetWidth(0);
            int right = 176 - this.guiCP.GetWidth(1);
            int persAnimTop = 153;
            int persAnimLeft = left - 10;
            for (int i = 0; i < 4; ++i) {
                if (this.shieldAnim != null) {
                    this.shieldAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                if (this.swordAnim != null) {
                    this.swordAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                this.persAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                if (i == 1 && this.hearAnim != null) {
                    int anfFrm = anmFrame / 4;
                    if (this.helmetAnim == null) {
                        this.hearAnim.DrawFrame(g, anfFrm, persAnimLeft, persAnimTop, 36);
                    }
                }
                if (this.armedAnim != null) {
                    this.armedAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                if (this.shoulderAnim != null) {
                    this.shoulderAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                if (this.breastplateAnim != null) {
                    this.breastplateAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                if (this.helmetAnim != null) {
                    this.helmetAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                if (this.legedAnim != null) {
                    this.legedAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                if (this.bootAnim == null) continue;
                this.bootAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
            }
            int persWidth = 60;
            left = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7 - persWidth;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = FontManagerEx.getHeight(0) * 2 + 4;
            int textShift = -1;
            this.drawVectorScrollList(g, left, tabsBottom, w, h, 2, fontHeight, textShift);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawInventarGoods(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_OK, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            FontManagerEx.drawString("" + this.GoodsItemsList.size() + "/" + this.max_goods_count, 88, 0 + Game.this.HEADER_HEIGHT / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            int persWidth = 0;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7 - persWidth;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = FontManagerEx.getHeight(0) * 2 + 4;
            int textShift = -1;
            this.drawVectorScrollList(g, left, tabsBottom, w, h, 11, fontHeight, textShift);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawInventarPresents(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_OK, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            int persWidth = 0;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7 - persWidth;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = FontManagerEx.getHeight(0) * 2 + 4;
            int textShift = -1;
            this.drawVectorScrollList(g, left, tabsBottom, w, h, 12, fontHeight, textShift);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawRoom(Graphics g) {
            switch (this.inventarState) {
                case 1: {
                    this.drawInventarClothes(g);
                    break;
                }
                case 2: {
                    this.drawInventarGoods(g);
                    break;
                }
                case 3: {
                    this.drawInventarPresents(g);
                }
            }
        }

        final void drawShop(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_BACK, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false);
            int l = this.getMoneyWidth(this.money);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            this.drawMoney(g, this.money, 88 - l / 2, 0 + Game.this.HEADER_HEIGHT / 2 - FontManagerEx.getHeight(0) / 2);
            int persWidth = 0;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7 - persWidth;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = FontManagerEx.getHeight(0) * 2 + 4;
            int textShift = -1;
            this.drawVectorScrollList(g, left, tabsBottom, w, h, 3, fontHeight, textShift);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawSecondHand(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_BACK, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false, false);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            FontManagerEx.drawString(this.curBuilding.Name, 88, 0 + Game.this.HEADER_HEIGHT / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            int persWidth = 0;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7 - persWidth;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = FontManagerEx.getHeight(0) * 2 + 4;
            int textShift = -1;
            this.drawVectorScrollList(g, left, tabsBottom, w, h, 4, fontHeight, textShift);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawQuests(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_OK, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            int persWidth = 0;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7 - persWidth;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = FontManagerEx.getHeight(0) * 2 + 4;
            int textShift = (fontHeight - 4) / 2 - FontManagerEx.getHeight(0) / 2;
            this.drawVectorScrollList(g, left, tabsBottom, w, h, 5, fontHeight, textShift);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawBeasts(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_BACK, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false, false);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            FontManagerEx.drawString(this.curBuilding.Name, 88, 0 + Game.this.HEADER_HEIGHT / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            int persWidth = 0;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7 - persWidth;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = FontManagerEx.getHeight(0) * 2 + 4;
            int textShift = (fontHeight - 4) / 2 - FontManagerEx.getHeight(0) / 2;
            this.drawVectorScrollList(g, left, tabsBottom, w, h, 6, fontHeight, textShift);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawHealth(Graphics g, int left, int top, int width, int total, int current, int color) {
            this.battleGUICP.Draw(g, 0, left, top, 20);
            this.battleGUICP.Draw(g, 1, left + width - this.battleGUICP.GetWidth(0), top, 20);
            Filler.fillWidthByImage(g, left + this.battleGUICP.GetWidth(0), top, left + width - this.battleGUICP.GetWidth(1), this.battleGUICP, 2);
            Filler.fillWidthByImage(g, left + this.battleGUICP.GetWidth(0), top + this.battleGUICP.GetHeight(0) - this.battleGUICP.GetHeight(3), left + width - this.battleGUICP.GetWidth(1), this.battleGUICP, 3);
            Filler.fillWidthByImage(g, left + this.battleGUICP.GetWidth(0), top + this.battleGUICP.GetHeight(2), left + width - this.battleGUICP.GetWidth(1), this.battleGUICP, 7 + color * 2);
            if (total > 0 && current > 0) {
                int wdth = (width - this.battleGUICP.GetWidth(1) - this.battleGUICP.GetWidth(0)) * current / total;
                Filler.fillWidthByImage(g, left + this.battleGUICP.GetWidth(0), top + this.battleGUICP.GetHeight(2), left + this.battleGUICP.GetWidth(0) + wdth, this.battleGUICP, 6 + color * 2);
            }
        }

        final void drawBattleStepTimer(Graphics g) {
            long cTime = System.currentTimeMillis();
            long outTime = cTime - this.inBattleStepTime > 30000L ? 0L : 30000L - cTime + this.inBattleStepTime;
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            if (this.battleState == 1 && outTime > 0L) {
                FontManagerEx.drawString("" + (outTime + 999L) / 1000L, 88, 0 + Game.this.HEADER_HEIGHT / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
                g.setColor(0xFF0000);
                g.fillRect(0 + this.guiCP.GetWidth(21) + 2, 0 + Game.this.HEADER_HEIGHT / 2 - FontManagerEx.getHeight(0) / 2 + FontManagerEx.getHeight(0) + 1, (176 - this.guiCP.GetWidth(21) * 2 - 4) * (int)outTime / 30000, 4);
            }
        }

        final void drawBattleAction(Graphics g) {
            int leftForLoc;
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_BACK, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_ACTION, false);
            this.drawBattleStepTimer(g);
            int topForLoc = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int clipX = leftForLoc = 0 + this.guiCP.GetWidth(0);
            int clipY = topForLoc;
            int clipW = this.battleLocation.getWidth();
            int clipH = this.battleLocation.getHeight();
            g.drawImage(this.battleLocation, leftForLoc, topForLoc, 20);
            g.setClip(clipX, clipY, clipW, 220 - clipY);
            Filler.fillWidthByImage(g, leftForLoc, topForLoc += this.battleLocation.getHeight(), leftForLoc + this.battleLocation.getWidth(), this.guiCP, 12);
            int leftNameX = leftForLoc + this.battleLocation.getWidth() / 4;
            int rightNameX = leftForLoc + 3 * this.battleLocation.getWidth() / 4;
            FontManagerEx.drawString(this.nikname, leftNameX, topForLoc += this.guiCP.GetHeight(12), 17, 0);
            if (this.curEnemy != null) {
                FontManagerEx.drawString(this.curEnemy.nik, rightNameX, topForLoc, 17, 0);
            }
            int healthWidth = (this.battleLocation.getWidth() - 6 - this.battleGUICP.GetWidth(4)) / 2;
            leftForLoc = 0 + this.guiCP.GetWidth(0) + 1;
            int rightForLoc = 176 - this.guiCP.GetWidth(1) - 1;
            this.drawHealth(g, leftForLoc, topForLoc += FontManagerEx.getHeight(0), healthWidth, this.healthMax + this.healthBonus, this.healthCur, this.isPoisoned ? 2 : 0);
            FontManagerEx.drawString("" + this.healthCur + "/" + (this.healthMax + this.healthBonus), leftForLoc + healthWidth / 2, topForLoc, 17, 0);
            if (this.curEnemy != null) {
                this.drawHealth(g, rightForLoc - healthWidth, topForLoc, healthWidth, this.healthMaxBeast, this.healthCurBeast, this.isPoisonedBeast ? 2 : 0);
                FontManagerEx.drawString("" + this.healthCurBeast + "/" + this.healthMaxBeast, rightForLoc - healthWidth / 2, topForLoc, 17, 0);
            }
            this.battleGUICP.Draw(g, 4, 88, topForLoc + this.battleGUICP.GetHeight(0) / 2, 3);
            this.drawHealth(g, leftForLoc, topForLoc += this.battleGUICP.GetHeight(0) + 2, healthWidth, this.manaMax, this.manaCur, 1);
            FontManagerEx.drawString("" + this.manaCur + "/" + this.manaMax, leftForLoc + healthWidth / 2, topForLoc, 17, 0);
            this.battleGUICP.Draw(g, 5, 88, topForLoc + this.battleGUICP.GetHeight(0) / 2, 3);
            g.setClip(clipX, clipY, clipW, clipH);
            if (this.lastTimeAnim == 0L) {
                this.lastTimeAnim = Game.this.paintTimeCur;
            }
            int animInd = this.curAnim;
            int frameID = -1;
            frameID = this.curAnim == 0 || this.curAnim == 7 || this.curAnim == 8 || this.curAnim == 15 ? this.persAnim.getFrame(animInd, Game.this.paintTimeCur - this.lastTimeAnim, true) : this.persAnim.getFrame(animInd, Game.this.paintTimeCur - this.lastTimeAnim, false);
            if (frameID < 0) {
                if (this.curAnim == 6 || this.curAnim == 14) {
                    this.damageDraw = 0;
                    if (this.healthCur <= 0) {
                        this.curAnim = 7 + this.withWeapon * 8;
                        this.healthCur = 0;
                    } else {
                        this.curAnim = this.withWeapon * 8;
                    }
                } else {
                    this.curAnim = this.withWeapon * 8;
                }
                this.lastTimeAnim = Game.this.paintTimeCur;
                animInd = this.curAnim;
                frameID = this.persAnim.getFrame(animInd, Game.this.paintTimeCur - this.lastTimeAnim, true);
                this.playerEnd = true;
            }
            int anmFrame = this.persAnim.getAnimFrame(animInd, frameID);
            int left = 0 + this.guiCP.GetWidth(0);
            int right = 176 - this.guiCP.GetWidth(1);
            int persAnimLeft = left - 10;
            int persAnimTop = 114 + Game.this.HEADER_HEIGHT;
            for (int i = 0; i < 4; ++i) {
                if (this.shieldAnim != null) {
                    this.shieldAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                if (this.swordAnim != null) {
                    this.swordAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                this.persAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                if (i == 1 && this.hearAnim != null) {
                    int anfFrm = anmFrame / 4;
                    if (this.helmetAnim == null) {
                        this.hearAnim.DrawFrame(g, anfFrm, persAnimLeft, persAnimTop, 36);
                    }
                }
                if (this.armedAnim != null) {
                    this.armedAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                if (this.shoulderAnim != null) {
                    this.shoulderAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                if (this.breastplateAnim != null) {
                    this.breastplateAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                if (this.helmetAnim != null) {
                    this.helmetAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                if (this.legedAnim != null) {
                    this.legedAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                if (this.bootAnim == null) continue;
                this.bootAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
            }
            if (this.isSuperPunch) {
                int _anfFrm = anmFrame / 4;
                if (this.isManPers) {
                    this.battleSuperPunch.DrawFrame(g, _anfFrm, persAnimLeft, persAnimTop, 36);
                } else {
                    this.battleSuperPunch.DrawFrame(g, _anfFrm, persAnimLeft, persAnimTop, 36, this.battleSuperPunchWoman);
                }
            }
            int leftBeast = 0 + this.guiCP.GetWidth(0);
            int rightBeast = 176 - this.guiCP.GetWidth(1);
            int BeastAnimRight = rightBeast + 10;
            int BeastAnimTop = 114 + Game.this.HEADER_HEIGHT;
            if (this.lastTimeAnimBeast == 0L) {
                this.lastTimeAnimBeast = Game.this.paintTimeCur;
            }
            int animIndBeast = this.curAnimBeast;
            int frameIDBeast = -1;
            int anmFrameBeast = -1;
            if (this.showEnemy && this.beastAnim != null) {
                frameIDBeast = this.curAnimBeast == 0 || this.curAnimBeast == 7 || this.curAnimBeast == 8 || this.curAnimBeast == 15 ? this.beastAnim.getFrame(animIndBeast, Game.this.paintTimeCur - this.lastTimeAnimBeast, true) : this.beastAnim.getFrame(animIndBeast, Game.this.paintTimeCur - this.lastTimeAnimBeast, false);
                if (frameIDBeast < 0) {
                    if (this.curAnimBeast == 6 || this.curAnimBeast == 14) {
                        this.damageDraw = 0;
                        if (this.healthCurBeast <= 0) {
                            this.curAnimBeast = 7 + this.withWeaponBeast * 8;
                            this.healthCurBeast = 0;
                        } else {
                            this.curAnimBeast = this.withWeaponBeast * 8;
                        }
                    } else {
                        this.curAnimBeast = this.withWeaponBeast * 8;
                    }
                    this.lastTimeAnimBeast = Game.this.paintTimeCur;
                    animIndBeast = this.curAnimBeast;
                    frameIDBeast = this.beastAnim.getFrame(animIndBeast, Game.this.paintTimeCur - this.lastTimeAnimBeast, true);
                    this.enemyEnd = true;
                }
                anmFrameBeast = this.beastAnim.getAnimFrame(animIndBeast, frameIDBeast);
                for (int i = 0; i < 4; ++i) {
                    if (this.shieldAnimBeast != null) {
                        this.shieldAnimBeast.DrawFrame(g, anmFrameBeast + i, BeastAnimRight, BeastAnimTop, 36, 2);
                    }
                    if (this.swordAnimBeast != null) {
                        this.swordAnimBeast.DrawFrame(g, anmFrameBeast + i, BeastAnimRight, BeastAnimTop, 36, 2);
                    }
                    this.beastAnim.DrawFrame(g, anmFrameBeast + i, BeastAnimRight, BeastAnimTop, 36, 2);
                    if (i == 1 && this.hearAnimBeast != null) {
                        int anfFrm = anmFrameBeast / 4;
                        if (this.helmetAnimBeast == null) {
                            this.hearAnimBeast.DrawFrame(g, anfFrm, BeastAnimRight, BeastAnimTop, 36, 2);
                        }
                    }
                    if (this.armedAnimBeast != null) {
                        this.armedAnimBeast.DrawFrame(g, anmFrameBeast + i, BeastAnimRight, BeastAnimTop, 36, 2);
                    }
                    if (this.shoulderAnimBeast != null) {
                        this.shoulderAnimBeast.DrawFrame(g, anmFrameBeast + i, BeastAnimRight, BeastAnimTop, 36, 2);
                    }
                    if (this.breastplateAnimBeast != null) {
                        this.breastplateAnimBeast.DrawFrame(g, anmFrameBeast + i, BeastAnimRight, BeastAnimTop, 36, 2);
                    }
                    if (this.helmetAnimBeast != null) {
                        this.helmetAnimBeast.DrawFrame(g, anmFrameBeast + i, BeastAnimRight, BeastAnimTop, 36, 2);
                    }
                    if (this.legedAnimBeast != null) {
                        this.legedAnimBeast.DrawFrame(g, anmFrameBeast + i, BeastAnimRight, BeastAnimTop, 36, 2);
                    }
                    if (this.bootAnimBeast == null) continue;
                    this.bootAnimBeast.DrawFrame(g, anmFrameBeast + i, BeastAnimRight, BeastAnimTop, 36, 2);
                }
            }
            if (this.isSuperPunchBeast) {
                int _anfFrm = anmFrameBeast / 4;
                if (this.isManPersBeast) {
                    this.battleSuperPunch.DrawFrame(g, _anfFrm, BeastAnimRight, BeastAnimTop, 36, 2);
                } else {
                    this.battleSuperPunch.DrawFrame(g, _anfFrm, BeastAnimRight, BeastAnimTop, 36, 2, this.battleSuperPunchWoman);
                }
            }
            g.setClip(clipX, clipY, clipW, clipH);
            if (this.battleState == 3) {
                if (this.isPlayeredTurn) {
                    if (this.playerEnd) {
                        this.damageDraw = 0;
                    }
                    if (this.damageDraw != 0 && Game.this.paintTimeCur - this.lastTimeAnimBeast > 100L) {
                        FontManagerEx.drawString("" + this.damageDraw, BeastAnimRight - 50, BeastAnimTop - 50 - (int)((Game.this.paintTimeCur - this.lastTimeAnimBeast) / 10L), 33, 3);
                    }
                } else {
                    if (this.enemyEnd) {
                        this.damageDraw = 0;
                    }
                    if (this.damageDraw != 0 && Game.this.paintTimeCur - this.lastTimeAnim > 100L) {
                        FontManagerEx.drawString("" + this.damageDraw, persAnimLeft + 50, persAnimTop - 50 - (int)((Game.this.paintTimeCur - this.lastTimeAnim) / 10L), 33, 3);
                    }
                }
                if (this.playerEnd && this.enemyEnd) {
                    if (!this.isBattleOver) {
                        this.showEnemy = false;
                        if (this.battleStepPrepearedState >= 2) {
                            this.initBattleStep();
                            this.battleStepPrepearedState = 0;
                        } else {
                            if (this.curAnim == 7 + this.withWeapon * 8 && this.beastAnim != null) {
                                this.beastAnim = null;
                            }
                            this.battleState = 2;
                        }
                    } else {
                        this.initBattleEnd();
                    }
                }
            }
            if (!this.isBattleOver && this.battleState == 1) {
                this.battleSelecter.DrawFrame(g, this.battleSelecterIndex, 88, persAnimTop - 50, 3);
            }
            if (this.menu.Active) {
                this.setClipFullSize(g);
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawBattleAlies(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_BACK, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false);
            this.drawBattleStepTimer(g);
            int persWidth = 0;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7 - persWidth;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = FontManagerEx.getHeight(0) * 2 + 4;
            int textShift = -1;
            this.drawVectorScrollList(g, left, tabsBottom, w, h, 8, fontHeight, textShift);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawBattleEnemies(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_BACK, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false);
            this.drawBattleStepTimer(g);
            int persWidth = 0;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7 - persWidth;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = FontManagerEx.getHeight(0) * 2 + 4;
            int textShift = -1;
            this.drawVectorScrollList(g, left, tabsBottom, w, h, 9, fontHeight, textShift);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawBattleLog(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_BACK, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false);
            this.drawBattleStepTimer(g);
            int persWidth = 0;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7 - persWidth;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = FontManagerEx.getHeight(0) * 2 + 4;
            int textShift = (fontHeight - 4) / 2 - FontManagerEx.getHeight(0) / 2;
            this.drawVectorScrollList(g, left, tabsBottom, w, h, 10, fontHeight, textShift);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawBattle(Graphics g) {
            if (this.battleActionState != 0) {
                if (this.lastTimeAnim == 0L) {
                    this.lastTimeAnim = Game.this.paintTimeCur;
                }
                int animInd = this.curAnim;
                int frameID = -1;
                frameID = this.curAnim == 0 || this.curAnim == 7 || this.curAnim == 8 || this.curAnim == 15 ? this.persAnim.getFrame(animInd, Game.this.paintTimeCur - this.lastTimeAnim, true) : this.persAnim.getFrame(animInd, Game.this.paintTimeCur - this.lastTimeAnim, false);
                if (frameID < 0) {
                    if (this.curAnim == 6 || this.curAnim == 14) {
                        this.damageDraw = 0;
                    }
                    this.curAnim = this.withWeapon * 8;
                    this.lastTimeAnim = Game.this.paintTimeCur;
                    animInd = this.curAnim;
                    frameID = this.persAnim.getFrame(animInd, Game.this.paintTimeCur - this.lastTimeAnim, true);
                    this.playerEnd = true;
                }
                if (this.lastTimeAnimBeast == 0L) {
                    this.lastTimeAnimBeast = Game.this.paintTimeCur;
                }
                int animIndBeast = this.curAnimBeast;
                int frameIDBeast = -1;
                if (this.beastAnim != null && (frameIDBeast = this.curAnimBeast == 0 || this.curAnimBeast == 7 || this.curAnimBeast == 8 || this.curAnimBeast == 15 ? this.beastAnim.getFrame(animIndBeast, Game.this.paintTimeCur - this.lastTimeAnimBeast, true) : this.beastAnim.getFrame(animIndBeast, Game.this.paintTimeCur - this.lastTimeAnimBeast, false)) < 0) {
                    if (this.curAnimBeast == 6 || this.curAnimBeast == 14) {
                        this.damageDraw = 0;
                    }
                    this.curAnimBeast = this.withWeaponBeast * 8;
                    this.lastTimeAnimBeast = Game.this.paintTimeCur;
                    animIndBeast = this.curAnimBeast;
                    frameIDBeast = this.beastAnim.getFrame(animIndBeast, Game.this.paintTimeCur - this.lastTimeAnimBeast, true);
                    this.enemyEnd = true;
                }
                if (this.battleState == 3) {
                    if (this.isPlayeredTurn) {
                        if (this.playerEnd) {
                            this.damageDraw = 0;
                        }
                    } else if (this.enemyEnd) {
                        this.damageDraw = 0;
                    }
                    if (this.playerEnd && this.enemyEnd) {
                        if (!this.isBattleOver) {
                            this.showEnemy = false;
                            if (this.battleStepPrepearedState >= 2) {
                                this.initBattleStep();
                                this.battleStepPrepearedState = 0;
                            } else {
                                this.battleState = 2;
                            }
                        } else {
                            this.initBattleEnd();
                        }
                    }
                }
            }
            switch (this.battleActionState) {
                case 0: {
                    this.drawBattleAction(g);
                    break;
                }
                case 3: {
                    this.drawBattleAlies(g);
                    break;
                }
                case 4: {
                    this.drawBattleEnemies(g);
                    break;
                }
                case 5: {
                    this.drawBattleLog(g);
                }
            }
        }

        final void drawLocatesList(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_OK, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false);
            long cTime = System.currentTimeMillis();
            long outTime = 0L;
            if (!this.isGhost) {
                outTime = cTime - this.inLocationTime > 30000L ? 0L : 30000L - cTime + this.inLocationTime;
            }
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            if (outTime > 0L) {
                FontManagerEx.drawString("" + (outTime + 999L) / 1000L, 88, 0 + Game.this.HEADER_HEIGHT / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
                g.setColor(0xFF0000);
                g.fillRect(0 + this.guiCP.GetWidth(21) + 2, 0 + Game.this.HEADER_HEIGHT / 2 - FontManagerEx.getHeight(0) / 2 + FontManagerEx.getHeight(0) + 1, (176 - this.guiCP.GetWidth(21) * 2 - 4) * (int)outTime / 30000, 4);
            }
            int persWidth = 0;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7 - persWidth;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = FontManagerEx.getHeight(0) * 2 + 4;
            int textShift = (fontHeight - 4) / 2 - FontManagerEx.getHeight(0) / 2;
            this.drawVectorScrollList(g, left, tabsBottom, w, h, 7, fontHeight, textShift);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawPersStatsParameters(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_OK, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false);
            int l = this.getMoneyWidth(this.money);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            this.drawMoney(g, this.money, 88 - l / 2, 0 + Game.this.HEADER_HEIGHT / 2 - FontManagerEx.getHeight(0) / 2);
            if (this.lastTimeAnim == 0L) {
                this.lastTimeAnim = Game.this.paintTimeCur;
            }
            int animInd = this.curAnim;
            int frameID = -1;
            frameID = this.curAnim == 0 || this.curAnim == 7 || this.curAnim == 8 || this.curAnim == 15 ? this.persAnim.getFrame(animInd, Game.this.paintTimeCur - this.lastTimeAnim, true) : this.persAnim.getFrame(animInd, Game.this.paintTimeCur - this.lastTimeAnim, false);
            if (frameID < 0) {
                this.curAnim = this.withWeapon * 8;
                this.lastTimeAnim = Game.this.paintTimeCur;
                animInd = this.curAnim;
                frameID = this.persAnim.getFrame(animInd, Game.this.paintTimeCur - this.lastTimeAnim, true);
            }
            int anmFrame = this.persAnim.getAnimFrame(animInd, frameID);
            int left = 0 + this.guiCP.GetWidth(0);
            int right = 176 - this.guiCP.GetWidth(1);
            int persAnimTop = 104 + Game.this.HEADER_HEIGHT;
            int persAnimLeft = left - 10;
            for (int i = 0; i < 4; ++i) {
                if (this.shieldAnim != null) {
                    this.shieldAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                if (this.swordAnim != null) {
                    this.swordAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                this.persAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                if (i == 1 && this.hearAnim != null) {
                    int anfFrm = anmFrame / 4;
                    if (this.helmetAnim == null) {
                        this.hearAnim.DrawFrame(g, anfFrm, persAnimLeft, persAnimTop, 36);
                    }
                }
                if (this.armedAnim != null) {
                    this.armedAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                if (this.shoulderAnim != null) {
                    this.shoulderAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                if (this.breastplateAnim != null) {
                    this.breastplateAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                if (this.helmetAnim != null) {
                    this.helmetAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                if (this.legedAnim != null) {
                    this.legedAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
                }
                if (this.bootAnim == null) continue;
                this.bootAnim.DrawFrame(g, anmFrame + i, persAnimLeft, persAnimTop, 36);
            }
            int persWidth = 60;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int leftC = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int rightC = 176 - this.guiCP.GetWidth(1) - 1;
            FontManagerEx.drawString(GameText.STR_TOOLBAR_LEVEL + ":", leftC, tabsBottom, 20, 0);
            FontManagerEx.drawString("" + this.playerLevel, rightC, tabsBottom, 24, 0);
            FontManagerEx.drawString(GameText.STR_TOOLBAR_DAMAGE + ":", leftC, tabsBottom += FontManagerEx.getHeight(0), 20, 0);
            FontManagerEx.drawString("" + this.playerDamage, rightC, tabsBottom, 24, 0);
            tabsBottom += FontManagerEx.getHeight(0);
            tabsBottom += FontManagerEx.getHeight(0);
            int editWidth = 116;
            int top = persAnimTop - 5;
            Filler.fillWidthByImage(g, left, top, right, this.guiCP, 2);
            this.guiCP.Draw(g, 13, left, top += this.guiCP.GetHeight(2));
            this.guiCP.Draw(g, 14, right - this.guiCP.GetWidth(14), top);
            Filler.fillWidthByImage(g, left + this.guiCP.GetWidth(13), top, right - this.guiCP.GetWidth(14), this.guiCP, 5);
            this.drawEditBox(g, 88 - editWidth / 2, top, editWidth, false, null);
            this.drawFilledBox(g, 88 - editWidth / 2 + 2, top + 1, editWidth - 4, "" + this.expCur + " / " + this.expMax, 0, this.expCur - this.expMin, this.expMax - this.expMin);
            Filler.fillWidthByImage(g, left, top += this.guiCP.GetHeight(13), right, this.guiCP, 3);
            Filler.fillWidthByImage(g, left, top += this.guiCP.GetHeight(3) - 4, right, this.guiCP, 2);
            this.guiCP.Draw(g, 13, left, top += this.guiCP.GetHeight(2));
            this.guiCP.Draw(g, 14, right - this.guiCP.GetWidth(14), top);
            Filler.fillWidthByImage(g, left + this.guiCP.GetWidth(13), top, right - this.guiCP.GetWidth(14), this.guiCP, 5);
            this.drawEditBox(g, 88 - editWidth / 2, top, editWidth, false, null);
            this.drawFilledBox(g, 88 - editWidth / 2 + 2, top + 1, editWidth - 4, "" + this.healthCur + " / " + (this.healthMax + this.healthBonus), 1, this.healthCur, this.healthMax + this.healthBonus);
            Filler.fillWidthByImage(g, left, top += this.guiCP.GetHeight(13), right, this.guiCP, 3);
            Filler.fillWidthByImage(g, left, top += this.guiCP.GetHeight(3) - 4, right, this.guiCP, 2);
            this.guiCP.Draw(g, 13, left, top += this.guiCP.GetHeight(2));
            this.guiCP.Draw(g, 14, right - this.guiCP.GetWidth(14), top);
            Filler.fillWidthByImage(g, left + this.guiCP.GetWidth(13), top, right - this.guiCP.GetWidth(14), this.guiCP, 5);
            this.drawEditBox(g, 88 - editWidth / 2, top, editWidth, false, null);
            this.drawFilledBox(g, 88 - editWidth / 2 + 2, top + 1, editWidth - 4, "" + this.manaCur + " / " + this.manaMax, 2, this.manaCur, this.manaMax);
            Filler.fillWidthByImage(g, left, top += this.guiCP.GetHeight(13), right, this.guiCP, 3);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawPersStatsRewards(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_OK, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            int persWidth = 0;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7 - persWidth;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = FontManagerEx.getHeight(0) * 2 + 4;
            int textShift = (fontHeight - 4) / 2 - FontManagerEx.getHeight(0) / 2;
            this.drawVectorScrollList(g, left, tabsBottom, w, h, 13, fontHeight, textShift);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawPersStatsGifts(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_OK, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            int persWidth = 0;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7 - persWidth;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = FontManagerEx.getHeight(0) * 2 + 4;
            int textShift = (fontHeight - 4) / 2 - FontManagerEx.getHeight(0) / 2;
            this.drawVectorScrollList(g, left, tabsBottom, w, h, 14, fontHeight, textShift);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawPersStats(Graphics g) {
            switch (this.statisticState) {
                case 1: {
                    this.drawPersStatsParameters(g);
                    break;
                }
                case 3: {
                    this.drawPersStatsRewards(g);
                    break;
                }
                case 4: {
                    this.drawPersStatsGifts(g);
                }
            }
        }

        final void drawArena(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_BACK, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            FontManagerEx.drawString("" + this.battlesList.size(), 88, 0 + Game.this.HEADER_HEIGHT / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            int persWidth = 0;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7 - persWidth;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = FontManagerEx.getHeight(0) * 2 + 4;
            int textShift = -1;
            this.drawVectorScrollList(g, left, tabsBottom, w, h, 15, fontHeight, textShift);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawCreateBattle(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_BACK, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_CREATE, false);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            FontManagerEx.drawString(GameText.STR_CREATE_BATTLE, 88, 0 + Game.this.HEADER_HEIGHT / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            int top = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0);
            int right = 176 - this.guiCP.GetWidth(1);
            FontManagerEx.drawString(GameText.STR_PLAYERS_LEVEL, 88, top, 17, 0);
            top += FontManagerEx.getHeight(0);
            int l1 = left + 74;
            int r1 = l1 + 46;
            int shift = 5;
            FontManagerEx.drawString(GameText.STR_FROM, left + shift, top += shift, 20, 0);
            if (this.fieldActiveElement == 0) {
                this.guiCP.Draw(g, 22, l1 - 2 - this.guiCP.GetWidth(22) - this.guiCP.GetWidth(21), top);
                this.guiCP.Draw(g, 23, r1 + 2 + this.guiCP.GetWidth(21), top);
            }
            Filler.fillHeightByImage(g, l1 - this.guiCP.GetWidth(21), top, top + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(5), this.guiCP, 21);
            Filler.fillHeightByImage(g, r1, top, top + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(5), this.guiCP, 21);
            Filler.fillWidthByImage(g, l1, top, r1, this.guiCP, 2);
            Filler.fillWidthByImage(g, l1, top += this.guiCP.GetHeight(2), r1, this.guiCP, this.fieldActiveElement == 0 ? 5 : 4);
            FontManagerEx.drawString("" + this.createBattle_MIN, (l1 + r1) / 2, top + this.guiCP.GetHeight(5) / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            Filler.fillWidthByImage(g, l1, top += this.guiCP.GetHeight(5), r1, this.guiCP, 3);
            top += this.guiCP.GetHeight(3);
            FontManagerEx.drawString(GameText.STR_TO, left + shift, top += shift, 20, 0);
            if (this.fieldActiveElement == 1) {
                this.guiCP.Draw(g, 22, l1 - 2 - this.guiCP.GetWidth(22) - this.guiCP.GetWidth(21), top);
                this.guiCP.Draw(g, 23, r1 + 2 + this.guiCP.GetWidth(21), top);
            }
            Filler.fillHeightByImage(g, l1 - this.guiCP.GetWidth(21), top, top + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(5), this.guiCP, 21);
            Filler.fillHeightByImage(g, r1, top, top + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(5), this.guiCP, 21);
            Filler.fillWidthByImage(g, l1, top, r1, this.guiCP, 2);
            Filler.fillWidthByImage(g, l1, top += this.guiCP.GetHeight(2), r1, this.guiCP, this.fieldActiveElement == 1 ? 5 : 4);
            FontManagerEx.drawString("" + this.createBattle_MAX, (l1 + r1) / 2, top + this.guiCP.GetHeight(5) / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            Filler.fillWidthByImage(g, l1, top += this.guiCP.GetHeight(5), r1, this.guiCP, 3);
            top += this.guiCP.GetHeight(3);
            FontManagerEx.drawString(GameText.STR_TEAM_COUNT, 88, top += shift, 17, 0);
            top += FontManagerEx.getHeight(0);
            top += shift;
            if (this.fieldActiveElement == 2) {
                this.guiCP.Draw(g, 22, l1 - 2 - this.guiCP.GetWidth(22) - this.guiCP.GetWidth(21), top);
                this.guiCP.Draw(g, 23, r1 + 2 + this.guiCP.GetWidth(21), top);
            }
            Filler.fillHeightByImage(g, l1 - this.guiCP.GetWidth(21), top, top + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(5), this.guiCP, 21);
            Filler.fillHeightByImage(g, r1, top, top + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(5), this.guiCP, 21);
            Filler.fillWidthByImage(g, l1, top, r1, this.guiCP, 2);
            Filler.fillWidthByImage(g, l1, top += this.guiCP.GetHeight(2), r1, this.guiCP, this.fieldActiveElement == 2 ? 5 : 4);
            FontManagerEx.drawString("" + this.createBattle_TEAM, (l1 + r1) / 2, top + this.guiCP.GetHeight(5) / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            Filler.fillWidthByImage(g, l1, top += this.guiCP.GetHeight(5), r1, this.guiCP, 3);
            top += this.guiCP.GetHeight(3);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawBattleWait(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_BACK, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            FontManagerEx.drawString("" + this.battleAliesList.size() + "(" + this.createBattle_TEAM + ")" + " / " + this.battleEnemiesList.size() + "(" + this.createBattle_TEAM + ")", 88, 0 + Game.this.HEADER_HEIGHT / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            int persWidth = 0;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7 - persWidth;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = FontManagerEx.getHeight(0) * 2 + 4;
            int textShift = (fontHeight - 4) / 2 - FontManagerEx.getHeight(0) / 2;
            this.drawVectorScrollList(g, left, tabsBottom, w, h, this.battleWaitState == 0 ? 16 : 17, fontHeight, textShift);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawSettings(Graphics g) {
            this.drawGUIBorders(g, this.getSettingLeftSoftKey(this.SelectedItem - 1), this.getSettingRightSoftKey(this.SelectedItem - 1), false);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            int persWidth = 0;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7 - persWidth;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = FontManagerEx.getHeight(0) * 2 + 4;
            int textShift = -1;
            this.drawVectorScrollList(g, left, tabsBottom, w, h, 18, fontHeight, textShift);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawSuperPunch(Graphics g) {
            this.drawGUIBorders(g, GameText.STR_TOOLBAR_BACK, "", false);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 2;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 4;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = FontManagerEx.getHeight(0) * 2 + 4;
            int textShift = (fontHeight - 4) / 2 - FontManagerEx.getHeight(0) / 2;
            SuperPunch sp = (SuperPunch)this.superPunchList.elementAt(this.superPunshState - 1);
            int Left = left;
            int Top = tabsBottom + 2;
            int MaxW = this.battleLogImages[3].getWidth();
            int MaxH = this.battleLogImages[3].getHeight();
            for (int i = 0; i < sp.Seq.length; ++i) {
                if (i != 0 && (Left += MaxW + 5) + MaxW > left + w) {
                    Left = left;
                    Top += MaxH + 5;
                }
                g.drawImage(this.battleLogImages[sp.Opened ? sp.Seq[i] : 3], Left, Top, 20);
            }
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawSMS(Graphics g) {
            String lSoft = "";
            String rSoft = "";
            if (this.window.active) {
                switch (this.window.WindowExternState) {
                    case 3: {
                        lSoft = GameText.STR_TOOLBAR_OK;
                        rSoft = GameText.STR_TOOLBAR_CANCEL;
                    }
                }
            } else {
                lSoft = this.menu.Active ? GameText.STR_TOOLBAR_OK : "";
                rSoft = this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_SEND;
            }
            this.drawGUIBorders(g, lSoft, rSoft, false);
            int l = this.getMoneyWidth(this.money);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            this.drawMoney(g, this.money, 88 - l / 2, 0 + Game.this.HEADER_HEIGHT / 2 - FontManagerEx.getHeight(0) / 2);
            int persWidth = 0;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7 - persWidth;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = FontManagerEx.getHeight(0) * 2 + 4;
            int textShift = -1;
            this.drawVectorScrollList(g, left, tabsBottom, w, h, 19, fontHeight, textShift);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawMails(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active || this.window.active ? GameText.STR_TOOLBAR_OK : "", this.menu.Active || this.window.active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            FontManagerEx.drawString("" + this.MailsList.size(), 88, 0 + Game.this.HEADER_HEIGHT / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            int persWidth = 0;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7 - persWidth;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = this.fontSmallNormal.getHeight() * 2 + 4;
            int textShift = -1;
            g.setFont(this.fontSmallNormal);
            this.drawVectorScrollList(g, left, tabsBottom, w, h, 20, fontHeight, textShift);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawUpdate(Graphics g) {
            this.drawGUIBorders(g, GameText.STR_TOOLBAR_OK, GameText.STR_TOOLBAR_CANCEL, false);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            FontManagerEx.drawString("v" + this.clientNewVersionTop + "." + this.clientNewVersionMid + "." + this.clientNewVersionBot, 88, 0 + Game.this.HEADER_HEIGHT / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            int left = 0 + this.guiCP.GetWidth(0) + 1;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            this.drawScroll(g, tabsBottom, 176 - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 3, h, this.scrollList.getPagePos(), this.scrollList.getScreenH(), this.scrollList.getPageH());
            FontManagerEx.drawPage(this.clientNewVersionStr, this.scrollList.getPagePos(), 20, true);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawLocUsers(Graphics g) {
            this.drawGUIBorders(g, this.menu.Active ? GameText.STR_TOOLBAR_OK : GameText.STR_TOOLBAR_BACK, this.menu.Active ? GameText.STR_TOOLBAR_CANCEL : GameText.STR_TOOLBAR_MENU, false);
            this.drawRect(g, 1, 0, 0, 176, Game.this.HEADER_HEIGHT, 2499093);
            FontManagerEx.drawString("" + this.LocUsersList.size(), 88, 0 + Game.this.HEADER_HEIGHT / 2 - FontManagerEx.getHeight(0) / 2, 17, 0);
            int persWidth = 0;
            int tabsBottom = 0 + Game.this.HEADER_HEIGHT + this.guiCP.GetHeight(2) + this.guiCP.GetHeight(3) + this.guiCP.GetHeight(4);
            int left = 0 + this.guiCP.GetWidth(0) + 1 + persWidth;
            int w = 176 - this.guiCP.GetWidth(0) - this.guiCP.GetWidth(1) - this.guiCP.GetWidth(28) - 7 - persWidth;
            int h = 220 - Game.this.HEADER_HEIGHT - this.guiCP.GetHeight(2) * 2 - this.guiCP.GetHeight(4) - this.guiCP.GetHeight(3) * 2 - this.guiCP.GetHeight(5);
            int fontHeight = this.fontSmallNormal.getHeight() + 2;
            int textShift = -1;
            g.setFont(this.fontSmallNormal);
            this.drawVectorScrollList(g, left, tabsBottom, w, h, 21, fontHeight, textShift);
            if (this.menu.Active) {
                this.drawMenu(g, 176, 220 - this.guiCP.GetHeight(3) - this.guiCP.GetHeight(2) - this.guiCP.GetHeight(5));
            }
        }

        final void drawWindowExtern(Graphics g) {
            switch (this.window.WindowExternState) {
                case 1: {
                    this.drawBattleEndText(g, true);
                    break;
                }
                case 2: {
                    this.drawBattleEndText(g, false);
                    break;
                }
                case 3: {
                    this.window.draw(g);
                    break;
                }
                case 4: {
                    this.window.draw(g);
                    break;
                }
                case 5: {
                    this.window.draw(g);
                }
            }
        }

        final void drawBattleEndText(Graphics g, boolean win) {
            if (win) {
                this.window.drawFrame(g);
                int top = this.window.PageY - this.window.pagePos;
                int middle = this.window.PageX + this.window.PageW / 2;
                FontManagerEx.drawString(this.window.string, middle, top, 1, 0);
                FontManagerEx.drawString(GameText.STR_EXP + ": +" + this.battleBonusExp, middle, top += FontManagerEx.getHeight(0), 1, 0);
                int l = this.getMoneyWidth(this.battleBonusMoney);
                this.drawMoney(g, this.battleBonusMoney, middle - l / 2, top += FontManagerEx.getHeight(0));
            } else {
                this.window.draw(g);
            }
        }

        public class Mail {
            public int ID;
            public boolean Readed;
            public String Sender;
            public long Time;
            public String TimeStr;

            public Mail(int ID, boolean Readed, String Sender, long Time) {
                this.ID = ID;
                this.Readed = Readed;
                this.Sender = Sender;
                this.Time = Time;
                Date d = new Date();
                d.setTime(Time);
                Calendar cal = Calendar.getInstance(TimeZone.getDefault());
                cal.setTime(d);
                int sendYear = cal.get(1);
                int sendMonth = cal.get(2);
                int sendDay = cal.get(5);
                int sendHour = cal.get(10);
                int sendMin = cal.get(12);
                StringBuffer sbuff = new StringBuffer("[");
                sbuff.append(sendYear);
                sbuff.append('.');
                if (sendMonth < 10) {
                    sbuff.append('0');
                }
                sbuff.append(sendMonth);
                sbuff.append('.');
                if (sendDay < 10) {
                    sbuff.append('0');
                }
                sbuff.append(sendDay);
                sbuff.append(' ');
                if (sendHour < 10) {
                    sbuff.append('0');
                }
                sbuff.append(sendHour);
                sbuff.append(':');
                if (sendMin < 10) {
                    sbuff.append('0');
                }
                sbuff.append(sendMin);
                sbuff.append(']');
                this.TimeStr = sbuff.toString();
            }
        }

        public class SuperPunch {
            public int Level;
            public boolean Opened;
            public int[] Seq;

            public SuperPunch(int Level2, boolean Opened, int[] Seq) {
                this.Level = Level2;
                this.Opened = Opened;
                this.Seq = Seq;
            }
        }

        public class HealthTimer
        extends TimerTask {
            public boolean pause = true;

            public void run() {
                if (!this.pause) {
                    GameData.this.stepAddHealth();
                }
            }
        }

        class ObjectFromResData {
            public int id = 0;
            public Integer mainPakNum = null;
            public Integer mainPakIndex = null;
            public Integer pallPakNum = null;
            public Integer pallPakIndex = null;

            ObjectFromResData() {
            }
        }

        class Building {
            int id;
            String Name;
            int Type;
            Image Image;

            public Building(int id, String name, int type) {
                this.id = id;
                this.Name = name;
                this.Type = type;
                this.Image = null;
            }

            public Building(Hashtable h) {
                try {
                    this.id = (Integer)Param.get(h, 0);
                    this.Name = (String)Param.get(h, 1);
                    this.Type = ((Byte)Param.get(h, 2)).byteValue();
                }
                catch (NotFoundParamIDException ne) {
                    System.out.println("ClothesItem = " + ne);
                }
            }
        }

        class Window {
            String string = "";
            int x = 0;
            int y = 0;
            int width = 100;
            int height = 100;
            int pagePos = 0;
            int pageHeight = 0;
            int borderH = 0;
            int borderW = 0;
            int scrollW = 0;
            boolean active = false;
            int PageX = 0;
            int PageY = 0;
            int PageW = 0;
            int PageH = 0;
            boolean isExternDraw = false;
            boolean isScrollable = true;
            int WindowExternState = 0;

            Window() {
            }

            final void init(String string, int x, int y, int width, int height, int anchor, boolean extDraw, int rowsCount) {
                this.isExternDraw = extDraw;
                this.WindowExternState = 0;
                if ((anchor & 1) != 0) {
                    x -= width / 2;
                } else if ((anchor & 8) != 0) {
                    x -= width;
                }
                if ((anchor & 2) != 0) {
                    y -= height / 2;
                } else if ((anchor & 0x20) != 0) {
                    y -= height;
                }
                this.string = string;
                this.x = x;
                this.y = y;
                this.width = width;
                this.height = height;
                this.borderH = GameData.this.guiCP.GetHeight(12);
                this.borderW = GameData.this.guiCP.GetWidth(21);
                this.scrollW = GameData.this.guiCP.GetWidth(29);
                this.pagePos = 0;
                FontManagerEx.setPage(x + this.borderW, y + this.borderH, width - 2 * this.borderW - this.scrollW, height - 2 * this.borderH);
                int PageTop = FontManagerEx.getPageY();
                int MaxPageWidth = FontManagerEx.getPageWidth();
                int MaxPageHeight = FontManagerEx.getPageHeight();
                this.pageHeight = rowsCount <= 0 ? FontManagerEx.lineNum(string) * FontManagerEx.getHeight() : rowsCount * FontManagerEx.getHeight();
                if (this.pageHeight <= MaxPageHeight) {
                    FontManagerEx.setPageY(PageTop + (MaxPageHeight - this.pageHeight) / 2);
                    this.isScrollable = false;
                }
                this.PageX = FontManagerEx.getPageX();
                this.PageY = FontManagerEx.getPageY();
                this.PageW = FontManagerEx.getPageWidth() + (this.isScrollable ? 0 : this.scrollW);
                this.PageH = FontManagerEx.getPageHeight();
                this.active = true;
            }

            final void init(String string) {
                this.init(string, 88, 110, 117, 110, 3, false, 0);
            }

            final void init(String string, int WindowExternState) {
                this.init(string, 88, 110, 117, 110, 3, true, 0);
                this.WindowExternState = WindowExternState;
            }

            final void init(String string, boolean extDraw, boolean scrollable, int WindowExternState, int rowsCount) {
                this.init(string, 88, 110, 117, 110, 3, extDraw, rowsCount);
                this.isScrollable = scrollable;
                this.WindowExternState = WindowExternState;
            }

            final boolean isExternDraw() {
                return this.isExternDraw;
            }

            final void run() {
                if (this.isScrollable) {
                    if (Game.this.keyUp) {
                        Game.this.keyUp = false;
                        --this.pagePos;
                    }
                    if (Game.this.keyDown) {
                        Game.this.keyDown = false;
                        ++this.pagePos;
                    }
                }
                if (Game.this.keyFire) {
                    Game.this.keyFire = false;
                    this.active = false;
                }
            }

            final void drawFrame(Graphics g) {
                g.setColor(4146242);
                g.setClip(this.x, this.y, this.width, this.height);
                g.fillRect(this.x, this.y, this.width, this.height);
                Filler.fillWidthByImage(g, this.x, this.y, this.x + this.width, GameData.this.guiCP, 12);
                Filler.fillWidthByImage(g, this.x, this.y + this.height - this.borderH, this.x + this.width, GameData.this.guiCP, 12);
                Filler.fillHeightByImage(g, this.x, this.y, this.y + this.height, GameData.this.guiCP, 21);
                Filler.fillHeightByImage(g, this.x + this.width - this.borderW, this.y, this.y + this.height, GameData.this.guiCP, 21);
                if (this.isScrollable) {
                    GameData.this.drawScroll(g, this.y + this.borderH, this.x + this.width - this.scrollW - this.borderW, this.height - 2 * this.borderH, this.pagePos, this.pageHeight, this.height - 2 * this.borderH);
                }
            }

            final void draw(Graphics g) {
                this.drawFrame(g);
                FontManagerEx.setPage(this.PageX, this.PageY, this.PageW, this.PageH);
                FontManagerEx.drawPage(this.string, -this.pagePos, 1, true);
            }
        }
    }
}

