/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.ChatElement;
import Game.ChatMessageView;
import Game.Dictionary;
import com.alsigames.gui.ScrollList;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Chat
extends ScrollList {
    Vector chatUsersList = new Vector();
    int chatUsersShiftY = 0;
    int SelectedUserNum = 0;
    Vector chatRoomsList = new Vector();
    public ChatUser SelectedUserData = null;
    int userID = -1;
    Font fontSmall;
    Font fontSmallNormal;
    Font fontMedium;
    Font fontBig;
    Font fontBigNormal;
    Dictionary smilesList = new Dictionary();
    boolean chatSmilesShow = true;
    static final int maxMessagesCount = 50;

    public Chat() {
        super(new ChatElement[50]);
        for (int i = 0; i < this.List.length; ++i) {
            this.List[i] = new ChatElement();
        }
    }

    public void clear(boolean withMessage) {
        this.chatRoomsList.removeAllElements();
        this.chatUsersList.removeAllElements();
        if (withMessage) {
            this.ElementsUsed = 0;
            for (int i = 0; i < this.List.length; ++i) {
                ChatElement ce = (ChatElement)this.List[i];
                if (ce == null) continue;
                ce.Clear();
            }
        }
    }

    public void addUser(int id, String name, int level) {
        if (this.chatUsersList.size() > 0) {
            for (int i = 0; i < this.chatUsersList.size(); ++i) {
                ChatUser chusr = (ChatUser)this.chatUsersList.elementAt(i);
                if (chusr.id == id) break;
                if (chusr.Name.toUpperCase().compareTo(name.toUpperCase()) >= 0) {
                    this.chatUsersList.insertElementAt(new ChatUser(id, name, level), i);
                    if (this.SelectedUserNum - 1 >= i) {
                        ++this.SelectedUserNum;
                    }
                } else {
                    if (i < this.chatUsersList.size() - 1) continue;
                    this.chatUsersList.addElement(new ChatUser(id, name, level));
                }
                break;
            }
        } else {
            this.SelectedUserNum = 1;
            this.chatUsersList.addElement(new ChatUser(id, name, level));
        }
    }

    public void delUser(int id) {
        for (int i = 0; i < this.chatUsersList.size(); ++i) {
            ChatUser chusr = (ChatUser)this.chatUsersList.elementAt(i);
            if (chusr.id != id) continue;
            if (this.SelectedUserNum > i) {
                --this.SelectedUserNum;
            }
            if (this.SelectedUserNum < 1) {
                this.SelectedUserNum = 1;
            }
            this.chatUsersList.removeElementAt(i);
            if (this.chatUsersList.size() != 0) break;
            this.SelectedUserNum = 0;
            break;
        }
    }

    public void addMessage(int sendUserID, int reciveUserID, int msgType, String msgText) {
        try {
            Vector words;
            ChatUser cu;
            int i;
            ChatElement se;
            int shiftMes = 0;
            boolean lastElem = this.IsInBottomList();
            if (!lastElem && this.isListFull()) {
                se = (ChatElement)this.GetElement(0);
                shiftMes = se.height + this.ElementsShift;
            }
            se = (ChatElement)this.GetEmptyElement();
            se.senderName = "";
            if (sendUserID > 0) {
                for (i = 0; i < this.chatUsersList.size(); ++i) {
                    cu = (ChatUser)this.chatUsersList.elementAt(i);
                    if (cu.id != sendUserID) continue;
                    if (msgType == 1 && sendUserID != this.userID) {
                        se.senderName = "<- ";
                    }
                    if (msgType == 0 || sendUserID != this.userID) {
                        se.senderName = se.senderName + cu.Name + " [" + cu.level + "]";
                    }
                    if (sendUserID == this.userID && msgType != 0) break;
                    se.senderName = se.senderName + ": ";
                    break;
                }
            }
            if (sendUserID == this.userID && msgType == 1) {
                for (i = 0; i < this.chatUsersList.size(); ++i) {
                    cu = (ChatUser)this.chatUsersList.elementAt(i);
                    if (cu.id != reciveUserID) continue;
                    se.senderName = se.senderName + "-> " + cu.Name + " [" + cu.level + "]: ";
                    break;
                }
            }
            se.msgText = msgText;
            se.isPrivate = msgType != 0;
            se.senderID = sendUserID;
            se.receiverID = reciveUserID;
            se.words = words = this.getWordsEx(se.msgText, se.senderID > 0);
            se.width = this.PageWidth;
            se.height = this.getTextChatElemHeight(this.fontSmall, this.fontSmallNormal, se);
            this.GetTotalHeight();
            se.msgColor = se.isPrivate ? (se.senderID == this.userID ? 0xFFFF00 : 0xFF0000) : 0xFFFFFF;
            if (!lastElem) {
                this.Scroll(-shiftMes);
            } else {
                this.ScrollTo(1);
            }
        }
        catch (Exception e) {
            System.out.println("ex = " + e);
        }
    }

    Vector getWordsEx(String str, boolean parsSmile) {
        Vector<ChatMessageView> words = new Vector<ChatMessageView>();
        int cnt = str.length();
        Dictionary smileElem = null;
        int lastSymb = -1;
        for (int i = 0; i < cnt; ++i) {
            ChatMessageView cmv;
            char ch = str.charAt(i);
            if (ch == ' ' || ch == '\t') {
                if (lastSymb < i - 1) {
                    cmv = new ChatMessageView(1, str.substring(lastSymb + 1, i));
                    words.addElement(cmv);
                }
                lastSymb = i;
                smileElem = null;
                continue;
            }
            if (parsSmile) {
                ChatMessageView cmv2;
                int level;
                Dictionary smileElem2;
                if (smileElem == null) {
                    smileElem2 = this.smilesList.GetDictionary(ch);
                    if (smileElem2 == null) {
                        smileElem = null;
                    } else if (smileElem2.image != null) {
                        level = smileElem2.level;
                        if (i - level > lastSymb + 1) {
                            cmv2 = new ChatMessageView(1, str.substring(lastSymb + 1, i - level));
                            words.addElement(cmv2);
                        }
                        cmv2 = new ChatMessageView(3, str.substring(i - level, i + 1));
                        cmv2.img = smileElem2.image;
                        words.addElement(cmv2);
                        lastSymb = i;
                        smileElem = null;
                    } else {
                        smileElem = smileElem2;
                    }
                } else {
                    smileElem2 = smileElem.GetDictionary(ch);
                    if (smileElem2 == null) {
                        smileElem = null;
                    } else if (smileElem2.image == null) {
                        smileElem = smileElem2;
                    } else {
                        level = smileElem2.level;
                        if (i - level > lastSymb + 1) {
                            cmv2 = new ChatMessageView(1, str.substring(lastSymb + 1, i - level));
                            words.addElement(cmv2);
                        }
                        cmv2 = new ChatMessageView(3, str.substring(i - level, i + 1));
                        cmv2.img = smileElem2.image;
                        words.addElement(cmv2);
                        lastSymb = i;
                        smileElem = null;
                    }
                }
            }
            if (i != cnt - 1 || lastSymb >= i) continue;
            cmv = new ChatMessageView(1, str.substring(lastSymb + 1, i + 1));
            words.addElement(cmv);
        }
        return words;
    }

    final int getTextChatElemHeight(Font font, Font fontNormal, ChatElement se) {
        int h = 0;
        int left = 0;
        left += font.stringWidth(se.senderName);
        boolean isEmptyRow = false;
        int pictreHeight = 0;
        int wordPart = 0;
        if (se.words != null && se.words.size() > 0) {
            for (int j = 0; j < se.words.size(); ++j) {
                ChatMessageView cmv = (ChatMessageView)se.words.elementAt(j);
                cmv.breakRow = false;
                String str = cmv.text;
                Image img = cmv.img;
                int curLength = str.length() - wordPart;
                int lngth = 0;
                lngth = cmv.type == 1 || img == null || !this.chatSmilesShow ? fontNormal.substringWidth(str, wordPart, curLength) : img.getWidth();
                if (lngth + left > this.PageWidth) {
                    if (isEmptyRow) {
                        if (cmv.type == 1 || img == null || !this.chatSmilesShow) {
                            if (--curLength > 0) {
                                int wdth = 0;
                                while ((wdth = fontNormal.substringWidth(str, wordPart, curLength)) > this.PageWidth && --curLength > 0) {
                                }
                            }
                            if (curLength <= 0) {
                                curLength = 1;
                            }
                            if (wordPart + curLength < str.length()) {
                                wordPart += curLength;
                                --j;
                            } else {
                                wordPart = 0;
                            }
                        } else {
                            left += lngth + fontNormal.charWidth(' ');
                            if (img.getHeight() > pictreHeight) {
                                pictreHeight = img.getHeight();
                            }
                        }
                    } else {
                        isEmptyRow = true;
                        pictreHeight = 0;
                        --j;
                    }
                    h = pictreHeight < fontNormal.getHeight() ? (h += fontNormal.getHeight() + this.ElementsShift) : (h += pictreHeight + this.ElementsShift);
                    left = 0;
                    cmv.breakRow = true;
                    continue;
                }
                isEmptyRow = false;
                left += lngth + fontNormal.charWidth(' ');
                if (img != null && img.getHeight() > pictreHeight) {
                    pictreHeight = img.getHeight();
                }
                if (j == se.words.size() - 1) {
                    h = pictreHeight < fontNormal.getHeight() ? (h += fontNormal.getHeight()) : (h += pictreHeight);
                }
                wordPart = 0;
            }
        }
        return h;
    }

    final void draw(Graphics g, int left, int top, Font font, Font fontNormal) {
        g.setClip(left, top, this.ScreenW, this.ScreenH);
        g.setFont(font);
        int fontHeight = font.getHeight();
        int lineTop = top + this.PagePos;
        int Left = left;
        for (int i = 0; i < this.ElementsUsed; ++i) {
            left = Left;
            ChatElement se = (ChatElement)this.List[i];
            g.setColor(se.msgColor);
            g.setFont(font);
            if (lineTop <= top + this.ScreenH && lineTop + se.height >= top) {
                g.drawString(se.senderName, left, lineTop, 20);
                left += font.stringWidth(se.senderName);
                g.setFont(fontNormal);
                boolean isEmptyRow = false;
                int pictreHeight = 0;
                int wordPart = 0;
                if (se.words == null || se.words.size() <= 0) continue;
                for (int j = 0; j < se.words.size(); ++j) {
                    ChatMessageView cmv = (ChatMessageView)se.words.elementAt(j);
                    String str = cmv.text;
                    Image img = cmv.img;
                    int curLength = str.length() - wordPart;
                    int lngth = 0;
                    lngth = cmv.type == 1 || img == null || !this.chatSmilesShow ? fontNormal.substringWidth(str, wordPart, curLength) : img.getWidth();
                    if (lngth + left - Left > this.PageWidth) {
                        if (isEmptyRow) {
                            if (cmv.type == 1 || img == null || !this.chatSmilesShow) {
                                if (--curLength > 0) {
                                    int wdth = 0;
                                    while ((wdth = fontNormal.substringWidth(str, wordPart, curLength)) > this.PageWidth && --curLength > 0) {
                                    }
                                }
                                if (curLength <= 0) {
                                    curLength = 1;
                                }
                                g.drawSubstring(str, wordPart, curLength, left, lineTop, 20);
                                if (wordPart + curLength < str.length()) {
                                    wordPart += curLength;
                                    --j;
                                } else {
                                    wordPart = 0;
                                }
                            } else {
                                if (lineTop <= top + this.ScreenH && lineTop + img.getHeight() >= top) {
                                    g.drawImage(img, left, lineTop, 20);
                                }
                                left += lngth + fontNormal.charWidth(' ');
                                if (img.getHeight() > pictreHeight) {
                                    pictreHeight = img.getHeight();
                                }
                            }
                        } else {
                            isEmptyRow = true;
                            pictreHeight = 0;
                            --j;
                        }
                        lineTop = pictreHeight < fontNormal.getHeight() ? (lineTop += fontNormal.getHeight() + this.ElementsShift) : (lineTop += pictreHeight + this.ElementsShift);
                        left = Left;
                        continue;
                    }
                    if (cmv.type == 1 || img == null || !this.chatSmilesShow) {
                        g.drawSubstring(str, wordPart, curLength, left, lineTop, 20);
                        isEmptyRow = false;
                        left += lngth + fontNormal.charWidth(' ');
                        if (j == se.words.size() - 1) {
                            lineTop = pictreHeight < fontNormal.getHeight() ? (lineTop += fontNormal.getHeight() + this.ElementsShift) : (lineTop += pictreHeight + this.ElementsShift);
                        }
                    } else {
                        if (lineTop <= top + this.ScreenH && lineTop + img.getHeight() >= top) {
                            g.drawImage(img, left, lineTop, 20);
                        }
                        isEmptyRow = false;
                        left += lngth + fontNormal.charWidth(' ');
                        if (img.getHeight() > pictreHeight) {
                            pictreHeight = img.getHeight();
                        }
                        if (j == se.words.size() - 1) {
                            lineTop = pictreHeight < fontNormal.getHeight() ? (lineTop += fontNormal.getHeight() + this.ElementsShift) : (lineTop += pictreHeight + this.ElementsShift);
                        }
                    }
                    wordPart = 0;
                }
                continue;
            }
            lineTop += se.height + this.ElementsShift;
        }
    }

    final void lockUser() {
        if (this.chatUsersList.size() > 0 && this.SelectedUserNum > 0) {
            this.SelectedUserData = (ChatUser)this.chatUsersList.elementAt(this.SelectedUserNum - 1);
        }
    }

    final int usersCount() {
        return this.chatUsersList.size();
    }

    public class ChatRoom {
        int room_id;
        int creater_id;
        String creater_name;
        String name;
        boolean isprivate;
        int usersCount;

        public ChatRoom(int lastRoomID, String Name, boolean isPrivate, int createrID, String createrName) {
            this.room_id = lastRoomID;
            this.name = Name;
            this.isprivate = isPrivate;
            this.creater_id = createrID;
            this.creater_name = createrName;
            this.usersCount = 0;
        }
    }

    public class ChatUser {
        public String Name;
        public int id;
        public int level;

        public ChatUser(int id, String name, int level) {
            this.id = id;
            this.Name = name;
            this.level = level;
        }
    }
}

