/*
 * Decompiled with CFR 0.152.
 */
package view;

import blue.bExplore;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Graphics;
import model.FileObject;
import model.LocalFileHandler;
import model.ModelFile;
import model.Preference;
import model.UIFsm;
import view.BWAlert;
import view.Icon;
import view.RowItem;
import view.TabForm;
import view.TabItem;

public class TabItemFile
extends TabItem {
    Vector fileObjects;
    Preference prefs = Preference.getInstance();

    public TabItemFile(int width, int height, String tabName, TabForm tabForm) {
        super(width, height, tabName, tabForm);
    }

    protected void pre_paint(Graphics g, int w, int h) {
        if (this.focusIndex == -1) {
            this.focusIndex = LocalFileHandler.getCurrentFocus();
            int num = this.rowItems.size();
            if (this.focusIndex >= num) {
                this.focusIndex = -1;
            }
            if (this.focusIndex > 3) {
                this.firstVisibleLine = this.focusIndex - 3;
            }
        }
    }

    protected void post_paint(Graphics g, int w, int h) {
        LocalFileHandler.setCurrentFocus(this.focusIndex);
    }

    public void fire() {
        if (this.focusIndex < 0 || this.fileObjects == null || this.focusIndex >= this.fileObjects.size()) {
            BWAlert.errorAlert("Please select a file.");
            return;
        }
        FileObject fo = (FileObject)this.fileObjects.elementAt(this.focusIndex);
        String path = LocalFileHandler.getCurrentFolder().getFullPath();
        String file = fo.getName();
        if (file == null) {
            BWAlert.errorAlert("Please select a file.");
            return;
        }
        try {
            if (fo.isFolder()) {
                UIFsm fsm = TabItemFile.selectedTabForm.midlet.getUIFsm();
                ModelFile model = (ModelFile)fsm.getModel("File");
                if (file.equals("..")) {
                    model.loadParentFolder();
                } else {
                    model.loadFolder(String.valueOf(path) + file);
                }
                fsm.inEvent("enter_file");
            } else {
                TabItemFile.selectedTabForm.midlet.platformRequest("file:///" + path + file);
            }
        }
        catch (ConnectionNotFoundException e) {
            BWAlert.errorAlert(e.toString());
        }
    }

    public void check() {
        if (this.focusIndex < 0) {
            return;
        }
        FileObject fo = (FileObject)this.fileObjects.elementAt(this.focusIndex);
        if (!fo.isFolder()) {
            RowItem rowItem = (RowItem)this.rowItems.elementAt(this.focusIndex);
            if (fo.isChecked()) {
                fo.setChecked(false);
                rowItem.setChecked(false);
            } else {
                fo.setChecked(true);
                rowItem.setChecked(true);
            }
            this.repaint();
        }
    }

    public void update(Vector fileObjects) {
        this.fileObjects = fileObjects;
        this.rowItems.removeAllElements();
        int i = 0;
        while (i < fileObjects.size()) {
            RowItem rowItem = new RowItem(1);
            FileObject fo = (FileObject)fileObjects.elementAt(i);
            String name = fo.getName();
            rowItem.setItems(0, name, bExplore.plainFont.stringWidth(name));
            if (fo.isFolder()) {
                if (fo.getName().equals("..")) {
                    rowItem.setIcon(Icon.UP);
                } else {
                    rowItem.setIcon(Icon.FOLDER);
                }
            } else {
                rowItem.setIcon(Icon.FILE);
            }
            if (!fo.isFolder() && fo.isChecked()) {
                rowItem.setChecked(true);
            }
            this.rowItems.addElement(rowItem);
            ++i;
        }
    }

    public Vector getFileObjects() {
        return this.fileObjects;
    }

    public FileObject getSelectedFileName() {
        if (this.focusIndex < 0) {
            return null;
        }
        FileObject fo = (FileObject)this.fileObjects.elementAt(this.focusIndex);
        return fo;
    }
}

