/*
 * Decompiled with CFR 0.152.
 */
package view;

import blue.bExplore;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import view.KeyRepeatTask;
import view.RowItem;
import view.TabForm;

public class TabItem
extends CustomItem
implements ItemCommandListener {
    private static final int MAX_TAB_SIZE = 10;
    private static int tabSize = 0;
    private static String[] tabNames = new String[10];
    private static Hashtable tabFormMap = new Hashtable();
    private static int[] tabXCoord = new int[10];
    private static int selectedTab = -1;
    private int idleTicks = 0;
    private KeyRepeatTask repeater;
    private Timer theTimer;
    protected Vector rowItems = new Vector();
    static TabForm selectedTabForm;
    private static final int KEY_REPEAT_DELAY = 150;
    int myWidth;
    int myHeight;
    int tabHeight;
    long keyPressedTime;
    long keyReleasedTime;
    static final long KEY_HOLD_TIME = 500L;
    static final int NOKIA_KEY_PEN = -50;
    int focusIndex = -1;
    int numItem;
    boolean hasFocus = false;
    int firstVisibleLine = 0;
    int lastVisibleLine = 0;
    int maxVisibleLines = 0;
    boolean paintTab = true;
    protected int rowHeight = bExplore.plainFont.getHeight();
    protected String formName;
    static final int KUP = 0;
    static final int KDOWN = 1;
    static final int KLEFT = 2;
    static final int KRIGHT = 3;
    static final int KFIRE = 4;
    static final int KSTAR = 5;
    int[] pressedKeys = new int[6];
    int blk_move = 0;
    private boolean hover = false;
    private boolean hidden = false;
    private static final int UPPER = 0;
    private static final int IN = 1;
    private static final int LOWER = 2;
    private int status = 0;

    public TabItem(int width, int height, String tabName, TabForm tabForm) {
        super("");
        this.init(width, height, tabName, tabForm);
    }

    public TabItem(int width, int height) {
        super("");
        this.paintTab = false;
        this.init(width, height, null, null);
    }

    private void init(int width, int height, String tabName, TabForm tabForm) {
        this.repeater = new KeyRepeatTask(this);
        this.tabHeight = bExplore.boldFont.getHeight() + 6;
        if (tabName != null && tabForm != null) {
            if (tabSize < 10) {
                TabItem.tabNames[TabItem.tabSize++] = tabName;
                tabFormMap.put(tabName, tabForm);
                if (tabSize == 1) {
                    TabItem.setSelectedTab(0);
                }
            } else {
                System.err.println("Too many tabs, max is 10!");
            }
        }
        this.resize(width, height);
    }

    public void commandAction(Command cmd, Item item) {
    }

    protected void sizeChanged(int width, int height) {
        this.resize(width, height);
    }

    protected void resize(int width, int height) {
        this.myWidth = width;
        this.myHeight = height;
    }

    protected int getMinContentWidth() {
        return this.myWidth;
    }

    protected int getMinContentHeight() {
        return this.tabHeight;
    }

    protected int getPrefContentWidth(int w) {
        return this.myWidth;
    }

    protected int getPrefContentHeight(int h) {
        return this.myHeight;
    }

    public int getSelectedTab() {
        return selectedTab;
    }

    public void setRowItems(Vector rowItems) {
        this.rowItems = rowItems;
    }

    protected void pre_paint(Graphics g, int w, int h) {
    }

    protected void post_paint(Graphics g, int w, int h) {
    }

    protected void paint(Graphics g, int w, int h) {
        RowItem rowItem;
        this.myWidth = w;
        g.setFont(bExplore.plainFont);
        this.pre_paint(g, w, h);
        if (this.paintTab) {
            this.drawTab(g, 0, 0, this.myWidth, this.tabHeight);
        } else if (this.formName != null) {
            g.setGrayScale(255);
            g.fillRect(0, 0, this.myWidth, this.tabHeight);
            this.drawBackground(g, this.myWidth, this.myHeight, this.tabHeight);
            int y1 = 4 + (this.tabHeight - bExplore.plainFont.getHeight()) / 2;
            g.drawString(this.formName, 4, y1, 20);
        }
        int xPos = 2;
        int yPos = this.tabHeight + 4;
        this.maxVisibleLines = (this.myHeight - yPos) / this.rowHeight;
        if (this.rowItems.size() == 0) {
            return;
        }
        this.numItem = this.rowItems.size();
        if (this.focusIndex >= this.numItem) {
            this.focusIndex = -1;
        }
        if (this.numItem < this.maxVisibleLines) {
            this.lastVisibleLine = this.firstVisibleLine + this.numItem - 1;
        } else {
            this.lastVisibleLine = this.firstVisibleLine + this.maxVisibleLines - 1;
            if (this.lastVisibleLine >= this.numItem) {
                this.lastVisibleLine = this.numItem - 1;
            }
        }
        int halfIconWidth = 4;
        int i = 0;
        while (i < this.numItem) {
            rowItem = (RowItem)this.rowItems.elementAt(i);
            if (rowItem.getIcon() != null && rowItem.getIcon().getWidth() > halfIconWidth) {
                halfIconWidth = rowItem.getIcon().getWidth();
            }
            ++i;
        }
        halfIconWidth /= 2;
        if (this.focusIndex == -1 && this.rowItems.size() > 0) {
            this.focusIndex = 0;
        }
        i = this.firstVisibleLine;
        while (i <= this.lastVisibleLine) {
            rowItem = (RowItem)this.rowItems.elementAt(i);
            if (rowItem.isChecked()) {
                g.setColor(-84215046);
                g.fillRect(0, yPos, this.myWidth, this.rowHeight);
                g.setColor(0);
            } else {
                g.setColor(0xFFFFFF);
            }
            xPos = 2 + halfIconWidth;
            int yshift = 4;
            if (rowItem.getIcon() != null) {
                g.drawImage(rowItem.getIcon(), xPos, yPos + this.rowHeight / 2, 3);
            }
            xPos += halfIconWidth + 2;
            String[] strItems = rowItem.getItems();
            int[] widthes = rowItem.getWidthes();
            int j = 0;
            while (j < strItems.length) {
                String text = strItems[j];
                if (text != null) {
                    g.drawString(text, xPos, yPos + yshift, 20);
                }
                xPos += widthes[j] + 2;
                ++j;
            }
            if (this.focusIndex == i) {
                g.drawRect(0, yPos, this.myWidth - 1, this.rowHeight - 1);
            }
            yPos += this.rowHeight;
            ++i;
        }
        this.post_paint(g, w, h);
    }

    protected void keyPressed(int keyCode) {
        int keyAction = this.getGameAction(keyCode);
        this.keyPressedTime = System.currentTimeMillis();
        this.cleanKeyTrack();
        if (keyAction == 1) {
            this.pressedKeys[0] = 1;
            if (this.pressedKeys[5] == 1 && this.blk_move != 1) {
                this.check();
                this.blk_move = 1;
            }
            this.moveUp();
        }
        if (keyAction == 6) {
            this.pressedKeys[1] = 1;
            if (this.pressedKeys[5] == 1 && this.blk_move != -1) {
                this.check();
                this.blk_move = -1;
            }
            this.moveDown();
        }
        if (keyAction == 5) {
            this.pressedKeys[3] = 1;
            this.moveRight();
        }
        if (keyAction == 2) {
            this.pressedKeys[2] = 1;
            this.moveLeft();
        }
        if (keyAction == 8) {
            this.pressedKeys[4] = 1;
        }
        if (keyCode == 42 || keyCode == -50) {
            this.pressedKeys[5] = 1;
        }
    }

    protected void keyReleased(int keyCode) {
        int keyAction = this.getGameAction(keyCode);
        this.keyReleasedTime = System.currentTimeMillis();
        this.idleTicks = 0;
        if (keyAction == 1) {
            this.pressedKeys[0] = 0;
        }
        if (keyAction == 6) {
            this.pressedKeys[1] = 0;
        }
        if (keyAction == 5) {
            this.pressedKeys[3] = 0;
        }
        if (keyAction == 2) {
            this.pressedKeys[2] = 0;
        }
        if (keyCode == 42 || keyCode == -50) {
            this.blk_move = 0;
            this.pressedKeys[5] = 0;
        }
        if (keyAction == 8) {
            this.pressedKeys[4] = 0;
            if (this.keyReleasedTime - this.keyPressedTime > 500L) {
                this.check();
            } else {
                this.fire();
            }
        }
    }

    void check() {
    }

    void fire() {
    }

    void moveUp() {
        if (this.numItem <= 0 || this.focusIndex == 0) {
            return;
        }
        if (this.focusIndex > this.numItem - 1) {
            this.focusIndex = this.numItem;
        }
        if (this.focusIndex < 0) {
            this.focusIndex = 1;
        }
        --this.focusIndex;
        if (this.focusIndex < this.firstVisibleLine) {
            --this.firstVisibleLine;
            --this.lastVisibleLine;
        }
        if (this.pressedKeys[5] == 1) {
            this.check();
        }
        this.repaint();
    }

    void moveDown() {
        if (this.numItem <= 0 || this.focusIndex == this.numItem - 1) {
            return;
        }
        if (this.focusIndex > this.numItem - 1) {
            this.focusIndex = this.numItem - 2;
        }
        if (this.focusIndex < 0) {
            this.focusIndex = -1;
        }
        ++this.focusIndex;
        if (this.focusIndex > this.lastVisibleLine) {
            ++this.firstVisibleLine;
            ++this.lastVisibleLine;
        }
        if (this.pressedKeys[5] == 1) {
            this.check();
        }
        this.repaint();
    }

    void moveRight() {
        if (!TabItem.selectedTabForm.hasTab) {
            return;
        }
        int prevIndex = selectedTab++;
        if (selectedTab >= tabSize) {
            selectedTab = 0;
        }
        TabItem.setSelectedTab(selectedTab);
        TabItem.moveToNextState(prevIndex, selectedTab);
        this.repaint();
    }

    void moveLeft() {
        if (!TabItem.selectedTabForm.hasTab) {
            return;
        }
        int prevIndex = selectedTab--;
        if (selectedTab < 0) {
            selectedTab = tabSize - 1;
        }
        TabItem.setSelectedTab(selectedTab);
        TabItem.moveToNextState(prevIndex, selectedTab);
        this.repaint();
    }

    public void tick() {
        if (this.pressedKeys[0] != 0) {
            if (this.pressedKeys[0] > 3) {
                this.moveUp();
            } else {
                this.pressedKeys[0] = this.pressedKeys[0] + 1;
            }
        }
        if (this.pressedKeys[1] != 0) {
            if (this.pressedKeys[1] > 3) {
                this.moveDown();
            } else {
                this.pressedKeys[1] = this.pressedKeys[1] + 1;
            }
        }
        if (this.pressedKeys[0] == 0 && this.pressedKeys[1] == 0 && this.pressedKeys[2] == 0 && this.pressedKeys[3] == 0 && this.pressedKeys[4] == 0) {
            ++this.idleTicks;
            if (this.idleTicks == 1000) {
                this.idleTicks = 500;
            }
        }
    }

    protected void cleanKeyTrack() {
        this.pressedKeys[0] = 0;
        this.pressedKeys[1] = 0;
        this.pressedKeys[2] = 0;
        this.pressedKeys[3] = 0;
        this.pressedKeys[4] = 0;
    }

    protected void hideNotify() {
        this.theTimer.cancel();
        this.theTimer = null;
        this.hidden = true;
        this.cleanKeyTrack();
    }

    protected void showNotify() {
        this.theTimer = new Timer();
        this.theTimer.schedule((TimerTask)this.repeater, 0L, 150L);
        if (this.hover) {
            this.hover = false;
        }
        this.hidden = false;
        this.numItem = this.rowItems.size();
        if (this.numItem == 0 || this.firstVisibleLine > this.numItem) {
            this.firstVisibleLine = 0;
        }
    }

    protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        return true;
    }

    public void refresh() {
        this.repaint();
    }

    private static void setSelectedTab(int index) {
        selectedTab = index;
        selectedTabForm = (TabForm)tabFormMap.get(tabNames[index]);
    }

    private static void moveToNextState(int prevIndex, int index) {
        TabForm tmpForm = (TabForm)tabFormMap.get(tabNames[prevIndex]);
        if (tmpForm != null) {
            if (index == 0) {
                tmpForm.leave("enter_neighbor");
            } else if (index == 1) {
                tmpForm.leave("enter_file");
            } else if (index == 2) {
                tmpForm.leave("enter_help");
            }
        }
    }

    private void drawTab(Graphics g, int sx, int sy, int myWidth, int tabHeight) {
        g.setGrayScale(255);
        g.fillRect(0, 0, myWidth, tabHeight);
        int x = 0;
        int i = 0;
        while (i < tabSize) {
            TabItem.tabXCoord[i] = x;
            int width = bExplore.boldFont.stringWidth(tabNames[i]);
            if (i == selectedTab) {
                x += width + 6;
            } else {
                this.drawATab(g, 0xBBBBBB, x, width, tabHeight, tabNames[i]);
                x += width + 6;
            }
            ++i;
        }
        if (selectedTab < tabSize) {
            x = tabXCoord[selectedTab];
            int width = bExplore.boldFont.stringWidth(tabNames[selectedTab]);
            this.drawATab(g, 0x606060, x, width, tabHeight, tabNames[selectedTab]);
        }
        this.drawBackground(g, myWidth, this.myHeight, tabHeight);
    }

    private void drawATab(Graphics g, int scale, int x, int width, int tabHeight, String name) {
        g.setColor(0xDDDDDD);
        g.fillRoundRect(x, 0, width + 8, tabHeight + 4, 8, 8);
        g.setColor(scale);
        g.fillRoundRect(x + 2, 2, width + 8, tabHeight + 4, 8, 8);
        g.setColor(0xFFFFFF);
        g.setFont(bExplore.plainFont);
        int y = 4 + (tabHeight - bExplore.plainFont.getHeight()) / 2;
        g.drawString(name, x + 4, y, 20);
    }

    void drawBackground(Graphics g, int myWidth, int myHeight, int tabHeight) {
        int xshift = 6;
        int yshift = 20;
        g.setColor(0x606060);
        g.fillRect(0, tabHeight, myWidth - xshift, myHeight - yshift);
    }

    public static TabForm getSelectedTabForm() {
        return selectedTabForm;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }
}

