/*
 * Decompiled with CFR 0.152.
 */
package view;

import blue.bExplore;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import local.Local;
import model.BTDesc;
import model.ModelBTDownloadConnectProgress;
import model.UIFsm;
import view.BTDeleteConfirm;
import view.BWAlert;
import view.TabForm;
import view.TabItemNeighbor;

public class TabFormNeighbor
extends TabForm {
    TabItemNeighbor tabItem;
    Command downloadCmd = new Command(Local.get("browse"), 1, 1);
    Command refreshCmd = new Command(Local.get("discover"), 1, 2);
    Command deleteCmd = new Command(Local.get("delete"), 1, 4);

    public TabFormNeighbor(bExplore midlet, String tabName) {
        super(midlet);
        this.tabItem = new TabItemNeighbor(this.width, this.height, tabName, this);
        this.form.setTitle(Local.get("bt"));
        this.form.append((Item)this.tabItem);
        this.form.addCommand(this.downloadCmd);
        this.form.addCommand(this.refreshCmd);
        this.form.addCommand(this.deleteCmd);
    }

    public void commandAction(Command cmd, Displayable disp) {
        super.commandAction(cmd, disp);
        if (cmd == this.downloadCmd) {
            BTDesc btDesc = this.tabItem.getSelectedItem();
            if (btDesc == null) {
                BWAlert.infoAlert(String.valueOf(Local.get("ps")) + " " + Local.get("bt"));
            } else {
                String url = btDesc.getFtpURL();
                if (url == null || url.equals("")) {
                    BWAlert.errorAlert("Invalid remote Bluetooth address [" + url + "]");
                } else {
                    UIFsm fsm = this.midlet.getUIFsm();
                    ModelBTDownloadConnectProgress model = (ModelBTDownloadConnectProgress)fsm.getModel("BTDownloadConnectProgress");
                    model.onUpdate(btDesc);
                    fsm.outEvent("enter_bt_download_connect_progress");
                }
            }
        } else if (cmd == this.deleteCmd) {
            BTDesc btDesc = this.tabItem.getSelectedItem();
            if (btDesc == null) {
                BWAlert.infoAlert(String.valueOf(Local.get("ps")) + " " + Local.get("bt"));
            } else {
                BTDeleteConfirm btDeleteConfirm = new BTDeleteConfirm(this.midlet, btDesc, this, String.valueOf(Local.get("del_confirm")) + " " + btDesc.getBtName() + "?", Local.get("yes"), Local.get("no"));
                this.midlet.changeScreen(btDeleteConfirm);
            }
        } else if (cmd == this.refreshCmd) {
            this.midlet.getUIFsm().outEvent("enter_neighbor_progress");
        }
    }

    public void update() {
        this.tabItem.update();
    }

    public void repaint() {
        this.tabItem.refresh();
    }
}

