/*
 * Decompiled with CFR 0.152.
 */
package view;

import blue.bExplore;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import local.Local;
import model.FileObject;
import model.LocalFileHandler;
import model.ModelBTPush;
import model.ModelFile;
import model.UIFsm;
import view.BWAlert;
import view.FileDeleteConfirm;
import view.FormCreateDir;
import view.TabForm;
import view.TabItemFile;

public class TabFormFile
extends TabForm {
    TabItemFile tabItem;
    Command pushCmd = new Command(Local.get("push"), 1, 2);
    Command refreshCmd = new Command(Local.get("refresh"), 1, 4);
    Command createDirCmd = new Command(String.valueOf(Local.get("create")) + " " + Local.get("folder"), 1, 5);
    Command deleteCmd = new Command(Local.get("delete"), 1, 6);

    public TabFormFile(bExplore midlet, String tabName) {
        super(midlet);
        this.tabItem = new TabItemFile(this.width, this.height, tabName, this);
        this.form.setTitle(Local.get("file"));
        this.form.append((Item)this.tabItem);
        this.form.addCommand(this.pushCmd);
        this.form.addCommand(this.refreshCmd);
        this.form.addCommand(this.createDirCmd);
        this.form.addCommand(this.deleteCmd);
    }

    public void commandAction(Command cmd, Displayable disp) {
        super.commandAction(cmd, disp);
        if (cmd == this.deleteCmd) {
            Vector files = this.tabItem.getFileObjects();
            int count = 0;
            FileObject fd = this.tabItem.getSelectedFileName();
            if (fd != null) {
                fd.setChecked(true);
            }
            int i = 0;
            while (i < files.size()) {
                FileObject fo = (FileObject)files.elementAt(i);
                if (fo.isChecked()) {
                    ++count;
                }
                ++i;
            }
            if (count == 0) {
                BWAlert.infoAlert("Please select a file.");
            } else {
                String warning = "";
                warning = count == 1 ? (fd.isFolder() ? "All files and folders in the folder " + fd.getName() + " will be deleted, do you want to continue?" : "Do you want to delete file: " + fd.getName() + "?") : "Do you want to delete " + count + " files?";
                this.midlet.changeScreen(new FileDeleteConfirm(this.midlet, this, warning, "Yes", "No"));
            }
        } else if (cmd == this.createDirCmd) {
            FormCreateDir createDir = new FormCreateDir(this.midlet, this);
            this.midlet.changeScreen(createDir);
        } else if (cmd == this.refreshCmd) {
            ModelFile modelFile = (ModelFile)this.midlet.getUIFsm().getModel("File");
            modelFile.refresh();
        } else if (cmd == this.pushCmd) {
            FileObject fo = this.tabItem.getSelectedFileName();
            if (fo == null) {
                BWAlert.infoAlert("Please select a file.");
                return;
            }
            fo.setChecked(true);
            Vector<FileObject> localFiles = new Vector<FileObject>();
            Vector fileObjects = this.tabItem.getFileObjects();
            int i = 0;
            while (i < fileObjects.size()) {
                fo = (FileObject)fileObjects.elementAt(i);
                if (fo.isChecked()) {
                    localFiles.addElement(fo);
                    fo.setChecked(false);
                }
                ++i;
            }
            UIFsm fsm = this.midlet.getUIFsm();
            ModelBTPush model = (ModelBTPush)fsm.getModel("BTPush");
            model.setLocalFiles(LocalFileHandler.getCurrentFolder().getFullPath(), localFiles);
            this.midlet.getUIFsm().outEvent("enter_bt_push");
        }
    }

    public void update(Vector fileObjects) {
        this.tabItem.update(fileObjects);
    }
}

