/*
 * Decompiled with CFR 0.152.
 */
package view;

import blue.bExplore;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import model.BTConnectProgress;
import model.BTGetFolderProgress;
import model.BTNeighborSearch;
import model.Model;
import model.ModelBTDownloadConnectProgress;
import model.ModelBTDownloadFileProgress;
import model.ModelBTDownloadFolderProgress;
import model.ModelBTDownloadProgress;
import model.ModelBTPushFileProgress;
import view.BaseScreen;

public class ProgressScreen
extends BaseScreen {
    private Command cancelCommand;
    private Gauge gauge;
    private Form progressBar = new Form("Please wait");
    private TextField textField;
    static final int MAXLEN = 200;

    public ProgressScreen(bExplore midlet, String message) {
        super(midlet);
        this.gauge = new Gauge(message, false, 100, 0);
        this.gauge.setLayout(3);
        this.gauge.setLayout(48);
        this.progressBar.append((Item)this.gauge);
        this.textField = new TextField("Status", "", 200, 131072);
        this.progressBar.append((Item)this.textField);
        this.cancelCommand = new Command("Cancel", 3, 1);
        this.progressBar.addCommand(this.cancelCommand);
        this.progressBar.setCommandListener((CommandListener)this);
        this.displayable = this.progressBar;
    }

    public void setLabel(String msg) {
        this.gauge.setLabel(msg);
    }

    public void setMaxValue(int maxValue) {
        this.gauge.setMaxValue(maxValue);
    }

    public void setValue(int value) {
        this.gauge.setValue(value);
    }

    public void insertTextField(String text) {
        int textLen = text.length();
        if (this.textField.size() + textLen + 1 < 200) {
            if (this.textField.size() > 0) {
                this.textField.insert("\n", this.textField.size());
            }
            this.textField.insert(text, this.textField.size());
        } else {
            this.textField.setString(text);
        }
    }

    public void setText(String text) {
        this.textField.setString(text);
    }

    public void progressUpdate(int part, int total, String text) {
        if (total > 0) {
            this.setMaxValue(total);
            this.setValue(part);
        }
        if (text != null) {
            this.setText(text);
        }
    }

    public void commandAction(Command command, Displayable _displayable) {
        if (command == this.cancelCommand) {
            Model progress;
            Model model = this.midlet.getUIFsm().getCurrentModel();
            if (model instanceof BTNeighborSearch) {
                progress = (BTNeighborSearch)model;
                ((BTNeighborSearch)progress).onCancel();
            }
            if (model instanceof ModelBTDownloadProgress) {
                progress = (ModelBTDownloadProgress)model;
                ((ModelBTDownloadProgress)progress).onCancel();
            }
            if (model instanceof ModelBTDownloadFolderProgress) {
                progress = (ModelBTDownloadFolderProgress)model;
                ((BTGetFolderProgress)progress).onCancel();
            }
            if (model instanceof ModelBTDownloadFileProgress) {
                progress = (ModelBTDownloadFileProgress)model;
                ((ModelBTDownloadFileProgress)progress).onCancel();
            }
            if (model instanceof ModelBTDownloadConnectProgress) {
                progress = (ModelBTDownloadConnectProgress)model;
                ((BTConnectProgress)progress).onCancel();
            }
            if (model instanceof ModelBTPushFileProgress) {
                progress = (ModelBTPushFileProgress)model;
                ((ModelBTPushFileProgress)progress).onCancel();
            }
        }
    }
}

