/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Icon {
    public static Image CURSOR;
    public static Image CROSS;
    public static Image FILE;
    public static Image FOLDER;
    public static Image BLUETOOTH;
    public static Image GREY_BLUETOOTH;
    public static Image DB;
    public static Image UP;
    public static Image LOGO;
    public static int TRANSPARENET_RGB_PIXEL;
    public static int SEMI_TRANSPARENET_RGB_PIXEL;
    public static int HIGHLIGHT_RGB_PIXEL;
    public static Image BLANKIMAGE;
    public static int ICON_WIDTH;
    public static int ICON_HEIGHT;

    static {
        TRANSPARENET_RGB_PIXEL = 0;
        SEMI_TRANSPARENET_RGB_PIXEL = -1996488705;
        HIGHLIGHT_RGB_PIXEL = 0x44FFFFFF;
        ICON_WIDTH = 16;
        ICON_HEIGHT = 16;
        int[] blankImageRGB = new int[ICON_WIDTH * ICON_HEIGHT];
        int bits = ICON_WIDTH * ICON_HEIGHT;
        int i = 0;
        while (i < bits) {
            blankImageRGB[i] = SEMI_TRANSPARENET_RGB_PIXEL;
            ++i;
        }
        BLANKIMAGE = Image.createRGBImage((int[])blankImageRGB, (int)ICON_WIDTH, (int)ICON_HEIGHT, (boolean)true);
        FILE = Icon.loadIcon("/file.png");
        FOLDER = Icon.loadIcon("/folder.png");
        BLUETOOTH = Icon.loadIcon("/bluetooth.png");
        GREY_BLUETOOTH = Icon.loadIcon("/grey_bluetooth.png");
        DB = Icon.loadIcon("/db.png");
        UP = Icon.loadIcon("/up.png");
        LOGO = Icon.halfSize(Icon.loadIcon("/b_folder.png"));
    }

    public static Image loadIcon(String imageFile) {
        try {
            return Image.createImage((String)imageFile);
        }
        catch (IOException exception) {
            return BLANKIMAGE;
        }
    }

    public static Image doubleSize(Image smallImage) {
        int w = smallImage.getWidth();
        int h = smallImage.getHeight();
        return Icon.resizeImage(smallImage, w * 2, h * 2);
    }

    public static Image halfSize(Image smallImage) {
        int w = smallImage.getWidth();
        int h = smallImage.getHeight();
        return Icon.resizeImage(smallImage, w / 2, h / 2);
    }

    public static Image resizeImage(Image src, int screenWidth, int screenHeight) {
        double whratio;
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        if (screenHeight == -1) {
            screenHeight = screenWidth * srcHeight / srcWidth;
        }
        if (screenWidth == -1) {
            screenWidth = screenHeight * srcWidth / srcHeight;
        }
        if ((whratio = (double)srcWidth / (double)srcHeight) > 1.0) {
            screenHeight = (int)((double)screenWidth / whratio);
        } else {
            screenWidth = (int)((double)screenHeight * whratio);
        }
        Image tmp = Image.createImage((int)screenWidth, (int)srcHeight);
        Graphics g = tmp.getGraphics();
        int ratio = (srcWidth << 16) / screenWidth;
        int pos = ratio / 2;
        int x = 0;
        while (x < screenWidth) {
            g.setClip(x, 0, 1, srcHeight);
            g.drawImage(src, x - (pos >> 16), 0, 20);
            pos += ratio;
            ++x;
        }
        Image resizedImage = Image.createImage((int)screenWidth, (int)screenHeight);
        g = resizedImage.getGraphics();
        ratio = (srcHeight << 16) / screenHeight;
        pos = ratio / 2;
        int y = 0;
        while (y < screenHeight) {
            g.setClip(0, y, screenWidth, 1);
            g.drawImage(tmp, 0, y - (pos >> 16), 20);
            pos += ratio;
            ++y;
        }
        return resizedImage;
    }
}

