/*
 * Decompiled with CFR 0.152.
 */
package view;

import blue.bExplore;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import local.Local;
import model.Preference;
import view.BaseScreen;

public class FormSetting
extends BaseScreen {
    BaseScreen prevScreen;
    Preference prefs = Preference.getInstance();
    Form form;
    Command cancelCmd = new Command(Local.get("cancel"), 3, 1);
    Command saveCmd = new Command(Local.get("save"), 1, 5);
    ChoiceGroup langChoice = new ChoiceGroup(Local.get("language"), 1, new String[]{Local.get("english"), Local.get("chinese")}, null);
    TextField btInqTimeout = new TextField(Local.get("bt_inquiry_timeout"), "10", 4, 2);

    public FormSetting(bExplore midlet, BaseScreen prevScreen) {
        super(midlet);
        this.prevScreen = prevScreen;
        this.form = new Form(Local.get("setting"));
        this.displayable = this.form;
        this.form.addCommand(this.cancelCmd);
        this.form.addCommand(this.saveCmd);
        this.loadPrefs();
        this.form.append((Item)this.btInqTimeout);
        this.form.setCommandListener((CommandListener)this);
    }

    void loadPrefs() {
        this.updateChoice("lang", this.langChoice);
        this.updateField("bt_inq_to", this.btInqTimeout);
    }

    public void commandAction(Command cmd, Displayable disp) {
        if (cmd == this.cancelCmd) {
            this.midlet.changeScreen(this.prevScreen);
        } else if (cmd == this.saveCmd) {
            boolean updated = false;
            if (this.updatePref("bt_inq_to", this.btInqTimeout.getString())) {
                updated = true;
            }
            if (updated) {
                this.prefs.save();
            }
            this.midlet.changeScreen(this.prevScreen);
        }
    }

    boolean updatePref(String key, String newValue) {
        if (newValue != null && newValue.length() > 0 && !newValue.equals(this.prefs.get(key))) {
            this.prefs.set(key, newValue);
            return true;
        }
        return false;
    }

    void updateField(String key, TextField field) {
        String value = field.getString();
        String dbValue = this.prefs.get(key);
        if (dbValue != null && dbValue.length() > 0 && !dbValue.equals(value)) {
            field.setString(dbValue);
        }
    }

    void updateChoice(String key, ChoiceGroup choice) {
        int kIdx;
        int idx = choice.getSelectedIndex();
        String keyIndex = this.prefs.get(key);
        if (keyIndex != null && keyIndex.length() > 0 && (kIdx = Integer.parseInt(keyIndex)) != idx && kIdx >= 0) {
            choice.setSelectedIndex(kIdx, true);
        }
    }
}

